/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.task.sql;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.CategoryTable;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.ClientTable;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.EmployeeTable;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.MilestoneTable;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.ProjectTable;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.TagTable;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.TasklistTable;

public class SqliteHelper
extends SQLiteOpenHelper {
    private static final String DATABASE_NAME = "task.db3";
    private static final int DATABASE_VERSION = 2;
    public SQLiteDatabase db;
    private final Context context;
    private SqliteHelper dbHelper;

    public SqliteHelper(Context context) {
        super(context, DATABASE_NAME, null, 2);
        this.context = context;
    }

    public void onCreate(SQLiteDatabase _db) {
        this.createTables(_db);
    }

    public void onUpgrade(SQLiteDatabase _db, int _oldVersion, int _newVersion) {
        this.dropTables(_db);
        this.createTables(_db);
    }

    private void createTables(SQLiteDatabase _db) {
        try {
            _db.execSQL(ProjectTable.CREATE_TABLE);
            _db.execSQL(ClientTable.CREATE_TABLE);
            _db.execSQL(CategoryTable.CREATE_TABLE);
            _db.execSQL(TagTable.CREATE_TABLE);
            _db.execSQL(MilestoneTable.CREATE_TABLE);
            _db.execSQL(TasklistTable.CREATE_TABLE);
            _db.execSQL(EmployeeTable.CREATE_TABLE);
            _db.execSQL("CREATE TABLE  IF NOT EXISTS task(_id INTEGER PRIMARY KEY,task_id VARCHAR(200),t_status TEXT,t_description TEXT,t_project_id TEXT,assigneddatetime TEXT,task_name TEXT,t_milestone_id TEXT,listtask_id TEXT,underprogressdatetime TEXT,t_progress TEXT,t_start_date TEXT,t_end_date TEXT,t_priority TEXT,t_sequence TEXT,t_tag TEXT,t_created_by_mailid TEXT,t_created_by_type TEXT,completed_by TEXT,completed_by_type TEXT,completed_datetime TEXT,stalled_by TEXT,stalled_by_type TEXT,stalled_datetime TEXT,stalled_reason TEXT,t_p_status TEXT,stoppeddatetime TEXT,t_datetime TEXT,lastupdatetime TEXT,t_deleted TEXT,CONSTRAINT assign_unique UNIQUE (task_id));");
            _db.execSQL("CREATE TABLE  IF NOT EXISTS assign(_id INTEGER PRIMARY KEY,assign_id VARCHAR(200),a_task_id TEXT,employee_id TEXT,a_status TEXT,a_datetime TEXT,a_accepted_reject_datetime TEXT,ar_latitude TEXT,ar_longitude TEXT,underprogress_datetime TEXT,u_latitude TEXT,u_longitude TEXT,stopped_datetime TEXT,rejected_stopped_reason TEXT,stopped_longitude TEXT,stopped_latitude TEXT,updateddatetime TEXT,a_deleted TEXT,CONSTRAINT assign_unique UNIQUE (assign_id));");
            _db.execSQL("CREATE TABLE  IF NOT EXISTS progress(_id INTEGER PRIMARY KEY,task_id VARCHAR(200),progress_by_type TEXT,progress_by TEXT,employee_id TEXT,completed_activities TEXT,progress_date TEXT,progress TEXT,progressImage TEXT,dateandtime TEXT,CONSTRAINT progress_unique UNIQUE (dateandtime,task_id));");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void dropTables(SQLiteDatabase _db) {
        try {
            _db.execSQL("DROP TABLE IF EXISTS " + ProjectTable.TABLENAME);
            _db.execSQL("DROP TABLE IF EXISTS " + ClientTable.TABLENAME);
            _db.execSQL("DROP TABLE IF EXISTS " + CategoryTable.TABLENAME);
            _db.execSQL("DROP TABLE IF EXISTS " + TagTable.TABLENAME);
            _db.execSQL("DROP TABLE IF EXISTS " + MilestoneTable.TABLENAME);
            _db.execSQL("DROP TABLE IF EXISTS " + TasklistTable.TABLENAME);
            _db.execSQL("DROP TABLE IF EXISTS " + EmployeeTable.TABLENAME);
            _db.execSQL("DROP TABLE IF EXISTS task");
            _db.execSQL("DROP TABLE IF EXISTS assign");
            _db.execSQL("DROP TABLE IF EXISTS progress");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

