/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0010\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u001a\u0012\u0010\u0007\u001a\u00020\b*\u00020\u00012\u0006\u0010\t\u001a\u00020\u0001\u001a\u0012\u0010\n\u001a\u00020\u0003*\u00020\u00012\u0006\u0010\t\u001a\u00020\u0001\u001a\u0012\u0010\u000b\u001a\u00020\b*\u00020\u00012\u0006\u0010\t\u001a\u00020\u0001\u001a\u0012\u0010\u000b\u001a\u00020\b*\u00020\u00012\u0006\u0010\t\u001a\u00020\u0003\u001a\u0012\u0010\f\u001a\u00020\u0003*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003\u001a\n\u0010\u000f\u001a\u00020\u0003*\u00020\u0003\u001a\u0014\u0010\u0010\u001a\u00020\u0003*\u00020\r2\b\b\u0002\u0010\u0011\u001a\u00020\u0003\u001a\u0012\u0010\u0012\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003\u001a\n\u0010\u0013\u001a\u00020\u0003*\u00020\u0003\u001a\n\u0010\u0014\u001a\u00020\u0003*\u00020\r\u001a\n\u0010\u0015\u001a\u00020\u0003*\u00020\r\u001a\n\u0010\u0015\u001a\u00020\u0003*\u00020\u0001\u001a\u001e\u0010\u0016\u001a\u00020\u0003*\u00020\u00012\b\b\u0002\u0010\f\u001a\u00020\u00032\b\b\u0002\u0010\u0017\u001a\u00020\u0018\u001a\u0014\u0010\u0019\u001a\u00020\u0001*\u00020\u00032\b\b\u0002\u0010\f\u001a\u00020\u0003\u001a\u001e\u0010\u001a\u001a\u00020\u0003*\u00020\u00012\b\b\u0002\u0010\f\u001a\u00020\u00032\b\b\u0002\u0010\u0017\u001a\u00020\u0018\u001a\n\u0010\u001b\u001a\u00020\u0001*\u00020\u0001\u00a8\u0006\u001c"}, d2={"getCurrentDateTime", "Ljava/util/Date;", "getCurrentDateTimeInString", "", "getTimeBefore", "seconds", "", "diffInMinitues", "", "date", "diffInReadbleFormat", "diffInSeconds", "format", "Ljava/util/Calendar;", "sdf", "getDate", "getDateString", "df", "getInFormat", "getTimeOnly", "getTimeString", "inRequestFormat", "string", "locale", "Ljava/util/Locale;", "toDate", "toString", "tomorrow6AM", "app_debug"})
public final class DateUtilsKt {
    @NotNull
    public static final String getCurrentDateTimeInString() {
        Date date = Calendar.getInstance().getTime();
        Intrinsics.checkNotNull((Object)date);
        return DateUtilsKt.toString$default(date, "yyyy-MM-dd HH:mm:ss", null, 2, null);
    }

    @NotNull
    public static final Date getCurrentDateTime() {
        Date date = Calendar.getInstance().getTime();
        Intrinsics.checkNotNullExpressionValue((Object)date, (String)"getTime(...)");
        return date;
    }

    @NotNull
    public static final String getTimeBefore(int seconds) {
        Date date = new Date(Calendar.getInstance().getTimeInMillis() - (long)(seconds * 100));
        return DateUtilsKt.toString$default(date, "yyyy-MM-dd HH:mm:ss", null, 2, null);
    }

    public static /* synthetic */ String getTimeBefore$default(int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 120;
        }
        return DateUtilsKt.getTimeBefore(n);
    }

    @NotNull
    public static final Date toDate(@NotNull String $this$toDate, @NotNull String format) {
        Intrinsics.checkNotNullParameter((Object)$this$toDate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        SimpleDateFormat sdf = new SimpleDateFormat(format, Locale.getDefault());
        Date date = sdf.parse($this$toDate);
        Intrinsics.checkNotNullExpressionValue((Object)date, (String)"parse(...)");
        return date;
    }

    public static /* synthetic */ Date toDate$default(String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string3 = "MM/dd/yyyy HH:mm:ss";
        }
        return DateUtilsKt.toDate(string2, string3);
    }

    @NotNull
    public static final String getTimeOnly(@NotNull String $this$getTimeOnly) {
        Date date;
        Intrinsics.checkNotNullParameter((Object)$this$getTimeOnly, (String)"<this>");
        Date date2 = date = DateUtilsKt.toDate($this$getTimeOnly, "MM/dd/yyyy HH:mm:ss");
        Intrinsics.checkNotNull((Object)date2);
        return DateUtilsKt.toString$default(date2, "hh:mm a", null, 2, null);
    }

    @NotNull
    public static final String getDate(@NotNull String $this$getDate) {
        Date date;
        Intrinsics.checkNotNullParameter((Object)$this$getDate, (String)"<this>");
        Date date2 = date = DateUtilsKt.toDate($this$getDate, "MM/dd/yyyy HH:mm:ss");
        Intrinsics.checkNotNull((Object)date2);
        return DateUtilsKt.toString$default(date2, "dd/MM/yyyy", null, 2, null);
    }

    @NotNull
    public static final String getInFormat(@NotNull String $this$getInFormat, @NotNull String format) {
        Date date;
        Intrinsics.checkNotNullParameter((Object)$this$getInFormat, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Date date2 = date = DateUtilsKt.toDate$default($this$getInFormat, null, 1, null);
        Intrinsics.checkNotNull((Object)date2);
        return DateUtilsKt.toString$default(date2, format, null, 2, null);
    }

    @NotNull
    public static final String toString(@NotNull Date $this$toString, @NotNull String format, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)$this$toString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        SimpleDateFormat formatter = new SimpleDateFormat(format, locale);
        String string2 = formatter.format($this$toString);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    public static /* synthetic */ String toString$default(Date date, String string2, Locale locale, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = "yyyy-MM-dd HH:mm:ss";
        }
        if ((n & 2) != 0) {
            Locale locale2 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault(...)");
            locale = locale2;
        }
        return DateUtilsKt.toString(date, string2, locale);
    }

    @NotNull
    public static final String string(@NotNull Date $this$string, @NotNull String format, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)$this$string, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        SimpleDateFormat formatter = new SimpleDateFormat(format, locale);
        String string2 = formatter.format($this$string);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    public static /* synthetic */ String string$default(Date date, String string2, Locale locale, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = "dd/MM/yyyy HH:mm:ss";
        }
        if ((n & 2) != 0) {
            Locale locale2 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault(...)");
            locale = locale2;
        }
        return DateUtilsKt.string(date, string2, locale);
    }

    @NotNull
    public static final String inRequestFormat(@NotNull Date $this$inRequestFormat) {
        Intrinsics.checkNotNullParameter((Object)$this$inRequestFormat, (String)"<this>");
        return DateUtilsKt.toString$default($this$inRequestFormat, "MM/dd/yyyy HH:mm:ss", null, 2, null);
    }

    @NotNull
    public static final Date tomorrow6AM(@NotNull Date $this$tomorrow6AM) {
        Intrinsics.checkNotNullParameter((Object)$this$tomorrow6AM, (String)"<this>");
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(5, 1);
        c.set(10, 6);
        c.set(12, 0);
        c.set(13, 0);
        Date date = c.getTime();
        Intrinsics.checkNotNullExpressionValue((Object)date, (String)"getTime(...)");
        return date;
    }

    @NotNull
    public static final String inRequestFormat(@NotNull Calendar $this$inRequestFormat) {
        Intrinsics.checkNotNullParameter((Object)$this$inRequestFormat, (String)"<this>");
        Date date = $this$inRequestFormat.getTime();
        Intrinsics.checkNotNullExpressionValue((Object)date, (String)"getTime(...)");
        return DateUtilsKt.toString$default(date, "MM/dd/yyyy HH:mm:ss", null, 2, null);
    }

    public static final long diffInSeconds(@NotNull Date $this$diffInSeconds, @NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)$this$diffInSeconds, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        long diff = $this$diffInSeconds.getTime() - date.getTime();
        return diff / (long)1000;
    }

    @NotNull
    public static final String diffInReadbleFormat(@NotNull Date $this$diffInReadbleFormat, @NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)$this$diffInReadbleFormat, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        long diff = date.getTime() - $this$diffInReadbleFormat.getTime();
        long diffSeconds = diff / (long)1000 % (long)60;
        long diffMinutes = diff / (long)60000 % (long)60;
        long diffHours = diff / (long)3600000 % (long)24;
        long diffDays = diff / (long)86400000;
        if (diffDays > 0L) {
            return diffDays + " day";
        }
        if (diffHours >= 1L) {
            return diffHours + " hr " + (diffMinutes != 0L ? Long.valueOf(diffMinutes) : "") + ' ';
        }
        if (diffMinutes >= 1L) {
            return diffMinutes + " min";
        }
        return diffSeconds + " sec";
    }

    public static final long diffInMinitues(@NotNull Date $this$diffInMinitues, @NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)$this$diffInMinitues, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        long diff = date.getTime() - $this$diffInMinitues.getTime();
        return diff / (long)60000 % (long)60;
    }

    public static final long diffInSeconds(@NotNull Date $this$diffInSeconds, @NotNull String date) {
        Intrinsics.checkNotNullParameter((Object)$this$diffInSeconds, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss", Locale.getDefault());
        try {
            Date date2 = sdf.parse(date);
            Intrinsics.checkNotNullExpressionValue((Object)date2, (String)"parse(...)");
            return DateUtilsKt.diffInSeconds($this$diffInSeconds, date2);
        }
        catch (ParseException e) {
            Date date3 = Calendar.getInstance().getTime();
            Intrinsics.checkNotNullExpressionValue((Object)date3, (String)"getTime(...)");
            return DateUtilsKt.diffInSeconds($this$diffInSeconds, date3);
        }
    }

    @NotNull
    public static final String format(@NotNull Calendar $this$format, @NotNull String sdf) {
        Intrinsics.checkNotNullParameter((Object)$this$format, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)sdf, (String)"sdf");
        Date date = $this$format.getTime();
        Intrinsics.checkNotNullExpressionValue((Object)date, (String)"getTime(...)");
        return DateUtilsKt.toString$default(date, sdf, null, 2, null);
    }

    @NotNull
    public static final String getDateString(@NotNull Calendar $this$getDateString, @NotNull String df) {
        Intrinsics.checkNotNullParameter((Object)$this$getDateString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)df, (String)"df");
        return DateUtilsKt.format($this$getDateString, df);
    }

    public static /* synthetic */ String getDateString$default(Calendar calendar, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = "MM/dd/yyyy";
        }
        return DateUtilsKt.getDateString(calendar, string2);
    }

    @NotNull
    public static final String getTimeString(@NotNull Calendar $this$getTimeString) {
        Intrinsics.checkNotNullParameter((Object)$this$getTimeString, (String)"<this>");
        return DateUtilsKt.format($this$getTimeString, "HH:mm:ss");
    }
}

