package com.b2lmobitech.fieldcloudplus.hcm.new_sql;

import androidx.annotation.NonNull;
import androidx.room.DatabaseConfiguration;
import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import androidx.room.RoomOpenHelper;
import androidx.room.migration.AutoMigrationSpec;
import androidx.room.migration.Migration;
import androidx.room.util.DBUtil;
import androidx.room.util.TableInfo;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.doa.FacilityDOA;
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.doa.FacilityDOA_Impl;
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.doa.ShiftDOA;
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.doa.ShiftDOA_Impl;
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.doa.TimeSheetDOA;
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.doa.TimeSheetDOA_Impl;
import com.cruzbytes.alfarz.sql.doa.AttendanceDOA;
import com.cruzbytes.alfarz.sql.doa.AttendanceDOA_Impl;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@SuppressWarnings({"unchecked", "deprecation"})
public final class LocalDatabase_Impl extends LocalDatabase {
  private volatile AttendanceDOA _attendanceDOA;

  private volatile FacilityDOA _facilityDOA;

  private volatile TimeSheetDOA _timeSheetDOA;

  private volatile ShiftDOA _shiftDOA;

  @Override
  @NonNull
  protected SupportSQLiteOpenHelper createOpenHelper(@NonNull final DatabaseConfiguration config) {
    final SupportSQLiteOpenHelper.Callback _openCallback = new RoomOpenHelper(config, new RoomOpenHelper.Delegate(2) {
      @Override
      public void createAllTables(@NonNull final SupportSQLiteDatabase db) {
        db.execSQL("CREATE TABLE IF NOT EXISTS `AttendenceEntity` (`id` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `companyname` TEXT NOT NULL, `emailid` TEXT NOT NULL, `date` TEXT NOT NULL, `checkintime` TEXT NOT NULL, `checkouttime` TEXT NOT NULL, `status` TEXT NOT NULL, `checkinlocation` TEXT NOT NULL, `checkoutlocation` TEXT NOT NULL, `totaltime` TEXT NOT NULL, `INSYNC` TEXT NOT NULL, `OUTSYNC` TEXT NOT NULL, `attendanceimage` TEXT NOT NULL, `imagepath` TEXT NOT NULL, `signature` TEXT NOT NULL, `signaturepath` TEXT NOT NULL, `facility_id` TEXT NOT NULL, `facility_id_out` TEXT NOT NULL, `shift_id` TEXT NOT NULL)");
        db.execSQL("CREATE TABLE IF NOT EXISTS `FacilityEntity` (`atmid` TEXT NOT NULL, `companyname` TEXT NOT NULL, `state` TEXT NOT NULL, `country` TEXT NOT NULL, `location` TEXT NOT NULL, `atmaddress` TEXT NOT NULL, `sitename` TEXT NOT NULL, `latitude` TEXT NOT NULL, `longitude` TEXT NOT NULL, `geofencing` TEXT NOT NULL, `geo_distance` TEXT NOT NULL, PRIMARY KEY(`atmid`))");
        db.execSQL("CREATE TABLE IF NOT EXISTS `TimesheetEntity` (`id` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `companyname` TEXT NOT NULL, `employeemailid` TEXT NOT NULL, `attendancegroup` TEXT NOT NULL, `attendancesubgroup` TEXT NOT NULL, `attendenceteam` TEXT NOT NULL, `activity` TEXT NOT NULL, `latitude` TEXT NOT NULL, `longitude` TEXT NOT NULL, `location` TEXT NOT NULL, `timesheetdate` TEXT NOT NULL, `starttime` TEXT NOT NULL, `endtime` TEXT NOT NULL, `dateandtime` TEXT NOT NULL, `sync` TEXT NOT NULL, `facility_id` TEXT NOT NULL)");
        db.execSQL("CREATE TABLE IF NOT EXISTS `ShiftEntity` (`shiftId` TEXT NOT NULL, `companyname` TEXT NOT NULL, `timeFrom` TEXT NOT NULL, `timeto` TEXT NOT NULL, PRIMARY KEY(`shiftId`))");
        db.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
        db.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, '15701b5b1a6e6bc69ab0a79cdbe35a64')");
      }

      @Override
      public void dropAllTables(@NonNull final SupportSQLiteDatabase db) {
        db.execSQL("DROP TABLE IF EXISTS `AttendenceEntity`");
        db.execSQL("DROP TABLE IF EXISTS `FacilityEntity`");
        db.execSQL("DROP TABLE IF EXISTS `TimesheetEntity`");
        db.execSQL("DROP TABLE IF EXISTS `ShiftEntity`");
        final List<? extends RoomDatabase.Callback> _callbacks = mCallbacks;
        if (_callbacks != null) {
          for (RoomDatabase.Callback _callback : _callbacks) {
            _callback.onDestructiveMigration(db);
          }
        }
      }

      @Override
      public void onCreate(@NonNull final SupportSQLiteDatabase db) {
        final List<? extends RoomDatabase.Callback> _callbacks = mCallbacks;
        if (_callbacks != null) {
          for (RoomDatabase.Callback _callback : _callbacks) {
            _callback.onCreate(db);
          }
        }
      }

      @Override
      public void onOpen(@NonNull final SupportSQLiteDatabase db) {
        mDatabase = db;
        internalInitInvalidationTracker(db);
        final List<? extends RoomDatabase.Callback> _callbacks = mCallbacks;
        if (_callbacks != null) {
          for (RoomDatabase.Callback _callback : _callbacks) {
            _callback.onOpen(db);
          }
        }
      }

      @Override
      public void onPreMigrate(@NonNull final SupportSQLiteDatabase db) {
        DBUtil.dropFtsSyncTriggers(db);
      }

      @Override
      public void onPostMigrate(@NonNull final SupportSQLiteDatabase db) {
      }

      @Override
      @NonNull
      public RoomOpenHelper.ValidationResult onValidateSchema(
          @NonNull final SupportSQLiteDatabase db) {
        final HashMap<String, TableInfo.Column> _columnsAttendenceEntity = new HashMap<String, TableInfo.Column>(19);
        _columnsAttendenceEntity.put("id", new TableInfo.Column("id", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAttendenceEntity.put("companyname", new TableInfo.Column("companyname", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAttendenceEntity.put("emailid", new TableInfo.Column("emailid", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAttendenceEntity.put("date", new TableInfo.Column("date", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAttendenceEntity.put("checkintime", new TableInfo.Column("checkintime", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAttendenceEntity.put("checkouttime", new TableInfo.Column("checkouttime", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAttendenceEntity.put("status", new TableInfo.Column("status", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAttendenceEntity.put("checkinlocation", new TableInfo.Column("checkinlocation", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAttendenceEntity.put("checkoutlocation", new TableInfo.Column("checkoutlocation", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAttendenceEntity.put("totaltime", new TableInfo.Column("totaltime", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAttendenceEntity.put("INSYNC", new TableInfo.Column("INSYNC", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAttendenceEntity.put("OUTSYNC", new TableInfo.Column("OUTSYNC", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAttendenceEntity.put("attendanceimage", new TableInfo.Column("attendanceimage", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAttendenceEntity.put("imagepath", new TableInfo.Column("imagepath", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAttendenceEntity.put("signature", new TableInfo.Column("signature", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAttendenceEntity.put("signaturepath", new TableInfo.Column("signaturepath", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAttendenceEntity.put("facility_id", new TableInfo.Column("facility_id", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAttendenceEntity.put("facility_id_out", new TableInfo.Column("facility_id_out", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAttendenceEntity.put("shift_id", new TableInfo.Column("shift_id", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysAttendenceEntity = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesAttendenceEntity = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoAttendenceEntity = new TableInfo("AttendenceEntity", _columnsAttendenceEntity, _foreignKeysAttendenceEntity, _indicesAttendenceEntity);
        final TableInfo _existingAttendenceEntity = TableInfo.read(db, "AttendenceEntity");
        if (!_infoAttendenceEntity.equals(_existingAttendenceEntity)) {
          return new RoomOpenHelper.ValidationResult(false, "AttendenceEntity(com.b2lmobitech.fieldcloudplus.hcm.new_sql.entities.AttendenceEntity).\n"
                  + " Expected:\n" + _infoAttendenceEntity + "\n"
                  + " Found:\n" + _existingAttendenceEntity);
        }
        final HashMap<String, TableInfo.Column> _columnsFacilityEntity = new HashMap<String, TableInfo.Column>(11);
        _columnsFacilityEntity.put("atmid", new TableInfo.Column("atmid", "TEXT", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsFacilityEntity.put("companyname", new TableInfo.Column("companyname", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsFacilityEntity.put("state", new TableInfo.Column("state", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsFacilityEntity.put("country", new TableInfo.Column("country", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsFacilityEntity.put("location", new TableInfo.Column("location", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsFacilityEntity.put("atmaddress", new TableInfo.Column("atmaddress", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsFacilityEntity.put("sitename", new TableInfo.Column("sitename", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsFacilityEntity.put("latitude", new TableInfo.Column("latitude", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsFacilityEntity.put("longitude", new TableInfo.Column("longitude", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsFacilityEntity.put("geofencing", new TableInfo.Column("geofencing", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsFacilityEntity.put("geo_distance", new TableInfo.Column("geo_distance", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysFacilityEntity = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesFacilityEntity = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoFacilityEntity = new TableInfo("FacilityEntity", _columnsFacilityEntity, _foreignKeysFacilityEntity, _indicesFacilityEntity);
        final TableInfo _existingFacilityEntity = TableInfo.read(db, "FacilityEntity");
        if (!_infoFacilityEntity.equals(_existingFacilityEntity)) {
          return new RoomOpenHelper.ValidationResult(false, "FacilityEntity(com.b2lmobitech.fieldcloudplus.hcm.new_sql.entities.FacilityEntity).\n"
                  + " Expected:\n" + _infoFacilityEntity + "\n"
                  + " Found:\n" + _existingFacilityEntity);
        }
        final HashMap<String, TableInfo.Column> _columnsTimesheetEntity = new HashMap<String, TableInfo.Column>(16);
        _columnsTimesheetEntity.put("id", new TableInfo.Column("id", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsTimesheetEntity.put("companyname", new TableInfo.Column("companyname", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsTimesheetEntity.put("employeemailid", new TableInfo.Column("employeemailid", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsTimesheetEntity.put("attendancegroup", new TableInfo.Column("attendancegroup", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsTimesheetEntity.put("attendancesubgroup", new TableInfo.Column("attendancesubgroup", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsTimesheetEntity.put("attendenceteam", new TableInfo.Column("attendenceteam", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsTimesheetEntity.put("activity", new TableInfo.Column("activity", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsTimesheetEntity.put("latitude", new TableInfo.Column("latitude", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsTimesheetEntity.put("longitude", new TableInfo.Column("longitude", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsTimesheetEntity.put("location", new TableInfo.Column("location", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsTimesheetEntity.put("timesheetdate", new TableInfo.Column("timesheetdate", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsTimesheetEntity.put("starttime", new TableInfo.Column("starttime", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsTimesheetEntity.put("endtime", new TableInfo.Column("endtime", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsTimesheetEntity.put("dateandtime", new TableInfo.Column("dateandtime", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsTimesheetEntity.put("sync", new TableInfo.Column("sync", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsTimesheetEntity.put("facility_id", new TableInfo.Column("facility_id", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysTimesheetEntity = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesTimesheetEntity = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoTimesheetEntity = new TableInfo("TimesheetEntity", _columnsTimesheetEntity, _foreignKeysTimesheetEntity, _indicesTimesheetEntity);
        final TableInfo _existingTimesheetEntity = TableInfo.read(db, "TimesheetEntity");
        if (!_infoTimesheetEntity.equals(_existingTimesheetEntity)) {
          return new RoomOpenHelper.ValidationResult(false, "TimesheetEntity(com.b2lmobitech.fieldcloudplus.hcm.new_sql.entities.TimesheetEntity).\n"
                  + " Expected:\n" + _infoTimesheetEntity + "\n"
                  + " Found:\n" + _existingTimesheetEntity);
        }
        final HashMap<String, TableInfo.Column> _columnsShiftEntity = new HashMap<String, TableInfo.Column>(4);
        _columnsShiftEntity.put("shiftId", new TableInfo.Column("shiftId", "TEXT", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsShiftEntity.put("companyname", new TableInfo.Column("companyname", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsShiftEntity.put("timeFrom", new TableInfo.Column("timeFrom", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsShiftEntity.put("timeto", new TableInfo.Column("timeto", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysShiftEntity = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesShiftEntity = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoShiftEntity = new TableInfo("ShiftEntity", _columnsShiftEntity, _foreignKeysShiftEntity, _indicesShiftEntity);
        final TableInfo _existingShiftEntity = TableInfo.read(db, "ShiftEntity");
        if (!_infoShiftEntity.equals(_existingShiftEntity)) {
          return new RoomOpenHelper.ValidationResult(false, "ShiftEntity(com.b2lmobitech.fieldcloudplus.hcm.new_sql.entities.ShiftEntity).\n"
                  + " Expected:\n" + _infoShiftEntity + "\n"
                  + " Found:\n" + _existingShiftEntity);
        }
        return new RoomOpenHelper.ValidationResult(true, null);
      }
    }, "15701b5b1a6e6bc69ab0a79cdbe35a64", "bd8f86da409837f81c20b4df44742c43");
    final SupportSQLiteOpenHelper.Configuration _sqliteConfig = SupportSQLiteOpenHelper.Configuration.builder(config.context).name(config.name).callback(_openCallback).build();
    final SupportSQLiteOpenHelper _helper = config.sqliteOpenHelperFactory.create(_sqliteConfig);
    return _helper;
  }

  @Override
  @NonNull
  protected InvalidationTracker createInvalidationTracker() {
    final HashMap<String, String> _shadowTablesMap = new HashMap<String, String>(0);
    final HashMap<String, Set<String>> _viewTables = new HashMap<String, Set<String>>(0);
    return new InvalidationTracker(this, _shadowTablesMap, _viewTables, "AttendenceEntity","FacilityEntity","TimesheetEntity","ShiftEntity");
  }

  @Override
  public void clearAllTables() {
    super.assertNotMainThread();
    final SupportSQLiteDatabase _db = super.getOpenHelper().getWritableDatabase();
    try {
      super.beginTransaction();
      _db.execSQL("DELETE FROM `AttendenceEntity`");
      _db.execSQL("DELETE FROM `FacilityEntity`");
      _db.execSQL("DELETE FROM `TimesheetEntity`");
      _db.execSQL("DELETE FROM `ShiftEntity`");
      super.setTransactionSuccessful();
    } finally {
      super.endTransaction();
      _db.query("PRAGMA wal_checkpoint(FULL)").close();
      if (!_db.inTransaction()) {
        _db.execSQL("VACUUM");
      }
    }
  }

  @Override
  @NonNull
  protected Map<Class<?>, List<Class<?>>> getRequiredTypeConverters() {
    final HashMap<Class<?>, List<Class<?>>> _typeConvertersMap = new HashMap<Class<?>, List<Class<?>>>();
    _typeConvertersMap.put(AttendanceDOA.class, AttendanceDOA_Impl.getRequiredConverters());
    _typeConvertersMap.put(FacilityDOA.class, FacilityDOA_Impl.getRequiredConverters());
    _typeConvertersMap.put(TimeSheetDOA.class, TimeSheetDOA_Impl.getRequiredConverters());
    _typeConvertersMap.put(ShiftDOA.class, ShiftDOA_Impl.getRequiredConverters());
    return _typeConvertersMap;
  }

  @Override
  @NonNull
  public Set<Class<? extends AutoMigrationSpec>> getRequiredAutoMigrationSpecs() {
    final HashSet<Class<? extends AutoMigrationSpec>> _autoMigrationSpecsSet = new HashSet<Class<? extends AutoMigrationSpec>>();
    return _autoMigrationSpecsSet;
  }

  @Override
  @NonNull
  public List<Migration> getAutoMigrations(
      @NonNull final Map<Class<? extends AutoMigrationSpec>, AutoMigrationSpec> autoMigrationSpecs) {
    final List<Migration> _autoMigrations = new ArrayList<Migration>();
    return _autoMigrations;
  }

  @Override
  public AttendanceDOA attendenceDOA() {
    if (_attendanceDOA != null) {
      return _attendanceDOA;
    } else {
      synchronized(this) {
        if(_attendanceDOA == null) {
          _attendanceDOA = new AttendanceDOA_Impl(this);
        }
        return _attendanceDOA;
      }
    }
  }

  @Override
  public FacilityDOA facilityDOA() {
    if (_facilityDOA != null) {
      return _facilityDOA;
    } else {
      synchronized(this) {
        if(_facilityDOA == null) {
          _facilityDOA = new FacilityDOA_Impl(this);
        }
        return _facilityDOA;
      }
    }
  }

  @Override
  public TimeSheetDOA timeSheetDOA() {
    if (_timeSheetDOA != null) {
      return _timeSheetDOA;
    } else {
      synchronized(this) {
        if(_timeSheetDOA == null) {
          _timeSheetDOA = new TimeSheetDOA_Impl(this);
        }
        return _timeSheetDOA;
      }
    }
  }

  @Override
  public ShiftDOA shiftDOA() {
    if (_shiftDOA != null) {
      return _shiftDOA;
    } else {
      synchronized(this) {
        if(_shiftDOA == null) {
          _shiftDOA = new ShiftDOA_Impl(this);
        }
        return _shiftDOA;
      }
    }
  }
}
