package com.b2lmobitech.fieldcloudplus.hcm.new_sql.doa;

import android.database.Cursor;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.LiveData;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.entities.ShiftEntity;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;

@SuppressWarnings({"unchecked", "deprecation"})
public final class ShiftDOA_Impl implements ShiftDOA {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<ShiftEntity> __insertionAdapterOfShiftEntity;

  private final EntityDeletionOrUpdateAdapter<ShiftEntity> __deletionAdapterOfShiftEntity;

  private final EntityDeletionOrUpdateAdapter<ShiftEntity> __updateAdapterOfShiftEntity;

  private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

  public ShiftDOA_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfShiftEntity = new EntityInsertionAdapter<ShiftEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR REPLACE INTO `ShiftEntity` (`shiftId`,`companyname`,`timeFrom`,`timeto`) VALUES (?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final ShiftEntity entity) {
        if (entity.getShiftId() == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, entity.getShiftId());
        }
        if (entity.getCompanyname() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getCompanyname());
        }
        if (entity.getTimeFrom() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getTimeFrom());
        }
        if (entity.getTimeto() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getTimeto());
        }
      }
    };
    this.__deletionAdapterOfShiftEntity = new EntityDeletionOrUpdateAdapter<ShiftEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "DELETE FROM `ShiftEntity` WHERE `shiftId` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final ShiftEntity entity) {
        if (entity.getShiftId() == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, entity.getShiftId());
        }
      }
    };
    this.__updateAdapterOfShiftEntity = new EntityDeletionOrUpdateAdapter<ShiftEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `ShiftEntity` SET `shiftId` = ?,`companyname` = ?,`timeFrom` = ?,`timeto` = ? WHERE `shiftId` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final ShiftEntity entity) {
        if (entity.getShiftId() == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, entity.getShiftId());
        }
        if (entity.getCompanyname() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getCompanyname());
        }
        if (entity.getTimeFrom() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getTimeFrom());
        }
        if (entity.getTimeto() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getTimeto());
        }
        if (entity.getShiftId() == null) {
          statement.bindNull(5);
        } else {
          statement.bindString(5, entity.getShiftId());
        }
      }
    };
    this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "DELETE  FROM ShiftEntity";
        return _query;
      }
    };
  }

  @Override
  public Long save(final ShiftEntity key) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      final Long _result = __insertionAdapterOfShiftEntity.insertAndReturnId(key);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void saveAll(final List<ShiftEntity> keys) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfShiftEntity.insert(keys);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void delete(final ShiftEntity key) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __deletionAdapterOfShiftEntity.handle(key);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void merge(final ShiftEntity key) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfShiftEntity.handle(key);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void deleteAll() {
    __db.assertNotSuspendingTransaction();
    final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteAll.acquire();
    try {
      __db.beginTransaction();
      try {
        _stmt.executeUpdateDelete();
        __db.setTransactionSuccessful();
      } finally {
        __db.endTransaction();
      }
    } finally {
      __preparedStmtOfDeleteAll.release(_stmt);
    }
  }

  @Override
  public LiveData<List<ShiftEntity>> fetchAll() {
    final String _sql = "SELECT * FROM ShiftEntity";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    return __db.getInvalidationTracker().createLiveData(new String[] {"ShiftEntity"}, false, new Callable<List<ShiftEntity>>() {
      @Override
      @Nullable
      public List<ShiftEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfShiftId = CursorUtil.getColumnIndexOrThrow(_cursor, "shiftId");
          final int _cursorIndexOfCompanyname = CursorUtil.getColumnIndexOrThrow(_cursor, "companyname");
          final int _cursorIndexOfTimeFrom = CursorUtil.getColumnIndexOrThrow(_cursor, "timeFrom");
          final int _cursorIndexOfTimeto = CursorUtil.getColumnIndexOrThrow(_cursor, "timeto");
          final List<ShiftEntity> _result = new ArrayList<ShiftEntity>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final ShiftEntity _item;
            final String _tmpShiftId;
            if (_cursor.isNull(_cursorIndexOfShiftId)) {
              _tmpShiftId = null;
            } else {
              _tmpShiftId = _cursor.getString(_cursorIndexOfShiftId);
            }
            final String _tmpCompanyname;
            if (_cursor.isNull(_cursorIndexOfCompanyname)) {
              _tmpCompanyname = null;
            } else {
              _tmpCompanyname = _cursor.getString(_cursorIndexOfCompanyname);
            }
            final String _tmpTimeFrom;
            if (_cursor.isNull(_cursorIndexOfTimeFrom)) {
              _tmpTimeFrom = null;
            } else {
              _tmpTimeFrom = _cursor.getString(_cursorIndexOfTimeFrom);
            }
            final String _tmpTimeto;
            if (_cursor.isNull(_cursorIndexOfTimeto)) {
              _tmpTimeto = null;
            } else {
              _tmpTimeto = _cursor.getString(_cursorIndexOfTimeto);
            }
            _item = new ShiftEntity(_tmpShiftId,_tmpCompanyname,_tmpTimeFrom,_tmpTimeto);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
