package com.b2lmobitech.fieldcloudplus.hcm.new_sql.doa;

import android.database.Cursor;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.LiveData;
import androidx.paging.DataSource;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetDataSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.entities.TimesheetEntity;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;

@SuppressWarnings({"unchecked", "deprecation"})
public final class TimeSheetDOA_Impl implements TimeSheetDOA {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<TimesheetEntity> __insertionAdapterOfTimesheetEntity;

  private final EntityDeletionOrUpdateAdapter<TimesheetEntity> __deletionAdapterOfTimesheetEntity;

  private final EntityDeletionOrUpdateAdapter<TimesheetEntity> __updateAdapterOfTimesheetEntity;

  private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

  private final SharedSQLiteStatement __preparedStmtOfDeleteHistory;

  public TimeSheetDOA_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfTimesheetEntity = new EntityInsertionAdapter<TimesheetEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR REPLACE INTO `TimesheetEntity` (`id`,`companyname`,`employeemailid`,`attendancegroup`,`attendancesubgroup`,`attendenceteam`,`activity`,`latitude`,`longitude`,`location`,`timesheetdate`,`starttime`,`endtime`,`dateandtime`,`sync`,`facility_id`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final TimesheetEntity entity) {
        statement.bindLong(1, entity.getId());
        if (entity.getCompanyname() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getCompanyname());
        }
        if (entity.getEmployeemailid() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getEmployeemailid());
        }
        if (entity.getAttendancegroup() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getAttendancegroup());
        }
        if (entity.getAttendancesubgroup() == null) {
          statement.bindNull(5);
        } else {
          statement.bindString(5, entity.getAttendancesubgroup());
        }
        if (entity.getAttendenceteam() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getAttendenceteam());
        }
        if (entity.getActivity() == null) {
          statement.bindNull(7);
        } else {
          statement.bindString(7, entity.getActivity());
        }
        if (entity.getLatitude() == null) {
          statement.bindNull(8);
        } else {
          statement.bindString(8, entity.getLatitude());
        }
        if (entity.getLongitude() == null) {
          statement.bindNull(9);
        } else {
          statement.bindString(9, entity.getLongitude());
        }
        if (entity.getLocation() == null) {
          statement.bindNull(10);
        } else {
          statement.bindString(10, entity.getLocation());
        }
        if (entity.getTimesheetdate() == null) {
          statement.bindNull(11);
        } else {
          statement.bindString(11, entity.getTimesheetdate());
        }
        if (entity.getStarttime() == null) {
          statement.bindNull(12);
        } else {
          statement.bindString(12, entity.getStarttime());
        }
        if (entity.getEndtime() == null) {
          statement.bindNull(13);
        } else {
          statement.bindString(13, entity.getEndtime());
        }
        if (entity.getDateandtime() == null) {
          statement.bindNull(14);
        } else {
          statement.bindString(14, entity.getDateandtime());
        }
        if (entity.getSync() == null) {
          statement.bindNull(15);
        } else {
          statement.bindString(15, entity.getSync());
        }
        if (entity.getFacility_id() == null) {
          statement.bindNull(16);
        } else {
          statement.bindString(16, entity.getFacility_id());
        }
      }
    };
    this.__deletionAdapterOfTimesheetEntity = new EntityDeletionOrUpdateAdapter<TimesheetEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "DELETE FROM `TimesheetEntity` WHERE `id` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final TimesheetEntity entity) {
        statement.bindLong(1, entity.getId());
      }
    };
    this.__updateAdapterOfTimesheetEntity = new EntityDeletionOrUpdateAdapter<TimesheetEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `TimesheetEntity` SET `id` = ?,`companyname` = ?,`employeemailid` = ?,`attendancegroup` = ?,`attendancesubgroup` = ?,`attendenceteam` = ?,`activity` = ?,`latitude` = ?,`longitude` = ?,`location` = ?,`timesheetdate` = ?,`starttime` = ?,`endtime` = ?,`dateandtime` = ?,`sync` = ?,`facility_id` = ? WHERE `id` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final TimesheetEntity entity) {
        statement.bindLong(1, entity.getId());
        if (entity.getCompanyname() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getCompanyname());
        }
        if (entity.getEmployeemailid() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getEmployeemailid());
        }
        if (entity.getAttendancegroup() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getAttendancegroup());
        }
        if (entity.getAttendancesubgroup() == null) {
          statement.bindNull(5);
        } else {
          statement.bindString(5, entity.getAttendancesubgroup());
        }
        if (entity.getAttendenceteam() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getAttendenceteam());
        }
        if (entity.getActivity() == null) {
          statement.bindNull(7);
        } else {
          statement.bindString(7, entity.getActivity());
        }
        if (entity.getLatitude() == null) {
          statement.bindNull(8);
        } else {
          statement.bindString(8, entity.getLatitude());
        }
        if (entity.getLongitude() == null) {
          statement.bindNull(9);
        } else {
          statement.bindString(9, entity.getLongitude());
        }
        if (entity.getLocation() == null) {
          statement.bindNull(10);
        } else {
          statement.bindString(10, entity.getLocation());
        }
        if (entity.getTimesheetdate() == null) {
          statement.bindNull(11);
        } else {
          statement.bindString(11, entity.getTimesheetdate());
        }
        if (entity.getStarttime() == null) {
          statement.bindNull(12);
        } else {
          statement.bindString(12, entity.getStarttime());
        }
        if (entity.getEndtime() == null) {
          statement.bindNull(13);
        } else {
          statement.bindString(13, entity.getEndtime());
        }
        if (entity.getDateandtime() == null) {
          statement.bindNull(14);
        } else {
          statement.bindString(14, entity.getDateandtime());
        }
        if (entity.getSync() == null) {
          statement.bindNull(15);
        } else {
          statement.bindString(15, entity.getSync());
        }
        if (entity.getFacility_id() == null) {
          statement.bindNull(16);
        } else {
          statement.bindString(16, entity.getFacility_id());
        }
        statement.bindLong(17, entity.getId());
      }
    };
    this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "DELETE  FROM TimesheetEntity";
        return _query;
      }
    };
    this.__preparedStmtOfDeleteHistory = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "DELETE  FROM TimesheetEntity WHERE DATE(TimesheetEntity.starttime)<?";
        return _query;
      }
    };
  }

  @Override
  public Long save(final TimesheetEntity key) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      final Long _result = __insertionAdapterOfTimesheetEntity.insertAndReturnId(key);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void delete(final TimesheetEntity key) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __deletionAdapterOfTimesheetEntity.handle(key);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void merge(final TimesheetEntity key) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfTimesheetEntity.handle(key);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void deleteAll() {
    __db.assertNotSuspendingTransaction();
    final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteAll.acquire();
    try {
      __db.beginTransaction();
      try {
        _stmt.executeUpdateDelete();
        __db.setTransactionSuccessful();
      } finally {
        __db.endTransaction();
      }
    } finally {
      __preparedStmtOfDeleteAll.release(_stmt);
    }
  }

  @Override
  public void deleteHistory(final String date) {
    __db.assertNotSuspendingTransaction();
    final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteHistory.acquire();
    int _argIndex = 1;
    if (date == null) {
      _stmt.bindNull(_argIndex);
    } else {
      _stmt.bindString(_argIndex, date);
    }
    try {
      __db.beginTransaction();
      try {
        _stmt.executeUpdateDelete();
        __db.setTransactionSuccessful();
      } finally {
        __db.endTransaction();
      }
    } finally {
      __preparedStmtOfDeleteHistory.release(_stmt);
    }
  }

  @Override
  public DataSource.Factory<Integer, TimesheetEntity> fetchAll() {
    final String _sql = "SELECT * FROM TimesheetEntity  ORDER BY id DESC";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    return new DataSource.Factory<Integer, TimesheetEntity>() {
      @Override
      @NonNull
      public LimitOffsetDataSource<TimesheetEntity> create() {
        return new LimitOffsetDataSource<TimesheetEntity>(__db, _statement, false, true, "TimesheetEntity") {
          @Override
          @NonNull
          protected List<TimesheetEntity> convertRows(@NonNull final Cursor cursor) {
            final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(cursor, "id");
            final int _cursorIndexOfCompanyname = CursorUtil.getColumnIndexOrThrow(cursor, "companyname");
            final int _cursorIndexOfEmployeemailid = CursorUtil.getColumnIndexOrThrow(cursor, "employeemailid");
            final int _cursorIndexOfAttendancegroup = CursorUtil.getColumnIndexOrThrow(cursor, "attendancegroup");
            final int _cursorIndexOfAttendancesubgroup = CursorUtil.getColumnIndexOrThrow(cursor, "attendancesubgroup");
            final int _cursorIndexOfAttendenceteam = CursorUtil.getColumnIndexOrThrow(cursor, "attendenceteam");
            final int _cursorIndexOfActivity = CursorUtil.getColumnIndexOrThrow(cursor, "activity");
            final int _cursorIndexOfLatitude = CursorUtil.getColumnIndexOrThrow(cursor, "latitude");
            final int _cursorIndexOfLongitude = CursorUtil.getColumnIndexOrThrow(cursor, "longitude");
            final int _cursorIndexOfLocation = CursorUtil.getColumnIndexOrThrow(cursor, "location");
            final int _cursorIndexOfTimesheetdate = CursorUtil.getColumnIndexOrThrow(cursor, "timesheetdate");
            final int _cursorIndexOfStarttime = CursorUtil.getColumnIndexOrThrow(cursor, "starttime");
            final int _cursorIndexOfEndtime = CursorUtil.getColumnIndexOrThrow(cursor, "endtime");
            final int _cursorIndexOfDateandtime = CursorUtil.getColumnIndexOrThrow(cursor, "dateandtime");
            final int _cursorIndexOfSync = CursorUtil.getColumnIndexOrThrow(cursor, "sync");
            final int _cursorIndexOfFacilityId = CursorUtil.getColumnIndexOrThrow(cursor, "facility_id");
            final List<TimesheetEntity> _res = new ArrayList<TimesheetEntity>(cursor.getCount());
            while (cursor.moveToNext()) {
              final TimesheetEntity _item;
              final int _tmpId;
              _tmpId = cursor.getInt(_cursorIndexOfId);
              final String _tmpCompanyname;
              if (cursor.isNull(_cursorIndexOfCompanyname)) {
                _tmpCompanyname = null;
              } else {
                _tmpCompanyname = cursor.getString(_cursorIndexOfCompanyname);
              }
              final String _tmpEmployeemailid;
              if (cursor.isNull(_cursorIndexOfEmployeemailid)) {
                _tmpEmployeemailid = null;
              } else {
                _tmpEmployeemailid = cursor.getString(_cursorIndexOfEmployeemailid);
              }
              final String _tmpAttendancegroup;
              if (cursor.isNull(_cursorIndexOfAttendancegroup)) {
                _tmpAttendancegroup = null;
              } else {
                _tmpAttendancegroup = cursor.getString(_cursorIndexOfAttendancegroup);
              }
              final String _tmpAttendancesubgroup;
              if (cursor.isNull(_cursorIndexOfAttendancesubgroup)) {
                _tmpAttendancesubgroup = null;
              } else {
                _tmpAttendancesubgroup = cursor.getString(_cursorIndexOfAttendancesubgroup);
              }
              final String _tmpAttendenceteam;
              if (cursor.isNull(_cursorIndexOfAttendenceteam)) {
                _tmpAttendenceteam = null;
              } else {
                _tmpAttendenceteam = cursor.getString(_cursorIndexOfAttendenceteam);
              }
              final String _tmpActivity;
              if (cursor.isNull(_cursorIndexOfActivity)) {
                _tmpActivity = null;
              } else {
                _tmpActivity = cursor.getString(_cursorIndexOfActivity);
              }
              final String _tmpLatitude;
              if (cursor.isNull(_cursorIndexOfLatitude)) {
                _tmpLatitude = null;
              } else {
                _tmpLatitude = cursor.getString(_cursorIndexOfLatitude);
              }
              final String _tmpLongitude;
              if (cursor.isNull(_cursorIndexOfLongitude)) {
                _tmpLongitude = null;
              } else {
                _tmpLongitude = cursor.getString(_cursorIndexOfLongitude);
              }
              final String _tmpLocation;
              if (cursor.isNull(_cursorIndexOfLocation)) {
                _tmpLocation = null;
              } else {
                _tmpLocation = cursor.getString(_cursorIndexOfLocation);
              }
              final String _tmpTimesheetdate;
              if (cursor.isNull(_cursorIndexOfTimesheetdate)) {
                _tmpTimesheetdate = null;
              } else {
                _tmpTimesheetdate = cursor.getString(_cursorIndexOfTimesheetdate);
              }
              final String _tmpStarttime;
              if (cursor.isNull(_cursorIndexOfStarttime)) {
                _tmpStarttime = null;
              } else {
                _tmpStarttime = cursor.getString(_cursorIndexOfStarttime);
              }
              final String _tmpEndtime;
              if (cursor.isNull(_cursorIndexOfEndtime)) {
                _tmpEndtime = null;
              } else {
                _tmpEndtime = cursor.getString(_cursorIndexOfEndtime);
              }
              final String _tmpDateandtime;
              if (cursor.isNull(_cursorIndexOfDateandtime)) {
                _tmpDateandtime = null;
              } else {
                _tmpDateandtime = cursor.getString(_cursorIndexOfDateandtime);
              }
              final String _tmpSync;
              if (cursor.isNull(_cursorIndexOfSync)) {
                _tmpSync = null;
              } else {
                _tmpSync = cursor.getString(_cursorIndexOfSync);
              }
              final String _tmpFacility_id;
              if (cursor.isNull(_cursorIndexOfFacilityId)) {
                _tmpFacility_id = null;
              } else {
                _tmpFacility_id = cursor.getString(_cursorIndexOfFacilityId);
              }
              _item = new TimesheetEntity(_tmpId,_tmpCompanyname,_tmpEmployeemailid,_tmpAttendancegroup,_tmpAttendancesubgroup,_tmpAttendenceteam,_tmpActivity,_tmpLatitude,_tmpLongitude,_tmpLocation,_tmpTimesheetdate,_tmpStarttime,_tmpEndtime,_tmpDateandtime,_tmpSync,_tmpFacility_id);
              _res.add(_item);
            }
            return _res;
          }
        };
      }
    };
  }

  @Override
  public DataSource.Factory<Integer, TimesheetEntity> fetchAll(final String startDate,
      final String endDate) {
    final String _sql = "SELECT * FROM TimesheetEntity WHERE DATE(timesheetdate) >= DATE(?) AND DATE(timesheetdate) <= DATE(?) ORDER BY id DESC";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    if (startDate == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, startDate);
    }
    _argIndex = 2;
    if (endDate == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, endDate);
    }
    return new DataSource.Factory<Integer, TimesheetEntity>() {
      @Override
      @NonNull
      public LimitOffsetDataSource<TimesheetEntity> create() {
        return new LimitOffsetDataSource<TimesheetEntity>(__db, _statement, false, true, "TimesheetEntity") {
          @Override
          @NonNull
          protected List<TimesheetEntity> convertRows(@NonNull final Cursor cursor) {
            final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(cursor, "id");
            final int _cursorIndexOfCompanyname = CursorUtil.getColumnIndexOrThrow(cursor, "companyname");
            final int _cursorIndexOfEmployeemailid = CursorUtil.getColumnIndexOrThrow(cursor, "employeemailid");
            final int _cursorIndexOfAttendancegroup = CursorUtil.getColumnIndexOrThrow(cursor, "attendancegroup");
            final int _cursorIndexOfAttendancesubgroup = CursorUtil.getColumnIndexOrThrow(cursor, "attendancesubgroup");
            final int _cursorIndexOfAttendenceteam = CursorUtil.getColumnIndexOrThrow(cursor, "attendenceteam");
            final int _cursorIndexOfActivity = CursorUtil.getColumnIndexOrThrow(cursor, "activity");
            final int _cursorIndexOfLatitude = CursorUtil.getColumnIndexOrThrow(cursor, "latitude");
            final int _cursorIndexOfLongitude = CursorUtil.getColumnIndexOrThrow(cursor, "longitude");
            final int _cursorIndexOfLocation = CursorUtil.getColumnIndexOrThrow(cursor, "location");
            final int _cursorIndexOfTimesheetdate = CursorUtil.getColumnIndexOrThrow(cursor, "timesheetdate");
            final int _cursorIndexOfStarttime = CursorUtil.getColumnIndexOrThrow(cursor, "starttime");
            final int _cursorIndexOfEndtime = CursorUtil.getColumnIndexOrThrow(cursor, "endtime");
            final int _cursorIndexOfDateandtime = CursorUtil.getColumnIndexOrThrow(cursor, "dateandtime");
            final int _cursorIndexOfSync = CursorUtil.getColumnIndexOrThrow(cursor, "sync");
            final int _cursorIndexOfFacilityId = CursorUtil.getColumnIndexOrThrow(cursor, "facility_id");
            final List<TimesheetEntity> _res = new ArrayList<TimesheetEntity>(cursor.getCount());
            while (cursor.moveToNext()) {
              final TimesheetEntity _item;
              final int _tmpId;
              _tmpId = cursor.getInt(_cursorIndexOfId);
              final String _tmpCompanyname;
              if (cursor.isNull(_cursorIndexOfCompanyname)) {
                _tmpCompanyname = null;
              } else {
                _tmpCompanyname = cursor.getString(_cursorIndexOfCompanyname);
              }
              final String _tmpEmployeemailid;
              if (cursor.isNull(_cursorIndexOfEmployeemailid)) {
                _tmpEmployeemailid = null;
              } else {
                _tmpEmployeemailid = cursor.getString(_cursorIndexOfEmployeemailid);
              }
              final String _tmpAttendancegroup;
              if (cursor.isNull(_cursorIndexOfAttendancegroup)) {
                _tmpAttendancegroup = null;
              } else {
                _tmpAttendancegroup = cursor.getString(_cursorIndexOfAttendancegroup);
              }
              final String _tmpAttendancesubgroup;
              if (cursor.isNull(_cursorIndexOfAttendancesubgroup)) {
                _tmpAttendancesubgroup = null;
              } else {
                _tmpAttendancesubgroup = cursor.getString(_cursorIndexOfAttendancesubgroup);
              }
              final String _tmpAttendenceteam;
              if (cursor.isNull(_cursorIndexOfAttendenceteam)) {
                _tmpAttendenceteam = null;
              } else {
                _tmpAttendenceteam = cursor.getString(_cursorIndexOfAttendenceteam);
              }
              final String _tmpActivity;
              if (cursor.isNull(_cursorIndexOfActivity)) {
                _tmpActivity = null;
              } else {
                _tmpActivity = cursor.getString(_cursorIndexOfActivity);
              }
              final String _tmpLatitude;
              if (cursor.isNull(_cursorIndexOfLatitude)) {
                _tmpLatitude = null;
              } else {
                _tmpLatitude = cursor.getString(_cursorIndexOfLatitude);
              }
              final String _tmpLongitude;
              if (cursor.isNull(_cursorIndexOfLongitude)) {
                _tmpLongitude = null;
              } else {
                _tmpLongitude = cursor.getString(_cursorIndexOfLongitude);
              }
              final String _tmpLocation;
              if (cursor.isNull(_cursorIndexOfLocation)) {
                _tmpLocation = null;
              } else {
                _tmpLocation = cursor.getString(_cursorIndexOfLocation);
              }
              final String _tmpTimesheetdate;
              if (cursor.isNull(_cursorIndexOfTimesheetdate)) {
                _tmpTimesheetdate = null;
              } else {
                _tmpTimesheetdate = cursor.getString(_cursorIndexOfTimesheetdate);
              }
              final String _tmpStarttime;
              if (cursor.isNull(_cursorIndexOfStarttime)) {
                _tmpStarttime = null;
              } else {
                _tmpStarttime = cursor.getString(_cursorIndexOfStarttime);
              }
              final String _tmpEndtime;
              if (cursor.isNull(_cursorIndexOfEndtime)) {
                _tmpEndtime = null;
              } else {
                _tmpEndtime = cursor.getString(_cursorIndexOfEndtime);
              }
              final String _tmpDateandtime;
              if (cursor.isNull(_cursorIndexOfDateandtime)) {
                _tmpDateandtime = null;
              } else {
                _tmpDateandtime = cursor.getString(_cursorIndexOfDateandtime);
              }
              final String _tmpSync;
              if (cursor.isNull(_cursorIndexOfSync)) {
                _tmpSync = null;
              } else {
                _tmpSync = cursor.getString(_cursorIndexOfSync);
              }
              final String _tmpFacility_id;
              if (cursor.isNull(_cursorIndexOfFacilityId)) {
                _tmpFacility_id = null;
              } else {
                _tmpFacility_id = cursor.getString(_cursorIndexOfFacilityId);
              }
              _item = new TimesheetEntity(_tmpId,_tmpCompanyname,_tmpEmployeemailid,_tmpAttendancegroup,_tmpAttendancesubgroup,_tmpAttendenceteam,_tmpActivity,_tmpLatitude,_tmpLongitude,_tmpLocation,_tmpTimesheetdate,_tmpStarttime,_tmpEndtime,_tmpDateandtime,_tmpSync,_tmpFacility_id);
              _res.add(_item);
            }
            return _res;
          }
        };
      }
    };
  }

  @Override
  public LiveData<List<TimesheetEntity>> fetchNotSynced() {
    final String _sql = "SELECT * FROM TimesheetEntity WHERE sync='No' ORDER BY id DESC";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    return __db.getInvalidationTracker().createLiveData(new String[] {"TimesheetEntity"}, false, new Callable<List<TimesheetEntity>>() {
      @Override
      @Nullable
      public List<TimesheetEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "id");
          final int _cursorIndexOfCompanyname = CursorUtil.getColumnIndexOrThrow(_cursor, "companyname");
          final int _cursorIndexOfEmployeemailid = CursorUtil.getColumnIndexOrThrow(_cursor, "employeemailid");
          final int _cursorIndexOfAttendancegroup = CursorUtil.getColumnIndexOrThrow(_cursor, "attendancegroup");
          final int _cursorIndexOfAttendancesubgroup = CursorUtil.getColumnIndexOrThrow(_cursor, "attendancesubgroup");
          final int _cursorIndexOfAttendenceteam = CursorUtil.getColumnIndexOrThrow(_cursor, "attendenceteam");
          final int _cursorIndexOfActivity = CursorUtil.getColumnIndexOrThrow(_cursor, "activity");
          final int _cursorIndexOfLatitude = CursorUtil.getColumnIndexOrThrow(_cursor, "latitude");
          final int _cursorIndexOfLongitude = CursorUtil.getColumnIndexOrThrow(_cursor, "longitude");
          final int _cursorIndexOfLocation = CursorUtil.getColumnIndexOrThrow(_cursor, "location");
          final int _cursorIndexOfTimesheetdate = CursorUtil.getColumnIndexOrThrow(_cursor, "timesheetdate");
          final int _cursorIndexOfStarttime = CursorUtil.getColumnIndexOrThrow(_cursor, "starttime");
          final int _cursorIndexOfEndtime = CursorUtil.getColumnIndexOrThrow(_cursor, "endtime");
          final int _cursorIndexOfDateandtime = CursorUtil.getColumnIndexOrThrow(_cursor, "dateandtime");
          final int _cursorIndexOfSync = CursorUtil.getColumnIndexOrThrow(_cursor, "sync");
          final int _cursorIndexOfFacilityId = CursorUtil.getColumnIndexOrThrow(_cursor, "facility_id");
          final List<TimesheetEntity> _result = new ArrayList<TimesheetEntity>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final TimesheetEntity _item;
            final int _tmpId;
            _tmpId = _cursor.getInt(_cursorIndexOfId);
            final String _tmpCompanyname;
            if (_cursor.isNull(_cursorIndexOfCompanyname)) {
              _tmpCompanyname = null;
            } else {
              _tmpCompanyname = _cursor.getString(_cursorIndexOfCompanyname);
            }
            final String _tmpEmployeemailid;
            if (_cursor.isNull(_cursorIndexOfEmployeemailid)) {
              _tmpEmployeemailid = null;
            } else {
              _tmpEmployeemailid = _cursor.getString(_cursorIndexOfEmployeemailid);
            }
            final String _tmpAttendancegroup;
            if (_cursor.isNull(_cursorIndexOfAttendancegroup)) {
              _tmpAttendancegroup = null;
            } else {
              _tmpAttendancegroup = _cursor.getString(_cursorIndexOfAttendancegroup);
            }
            final String _tmpAttendancesubgroup;
            if (_cursor.isNull(_cursorIndexOfAttendancesubgroup)) {
              _tmpAttendancesubgroup = null;
            } else {
              _tmpAttendancesubgroup = _cursor.getString(_cursorIndexOfAttendancesubgroup);
            }
            final String _tmpAttendenceteam;
            if (_cursor.isNull(_cursorIndexOfAttendenceteam)) {
              _tmpAttendenceteam = null;
            } else {
              _tmpAttendenceteam = _cursor.getString(_cursorIndexOfAttendenceteam);
            }
            final String _tmpActivity;
            if (_cursor.isNull(_cursorIndexOfActivity)) {
              _tmpActivity = null;
            } else {
              _tmpActivity = _cursor.getString(_cursorIndexOfActivity);
            }
            final String _tmpLatitude;
            if (_cursor.isNull(_cursorIndexOfLatitude)) {
              _tmpLatitude = null;
            } else {
              _tmpLatitude = _cursor.getString(_cursorIndexOfLatitude);
            }
            final String _tmpLongitude;
            if (_cursor.isNull(_cursorIndexOfLongitude)) {
              _tmpLongitude = null;
            } else {
              _tmpLongitude = _cursor.getString(_cursorIndexOfLongitude);
            }
            final String _tmpLocation;
            if (_cursor.isNull(_cursorIndexOfLocation)) {
              _tmpLocation = null;
            } else {
              _tmpLocation = _cursor.getString(_cursorIndexOfLocation);
            }
            final String _tmpTimesheetdate;
            if (_cursor.isNull(_cursorIndexOfTimesheetdate)) {
              _tmpTimesheetdate = null;
            } else {
              _tmpTimesheetdate = _cursor.getString(_cursorIndexOfTimesheetdate);
            }
            final String _tmpStarttime;
            if (_cursor.isNull(_cursorIndexOfStarttime)) {
              _tmpStarttime = null;
            } else {
              _tmpStarttime = _cursor.getString(_cursorIndexOfStarttime);
            }
            final String _tmpEndtime;
            if (_cursor.isNull(_cursorIndexOfEndtime)) {
              _tmpEndtime = null;
            } else {
              _tmpEndtime = _cursor.getString(_cursorIndexOfEndtime);
            }
            final String _tmpDateandtime;
            if (_cursor.isNull(_cursorIndexOfDateandtime)) {
              _tmpDateandtime = null;
            } else {
              _tmpDateandtime = _cursor.getString(_cursorIndexOfDateandtime);
            }
            final String _tmpSync;
            if (_cursor.isNull(_cursorIndexOfSync)) {
              _tmpSync = null;
            } else {
              _tmpSync = _cursor.getString(_cursorIndexOfSync);
            }
            final String _tmpFacility_id;
            if (_cursor.isNull(_cursorIndexOfFacilityId)) {
              _tmpFacility_id = null;
            } else {
              _tmpFacility_id = _cursor.getString(_cursorIndexOfFacilityId);
            }
            _item = new TimesheetEntity(_tmpId,_tmpCompanyname,_tmpEmployeemailid,_tmpAttendancegroup,_tmpAttendancesubgroup,_tmpAttendenceteam,_tmpActivity,_tmpLatitude,_tmpLongitude,_tmpLocation,_tmpTimesheetdate,_tmpStarttime,_tmpEndtime,_tmpDateandtime,_tmpSync,_tmpFacility_id);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public LiveData<List<TimesheetEntity>> validateTimesheet(final String currentStart,
      final String currentEnd, final String date) {
    final String _sql = "SELECT * FROM TimesheetEntity WHERE timesheetdate=? AND ( TIME(?) BETWEEN  DATETIME(starttime) AND DATETIME(endtime) OR DATETIME(?) BETWEEN DATETIME(starttime) AND DATETIME(endtime)  OR ( DATETIME(starttime) > DATETIME(?)  AND DATETIME(endtime) < DATETIME(?) ))";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 5);
    int _argIndex = 1;
    if (date == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, date);
    }
    _argIndex = 2;
    if (currentStart == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, currentStart);
    }
    _argIndex = 3;
    if (currentEnd == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, currentEnd);
    }
    _argIndex = 4;
    if (currentStart == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, currentStart);
    }
    _argIndex = 5;
    if (currentEnd == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, currentEnd);
    }
    return __db.getInvalidationTracker().createLiveData(new String[] {"TimesheetEntity"}, false, new Callable<List<TimesheetEntity>>() {
      @Override
      @Nullable
      public List<TimesheetEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "id");
          final int _cursorIndexOfCompanyname = CursorUtil.getColumnIndexOrThrow(_cursor, "companyname");
          final int _cursorIndexOfEmployeemailid = CursorUtil.getColumnIndexOrThrow(_cursor, "employeemailid");
          final int _cursorIndexOfAttendancegroup = CursorUtil.getColumnIndexOrThrow(_cursor, "attendancegroup");
          final int _cursorIndexOfAttendancesubgroup = CursorUtil.getColumnIndexOrThrow(_cursor, "attendancesubgroup");
          final int _cursorIndexOfAttendenceteam = CursorUtil.getColumnIndexOrThrow(_cursor, "attendenceteam");
          final int _cursorIndexOfActivity = CursorUtil.getColumnIndexOrThrow(_cursor, "activity");
          final int _cursorIndexOfLatitude = CursorUtil.getColumnIndexOrThrow(_cursor, "latitude");
          final int _cursorIndexOfLongitude = CursorUtil.getColumnIndexOrThrow(_cursor, "longitude");
          final int _cursorIndexOfLocation = CursorUtil.getColumnIndexOrThrow(_cursor, "location");
          final int _cursorIndexOfTimesheetdate = CursorUtil.getColumnIndexOrThrow(_cursor, "timesheetdate");
          final int _cursorIndexOfStarttime = CursorUtil.getColumnIndexOrThrow(_cursor, "starttime");
          final int _cursorIndexOfEndtime = CursorUtil.getColumnIndexOrThrow(_cursor, "endtime");
          final int _cursorIndexOfDateandtime = CursorUtil.getColumnIndexOrThrow(_cursor, "dateandtime");
          final int _cursorIndexOfSync = CursorUtil.getColumnIndexOrThrow(_cursor, "sync");
          final int _cursorIndexOfFacilityId = CursorUtil.getColumnIndexOrThrow(_cursor, "facility_id");
          final List<TimesheetEntity> _result = new ArrayList<TimesheetEntity>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final TimesheetEntity _item;
            final int _tmpId;
            _tmpId = _cursor.getInt(_cursorIndexOfId);
            final String _tmpCompanyname;
            if (_cursor.isNull(_cursorIndexOfCompanyname)) {
              _tmpCompanyname = null;
            } else {
              _tmpCompanyname = _cursor.getString(_cursorIndexOfCompanyname);
            }
            final String _tmpEmployeemailid;
            if (_cursor.isNull(_cursorIndexOfEmployeemailid)) {
              _tmpEmployeemailid = null;
            } else {
              _tmpEmployeemailid = _cursor.getString(_cursorIndexOfEmployeemailid);
            }
            final String _tmpAttendancegroup;
            if (_cursor.isNull(_cursorIndexOfAttendancegroup)) {
              _tmpAttendancegroup = null;
            } else {
              _tmpAttendancegroup = _cursor.getString(_cursorIndexOfAttendancegroup);
            }
            final String _tmpAttendancesubgroup;
            if (_cursor.isNull(_cursorIndexOfAttendancesubgroup)) {
              _tmpAttendancesubgroup = null;
            } else {
              _tmpAttendancesubgroup = _cursor.getString(_cursorIndexOfAttendancesubgroup);
            }
            final String _tmpAttendenceteam;
            if (_cursor.isNull(_cursorIndexOfAttendenceteam)) {
              _tmpAttendenceteam = null;
            } else {
              _tmpAttendenceteam = _cursor.getString(_cursorIndexOfAttendenceteam);
            }
            final String _tmpActivity;
            if (_cursor.isNull(_cursorIndexOfActivity)) {
              _tmpActivity = null;
            } else {
              _tmpActivity = _cursor.getString(_cursorIndexOfActivity);
            }
            final String _tmpLatitude;
            if (_cursor.isNull(_cursorIndexOfLatitude)) {
              _tmpLatitude = null;
            } else {
              _tmpLatitude = _cursor.getString(_cursorIndexOfLatitude);
            }
            final String _tmpLongitude;
            if (_cursor.isNull(_cursorIndexOfLongitude)) {
              _tmpLongitude = null;
            } else {
              _tmpLongitude = _cursor.getString(_cursorIndexOfLongitude);
            }
            final String _tmpLocation;
            if (_cursor.isNull(_cursorIndexOfLocation)) {
              _tmpLocation = null;
            } else {
              _tmpLocation = _cursor.getString(_cursorIndexOfLocation);
            }
            final String _tmpTimesheetdate;
            if (_cursor.isNull(_cursorIndexOfTimesheetdate)) {
              _tmpTimesheetdate = null;
            } else {
              _tmpTimesheetdate = _cursor.getString(_cursorIndexOfTimesheetdate);
            }
            final String _tmpStarttime;
            if (_cursor.isNull(_cursorIndexOfStarttime)) {
              _tmpStarttime = null;
            } else {
              _tmpStarttime = _cursor.getString(_cursorIndexOfStarttime);
            }
            final String _tmpEndtime;
            if (_cursor.isNull(_cursorIndexOfEndtime)) {
              _tmpEndtime = null;
            } else {
              _tmpEndtime = _cursor.getString(_cursorIndexOfEndtime);
            }
            final String _tmpDateandtime;
            if (_cursor.isNull(_cursorIndexOfDateandtime)) {
              _tmpDateandtime = null;
            } else {
              _tmpDateandtime = _cursor.getString(_cursorIndexOfDateandtime);
            }
            final String _tmpSync;
            if (_cursor.isNull(_cursorIndexOfSync)) {
              _tmpSync = null;
            } else {
              _tmpSync = _cursor.getString(_cursorIndexOfSync);
            }
            final String _tmpFacility_id;
            if (_cursor.isNull(_cursorIndexOfFacilityId)) {
              _tmpFacility_id = null;
            } else {
              _tmpFacility_id = _cursor.getString(_cursorIndexOfFacilityId);
            }
            _item = new TimesheetEntity(_tmpId,_tmpCompanyname,_tmpEmployeemailid,_tmpAttendancegroup,_tmpAttendancesubgroup,_tmpAttendenceteam,_tmpActivity,_tmpLatitude,_tmpLongitude,_tmpLocation,_tmpTimesheetdate,_tmpStarttime,_tmpEndtime,_tmpDateandtime,_tmpSync,_tmpFacility_id);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public void updateSynced(final List<Integer> ids) {
    __db.assertNotSuspendingTransaction();
    final StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("UPDATE TimesheetEntity SET sync = 'Yes' WHERE id IN (");
    final int _inputSize = ids.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(")");
    final String _sql = _stringBuilder.toString();
    final SupportSQLiteStatement _stmt = __db.compileStatement(_sql);
    int _argIndex = 1;
    for (Integer _item : ids) {
      if (_item == null) {
        _stmt.bindNull(_argIndex);
      } else {
        _stmt.bindLong(_argIndex, _item);
      }
      _argIndex++;
    }
    __db.beginTransaction();
    try {
      _stmt.executeUpdateDelete();
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
