package com.cruzbytes.alfarz.sql.doa;

import android.database.Cursor;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.LiveData;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.entities.AttendenceEntity;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;

@SuppressWarnings({"unchecked", "deprecation"})
public final class AttendanceDOA_Impl implements AttendanceDOA {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<AttendenceEntity> __insertionAdapterOfAttendenceEntity;

  private final EntityDeletionOrUpdateAdapter<AttendenceEntity> __deletionAdapterOfAttendenceEntity;

  private final EntityDeletionOrUpdateAdapter<AttendenceEntity> __updateAdapterOfAttendenceEntity;

  private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

  private final SharedSQLiteStatement __preparedStmtOfDeleteHistory;

  private final SharedSQLiteStatement __preparedStmtOfUpdateCheckOut;

  public AttendanceDOA_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfAttendenceEntity = new EntityInsertionAdapter<AttendenceEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR REPLACE INTO `AttendenceEntity` (`id`,`companyname`,`emailid`,`date`,`checkintime`,`checkouttime`,`status`,`checkinlocation`,`checkoutlocation`,`totaltime`,`INSYNC`,`OUTSYNC`,`attendanceimage`,`imagepath`,`signature`,`signaturepath`,`facility_id`,`facility_id_out`,`shift_id`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final AttendenceEntity entity) {
        statement.bindLong(1, entity.getId());
        if (entity.getCompanyname() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getCompanyname());
        }
        if (entity.getEmailid() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getEmailid());
        }
        if (entity.getDate() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getDate());
        }
        if (entity.getCheckintime() == null) {
          statement.bindNull(5);
        } else {
          statement.bindString(5, entity.getCheckintime());
        }
        if (entity.getCheckouttime() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getCheckouttime());
        }
        if (entity.getStatus() == null) {
          statement.bindNull(7);
        } else {
          statement.bindString(7, entity.getStatus());
        }
        if (entity.getCheckinlocation() == null) {
          statement.bindNull(8);
        } else {
          statement.bindString(8, entity.getCheckinlocation());
        }
        if (entity.getCheckoutlocation() == null) {
          statement.bindNull(9);
        } else {
          statement.bindString(9, entity.getCheckoutlocation());
        }
        if (entity.getTotaltime() == null) {
          statement.bindNull(10);
        } else {
          statement.bindString(10, entity.getTotaltime());
        }
        if (entity.getINSYNC() == null) {
          statement.bindNull(11);
        } else {
          statement.bindString(11, entity.getINSYNC());
        }
        if (entity.getOUTSYNC() == null) {
          statement.bindNull(12);
        } else {
          statement.bindString(12, entity.getOUTSYNC());
        }
        if (entity.getAttendanceimage() == null) {
          statement.bindNull(13);
        } else {
          statement.bindString(13, entity.getAttendanceimage());
        }
        if (entity.getImagepath() == null) {
          statement.bindNull(14);
        } else {
          statement.bindString(14, entity.getImagepath());
        }
        if (entity.getSignature() == null) {
          statement.bindNull(15);
        } else {
          statement.bindString(15, entity.getSignature());
        }
        if (entity.getSignaturepath() == null) {
          statement.bindNull(16);
        } else {
          statement.bindString(16, entity.getSignaturepath());
        }
        if (entity.getFacility_id() == null) {
          statement.bindNull(17);
        } else {
          statement.bindString(17, entity.getFacility_id());
        }
        if (entity.getFacility_id_out() == null) {
          statement.bindNull(18);
        } else {
          statement.bindString(18, entity.getFacility_id_out());
        }
        if (entity.getShift_id() == null) {
          statement.bindNull(19);
        } else {
          statement.bindString(19, entity.getShift_id());
        }
      }
    };
    this.__deletionAdapterOfAttendenceEntity = new EntityDeletionOrUpdateAdapter<AttendenceEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "DELETE FROM `AttendenceEntity` WHERE `id` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final AttendenceEntity entity) {
        statement.bindLong(1, entity.getId());
      }
    };
    this.__updateAdapterOfAttendenceEntity = new EntityDeletionOrUpdateAdapter<AttendenceEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `AttendenceEntity` SET `id` = ?,`companyname` = ?,`emailid` = ?,`date` = ?,`checkintime` = ?,`checkouttime` = ?,`status` = ?,`checkinlocation` = ?,`checkoutlocation` = ?,`totaltime` = ?,`INSYNC` = ?,`OUTSYNC` = ?,`attendanceimage` = ?,`imagepath` = ?,`signature` = ?,`signaturepath` = ?,`facility_id` = ?,`facility_id_out` = ?,`shift_id` = ? WHERE `id` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final AttendenceEntity entity) {
        statement.bindLong(1, entity.getId());
        if (entity.getCompanyname() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getCompanyname());
        }
        if (entity.getEmailid() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getEmailid());
        }
        if (entity.getDate() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getDate());
        }
        if (entity.getCheckintime() == null) {
          statement.bindNull(5);
        } else {
          statement.bindString(5, entity.getCheckintime());
        }
        if (entity.getCheckouttime() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getCheckouttime());
        }
        if (entity.getStatus() == null) {
          statement.bindNull(7);
        } else {
          statement.bindString(7, entity.getStatus());
        }
        if (entity.getCheckinlocation() == null) {
          statement.bindNull(8);
        } else {
          statement.bindString(8, entity.getCheckinlocation());
        }
        if (entity.getCheckoutlocation() == null) {
          statement.bindNull(9);
        } else {
          statement.bindString(9, entity.getCheckoutlocation());
        }
        if (entity.getTotaltime() == null) {
          statement.bindNull(10);
        } else {
          statement.bindString(10, entity.getTotaltime());
        }
        if (entity.getINSYNC() == null) {
          statement.bindNull(11);
        } else {
          statement.bindString(11, entity.getINSYNC());
        }
        if (entity.getOUTSYNC() == null) {
          statement.bindNull(12);
        } else {
          statement.bindString(12, entity.getOUTSYNC());
        }
        if (entity.getAttendanceimage() == null) {
          statement.bindNull(13);
        } else {
          statement.bindString(13, entity.getAttendanceimage());
        }
        if (entity.getImagepath() == null) {
          statement.bindNull(14);
        } else {
          statement.bindString(14, entity.getImagepath());
        }
        if (entity.getSignature() == null) {
          statement.bindNull(15);
        } else {
          statement.bindString(15, entity.getSignature());
        }
        if (entity.getSignaturepath() == null) {
          statement.bindNull(16);
        } else {
          statement.bindString(16, entity.getSignaturepath());
        }
        if (entity.getFacility_id() == null) {
          statement.bindNull(17);
        } else {
          statement.bindString(17, entity.getFacility_id());
        }
        if (entity.getFacility_id_out() == null) {
          statement.bindNull(18);
        } else {
          statement.bindString(18, entity.getFacility_id_out());
        }
        if (entity.getShift_id() == null) {
          statement.bindNull(19);
        } else {
          statement.bindString(19, entity.getShift_id());
        }
        statement.bindLong(20, entity.getId());
      }
    };
    this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "DELETE  FROM AttendenceEntity";
        return _query;
      }
    };
    this.__preparedStmtOfDeleteHistory = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "DELETE  FROM AttendenceEntity WHERE DATE(AttendenceEntity.date)<?";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateCheckOut = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "UPDATE AttendenceEntity SET status=?,totaltime=?,facility_id_out=?,checkouttime=?,checkoutlocation=?,OUTSYNC='No',status='Present' WHERE id=?";
        return _query;
      }
    };
  }

  @Override
  public Long save(final AttendenceEntity key) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      final Long _result = __insertionAdapterOfAttendenceEntity.insertAndReturnId(key);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void delete(final AttendenceEntity key) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __deletionAdapterOfAttendenceEntity.handle(key);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void merge(final AttendenceEntity key) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfAttendenceEntity.handle(key);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void deleteAll() {
    __db.assertNotSuspendingTransaction();
    final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteAll.acquire();
    try {
      __db.beginTransaction();
      try {
        _stmt.executeUpdateDelete();
        __db.setTransactionSuccessful();
      } finally {
        __db.endTransaction();
      }
    } finally {
      __preparedStmtOfDeleteAll.release(_stmt);
    }
  }

  @Override
  public void deleteHistory(final String date) {
    __db.assertNotSuspendingTransaction();
    final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteHistory.acquire();
    int _argIndex = 1;
    if (date == null) {
      _stmt.bindNull(_argIndex);
    } else {
      _stmt.bindString(_argIndex, date);
    }
    try {
      __db.beginTransaction();
      try {
        _stmt.executeUpdateDelete();
        __db.setTransactionSuccessful();
      } finally {
        __db.endTransaction();
      }
    } finally {
      __preparedStmtOfDeleteHistory.release(_stmt);
    }
  }

  @Override
  public void updateCheckOut(final String checkouttime, final String checkoutlocation,
      final String status, final String toaltime, final int id, final String facility_id_out) {
    __db.assertNotSuspendingTransaction();
    final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateCheckOut.acquire();
    int _argIndex = 1;
    if (status == null) {
      _stmt.bindNull(_argIndex);
    } else {
      _stmt.bindString(_argIndex, status);
    }
    _argIndex = 2;
    if (toaltime == null) {
      _stmt.bindNull(_argIndex);
    } else {
      _stmt.bindString(_argIndex, toaltime);
    }
    _argIndex = 3;
    if (facility_id_out == null) {
      _stmt.bindNull(_argIndex);
    } else {
      _stmt.bindString(_argIndex, facility_id_out);
    }
    _argIndex = 4;
    if (checkouttime == null) {
      _stmt.bindNull(_argIndex);
    } else {
      _stmt.bindString(_argIndex, checkouttime);
    }
    _argIndex = 5;
    if (checkoutlocation == null) {
      _stmt.bindNull(_argIndex);
    } else {
      _stmt.bindString(_argIndex, checkoutlocation);
    }
    _argIndex = 6;
    _stmt.bindLong(_argIndex, id);
    try {
      __db.beginTransaction();
      try {
        _stmt.executeUpdateDelete();
        __db.setTransactionSuccessful();
      } finally {
        __db.endTransaction();
      }
    } finally {
      __preparedStmtOfUpdateCheckOut.release(_stmt);
    }
  }

  @Override
  public LiveData<List<AttendenceEntity>> fetchAll() {
    final String _sql = "SELECT * FROM AttendenceEntity ORDER BY id DESC";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    return __db.getInvalidationTracker().createLiveData(new String[] {"AttendenceEntity"}, false, new Callable<List<AttendenceEntity>>() {
      @Override
      @Nullable
      public List<AttendenceEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "id");
          final int _cursorIndexOfCompanyname = CursorUtil.getColumnIndexOrThrow(_cursor, "companyname");
          final int _cursorIndexOfEmailid = CursorUtil.getColumnIndexOrThrow(_cursor, "emailid");
          final int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow(_cursor, "date");
          final int _cursorIndexOfCheckintime = CursorUtil.getColumnIndexOrThrow(_cursor, "checkintime");
          final int _cursorIndexOfCheckouttime = CursorUtil.getColumnIndexOrThrow(_cursor, "checkouttime");
          final int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "status");
          final int _cursorIndexOfCheckinlocation = CursorUtil.getColumnIndexOrThrow(_cursor, "checkinlocation");
          final int _cursorIndexOfCheckoutlocation = CursorUtil.getColumnIndexOrThrow(_cursor, "checkoutlocation");
          final int _cursorIndexOfTotaltime = CursorUtil.getColumnIndexOrThrow(_cursor, "totaltime");
          final int _cursorIndexOfINSYNC = CursorUtil.getColumnIndexOrThrow(_cursor, "INSYNC");
          final int _cursorIndexOfOUTSYNC = CursorUtil.getColumnIndexOrThrow(_cursor, "OUTSYNC");
          final int _cursorIndexOfAttendanceimage = CursorUtil.getColumnIndexOrThrow(_cursor, "attendanceimage");
          final int _cursorIndexOfImagepath = CursorUtil.getColumnIndexOrThrow(_cursor, "imagepath");
          final int _cursorIndexOfSignature = CursorUtil.getColumnIndexOrThrow(_cursor, "signature");
          final int _cursorIndexOfSignaturepath = CursorUtil.getColumnIndexOrThrow(_cursor, "signaturepath");
          final int _cursorIndexOfFacilityId = CursorUtil.getColumnIndexOrThrow(_cursor, "facility_id");
          final int _cursorIndexOfFacilityIdOut = CursorUtil.getColumnIndexOrThrow(_cursor, "facility_id_out");
          final int _cursorIndexOfShiftId = CursorUtil.getColumnIndexOrThrow(_cursor, "shift_id");
          final List<AttendenceEntity> _result = new ArrayList<AttendenceEntity>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final AttendenceEntity _item;
            final int _tmpId;
            _tmpId = _cursor.getInt(_cursorIndexOfId);
            final String _tmpCompanyname;
            if (_cursor.isNull(_cursorIndexOfCompanyname)) {
              _tmpCompanyname = null;
            } else {
              _tmpCompanyname = _cursor.getString(_cursorIndexOfCompanyname);
            }
            final String _tmpEmailid;
            if (_cursor.isNull(_cursorIndexOfEmailid)) {
              _tmpEmailid = null;
            } else {
              _tmpEmailid = _cursor.getString(_cursorIndexOfEmailid);
            }
            final String _tmpDate;
            if (_cursor.isNull(_cursorIndexOfDate)) {
              _tmpDate = null;
            } else {
              _tmpDate = _cursor.getString(_cursorIndexOfDate);
            }
            final String _tmpCheckintime;
            if (_cursor.isNull(_cursorIndexOfCheckintime)) {
              _tmpCheckintime = null;
            } else {
              _tmpCheckintime = _cursor.getString(_cursorIndexOfCheckintime);
            }
            final String _tmpCheckouttime;
            if (_cursor.isNull(_cursorIndexOfCheckouttime)) {
              _tmpCheckouttime = null;
            } else {
              _tmpCheckouttime = _cursor.getString(_cursorIndexOfCheckouttime);
            }
            final String _tmpStatus;
            if (_cursor.isNull(_cursorIndexOfStatus)) {
              _tmpStatus = null;
            } else {
              _tmpStatus = _cursor.getString(_cursorIndexOfStatus);
            }
            final String _tmpCheckinlocation;
            if (_cursor.isNull(_cursorIndexOfCheckinlocation)) {
              _tmpCheckinlocation = null;
            } else {
              _tmpCheckinlocation = _cursor.getString(_cursorIndexOfCheckinlocation);
            }
            final String _tmpCheckoutlocation;
            if (_cursor.isNull(_cursorIndexOfCheckoutlocation)) {
              _tmpCheckoutlocation = null;
            } else {
              _tmpCheckoutlocation = _cursor.getString(_cursorIndexOfCheckoutlocation);
            }
            final String _tmpTotaltime;
            if (_cursor.isNull(_cursorIndexOfTotaltime)) {
              _tmpTotaltime = null;
            } else {
              _tmpTotaltime = _cursor.getString(_cursorIndexOfTotaltime);
            }
            final String _tmpINSYNC;
            if (_cursor.isNull(_cursorIndexOfINSYNC)) {
              _tmpINSYNC = null;
            } else {
              _tmpINSYNC = _cursor.getString(_cursorIndexOfINSYNC);
            }
            final String _tmpOUTSYNC;
            if (_cursor.isNull(_cursorIndexOfOUTSYNC)) {
              _tmpOUTSYNC = null;
            } else {
              _tmpOUTSYNC = _cursor.getString(_cursorIndexOfOUTSYNC);
            }
            final String _tmpAttendanceimage;
            if (_cursor.isNull(_cursorIndexOfAttendanceimage)) {
              _tmpAttendanceimage = null;
            } else {
              _tmpAttendanceimage = _cursor.getString(_cursorIndexOfAttendanceimage);
            }
            final String _tmpImagepath;
            if (_cursor.isNull(_cursorIndexOfImagepath)) {
              _tmpImagepath = null;
            } else {
              _tmpImagepath = _cursor.getString(_cursorIndexOfImagepath);
            }
            final String _tmpSignature;
            if (_cursor.isNull(_cursorIndexOfSignature)) {
              _tmpSignature = null;
            } else {
              _tmpSignature = _cursor.getString(_cursorIndexOfSignature);
            }
            final String _tmpSignaturepath;
            if (_cursor.isNull(_cursorIndexOfSignaturepath)) {
              _tmpSignaturepath = null;
            } else {
              _tmpSignaturepath = _cursor.getString(_cursorIndexOfSignaturepath);
            }
            final String _tmpFacility_id;
            if (_cursor.isNull(_cursorIndexOfFacilityId)) {
              _tmpFacility_id = null;
            } else {
              _tmpFacility_id = _cursor.getString(_cursorIndexOfFacilityId);
            }
            final String _tmpFacility_id_out;
            if (_cursor.isNull(_cursorIndexOfFacilityIdOut)) {
              _tmpFacility_id_out = null;
            } else {
              _tmpFacility_id_out = _cursor.getString(_cursorIndexOfFacilityIdOut);
            }
            final String _tmpShift_id;
            if (_cursor.isNull(_cursorIndexOfShiftId)) {
              _tmpShift_id = null;
            } else {
              _tmpShift_id = _cursor.getString(_cursorIndexOfShiftId);
            }
            _item = new AttendenceEntity(_tmpId,_tmpCompanyname,_tmpEmailid,_tmpDate,_tmpCheckintime,_tmpCheckouttime,_tmpStatus,_tmpCheckinlocation,_tmpCheckoutlocation,_tmpTotaltime,_tmpINSYNC,_tmpOUTSYNC,_tmpAttendanceimage,_tmpImagepath,_tmpSignature,_tmpSignaturepath,_tmpFacility_id,_tmpFacility_id_out,_tmpShift_id);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public LiveData<List<AttendenceEntity>> fetchLatest() {
    final String _sql = "SELECT * FROM AttendenceEntity ORDER BY id DESC LIMIT 6";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    return __db.getInvalidationTracker().createLiveData(new String[] {"AttendenceEntity"}, false, new Callable<List<AttendenceEntity>>() {
      @Override
      @Nullable
      public List<AttendenceEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "id");
          final int _cursorIndexOfCompanyname = CursorUtil.getColumnIndexOrThrow(_cursor, "companyname");
          final int _cursorIndexOfEmailid = CursorUtil.getColumnIndexOrThrow(_cursor, "emailid");
          final int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow(_cursor, "date");
          final int _cursorIndexOfCheckintime = CursorUtil.getColumnIndexOrThrow(_cursor, "checkintime");
          final int _cursorIndexOfCheckouttime = CursorUtil.getColumnIndexOrThrow(_cursor, "checkouttime");
          final int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "status");
          final int _cursorIndexOfCheckinlocation = CursorUtil.getColumnIndexOrThrow(_cursor, "checkinlocation");
          final int _cursorIndexOfCheckoutlocation = CursorUtil.getColumnIndexOrThrow(_cursor, "checkoutlocation");
          final int _cursorIndexOfTotaltime = CursorUtil.getColumnIndexOrThrow(_cursor, "totaltime");
          final int _cursorIndexOfINSYNC = CursorUtil.getColumnIndexOrThrow(_cursor, "INSYNC");
          final int _cursorIndexOfOUTSYNC = CursorUtil.getColumnIndexOrThrow(_cursor, "OUTSYNC");
          final int _cursorIndexOfAttendanceimage = CursorUtil.getColumnIndexOrThrow(_cursor, "attendanceimage");
          final int _cursorIndexOfImagepath = CursorUtil.getColumnIndexOrThrow(_cursor, "imagepath");
          final int _cursorIndexOfSignature = CursorUtil.getColumnIndexOrThrow(_cursor, "signature");
          final int _cursorIndexOfSignaturepath = CursorUtil.getColumnIndexOrThrow(_cursor, "signaturepath");
          final int _cursorIndexOfFacilityId = CursorUtil.getColumnIndexOrThrow(_cursor, "facility_id");
          final int _cursorIndexOfFacilityIdOut = CursorUtil.getColumnIndexOrThrow(_cursor, "facility_id_out");
          final int _cursorIndexOfShiftId = CursorUtil.getColumnIndexOrThrow(_cursor, "shift_id");
          final List<AttendenceEntity> _result = new ArrayList<AttendenceEntity>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final AttendenceEntity _item;
            final int _tmpId;
            _tmpId = _cursor.getInt(_cursorIndexOfId);
            final String _tmpCompanyname;
            if (_cursor.isNull(_cursorIndexOfCompanyname)) {
              _tmpCompanyname = null;
            } else {
              _tmpCompanyname = _cursor.getString(_cursorIndexOfCompanyname);
            }
            final String _tmpEmailid;
            if (_cursor.isNull(_cursorIndexOfEmailid)) {
              _tmpEmailid = null;
            } else {
              _tmpEmailid = _cursor.getString(_cursorIndexOfEmailid);
            }
            final String _tmpDate;
            if (_cursor.isNull(_cursorIndexOfDate)) {
              _tmpDate = null;
            } else {
              _tmpDate = _cursor.getString(_cursorIndexOfDate);
            }
            final String _tmpCheckintime;
            if (_cursor.isNull(_cursorIndexOfCheckintime)) {
              _tmpCheckintime = null;
            } else {
              _tmpCheckintime = _cursor.getString(_cursorIndexOfCheckintime);
            }
            final String _tmpCheckouttime;
            if (_cursor.isNull(_cursorIndexOfCheckouttime)) {
              _tmpCheckouttime = null;
            } else {
              _tmpCheckouttime = _cursor.getString(_cursorIndexOfCheckouttime);
            }
            final String _tmpStatus;
            if (_cursor.isNull(_cursorIndexOfStatus)) {
              _tmpStatus = null;
            } else {
              _tmpStatus = _cursor.getString(_cursorIndexOfStatus);
            }
            final String _tmpCheckinlocation;
            if (_cursor.isNull(_cursorIndexOfCheckinlocation)) {
              _tmpCheckinlocation = null;
            } else {
              _tmpCheckinlocation = _cursor.getString(_cursorIndexOfCheckinlocation);
            }
            final String _tmpCheckoutlocation;
            if (_cursor.isNull(_cursorIndexOfCheckoutlocation)) {
              _tmpCheckoutlocation = null;
            } else {
              _tmpCheckoutlocation = _cursor.getString(_cursorIndexOfCheckoutlocation);
            }
            final String _tmpTotaltime;
            if (_cursor.isNull(_cursorIndexOfTotaltime)) {
              _tmpTotaltime = null;
            } else {
              _tmpTotaltime = _cursor.getString(_cursorIndexOfTotaltime);
            }
            final String _tmpINSYNC;
            if (_cursor.isNull(_cursorIndexOfINSYNC)) {
              _tmpINSYNC = null;
            } else {
              _tmpINSYNC = _cursor.getString(_cursorIndexOfINSYNC);
            }
            final String _tmpOUTSYNC;
            if (_cursor.isNull(_cursorIndexOfOUTSYNC)) {
              _tmpOUTSYNC = null;
            } else {
              _tmpOUTSYNC = _cursor.getString(_cursorIndexOfOUTSYNC);
            }
            final String _tmpAttendanceimage;
            if (_cursor.isNull(_cursorIndexOfAttendanceimage)) {
              _tmpAttendanceimage = null;
            } else {
              _tmpAttendanceimage = _cursor.getString(_cursorIndexOfAttendanceimage);
            }
            final String _tmpImagepath;
            if (_cursor.isNull(_cursorIndexOfImagepath)) {
              _tmpImagepath = null;
            } else {
              _tmpImagepath = _cursor.getString(_cursorIndexOfImagepath);
            }
            final String _tmpSignature;
            if (_cursor.isNull(_cursorIndexOfSignature)) {
              _tmpSignature = null;
            } else {
              _tmpSignature = _cursor.getString(_cursorIndexOfSignature);
            }
            final String _tmpSignaturepath;
            if (_cursor.isNull(_cursorIndexOfSignaturepath)) {
              _tmpSignaturepath = null;
            } else {
              _tmpSignaturepath = _cursor.getString(_cursorIndexOfSignaturepath);
            }
            final String _tmpFacility_id;
            if (_cursor.isNull(_cursorIndexOfFacilityId)) {
              _tmpFacility_id = null;
            } else {
              _tmpFacility_id = _cursor.getString(_cursorIndexOfFacilityId);
            }
            final String _tmpFacility_id_out;
            if (_cursor.isNull(_cursorIndexOfFacilityIdOut)) {
              _tmpFacility_id_out = null;
            } else {
              _tmpFacility_id_out = _cursor.getString(_cursorIndexOfFacilityIdOut);
            }
            final String _tmpShift_id;
            if (_cursor.isNull(_cursorIndexOfShiftId)) {
              _tmpShift_id = null;
            } else {
              _tmpShift_id = _cursor.getString(_cursorIndexOfShiftId);
            }
            _item = new AttendenceEntity(_tmpId,_tmpCompanyname,_tmpEmailid,_tmpDate,_tmpCheckintime,_tmpCheckouttime,_tmpStatus,_tmpCheckinlocation,_tmpCheckoutlocation,_tmpTotaltime,_tmpINSYNC,_tmpOUTSYNC,_tmpAttendanceimage,_tmpImagepath,_tmpSignature,_tmpSignaturepath,_tmpFacility_id,_tmpFacility_id_out,_tmpShift_id);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public LiveData<List<AttendenceEntity>> getAttendance(final String date, final String shiftId) {
    final String _sql = "SELECT * FROM AttendenceEntity WHERE DATE(AttendenceEntity.date)=? AND shift_id=?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    if (date == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, date);
    }
    _argIndex = 2;
    if (shiftId == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, shiftId);
    }
    return __db.getInvalidationTracker().createLiveData(new String[] {"AttendenceEntity"}, false, new Callable<List<AttendenceEntity>>() {
      @Override
      @Nullable
      public List<AttendenceEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "id");
          final int _cursorIndexOfCompanyname = CursorUtil.getColumnIndexOrThrow(_cursor, "companyname");
          final int _cursorIndexOfEmailid = CursorUtil.getColumnIndexOrThrow(_cursor, "emailid");
          final int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow(_cursor, "date");
          final int _cursorIndexOfCheckintime = CursorUtil.getColumnIndexOrThrow(_cursor, "checkintime");
          final int _cursorIndexOfCheckouttime = CursorUtil.getColumnIndexOrThrow(_cursor, "checkouttime");
          final int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "status");
          final int _cursorIndexOfCheckinlocation = CursorUtil.getColumnIndexOrThrow(_cursor, "checkinlocation");
          final int _cursorIndexOfCheckoutlocation = CursorUtil.getColumnIndexOrThrow(_cursor, "checkoutlocation");
          final int _cursorIndexOfTotaltime = CursorUtil.getColumnIndexOrThrow(_cursor, "totaltime");
          final int _cursorIndexOfINSYNC = CursorUtil.getColumnIndexOrThrow(_cursor, "INSYNC");
          final int _cursorIndexOfOUTSYNC = CursorUtil.getColumnIndexOrThrow(_cursor, "OUTSYNC");
          final int _cursorIndexOfAttendanceimage = CursorUtil.getColumnIndexOrThrow(_cursor, "attendanceimage");
          final int _cursorIndexOfImagepath = CursorUtil.getColumnIndexOrThrow(_cursor, "imagepath");
          final int _cursorIndexOfSignature = CursorUtil.getColumnIndexOrThrow(_cursor, "signature");
          final int _cursorIndexOfSignaturepath = CursorUtil.getColumnIndexOrThrow(_cursor, "signaturepath");
          final int _cursorIndexOfFacilityId = CursorUtil.getColumnIndexOrThrow(_cursor, "facility_id");
          final int _cursorIndexOfFacilityIdOut = CursorUtil.getColumnIndexOrThrow(_cursor, "facility_id_out");
          final int _cursorIndexOfShiftId = CursorUtil.getColumnIndexOrThrow(_cursor, "shift_id");
          final List<AttendenceEntity> _result = new ArrayList<AttendenceEntity>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final AttendenceEntity _item;
            final int _tmpId;
            _tmpId = _cursor.getInt(_cursorIndexOfId);
            final String _tmpCompanyname;
            if (_cursor.isNull(_cursorIndexOfCompanyname)) {
              _tmpCompanyname = null;
            } else {
              _tmpCompanyname = _cursor.getString(_cursorIndexOfCompanyname);
            }
            final String _tmpEmailid;
            if (_cursor.isNull(_cursorIndexOfEmailid)) {
              _tmpEmailid = null;
            } else {
              _tmpEmailid = _cursor.getString(_cursorIndexOfEmailid);
            }
            final String _tmpDate;
            if (_cursor.isNull(_cursorIndexOfDate)) {
              _tmpDate = null;
            } else {
              _tmpDate = _cursor.getString(_cursorIndexOfDate);
            }
            final String _tmpCheckintime;
            if (_cursor.isNull(_cursorIndexOfCheckintime)) {
              _tmpCheckintime = null;
            } else {
              _tmpCheckintime = _cursor.getString(_cursorIndexOfCheckintime);
            }
            final String _tmpCheckouttime;
            if (_cursor.isNull(_cursorIndexOfCheckouttime)) {
              _tmpCheckouttime = null;
            } else {
              _tmpCheckouttime = _cursor.getString(_cursorIndexOfCheckouttime);
            }
            final String _tmpStatus;
            if (_cursor.isNull(_cursorIndexOfStatus)) {
              _tmpStatus = null;
            } else {
              _tmpStatus = _cursor.getString(_cursorIndexOfStatus);
            }
            final String _tmpCheckinlocation;
            if (_cursor.isNull(_cursorIndexOfCheckinlocation)) {
              _tmpCheckinlocation = null;
            } else {
              _tmpCheckinlocation = _cursor.getString(_cursorIndexOfCheckinlocation);
            }
            final String _tmpCheckoutlocation;
            if (_cursor.isNull(_cursorIndexOfCheckoutlocation)) {
              _tmpCheckoutlocation = null;
            } else {
              _tmpCheckoutlocation = _cursor.getString(_cursorIndexOfCheckoutlocation);
            }
            final String _tmpTotaltime;
            if (_cursor.isNull(_cursorIndexOfTotaltime)) {
              _tmpTotaltime = null;
            } else {
              _tmpTotaltime = _cursor.getString(_cursorIndexOfTotaltime);
            }
            final String _tmpINSYNC;
            if (_cursor.isNull(_cursorIndexOfINSYNC)) {
              _tmpINSYNC = null;
            } else {
              _tmpINSYNC = _cursor.getString(_cursorIndexOfINSYNC);
            }
            final String _tmpOUTSYNC;
            if (_cursor.isNull(_cursorIndexOfOUTSYNC)) {
              _tmpOUTSYNC = null;
            } else {
              _tmpOUTSYNC = _cursor.getString(_cursorIndexOfOUTSYNC);
            }
            final String _tmpAttendanceimage;
            if (_cursor.isNull(_cursorIndexOfAttendanceimage)) {
              _tmpAttendanceimage = null;
            } else {
              _tmpAttendanceimage = _cursor.getString(_cursorIndexOfAttendanceimage);
            }
            final String _tmpImagepath;
            if (_cursor.isNull(_cursorIndexOfImagepath)) {
              _tmpImagepath = null;
            } else {
              _tmpImagepath = _cursor.getString(_cursorIndexOfImagepath);
            }
            final String _tmpSignature;
            if (_cursor.isNull(_cursorIndexOfSignature)) {
              _tmpSignature = null;
            } else {
              _tmpSignature = _cursor.getString(_cursorIndexOfSignature);
            }
            final String _tmpSignaturepath;
            if (_cursor.isNull(_cursorIndexOfSignaturepath)) {
              _tmpSignaturepath = null;
            } else {
              _tmpSignaturepath = _cursor.getString(_cursorIndexOfSignaturepath);
            }
            final String _tmpFacility_id;
            if (_cursor.isNull(_cursorIndexOfFacilityId)) {
              _tmpFacility_id = null;
            } else {
              _tmpFacility_id = _cursor.getString(_cursorIndexOfFacilityId);
            }
            final String _tmpFacility_id_out;
            if (_cursor.isNull(_cursorIndexOfFacilityIdOut)) {
              _tmpFacility_id_out = null;
            } else {
              _tmpFacility_id_out = _cursor.getString(_cursorIndexOfFacilityIdOut);
            }
            final String _tmpShift_id;
            if (_cursor.isNull(_cursorIndexOfShiftId)) {
              _tmpShift_id = null;
            } else {
              _tmpShift_id = _cursor.getString(_cursorIndexOfShiftId);
            }
            _item = new AttendenceEntity(_tmpId,_tmpCompanyname,_tmpEmailid,_tmpDate,_tmpCheckintime,_tmpCheckouttime,_tmpStatus,_tmpCheckinlocation,_tmpCheckoutlocation,_tmpTotaltime,_tmpINSYNC,_tmpOUTSYNC,_tmpAttendanceimage,_tmpImagepath,_tmpSignature,_tmpSignaturepath,_tmpFacility_id,_tmpFacility_id_out,_tmpShift_id);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public LiveData<List<AttendenceEntity>> getAttendance(final String date) {
    final String _sql = "SELECT * FROM AttendenceEntity WHERE DATE(AttendenceEntity.date)=?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    if (date == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, date);
    }
    return __db.getInvalidationTracker().createLiveData(new String[] {"AttendenceEntity"}, false, new Callable<List<AttendenceEntity>>() {
      @Override
      @Nullable
      public List<AttendenceEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "id");
          final int _cursorIndexOfCompanyname = CursorUtil.getColumnIndexOrThrow(_cursor, "companyname");
          final int _cursorIndexOfEmailid = CursorUtil.getColumnIndexOrThrow(_cursor, "emailid");
          final int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow(_cursor, "date");
          final int _cursorIndexOfCheckintime = CursorUtil.getColumnIndexOrThrow(_cursor, "checkintime");
          final int _cursorIndexOfCheckouttime = CursorUtil.getColumnIndexOrThrow(_cursor, "checkouttime");
          final int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "status");
          final int _cursorIndexOfCheckinlocation = CursorUtil.getColumnIndexOrThrow(_cursor, "checkinlocation");
          final int _cursorIndexOfCheckoutlocation = CursorUtil.getColumnIndexOrThrow(_cursor, "checkoutlocation");
          final int _cursorIndexOfTotaltime = CursorUtil.getColumnIndexOrThrow(_cursor, "totaltime");
          final int _cursorIndexOfINSYNC = CursorUtil.getColumnIndexOrThrow(_cursor, "INSYNC");
          final int _cursorIndexOfOUTSYNC = CursorUtil.getColumnIndexOrThrow(_cursor, "OUTSYNC");
          final int _cursorIndexOfAttendanceimage = CursorUtil.getColumnIndexOrThrow(_cursor, "attendanceimage");
          final int _cursorIndexOfImagepath = CursorUtil.getColumnIndexOrThrow(_cursor, "imagepath");
          final int _cursorIndexOfSignature = CursorUtil.getColumnIndexOrThrow(_cursor, "signature");
          final int _cursorIndexOfSignaturepath = CursorUtil.getColumnIndexOrThrow(_cursor, "signaturepath");
          final int _cursorIndexOfFacilityId = CursorUtil.getColumnIndexOrThrow(_cursor, "facility_id");
          final int _cursorIndexOfFacilityIdOut = CursorUtil.getColumnIndexOrThrow(_cursor, "facility_id_out");
          final int _cursorIndexOfShiftId = CursorUtil.getColumnIndexOrThrow(_cursor, "shift_id");
          final List<AttendenceEntity> _result = new ArrayList<AttendenceEntity>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final AttendenceEntity _item;
            final int _tmpId;
            _tmpId = _cursor.getInt(_cursorIndexOfId);
            final String _tmpCompanyname;
            if (_cursor.isNull(_cursorIndexOfCompanyname)) {
              _tmpCompanyname = null;
            } else {
              _tmpCompanyname = _cursor.getString(_cursorIndexOfCompanyname);
            }
            final String _tmpEmailid;
            if (_cursor.isNull(_cursorIndexOfEmailid)) {
              _tmpEmailid = null;
            } else {
              _tmpEmailid = _cursor.getString(_cursorIndexOfEmailid);
            }
            final String _tmpDate;
            if (_cursor.isNull(_cursorIndexOfDate)) {
              _tmpDate = null;
            } else {
              _tmpDate = _cursor.getString(_cursorIndexOfDate);
            }
            final String _tmpCheckintime;
            if (_cursor.isNull(_cursorIndexOfCheckintime)) {
              _tmpCheckintime = null;
            } else {
              _tmpCheckintime = _cursor.getString(_cursorIndexOfCheckintime);
            }
            final String _tmpCheckouttime;
            if (_cursor.isNull(_cursorIndexOfCheckouttime)) {
              _tmpCheckouttime = null;
            } else {
              _tmpCheckouttime = _cursor.getString(_cursorIndexOfCheckouttime);
            }
            final String _tmpStatus;
            if (_cursor.isNull(_cursorIndexOfStatus)) {
              _tmpStatus = null;
            } else {
              _tmpStatus = _cursor.getString(_cursorIndexOfStatus);
            }
            final String _tmpCheckinlocation;
            if (_cursor.isNull(_cursorIndexOfCheckinlocation)) {
              _tmpCheckinlocation = null;
            } else {
              _tmpCheckinlocation = _cursor.getString(_cursorIndexOfCheckinlocation);
            }
            final String _tmpCheckoutlocation;
            if (_cursor.isNull(_cursorIndexOfCheckoutlocation)) {
              _tmpCheckoutlocation = null;
            } else {
              _tmpCheckoutlocation = _cursor.getString(_cursorIndexOfCheckoutlocation);
            }
            final String _tmpTotaltime;
            if (_cursor.isNull(_cursorIndexOfTotaltime)) {
              _tmpTotaltime = null;
            } else {
              _tmpTotaltime = _cursor.getString(_cursorIndexOfTotaltime);
            }
            final String _tmpINSYNC;
            if (_cursor.isNull(_cursorIndexOfINSYNC)) {
              _tmpINSYNC = null;
            } else {
              _tmpINSYNC = _cursor.getString(_cursorIndexOfINSYNC);
            }
            final String _tmpOUTSYNC;
            if (_cursor.isNull(_cursorIndexOfOUTSYNC)) {
              _tmpOUTSYNC = null;
            } else {
              _tmpOUTSYNC = _cursor.getString(_cursorIndexOfOUTSYNC);
            }
            final String _tmpAttendanceimage;
            if (_cursor.isNull(_cursorIndexOfAttendanceimage)) {
              _tmpAttendanceimage = null;
            } else {
              _tmpAttendanceimage = _cursor.getString(_cursorIndexOfAttendanceimage);
            }
            final String _tmpImagepath;
            if (_cursor.isNull(_cursorIndexOfImagepath)) {
              _tmpImagepath = null;
            } else {
              _tmpImagepath = _cursor.getString(_cursorIndexOfImagepath);
            }
            final String _tmpSignature;
            if (_cursor.isNull(_cursorIndexOfSignature)) {
              _tmpSignature = null;
            } else {
              _tmpSignature = _cursor.getString(_cursorIndexOfSignature);
            }
            final String _tmpSignaturepath;
            if (_cursor.isNull(_cursorIndexOfSignaturepath)) {
              _tmpSignaturepath = null;
            } else {
              _tmpSignaturepath = _cursor.getString(_cursorIndexOfSignaturepath);
            }
            final String _tmpFacility_id;
            if (_cursor.isNull(_cursorIndexOfFacilityId)) {
              _tmpFacility_id = null;
            } else {
              _tmpFacility_id = _cursor.getString(_cursorIndexOfFacilityId);
            }
            final String _tmpFacility_id_out;
            if (_cursor.isNull(_cursorIndexOfFacilityIdOut)) {
              _tmpFacility_id_out = null;
            } else {
              _tmpFacility_id_out = _cursor.getString(_cursorIndexOfFacilityIdOut);
            }
            final String _tmpShift_id;
            if (_cursor.isNull(_cursorIndexOfShiftId)) {
              _tmpShift_id = null;
            } else {
              _tmpShift_id = _cursor.getString(_cursorIndexOfShiftId);
            }
            _item = new AttendenceEntity(_tmpId,_tmpCompanyname,_tmpEmailid,_tmpDate,_tmpCheckintime,_tmpCheckouttime,_tmpStatus,_tmpCheckinlocation,_tmpCheckoutlocation,_tmpTotaltime,_tmpINSYNC,_tmpOUTSYNC,_tmpAttendanceimage,_tmpImagepath,_tmpSignature,_tmpSignaturepath,_tmpFacility_id,_tmpFacility_id_out,_tmpShift_id);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public LiveData<List<AttendenceEntity>> getCheckInNotSynced() {
    final String _sql = "SELECT * FROM AttendenceEntity WHERE INSYNC='No' AND OUTSYNC='No' LIMIT 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    return __db.getInvalidationTracker().createLiveData(new String[] {"AttendenceEntity"}, false, new Callable<List<AttendenceEntity>>() {
      @Override
      @Nullable
      public List<AttendenceEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "id");
          final int _cursorIndexOfCompanyname = CursorUtil.getColumnIndexOrThrow(_cursor, "companyname");
          final int _cursorIndexOfEmailid = CursorUtil.getColumnIndexOrThrow(_cursor, "emailid");
          final int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow(_cursor, "date");
          final int _cursorIndexOfCheckintime = CursorUtil.getColumnIndexOrThrow(_cursor, "checkintime");
          final int _cursorIndexOfCheckouttime = CursorUtil.getColumnIndexOrThrow(_cursor, "checkouttime");
          final int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "status");
          final int _cursorIndexOfCheckinlocation = CursorUtil.getColumnIndexOrThrow(_cursor, "checkinlocation");
          final int _cursorIndexOfCheckoutlocation = CursorUtil.getColumnIndexOrThrow(_cursor, "checkoutlocation");
          final int _cursorIndexOfTotaltime = CursorUtil.getColumnIndexOrThrow(_cursor, "totaltime");
          final int _cursorIndexOfINSYNC = CursorUtil.getColumnIndexOrThrow(_cursor, "INSYNC");
          final int _cursorIndexOfOUTSYNC = CursorUtil.getColumnIndexOrThrow(_cursor, "OUTSYNC");
          final int _cursorIndexOfAttendanceimage = CursorUtil.getColumnIndexOrThrow(_cursor, "attendanceimage");
          final int _cursorIndexOfImagepath = CursorUtil.getColumnIndexOrThrow(_cursor, "imagepath");
          final int _cursorIndexOfSignature = CursorUtil.getColumnIndexOrThrow(_cursor, "signature");
          final int _cursorIndexOfSignaturepath = CursorUtil.getColumnIndexOrThrow(_cursor, "signaturepath");
          final int _cursorIndexOfFacilityId = CursorUtil.getColumnIndexOrThrow(_cursor, "facility_id");
          final int _cursorIndexOfFacilityIdOut = CursorUtil.getColumnIndexOrThrow(_cursor, "facility_id_out");
          final int _cursorIndexOfShiftId = CursorUtil.getColumnIndexOrThrow(_cursor, "shift_id");
          final List<AttendenceEntity> _result = new ArrayList<AttendenceEntity>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final AttendenceEntity _item;
            final int _tmpId;
            _tmpId = _cursor.getInt(_cursorIndexOfId);
            final String _tmpCompanyname;
            if (_cursor.isNull(_cursorIndexOfCompanyname)) {
              _tmpCompanyname = null;
            } else {
              _tmpCompanyname = _cursor.getString(_cursorIndexOfCompanyname);
            }
            final String _tmpEmailid;
            if (_cursor.isNull(_cursorIndexOfEmailid)) {
              _tmpEmailid = null;
            } else {
              _tmpEmailid = _cursor.getString(_cursorIndexOfEmailid);
            }
            final String _tmpDate;
            if (_cursor.isNull(_cursorIndexOfDate)) {
              _tmpDate = null;
            } else {
              _tmpDate = _cursor.getString(_cursorIndexOfDate);
            }
            final String _tmpCheckintime;
            if (_cursor.isNull(_cursorIndexOfCheckintime)) {
              _tmpCheckintime = null;
            } else {
              _tmpCheckintime = _cursor.getString(_cursorIndexOfCheckintime);
            }
            final String _tmpCheckouttime;
            if (_cursor.isNull(_cursorIndexOfCheckouttime)) {
              _tmpCheckouttime = null;
            } else {
              _tmpCheckouttime = _cursor.getString(_cursorIndexOfCheckouttime);
            }
            final String _tmpStatus;
            if (_cursor.isNull(_cursorIndexOfStatus)) {
              _tmpStatus = null;
            } else {
              _tmpStatus = _cursor.getString(_cursorIndexOfStatus);
            }
            final String _tmpCheckinlocation;
            if (_cursor.isNull(_cursorIndexOfCheckinlocation)) {
              _tmpCheckinlocation = null;
            } else {
              _tmpCheckinlocation = _cursor.getString(_cursorIndexOfCheckinlocation);
            }
            final String _tmpCheckoutlocation;
            if (_cursor.isNull(_cursorIndexOfCheckoutlocation)) {
              _tmpCheckoutlocation = null;
            } else {
              _tmpCheckoutlocation = _cursor.getString(_cursorIndexOfCheckoutlocation);
            }
            final String _tmpTotaltime;
            if (_cursor.isNull(_cursorIndexOfTotaltime)) {
              _tmpTotaltime = null;
            } else {
              _tmpTotaltime = _cursor.getString(_cursorIndexOfTotaltime);
            }
            final String _tmpINSYNC;
            if (_cursor.isNull(_cursorIndexOfINSYNC)) {
              _tmpINSYNC = null;
            } else {
              _tmpINSYNC = _cursor.getString(_cursorIndexOfINSYNC);
            }
            final String _tmpOUTSYNC;
            if (_cursor.isNull(_cursorIndexOfOUTSYNC)) {
              _tmpOUTSYNC = null;
            } else {
              _tmpOUTSYNC = _cursor.getString(_cursorIndexOfOUTSYNC);
            }
            final String _tmpAttendanceimage;
            if (_cursor.isNull(_cursorIndexOfAttendanceimage)) {
              _tmpAttendanceimage = null;
            } else {
              _tmpAttendanceimage = _cursor.getString(_cursorIndexOfAttendanceimage);
            }
            final String _tmpImagepath;
            if (_cursor.isNull(_cursorIndexOfImagepath)) {
              _tmpImagepath = null;
            } else {
              _tmpImagepath = _cursor.getString(_cursorIndexOfImagepath);
            }
            final String _tmpSignature;
            if (_cursor.isNull(_cursorIndexOfSignature)) {
              _tmpSignature = null;
            } else {
              _tmpSignature = _cursor.getString(_cursorIndexOfSignature);
            }
            final String _tmpSignaturepath;
            if (_cursor.isNull(_cursorIndexOfSignaturepath)) {
              _tmpSignaturepath = null;
            } else {
              _tmpSignaturepath = _cursor.getString(_cursorIndexOfSignaturepath);
            }
            final String _tmpFacility_id;
            if (_cursor.isNull(_cursorIndexOfFacilityId)) {
              _tmpFacility_id = null;
            } else {
              _tmpFacility_id = _cursor.getString(_cursorIndexOfFacilityId);
            }
            final String _tmpFacility_id_out;
            if (_cursor.isNull(_cursorIndexOfFacilityIdOut)) {
              _tmpFacility_id_out = null;
            } else {
              _tmpFacility_id_out = _cursor.getString(_cursorIndexOfFacilityIdOut);
            }
            final String _tmpShift_id;
            if (_cursor.isNull(_cursorIndexOfShiftId)) {
              _tmpShift_id = null;
            } else {
              _tmpShift_id = _cursor.getString(_cursorIndexOfShiftId);
            }
            _item = new AttendenceEntity(_tmpId,_tmpCompanyname,_tmpEmailid,_tmpDate,_tmpCheckintime,_tmpCheckouttime,_tmpStatus,_tmpCheckinlocation,_tmpCheckoutlocation,_tmpTotaltime,_tmpINSYNC,_tmpOUTSYNC,_tmpAttendanceimage,_tmpImagepath,_tmpSignature,_tmpSignaturepath,_tmpFacility_id,_tmpFacility_id_out,_tmpShift_id);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public LiveData<List<AttendenceEntity>> getCheckOutNotSynced() {
    final String _sql = "SELECT * FROM AttendenceEntity WHERE AttendenceEntity.OUTSYNC='No' AND status='Present' LIMIT 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    return __db.getInvalidationTracker().createLiveData(new String[] {"AttendenceEntity"}, false, new Callable<List<AttendenceEntity>>() {
      @Override
      @Nullable
      public List<AttendenceEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "id");
          final int _cursorIndexOfCompanyname = CursorUtil.getColumnIndexOrThrow(_cursor, "companyname");
          final int _cursorIndexOfEmailid = CursorUtil.getColumnIndexOrThrow(_cursor, "emailid");
          final int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow(_cursor, "date");
          final int _cursorIndexOfCheckintime = CursorUtil.getColumnIndexOrThrow(_cursor, "checkintime");
          final int _cursorIndexOfCheckouttime = CursorUtil.getColumnIndexOrThrow(_cursor, "checkouttime");
          final int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "status");
          final int _cursorIndexOfCheckinlocation = CursorUtil.getColumnIndexOrThrow(_cursor, "checkinlocation");
          final int _cursorIndexOfCheckoutlocation = CursorUtil.getColumnIndexOrThrow(_cursor, "checkoutlocation");
          final int _cursorIndexOfTotaltime = CursorUtil.getColumnIndexOrThrow(_cursor, "totaltime");
          final int _cursorIndexOfINSYNC = CursorUtil.getColumnIndexOrThrow(_cursor, "INSYNC");
          final int _cursorIndexOfOUTSYNC = CursorUtil.getColumnIndexOrThrow(_cursor, "OUTSYNC");
          final int _cursorIndexOfAttendanceimage = CursorUtil.getColumnIndexOrThrow(_cursor, "attendanceimage");
          final int _cursorIndexOfImagepath = CursorUtil.getColumnIndexOrThrow(_cursor, "imagepath");
          final int _cursorIndexOfSignature = CursorUtil.getColumnIndexOrThrow(_cursor, "signature");
          final int _cursorIndexOfSignaturepath = CursorUtil.getColumnIndexOrThrow(_cursor, "signaturepath");
          final int _cursorIndexOfFacilityId = CursorUtil.getColumnIndexOrThrow(_cursor, "facility_id");
          final int _cursorIndexOfFacilityIdOut = CursorUtil.getColumnIndexOrThrow(_cursor, "facility_id_out");
          final int _cursorIndexOfShiftId = CursorUtil.getColumnIndexOrThrow(_cursor, "shift_id");
          final List<AttendenceEntity> _result = new ArrayList<AttendenceEntity>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final AttendenceEntity _item;
            final int _tmpId;
            _tmpId = _cursor.getInt(_cursorIndexOfId);
            final String _tmpCompanyname;
            if (_cursor.isNull(_cursorIndexOfCompanyname)) {
              _tmpCompanyname = null;
            } else {
              _tmpCompanyname = _cursor.getString(_cursorIndexOfCompanyname);
            }
            final String _tmpEmailid;
            if (_cursor.isNull(_cursorIndexOfEmailid)) {
              _tmpEmailid = null;
            } else {
              _tmpEmailid = _cursor.getString(_cursorIndexOfEmailid);
            }
            final String _tmpDate;
            if (_cursor.isNull(_cursorIndexOfDate)) {
              _tmpDate = null;
            } else {
              _tmpDate = _cursor.getString(_cursorIndexOfDate);
            }
            final String _tmpCheckintime;
            if (_cursor.isNull(_cursorIndexOfCheckintime)) {
              _tmpCheckintime = null;
            } else {
              _tmpCheckintime = _cursor.getString(_cursorIndexOfCheckintime);
            }
            final String _tmpCheckouttime;
            if (_cursor.isNull(_cursorIndexOfCheckouttime)) {
              _tmpCheckouttime = null;
            } else {
              _tmpCheckouttime = _cursor.getString(_cursorIndexOfCheckouttime);
            }
            final String _tmpStatus;
            if (_cursor.isNull(_cursorIndexOfStatus)) {
              _tmpStatus = null;
            } else {
              _tmpStatus = _cursor.getString(_cursorIndexOfStatus);
            }
            final String _tmpCheckinlocation;
            if (_cursor.isNull(_cursorIndexOfCheckinlocation)) {
              _tmpCheckinlocation = null;
            } else {
              _tmpCheckinlocation = _cursor.getString(_cursorIndexOfCheckinlocation);
            }
            final String _tmpCheckoutlocation;
            if (_cursor.isNull(_cursorIndexOfCheckoutlocation)) {
              _tmpCheckoutlocation = null;
            } else {
              _tmpCheckoutlocation = _cursor.getString(_cursorIndexOfCheckoutlocation);
            }
            final String _tmpTotaltime;
            if (_cursor.isNull(_cursorIndexOfTotaltime)) {
              _tmpTotaltime = null;
            } else {
              _tmpTotaltime = _cursor.getString(_cursorIndexOfTotaltime);
            }
            final String _tmpINSYNC;
            if (_cursor.isNull(_cursorIndexOfINSYNC)) {
              _tmpINSYNC = null;
            } else {
              _tmpINSYNC = _cursor.getString(_cursorIndexOfINSYNC);
            }
            final String _tmpOUTSYNC;
            if (_cursor.isNull(_cursorIndexOfOUTSYNC)) {
              _tmpOUTSYNC = null;
            } else {
              _tmpOUTSYNC = _cursor.getString(_cursorIndexOfOUTSYNC);
            }
            final String _tmpAttendanceimage;
            if (_cursor.isNull(_cursorIndexOfAttendanceimage)) {
              _tmpAttendanceimage = null;
            } else {
              _tmpAttendanceimage = _cursor.getString(_cursorIndexOfAttendanceimage);
            }
            final String _tmpImagepath;
            if (_cursor.isNull(_cursorIndexOfImagepath)) {
              _tmpImagepath = null;
            } else {
              _tmpImagepath = _cursor.getString(_cursorIndexOfImagepath);
            }
            final String _tmpSignature;
            if (_cursor.isNull(_cursorIndexOfSignature)) {
              _tmpSignature = null;
            } else {
              _tmpSignature = _cursor.getString(_cursorIndexOfSignature);
            }
            final String _tmpSignaturepath;
            if (_cursor.isNull(_cursorIndexOfSignaturepath)) {
              _tmpSignaturepath = null;
            } else {
              _tmpSignaturepath = _cursor.getString(_cursorIndexOfSignaturepath);
            }
            final String _tmpFacility_id;
            if (_cursor.isNull(_cursorIndexOfFacilityId)) {
              _tmpFacility_id = null;
            } else {
              _tmpFacility_id = _cursor.getString(_cursorIndexOfFacilityId);
            }
            final String _tmpFacility_id_out;
            if (_cursor.isNull(_cursorIndexOfFacilityIdOut)) {
              _tmpFacility_id_out = null;
            } else {
              _tmpFacility_id_out = _cursor.getString(_cursorIndexOfFacilityIdOut);
            }
            final String _tmpShift_id;
            if (_cursor.isNull(_cursorIndexOfShiftId)) {
              _tmpShift_id = null;
            } else {
              _tmpShift_id = _cursor.getString(_cursorIndexOfShiftId);
            }
            _item = new AttendenceEntity(_tmpId,_tmpCompanyname,_tmpEmailid,_tmpDate,_tmpCheckintime,_tmpCheckouttime,_tmpStatus,_tmpCheckinlocation,_tmpCheckoutlocation,_tmpTotaltime,_tmpINSYNC,_tmpOUTSYNC,_tmpAttendanceimage,_tmpImagepath,_tmpSignature,_tmpSignaturepath,_tmpFacility_id,_tmpFacility_id_out,_tmpShift_id);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public LiveData<List<AttendenceEntity>> getcurrentmonthpresent(final String startdate,
      final String enddate) {
    final String _sql = "SELECT * FROM AttendenceEntity WHERE DATE(AttendenceEntity.date)<=? AND DATE(AttendenceEntity.date)>=? ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    if (enddate == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, enddate);
    }
    _argIndex = 2;
    if (startdate == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, startdate);
    }
    return __db.getInvalidationTracker().createLiveData(new String[] {"AttendenceEntity"}, false, new Callable<List<AttendenceEntity>>() {
      @Override
      @Nullable
      public List<AttendenceEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "id");
          final int _cursorIndexOfCompanyname = CursorUtil.getColumnIndexOrThrow(_cursor, "companyname");
          final int _cursorIndexOfEmailid = CursorUtil.getColumnIndexOrThrow(_cursor, "emailid");
          final int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow(_cursor, "date");
          final int _cursorIndexOfCheckintime = CursorUtil.getColumnIndexOrThrow(_cursor, "checkintime");
          final int _cursorIndexOfCheckouttime = CursorUtil.getColumnIndexOrThrow(_cursor, "checkouttime");
          final int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "status");
          final int _cursorIndexOfCheckinlocation = CursorUtil.getColumnIndexOrThrow(_cursor, "checkinlocation");
          final int _cursorIndexOfCheckoutlocation = CursorUtil.getColumnIndexOrThrow(_cursor, "checkoutlocation");
          final int _cursorIndexOfTotaltime = CursorUtil.getColumnIndexOrThrow(_cursor, "totaltime");
          final int _cursorIndexOfINSYNC = CursorUtil.getColumnIndexOrThrow(_cursor, "INSYNC");
          final int _cursorIndexOfOUTSYNC = CursorUtil.getColumnIndexOrThrow(_cursor, "OUTSYNC");
          final int _cursorIndexOfAttendanceimage = CursorUtil.getColumnIndexOrThrow(_cursor, "attendanceimage");
          final int _cursorIndexOfImagepath = CursorUtil.getColumnIndexOrThrow(_cursor, "imagepath");
          final int _cursorIndexOfSignature = CursorUtil.getColumnIndexOrThrow(_cursor, "signature");
          final int _cursorIndexOfSignaturepath = CursorUtil.getColumnIndexOrThrow(_cursor, "signaturepath");
          final int _cursorIndexOfFacilityId = CursorUtil.getColumnIndexOrThrow(_cursor, "facility_id");
          final int _cursorIndexOfFacilityIdOut = CursorUtil.getColumnIndexOrThrow(_cursor, "facility_id_out");
          final int _cursorIndexOfShiftId = CursorUtil.getColumnIndexOrThrow(_cursor, "shift_id");
          final List<AttendenceEntity> _result = new ArrayList<AttendenceEntity>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final AttendenceEntity _item;
            final int _tmpId;
            _tmpId = _cursor.getInt(_cursorIndexOfId);
            final String _tmpCompanyname;
            if (_cursor.isNull(_cursorIndexOfCompanyname)) {
              _tmpCompanyname = null;
            } else {
              _tmpCompanyname = _cursor.getString(_cursorIndexOfCompanyname);
            }
            final String _tmpEmailid;
            if (_cursor.isNull(_cursorIndexOfEmailid)) {
              _tmpEmailid = null;
            } else {
              _tmpEmailid = _cursor.getString(_cursorIndexOfEmailid);
            }
            final String _tmpDate;
            if (_cursor.isNull(_cursorIndexOfDate)) {
              _tmpDate = null;
            } else {
              _tmpDate = _cursor.getString(_cursorIndexOfDate);
            }
            final String _tmpCheckintime;
            if (_cursor.isNull(_cursorIndexOfCheckintime)) {
              _tmpCheckintime = null;
            } else {
              _tmpCheckintime = _cursor.getString(_cursorIndexOfCheckintime);
            }
            final String _tmpCheckouttime;
            if (_cursor.isNull(_cursorIndexOfCheckouttime)) {
              _tmpCheckouttime = null;
            } else {
              _tmpCheckouttime = _cursor.getString(_cursorIndexOfCheckouttime);
            }
            final String _tmpStatus;
            if (_cursor.isNull(_cursorIndexOfStatus)) {
              _tmpStatus = null;
            } else {
              _tmpStatus = _cursor.getString(_cursorIndexOfStatus);
            }
            final String _tmpCheckinlocation;
            if (_cursor.isNull(_cursorIndexOfCheckinlocation)) {
              _tmpCheckinlocation = null;
            } else {
              _tmpCheckinlocation = _cursor.getString(_cursorIndexOfCheckinlocation);
            }
            final String _tmpCheckoutlocation;
            if (_cursor.isNull(_cursorIndexOfCheckoutlocation)) {
              _tmpCheckoutlocation = null;
            } else {
              _tmpCheckoutlocation = _cursor.getString(_cursorIndexOfCheckoutlocation);
            }
            final String _tmpTotaltime;
            if (_cursor.isNull(_cursorIndexOfTotaltime)) {
              _tmpTotaltime = null;
            } else {
              _tmpTotaltime = _cursor.getString(_cursorIndexOfTotaltime);
            }
            final String _tmpINSYNC;
            if (_cursor.isNull(_cursorIndexOfINSYNC)) {
              _tmpINSYNC = null;
            } else {
              _tmpINSYNC = _cursor.getString(_cursorIndexOfINSYNC);
            }
            final String _tmpOUTSYNC;
            if (_cursor.isNull(_cursorIndexOfOUTSYNC)) {
              _tmpOUTSYNC = null;
            } else {
              _tmpOUTSYNC = _cursor.getString(_cursorIndexOfOUTSYNC);
            }
            final String _tmpAttendanceimage;
            if (_cursor.isNull(_cursorIndexOfAttendanceimage)) {
              _tmpAttendanceimage = null;
            } else {
              _tmpAttendanceimage = _cursor.getString(_cursorIndexOfAttendanceimage);
            }
            final String _tmpImagepath;
            if (_cursor.isNull(_cursorIndexOfImagepath)) {
              _tmpImagepath = null;
            } else {
              _tmpImagepath = _cursor.getString(_cursorIndexOfImagepath);
            }
            final String _tmpSignature;
            if (_cursor.isNull(_cursorIndexOfSignature)) {
              _tmpSignature = null;
            } else {
              _tmpSignature = _cursor.getString(_cursorIndexOfSignature);
            }
            final String _tmpSignaturepath;
            if (_cursor.isNull(_cursorIndexOfSignaturepath)) {
              _tmpSignaturepath = null;
            } else {
              _tmpSignaturepath = _cursor.getString(_cursorIndexOfSignaturepath);
            }
            final String _tmpFacility_id;
            if (_cursor.isNull(_cursorIndexOfFacilityId)) {
              _tmpFacility_id = null;
            } else {
              _tmpFacility_id = _cursor.getString(_cursorIndexOfFacilityId);
            }
            final String _tmpFacility_id_out;
            if (_cursor.isNull(_cursorIndexOfFacilityIdOut)) {
              _tmpFacility_id_out = null;
            } else {
              _tmpFacility_id_out = _cursor.getString(_cursorIndexOfFacilityIdOut);
            }
            final String _tmpShift_id;
            if (_cursor.isNull(_cursorIndexOfShiftId)) {
              _tmpShift_id = null;
            } else {
              _tmpShift_id = _cursor.getString(_cursorIndexOfShiftId);
            }
            _item = new AttendenceEntity(_tmpId,_tmpCompanyname,_tmpEmailid,_tmpDate,_tmpCheckintime,_tmpCheckouttime,_tmpStatus,_tmpCheckinlocation,_tmpCheckoutlocation,_tmpTotaltime,_tmpINSYNC,_tmpOUTSYNC,_tmpAttendanceimage,_tmpImagepath,_tmpSignature,_tmpSignaturepath,_tmpFacility_id,_tmpFacility_id_out,_tmpShift_id);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public List<AttendenceEntity> getcurrentmonth_present(final String startdate,
      final String enddate) {
    final String _sql = "SELECT * FROM AttendenceEntity WHERE DATE(AttendenceEntity.date)<=? AND DATE(AttendenceEntity.date)>=? ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    if (enddate == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, enddate);
    }
    _argIndex = 2;
    if (startdate == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, startdate);
    }
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "id");
      final int _cursorIndexOfCompanyname = CursorUtil.getColumnIndexOrThrow(_cursor, "companyname");
      final int _cursorIndexOfEmailid = CursorUtil.getColumnIndexOrThrow(_cursor, "emailid");
      final int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow(_cursor, "date");
      final int _cursorIndexOfCheckintime = CursorUtil.getColumnIndexOrThrow(_cursor, "checkintime");
      final int _cursorIndexOfCheckouttime = CursorUtil.getColumnIndexOrThrow(_cursor, "checkouttime");
      final int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "status");
      final int _cursorIndexOfCheckinlocation = CursorUtil.getColumnIndexOrThrow(_cursor, "checkinlocation");
      final int _cursorIndexOfCheckoutlocation = CursorUtil.getColumnIndexOrThrow(_cursor, "checkoutlocation");
      final int _cursorIndexOfTotaltime = CursorUtil.getColumnIndexOrThrow(_cursor, "totaltime");
      final int _cursorIndexOfINSYNC = CursorUtil.getColumnIndexOrThrow(_cursor, "INSYNC");
      final int _cursorIndexOfOUTSYNC = CursorUtil.getColumnIndexOrThrow(_cursor, "OUTSYNC");
      final int _cursorIndexOfAttendanceimage = CursorUtil.getColumnIndexOrThrow(_cursor, "attendanceimage");
      final int _cursorIndexOfImagepath = CursorUtil.getColumnIndexOrThrow(_cursor, "imagepath");
      final int _cursorIndexOfSignature = CursorUtil.getColumnIndexOrThrow(_cursor, "signature");
      final int _cursorIndexOfSignaturepath = CursorUtil.getColumnIndexOrThrow(_cursor, "signaturepath");
      final int _cursorIndexOfFacilityId = CursorUtil.getColumnIndexOrThrow(_cursor, "facility_id");
      final int _cursorIndexOfFacilityIdOut = CursorUtil.getColumnIndexOrThrow(_cursor, "facility_id_out");
      final int _cursorIndexOfShiftId = CursorUtil.getColumnIndexOrThrow(_cursor, "shift_id");
      final List<AttendenceEntity> _result = new ArrayList<AttendenceEntity>(_cursor.getCount());
      while (_cursor.moveToNext()) {
        final AttendenceEntity _item;
        final int _tmpId;
        _tmpId = _cursor.getInt(_cursorIndexOfId);
        final String _tmpCompanyname;
        if (_cursor.isNull(_cursorIndexOfCompanyname)) {
          _tmpCompanyname = null;
        } else {
          _tmpCompanyname = _cursor.getString(_cursorIndexOfCompanyname);
        }
        final String _tmpEmailid;
        if (_cursor.isNull(_cursorIndexOfEmailid)) {
          _tmpEmailid = null;
        } else {
          _tmpEmailid = _cursor.getString(_cursorIndexOfEmailid);
        }
        final String _tmpDate;
        if (_cursor.isNull(_cursorIndexOfDate)) {
          _tmpDate = null;
        } else {
          _tmpDate = _cursor.getString(_cursorIndexOfDate);
        }
        final String _tmpCheckintime;
        if (_cursor.isNull(_cursorIndexOfCheckintime)) {
          _tmpCheckintime = null;
        } else {
          _tmpCheckintime = _cursor.getString(_cursorIndexOfCheckintime);
        }
        final String _tmpCheckouttime;
        if (_cursor.isNull(_cursorIndexOfCheckouttime)) {
          _tmpCheckouttime = null;
        } else {
          _tmpCheckouttime = _cursor.getString(_cursorIndexOfCheckouttime);
        }
        final String _tmpStatus;
        if (_cursor.isNull(_cursorIndexOfStatus)) {
          _tmpStatus = null;
        } else {
          _tmpStatus = _cursor.getString(_cursorIndexOfStatus);
        }
        final String _tmpCheckinlocation;
        if (_cursor.isNull(_cursorIndexOfCheckinlocation)) {
          _tmpCheckinlocation = null;
        } else {
          _tmpCheckinlocation = _cursor.getString(_cursorIndexOfCheckinlocation);
        }
        final String _tmpCheckoutlocation;
        if (_cursor.isNull(_cursorIndexOfCheckoutlocation)) {
          _tmpCheckoutlocation = null;
        } else {
          _tmpCheckoutlocation = _cursor.getString(_cursorIndexOfCheckoutlocation);
        }
        final String _tmpTotaltime;
        if (_cursor.isNull(_cursorIndexOfTotaltime)) {
          _tmpTotaltime = null;
        } else {
          _tmpTotaltime = _cursor.getString(_cursorIndexOfTotaltime);
        }
        final String _tmpINSYNC;
        if (_cursor.isNull(_cursorIndexOfINSYNC)) {
          _tmpINSYNC = null;
        } else {
          _tmpINSYNC = _cursor.getString(_cursorIndexOfINSYNC);
        }
        final String _tmpOUTSYNC;
        if (_cursor.isNull(_cursorIndexOfOUTSYNC)) {
          _tmpOUTSYNC = null;
        } else {
          _tmpOUTSYNC = _cursor.getString(_cursorIndexOfOUTSYNC);
        }
        final String _tmpAttendanceimage;
        if (_cursor.isNull(_cursorIndexOfAttendanceimage)) {
          _tmpAttendanceimage = null;
        } else {
          _tmpAttendanceimage = _cursor.getString(_cursorIndexOfAttendanceimage);
        }
        final String _tmpImagepath;
        if (_cursor.isNull(_cursorIndexOfImagepath)) {
          _tmpImagepath = null;
        } else {
          _tmpImagepath = _cursor.getString(_cursorIndexOfImagepath);
        }
        final String _tmpSignature;
        if (_cursor.isNull(_cursorIndexOfSignature)) {
          _tmpSignature = null;
        } else {
          _tmpSignature = _cursor.getString(_cursorIndexOfSignature);
        }
        final String _tmpSignaturepath;
        if (_cursor.isNull(_cursorIndexOfSignaturepath)) {
          _tmpSignaturepath = null;
        } else {
          _tmpSignaturepath = _cursor.getString(_cursorIndexOfSignaturepath);
        }
        final String _tmpFacility_id;
        if (_cursor.isNull(_cursorIndexOfFacilityId)) {
          _tmpFacility_id = null;
        } else {
          _tmpFacility_id = _cursor.getString(_cursorIndexOfFacilityId);
        }
        final String _tmpFacility_id_out;
        if (_cursor.isNull(_cursorIndexOfFacilityIdOut)) {
          _tmpFacility_id_out = null;
        } else {
          _tmpFacility_id_out = _cursor.getString(_cursorIndexOfFacilityIdOut);
        }
        final String _tmpShift_id;
        if (_cursor.isNull(_cursorIndexOfShiftId)) {
          _tmpShift_id = null;
        } else {
          _tmpShift_id = _cursor.getString(_cursorIndexOfShiftId);
        }
        _item = new AttendenceEntity(_tmpId,_tmpCompanyname,_tmpEmailid,_tmpDate,_tmpCheckintime,_tmpCheckouttime,_tmpStatus,_tmpCheckinlocation,_tmpCheckoutlocation,_tmpTotaltime,_tmpINSYNC,_tmpOUTSYNC,_tmpAttendanceimage,_tmpImagepath,_tmpSignature,_tmpSignaturepath,_tmpFacility_id,_tmpFacility_id_out,_tmpShift_id);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public LiveData<List<AttendenceEntity>> getselecteddatedetails_attendance(
      final String selecteddate) {
    final String _sql = "SELECT * FROM AttendenceEntity WHERE DATE(AttendenceEntity.date) =? ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    if (selecteddate == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, selecteddate);
    }
    return __db.getInvalidationTracker().createLiveData(new String[] {"AttendenceEntity"}, false, new Callable<List<AttendenceEntity>>() {
      @Override
      @Nullable
      public List<AttendenceEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "id");
          final int _cursorIndexOfCompanyname = CursorUtil.getColumnIndexOrThrow(_cursor, "companyname");
          final int _cursorIndexOfEmailid = CursorUtil.getColumnIndexOrThrow(_cursor, "emailid");
          final int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow(_cursor, "date");
          final int _cursorIndexOfCheckintime = CursorUtil.getColumnIndexOrThrow(_cursor, "checkintime");
          final int _cursorIndexOfCheckouttime = CursorUtil.getColumnIndexOrThrow(_cursor, "checkouttime");
          final int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "status");
          final int _cursorIndexOfCheckinlocation = CursorUtil.getColumnIndexOrThrow(_cursor, "checkinlocation");
          final int _cursorIndexOfCheckoutlocation = CursorUtil.getColumnIndexOrThrow(_cursor, "checkoutlocation");
          final int _cursorIndexOfTotaltime = CursorUtil.getColumnIndexOrThrow(_cursor, "totaltime");
          final int _cursorIndexOfINSYNC = CursorUtil.getColumnIndexOrThrow(_cursor, "INSYNC");
          final int _cursorIndexOfOUTSYNC = CursorUtil.getColumnIndexOrThrow(_cursor, "OUTSYNC");
          final int _cursorIndexOfAttendanceimage = CursorUtil.getColumnIndexOrThrow(_cursor, "attendanceimage");
          final int _cursorIndexOfImagepath = CursorUtil.getColumnIndexOrThrow(_cursor, "imagepath");
          final int _cursorIndexOfSignature = CursorUtil.getColumnIndexOrThrow(_cursor, "signature");
          final int _cursorIndexOfSignaturepath = CursorUtil.getColumnIndexOrThrow(_cursor, "signaturepath");
          final int _cursorIndexOfFacilityId = CursorUtil.getColumnIndexOrThrow(_cursor, "facility_id");
          final int _cursorIndexOfFacilityIdOut = CursorUtil.getColumnIndexOrThrow(_cursor, "facility_id_out");
          final int _cursorIndexOfShiftId = CursorUtil.getColumnIndexOrThrow(_cursor, "shift_id");
          final List<AttendenceEntity> _result = new ArrayList<AttendenceEntity>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final AttendenceEntity _item;
            final int _tmpId;
            _tmpId = _cursor.getInt(_cursorIndexOfId);
            final String _tmpCompanyname;
            if (_cursor.isNull(_cursorIndexOfCompanyname)) {
              _tmpCompanyname = null;
            } else {
              _tmpCompanyname = _cursor.getString(_cursorIndexOfCompanyname);
            }
            final String _tmpEmailid;
            if (_cursor.isNull(_cursorIndexOfEmailid)) {
              _tmpEmailid = null;
            } else {
              _tmpEmailid = _cursor.getString(_cursorIndexOfEmailid);
            }
            final String _tmpDate;
            if (_cursor.isNull(_cursorIndexOfDate)) {
              _tmpDate = null;
            } else {
              _tmpDate = _cursor.getString(_cursorIndexOfDate);
            }
            final String _tmpCheckintime;
            if (_cursor.isNull(_cursorIndexOfCheckintime)) {
              _tmpCheckintime = null;
            } else {
              _tmpCheckintime = _cursor.getString(_cursorIndexOfCheckintime);
            }
            final String _tmpCheckouttime;
            if (_cursor.isNull(_cursorIndexOfCheckouttime)) {
              _tmpCheckouttime = null;
            } else {
              _tmpCheckouttime = _cursor.getString(_cursorIndexOfCheckouttime);
            }
            final String _tmpStatus;
            if (_cursor.isNull(_cursorIndexOfStatus)) {
              _tmpStatus = null;
            } else {
              _tmpStatus = _cursor.getString(_cursorIndexOfStatus);
            }
            final String _tmpCheckinlocation;
            if (_cursor.isNull(_cursorIndexOfCheckinlocation)) {
              _tmpCheckinlocation = null;
            } else {
              _tmpCheckinlocation = _cursor.getString(_cursorIndexOfCheckinlocation);
            }
            final String _tmpCheckoutlocation;
            if (_cursor.isNull(_cursorIndexOfCheckoutlocation)) {
              _tmpCheckoutlocation = null;
            } else {
              _tmpCheckoutlocation = _cursor.getString(_cursorIndexOfCheckoutlocation);
            }
            final String _tmpTotaltime;
            if (_cursor.isNull(_cursorIndexOfTotaltime)) {
              _tmpTotaltime = null;
            } else {
              _tmpTotaltime = _cursor.getString(_cursorIndexOfTotaltime);
            }
            final String _tmpINSYNC;
            if (_cursor.isNull(_cursorIndexOfINSYNC)) {
              _tmpINSYNC = null;
            } else {
              _tmpINSYNC = _cursor.getString(_cursorIndexOfINSYNC);
            }
            final String _tmpOUTSYNC;
            if (_cursor.isNull(_cursorIndexOfOUTSYNC)) {
              _tmpOUTSYNC = null;
            } else {
              _tmpOUTSYNC = _cursor.getString(_cursorIndexOfOUTSYNC);
            }
            final String _tmpAttendanceimage;
            if (_cursor.isNull(_cursorIndexOfAttendanceimage)) {
              _tmpAttendanceimage = null;
            } else {
              _tmpAttendanceimage = _cursor.getString(_cursorIndexOfAttendanceimage);
            }
            final String _tmpImagepath;
            if (_cursor.isNull(_cursorIndexOfImagepath)) {
              _tmpImagepath = null;
            } else {
              _tmpImagepath = _cursor.getString(_cursorIndexOfImagepath);
            }
            final String _tmpSignature;
            if (_cursor.isNull(_cursorIndexOfSignature)) {
              _tmpSignature = null;
            } else {
              _tmpSignature = _cursor.getString(_cursorIndexOfSignature);
            }
            final String _tmpSignaturepath;
            if (_cursor.isNull(_cursorIndexOfSignaturepath)) {
              _tmpSignaturepath = null;
            } else {
              _tmpSignaturepath = _cursor.getString(_cursorIndexOfSignaturepath);
            }
            final String _tmpFacility_id;
            if (_cursor.isNull(_cursorIndexOfFacilityId)) {
              _tmpFacility_id = null;
            } else {
              _tmpFacility_id = _cursor.getString(_cursorIndexOfFacilityId);
            }
            final String _tmpFacility_id_out;
            if (_cursor.isNull(_cursorIndexOfFacilityIdOut)) {
              _tmpFacility_id_out = null;
            } else {
              _tmpFacility_id_out = _cursor.getString(_cursorIndexOfFacilityIdOut);
            }
            final String _tmpShift_id;
            if (_cursor.isNull(_cursorIndexOfShiftId)) {
              _tmpShift_id = null;
            } else {
              _tmpShift_id = _cursor.getString(_cursorIndexOfShiftId);
            }
            _item = new AttendenceEntity(_tmpId,_tmpCompanyname,_tmpEmailid,_tmpDate,_tmpCheckintime,_tmpCheckouttime,_tmpStatus,_tmpCheckinlocation,_tmpCheckoutlocation,_tmpTotaltime,_tmpINSYNC,_tmpOUTSYNC,_tmpAttendanceimage,_tmpImagepath,_tmpSignature,_tmpSignaturepath,_tmpFacility_id,_tmpFacility_id_out,_tmpShift_id);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public void updateCheckInSynced(final List<Integer> ids) {
    __db.assertNotSuspendingTransaction();
    final StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("UPDATE AttendenceEntity SET INSYNC = 'YES' WHERE status='IN' AND id IN (");
    final int _inputSize = ids.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(")");
    final String _sql = _stringBuilder.toString();
    final SupportSQLiteStatement _stmt = __db.compileStatement(_sql);
    int _argIndex = 1;
    for (Integer _item : ids) {
      if (_item == null) {
        _stmt.bindNull(_argIndex);
      } else {
        _stmt.bindLong(_argIndex, _item);
      }
      _argIndex++;
    }
    __db.beginTransaction();
    try {
      _stmt.executeUpdateDelete();
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void updateCheckOutSynced(final List<Integer> ids) {
    __db.assertNotSuspendingTransaction();
    final StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("UPDATE AttendenceEntity SET OUTSYNC = 'YES' WHERE status='Present' AND id IN (");
    final int _inputSize = ids.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(")");
    final String _sql = _stringBuilder.toString();
    final SupportSQLiteStatement _stmt = __db.compileStatement(_sql);
    int _argIndex = 1;
    for (Integer _item : ids) {
      if (_item == null) {
        _stmt.bindNull(_argIndex);
      } else {
        _stmt.bindLong(_argIndex, _item);
      }
      _argIndex++;
    }
    __db.beginTransaction();
    try {
      _stmt.executeUpdateDelete();
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
