package com.b2lmobitech.fieldcloudplus.hcm.new_sql.doa;

import android.database.Cursor;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.LiveData;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.entities.FacilityEntity;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;

@SuppressWarnings({"unchecked", "deprecation"})
public final class FacilityDOA_Impl implements FacilityDOA {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<FacilityEntity> __insertionAdapterOfFacilityEntity;

  private final EntityDeletionOrUpdateAdapter<FacilityEntity> __deletionAdapterOfFacilityEntity;

  private final EntityDeletionOrUpdateAdapter<FacilityEntity> __updateAdapterOfFacilityEntity;

  private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

  public FacilityDOA_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfFacilityEntity = new EntityInsertionAdapter<FacilityEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR REPLACE INTO `FacilityEntity` (`atmid`,`companyname`,`state`,`country`,`location`,`atmaddress`,`sitename`,`latitude`,`longitude`,`geofencing`,`geo_distance`) VALUES (?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final FacilityEntity entity) {
        if (entity.getAtmid() == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, entity.getAtmid());
        }
        if (entity.getCompanyname() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getCompanyname());
        }
        if (entity.getState() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getState());
        }
        if (entity.getCountry() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getCountry());
        }
        if (entity.getLocation() == null) {
          statement.bindNull(5);
        } else {
          statement.bindString(5, entity.getLocation());
        }
        if (entity.getAtmaddress() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getAtmaddress());
        }
        if (entity.getSitename() == null) {
          statement.bindNull(7);
        } else {
          statement.bindString(7, entity.getSitename());
        }
        if (entity.getLatitude() == null) {
          statement.bindNull(8);
        } else {
          statement.bindString(8, entity.getLatitude());
        }
        if (entity.getLongitude() == null) {
          statement.bindNull(9);
        } else {
          statement.bindString(9, entity.getLongitude());
        }
        if (entity.getGeofencing() == null) {
          statement.bindNull(10);
        } else {
          statement.bindString(10, entity.getGeofencing());
        }
        if (entity.getGeo_distance() == null) {
          statement.bindNull(11);
        } else {
          statement.bindString(11, entity.getGeo_distance());
        }
      }
    };
    this.__deletionAdapterOfFacilityEntity = new EntityDeletionOrUpdateAdapter<FacilityEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "DELETE FROM `FacilityEntity` WHERE `atmid` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final FacilityEntity entity) {
        if (entity.getAtmid() == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, entity.getAtmid());
        }
      }
    };
    this.__updateAdapterOfFacilityEntity = new EntityDeletionOrUpdateAdapter<FacilityEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `FacilityEntity` SET `atmid` = ?,`companyname` = ?,`state` = ?,`country` = ?,`location` = ?,`atmaddress` = ?,`sitename` = ?,`latitude` = ?,`longitude` = ?,`geofencing` = ?,`geo_distance` = ? WHERE `atmid` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final FacilityEntity entity) {
        if (entity.getAtmid() == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, entity.getAtmid());
        }
        if (entity.getCompanyname() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getCompanyname());
        }
        if (entity.getState() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getState());
        }
        if (entity.getCountry() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getCountry());
        }
        if (entity.getLocation() == null) {
          statement.bindNull(5);
        } else {
          statement.bindString(5, entity.getLocation());
        }
        if (entity.getAtmaddress() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getAtmaddress());
        }
        if (entity.getSitename() == null) {
          statement.bindNull(7);
        } else {
          statement.bindString(7, entity.getSitename());
        }
        if (entity.getLatitude() == null) {
          statement.bindNull(8);
        } else {
          statement.bindString(8, entity.getLatitude());
        }
        if (entity.getLongitude() == null) {
          statement.bindNull(9);
        } else {
          statement.bindString(9, entity.getLongitude());
        }
        if (entity.getGeofencing() == null) {
          statement.bindNull(10);
        } else {
          statement.bindString(10, entity.getGeofencing());
        }
        if (entity.getGeo_distance() == null) {
          statement.bindNull(11);
        } else {
          statement.bindString(11, entity.getGeo_distance());
        }
        if (entity.getAtmid() == null) {
          statement.bindNull(12);
        } else {
          statement.bindString(12, entity.getAtmid());
        }
      }
    };
    this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "DELETE  FROM FacilityEntity";
        return _query;
      }
    };
  }

  @Override
  public Long save(final FacilityEntity key) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      final Long _result = __insertionAdapterOfFacilityEntity.insertAndReturnId(key);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void saveAll(final List<FacilityEntity> keys) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfFacilityEntity.insert(keys);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void delete(final FacilityEntity key) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __deletionAdapterOfFacilityEntity.handle(key);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void merge(final FacilityEntity key) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfFacilityEntity.handle(key);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void deleteAll() {
    __db.assertNotSuspendingTransaction();
    final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteAll.acquire();
    try {
      __db.beginTransaction();
      try {
        _stmt.executeUpdateDelete();
        __db.setTransactionSuccessful();
      } finally {
        __db.endTransaction();
      }
    } finally {
      __preparedStmtOfDeleteAll.release(_stmt);
    }
  }

  @Override
  public LiveData<List<FacilityEntity>> fetchAll() {
    final String _sql = "SELECT * FROM FacilityEntity";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    return __db.getInvalidationTracker().createLiveData(new String[] {"FacilityEntity"}, false, new Callable<List<FacilityEntity>>() {
      @Override
      @Nullable
      public List<FacilityEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfAtmid = CursorUtil.getColumnIndexOrThrow(_cursor, "atmid");
          final int _cursorIndexOfCompanyname = CursorUtil.getColumnIndexOrThrow(_cursor, "companyname");
          final int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow(_cursor, "state");
          final int _cursorIndexOfCountry = CursorUtil.getColumnIndexOrThrow(_cursor, "country");
          final int _cursorIndexOfLocation = CursorUtil.getColumnIndexOrThrow(_cursor, "location");
          final int _cursorIndexOfAtmaddress = CursorUtil.getColumnIndexOrThrow(_cursor, "atmaddress");
          final int _cursorIndexOfSitename = CursorUtil.getColumnIndexOrThrow(_cursor, "sitename");
          final int _cursorIndexOfLatitude = CursorUtil.getColumnIndexOrThrow(_cursor, "latitude");
          final int _cursorIndexOfLongitude = CursorUtil.getColumnIndexOrThrow(_cursor, "longitude");
          final int _cursorIndexOfGeofencing = CursorUtil.getColumnIndexOrThrow(_cursor, "geofencing");
          final int _cursorIndexOfGeoDistance = CursorUtil.getColumnIndexOrThrow(_cursor, "geo_distance");
          final List<FacilityEntity> _result = new ArrayList<FacilityEntity>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final FacilityEntity _item;
            final String _tmpAtmid;
            if (_cursor.isNull(_cursorIndexOfAtmid)) {
              _tmpAtmid = null;
            } else {
              _tmpAtmid = _cursor.getString(_cursorIndexOfAtmid);
            }
            final String _tmpCompanyname;
            if (_cursor.isNull(_cursorIndexOfCompanyname)) {
              _tmpCompanyname = null;
            } else {
              _tmpCompanyname = _cursor.getString(_cursorIndexOfCompanyname);
            }
            final String _tmpState;
            if (_cursor.isNull(_cursorIndexOfState)) {
              _tmpState = null;
            } else {
              _tmpState = _cursor.getString(_cursorIndexOfState);
            }
            final String _tmpCountry;
            if (_cursor.isNull(_cursorIndexOfCountry)) {
              _tmpCountry = null;
            } else {
              _tmpCountry = _cursor.getString(_cursorIndexOfCountry);
            }
            final String _tmpLocation;
            if (_cursor.isNull(_cursorIndexOfLocation)) {
              _tmpLocation = null;
            } else {
              _tmpLocation = _cursor.getString(_cursorIndexOfLocation);
            }
            final String _tmpAtmaddress;
            if (_cursor.isNull(_cursorIndexOfAtmaddress)) {
              _tmpAtmaddress = null;
            } else {
              _tmpAtmaddress = _cursor.getString(_cursorIndexOfAtmaddress);
            }
            final String _tmpSitename;
            if (_cursor.isNull(_cursorIndexOfSitename)) {
              _tmpSitename = null;
            } else {
              _tmpSitename = _cursor.getString(_cursorIndexOfSitename);
            }
            final String _tmpLatitude;
            if (_cursor.isNull(_cursorIndexOfLatitude)) {
              _tmpLatitude = null;
            } else {
              _tmpLatitude = _cursor.getString(_cursorIndexOfLatitude);
            }
            final String _tmpLongitude;
            if (_cursor.isNull(_cursorIndexOfLongitude)) {
              _tmpLongitude = null;
            } else {
              _tmpLongitude = _cursor.getString(_cursorIndexOfLongitude);
            }
            final String _tmpGeofencing;
            if (_cursor.isNull(_cursorIndexOfGeofencing)) {
              _tmpGeofencing = null;
            } else {
              _tmpGeofencing = _cursor.getString(_cursorIndexOfGeofencing);
            }
            final String _tmpGeo_distance;
            if (_cursor.isNull(_cursorIndexOfGeoDistance)) {
              _tmpGeo_distance = null;
            } else {
              _tmpGeo_distance = _cursor.getString(_cursorIndexOfGeoDistance);
            }
            _item = new FacilityEntity(_tmpAtmid,_tmpCompanyname,_tmpState,_tmpCountry,_tmpLocation,_tmpAtmaddress,_tmpSitename,_tmpLatitude,_tmpLongitude,_tmpGeofencing,_tmpGeo_distance);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
