package com.b2lmobitech.fieldcloudplus.notes.room;

import android.database.Cursor;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.LiveData;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;

@SuppressWarnings({"unchecked", "deprecation"})
public final class NotesDAO_Impl implements NotesDAO {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<NoteEntity> __insertionAdapterOfNoteEntity;

  private final EntityDeletionOrUpdateAdapter<NoteEntity> __deletionAdapterOfNoteEntity;

  private final EntityDeletionOrUpdateAdapter<NoteEntity> __updateAdapterOfNoteEntity;

  public NotesDAO_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfNoteEntity = new EntityInsertionAdapter<NoteEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR REPLACE INTO `NoteEntity` (`id`,`notes`,`title`,`createdOn`,`updatedOn`,`deleted`) VALUES (?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final NoteEntity entity) {
        statement.bindLong(1, entity.getId());
        if (entity.getNotes() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getNotes());
        }
        if (entity.getTitle() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getTitle());
        }
        if (entity.getCreatedOn() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getCreatedOn());
        }
        if (entity.getUpdatedOn() == null) {
          statement.bindNull(5);
        } else {
          statement.bindString(5, entity.getUpdatedOn());
        }
        statement.bindLong(6, entity.getDeleted());
      }
    };
    this.__deletionAdapterOfNoteEntity = new EntityDeletionOrUpdateAdapter<NoteEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "DELETE FROM `NoteEntity` WHERE `id` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final NoteEntity entity) {
        statement.bindLong(1, entity.getId());
      }
    };
    this.__updateAdapterOfNoteEntity = new EntityDeletionOrUpdateAdapter<NoteEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `NoteEntity` SET `id` = ?,`notes` = ?,`title` = ?,`createdOn` = ?,`updatedOn` = ?,`deleted` = ? WHERE `id` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final NoteEntity entity) {
        statement.bindLong(1, entity.getId());
        if (entity.getNotes() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getNotes());
        }
        if (entity.getTitle() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getTitle());
        }
        if (entity.getCreatedOn() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getCreatedOn());
        }
        if (entity.getUpdatedOn() == null) {
          statement.bindNull(5);
        } else {
          statement.bindString(5, entity.getUpdatedOn());
        }
        statement.bindLong(6, entity.getDeleted());
        statement.bindLong(7, entity.getId());
      }
    };
  }

  @Override
  public Long save(final NoteEntity key) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      final Long _result = __insertionAdapterOfNoteEntity.insertAndReturnId(key);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void delete(final NoteEntity key) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __deletionAdapterOfNoteEntity.handle(key);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void merge(final NoteEntity key) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfNoteEntity.handle(key);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public LiveData<List<NoteEntity>> getAll() {
    final String _sql = "SELECT * FROM NoteEntity WHERE deleted=0 ORDER BY id DESC";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    return __db.getInvalidationTracker().createLiveData(new String[] {"NoteEntity"}, false, new Callable<List<NoteEntity>>() {
      @Override
      @Nullable
      public List<NoteEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "id");
          final int _cursorIndexOfNotes = CursorUtil.getColumnIndexOrThrow(_cursor, "notes");
          final int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "title");
          final int _cursorIndexOfCreatedOn = CursorUtil.getColumnIndexOrThrow(_cursor, "createdOn");
          final int _cursorIndexOfUpdatedOn = CursorUtil.getColumnIndexOrThrow(_cursor, "updatedOn");
          final int _cursorIndexOfDeleted = CursorUtil.getColumnIndexOrThrow(_cursor, "deleted");
          final List<NoteEntity> _result = new ArrayList<NoteEntity>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final NoteEntity _item;
            final int _tmpId;
            _tmpId = _cursor.getInt(_cursorIndexOfId);
            final String _tmpNotes;
            if (_cursor.isNull(_cursorIndexOfNotes)) {
              _tmpNotes = null;
            } else {
              _tmpNotes = _cursor.getString(_cursorIndexOfNotes);
            }
            final String _tmpTitle;
            if (_cursor.isNull(_cursorIndexOfTitle)) {
              _tmpTitle = null;
            } else {
              _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
            }
            final String _tmpCreatedOn;
            if (_cursor.isNull(_cursorIndexOfCreatedOn)) {
              _tmpCreatedOn = null;
            } else {
              _tmpCreatedOn = _cursor.getString(_cursorIndexOfCreatedOn);
            }
            final String _tmpUpdatedOn;
            if (_cursor.isNull(_cursorIndexOfUpdatedOn)) {
              _tmpUpdatedOn = null;
            } else {
              _tmpUpdatedOn = _cursor.getString(_cursorIndexOfUpdatedOn);
            }
            final int _tmpDeleted;
            _tmpDeleted = _cursor.getInt(_cursorIndexOfDeleted);
            _item = new NoteEntity(_tmpId,_tmpNotes,_tmpTitle,_tmpCreatedOn,_tmpUpdatedOn,_tmpDeleted);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public LiveData<List<NoteEntity>> getAll(final int limit) {
    final String _sql = "SELECT * FROM NoteEntity WHERE deleted=0 ORDER BY id DESC LIMIT ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, limit);
    return __db.getInvalidationTracker().createLiveData(new String[] {"NoteEntity"}, false, new Callable<List<NoteEntity>>() {
      @Override
      @Nullable
      public List<NoteEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "id");
          final int _cursorIndexOfNotes = CursorUtil.getColumnIndexOrThrow(_cursor, "notes");
          final int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "title");
          final int _cursorIndexOfCreatedOn = CursorUtil.getColumnIndexOrThrow(_cursor, "createdOn");
          final int _cursorIndexOfUpdatedOn = CursorUtil.getColumnIndexOrThrow(_cursor, "updatedOn");
          final int _cursorIndexOfDeleted = CursorUtil.getColumnIndexOrThrow(_cursor, "deleted");
          final List<NoteEntity> _result = new ArrayList<NoteEntity>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final NoteEntity _item;
            final int _tmpId;
            _tmpId = _cursor.getInt(_cursorIndexOfId);
            final String _tmpNotes;
            if (_cursor.isNull(_cursorIndexOfNotes)) {
              _tmpNotes = null;
            } else {
              _tmpNotes = _cursor.getString(_cursorIndexOfNotes);
            }
            final String _tmpTitle;
            if (_cursor.isNull(_cursorIndexOfTitle)) {
              _tmpTitle = null;
            } else {
              _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
            }
            final String _tmpCreatedOn;
            if (_cursor.isNull(_cursorIndexOfCreatedOn)) {
              _tmpCreatedOn = null;
            } else {
              _tmpCreatedOn = _cursor.getString(_cursorIndexOfCreatedOn);
            }
            final String _tmpUpdatedOn;
            if (_cursor.isNull(_cursorIndexOfUpdatedOn)) {
              _tmpUpdatedOn = null;
            } else {
              _tmpUpdatedOn = _cursor.getString(_cursorIndexOfUpdatedOn);
            }
            final int _tmpDeleted;
            _tmpDeleted = _cursor.getInt(_cursorIndexOfDeleted);
            _item = new NoteEntity(_tmpId,_tmpNotes,_tmpTitle,_tmpCreatedOn,_tmpUpdatedOn,_tmpDeleted);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
