package com.b2lmobitech.fieldcloudplus;


import androidx.lifecycle.ViewModelProvider;
import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.b2lmobitech.fieldcloudplus.hcm.HCMURL;
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.viewModel.DBViewModel;
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.viewModel.TimeSheetVM;
import com.b2lmobitech.fieldcloudplus.hcm.sql.HcmDatabase;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.DateUtils;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.others.utils.Preference;
import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables;

import org.json.JSONException;
import org.json.JSONObject;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;


/**
 * A simple {@link Fragment} subclass.
 */
public class DumpFragment extends Fragment {

    public DumpFragment() {}

    Preference preference;
    HcmDatabase hcmDatabase;
    DBViewModel dbViewModel;
    TimeSheetVM timeSheetVM;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,Bundle savedInstanceState) {


        return inflater.inflate(R.layout.fragment_dump, container, false);
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        dbViewModel = ViewModelProvider.AndroidViewModelFactory.getInstance(getActivity().getApplication()).create(DBViewModel.class);
        timeSheetVM = ViewModelProvider.AndroidViewModelFactory.getInstance(getActivity().getApplication()).create(TimeSheetVM.class);


        preference=Preference.getInstance(getActivity());
        hcmDatabase=HcmDatabase.getInstance(getActivity());
        getAttendance();
    }

    private void getAttendance() {
        Calendar c = Calendar.getInstance();
        c.set(Calendar.DAY_OF_MONTH, 1);
        Map<String, String> params = new HashMap<>();
        params.put("email",preference.getEmailId());
        params.put("companyname",preference.getCompanyName());
        params.put("enddate",DateUtils.getCurrentDate());
        params.put("startdate",new SimpleDateFormat("yyyy-MM-dd").format(c.getTime()));

        MyRequestQueue.getInstance(this).addToQueue(HCMURL.GET_ATTENDENCE_MONTH, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject=new JSONObject(response);
                    if(jsonObject.getInt("s")==1){
                        dbViewModel.inserAttendanceHistory(jsonObject.getJSONArray("list"));
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
                getTimesheet();
            }
        });
    }

    private void getTimesheet() {

        Map<String, String> params = new HashMap<>();
        params.put("email",preference.getEmailId());
        params.put("companyname",preference.getCompanyName());

        MyRequestQueue.getInstance(this).addToQueue(HCMURL.GET_TIMESHEET, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject=new JSONObject(response);
                    if(jsonObject.getInt("s")==1){
                        timeSheetVM.inserTimesheetHistory(jsonObject.getJSONArray("list"));
                        hcmDatabase.insertTimesheet(jsonObject.getJSONArray("list"));
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
                getLeaves();
            }
        });
    }

    private void getLeaves() {

        Map<String, String> params = new HashMap<>();
        params.put("email",preference.getEmailId());
        params.put("companyname",preference.getCompanyName());

        MyRequestQueue.getInstance(this).addToQueue(HCMURL.GET_LEAVESFULL, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject=new JSONObject(response);
                    if(jsonObject.getInt("s")==1){
                        hcmDatabase.insertLeaves(jsonObject.getJSONArray("list"));
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
                nextActivity();
            }
        });
    }

    private void nextActivity(){
        preference.putString(globalvariables.logout_initialdump,"Yes");
        Intent intent = new Intent(getActivity(), dashboard.class);
        intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP|Intent.FLAG_ACTIVITY_NEW_TASK);
        startActivity(intent);
        getActivity().finish();
    }

}
