package com.b2lmobitech.fieldcloudplus;

import android.Manifest;
import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.provider.Settings;
import com.google.android.material.snackbar.Snackbar;
import androidx.core.app.ActivityCompat;
import androidx.appcompat.app.AppCompatActivity;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.inputmethod.InputMethodManager;
import android.widget.AutoCompleteTextView;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.File;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.DateUtils;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.others.utils.Preference;
import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables;

/**
 * A login screen that offers login via email/password.
 */
public class LoginActivity extends AppCompatActivity {
    private Context mycontext;

    // UI references.
    private AutoCompleteTextView mEmailView;
    private EditText mPasswordView;
    private View mProgressView;
    private View mLoginFormView;
    //private ImageView iconView;

    private static String url_check_passworddetails = "";
    private String enteredmail = "";
    private int checkin_success = 0, forgotstatus = 0;
    public static Activity loginactivity;
    private Snackbar snackBar;
    private InputMethodManager imm;
    public static LinearLayout loginfulllayout;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_login);

        mycontext = this;
        loginactivity = this;

        getSupportActionBar().hide();

        getWidgets();


    }

    private void getWidgets() {
        mEmailView = findViewById(R.id.email);
        mPasswordView = findViewById(R.id.password);
        ((ImageView) findViewById(R.id.emailicon)).setImageResource(R.drawable.ic_action_email);
        ((ImageView) findViewById(R.id.pwdicon)).setImageResource(R.drawable.ic_action_password);
        snackBar = Snackbar.make(findViewById(android.R.id.content), "Please check internet connection", Snackbar.LENGTH_INDEFINITE);

        imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);

        findViewById(R.id.email_sign_in_button).setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View view) {
                snackBar.dismiss();
                try {
                    imm.hideSoftInputFromWindow(getCurrentFocus().getWindowToken(),
                            InputMethodManager.RESULT_UNCHANGED_SHOWN);
                } catch (Exception e) {
                    e.printStackTrace();
                }
                if (isValid()) {
                    login();
                }

            }
        });
        findViewById(R.id.email_cancel_button).setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View view) {
                snackBar.dismiss();
                imm.hideSoftInputFromWindow(getCurrentFocus().getWindowToken(),
                        InputMethodManager.RESULT_UNCHANGED_SHOWN);
                mEmailView.setText("");
                mPasswordView.setText("");
//                mEmailView.getText().clear();
//                mPasswordView.getText().clear();

            }
        });
        findViewById(R.id.forgotpassword).setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {

                imm.hideSoftInputFromWindow(getCurrentFocus().getWindowToken(),
                        InputMethodManager.RESULT_UNCHANGED_SHOWN);

                enteredmail = String.valueOf(mEmailView.getText());
                if (TextUtils.isEmpty(enteredmail)) {
                    mEmailView.setError(getString(R.string.error_field_required));
                } else if (!android.util.Patterns.EMAIL_ADDRESS.matcher(mEmailView.getText().toString()).matches()) {
                    mEmailView.setError(getString(R.string.error_invalid_email));
                } else {
                    AlertDialog.Builder alertdialog = new AlertDialog.Builder(mycontext);
                    alertdialog.setTitle("Forgot password");
                    alertdialog.setIcon(R.drawable.ic_action_help);
                    alertdialog.setMessage("Password will be send to this mail address?");
                    alertdialog.setPositiveButton("Ok",
                            new DialogInterface.OnClickListener() {
                                public void onClick(DialogInterface dialog, int whichButton) {
                                    try {
                                        if (isNetworkAvailable()) {
                                            forgot();
                                        } else {
                                            // Toast.makeText(mycontext, "Please check internet connection", Toast.LENGTH_LONG).show();
                                            snackBar.dismiss();
                                            snackBar = Snackbar.make(findViewById(android.R.id.content), "Please check internet connection", Snackbar.LENGTH_INDEFINITE);
                                            toast();
                                        }
                                    } catch (Exception e) {
                                        // TODO Auto-generated catch block
                                        e.printStackTrace();
                                    }
                                }
                            });
                    alertdialog.setNegativeButton("No,thanks", new DialogInterface.OnClickListener() {

                        @Override
                        public void onClick(DialogInterface dialog, int which) {
                            // TODO Auto-generated method stub

                        }
                    }).create();
                    alertdialog.show();

                }
            }
        });
        mLoginFormView = findViewById(R.id.login_form);
        mProgressView = findViewById(R.id.login_progress);
    }

    private boolean isValid() {
        mEmailView.setError(null);
        mPasswordView.setError(null);

        if (mEmailView.getText().toString().isEmpty()) {
            mEmailView.setError(getString(R.string.error_field_required));
            mEmailView.requestFocus();
            return false;
        } else if (!android.util.Patterns.EMAIL_ADDRESS.matcher(mEmailView.getText().toString()).matches()) {
            mEmailView.setError(getString(R.string.error_invalid_email));
            mEmailView.requestFocus();
            return false;
        }

        if (mPasswordView.getText().toString().isEmpty()) {
            mPasswordView.setError("This field is required");
            mPasswordView.requestFocus();
            return false;
        } else if (mPasswordView.getText().toString().length()<4) {
            mPasswordView.setError(getString(R.string.error_invalid_password));
            mPasswordView.requestFocus();
            return false;
        }

        if (MyRequestQueue.getInstance(this).isNoInternet()) {
            snackBar.dismiss();
            snackBar = Snackbar.make(findViewById(android.R.id.content), "Please check internet connection", Snackbar.LENGTH_INDEFINITE);
            toast();
            return false;
        }

        return ActivityCompat.checkSelfPermission(this, Manifest.permission.READ_PHONE_STATE) == PackageManager.PERMISSION_GRANTED;
    }

    private String getImei(){
        String imei = null;
        TelephonyManager tm = (TelephonyManager) getSystemService(TELEPHONY_SERVICE);



        try {
            //Old Method
            imei = tm.getDeviceId();
            //New Method 1
            if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.O) {
                imei = tm.getImei();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }




        //New Method 2
        if(imei == null){
            if(Settings.Secure.getString(this.getContentResolver(), Settings.Secure.ANDROID_ID) != null){
                imei = Settings.Secure.getString(this.getContentResolver(), Settings.Secure.ANDROID_ID);
            }
        }
        return imei;
    }

    private void login() {
        Map<String, String> params = new HashMap<>();
        params.put("email", mEmailView.getText().toString());
        params.put("pass", mPasswordView.getText().toString());
        if (ActivityCompat.checkSelfPermission(this, Manifest.permission.READ_PHONE_STATE) != PackageManager.PERMISSION_GRANTED) {
            return;
        }





        params.put("imei",getImei());

        params.put("updated", DateUtils.formatDate(apkUpdateTime()));
        params.put("installed",DateUtils.formatDate(getInstallTime()));
        params.put("verision_name",BuildConfig.VERSION_NAME);
        params.put("verision_code",String.valueOf(BuildConfig.VERSION_CODE));

        Log.d("params",params.toString());

        MyRequestQueue.getInstance(this).addToQueue(URL.LOGIN, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    login(new JSONObject(response));
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void login(JSONObject jsonObject) throws JSONException{
        if(jsonObject.getInt("s")==1) {
            HashMap<String, String> hashMap = new HashMap<>();
            hashMap.put(globalvariables.logout_companyname, jsonObject.getString("companyname"));
            hashMap.put(globalvariables.logout_companytype, jsonObject.getString("companytype"));
            hashMap.put(globalvariables.logout_emailid, jsonObject.getString("emailid"));
            hashMap.put(globalvariables.logout_employeename, jsonObject.getString("employeename"));
            hashMap.put(globalvariables.logout_designation, jsonObject.getString("designation"));
            hashMap.put(globalvariables.logout_group, jsonObject.getString("group"));
            hashMap.put(globalvariables.logout_subgroup, jsonObject.getString("subgroup"));
            hashMap.put(globalvariables.logout_team, jsonObject.getString("team"));
            hashMap.put("empcompanytype", jsonObject.getString("empcompanytype"));
            hashMap.put(globalvariables.logout_signout, "no");
            hashMap.put("profile", jsonObject.getString("profilepic"));
            hashMap.put(globalvariables.latitude, jsonObject.getString("latitude"));
            hashMap.put(globalvariables.longitude, jsonObject.getString("longitude"));
            hashMap.put(globalvariables.geo_enabled, jsonObject.getString("geofencing"));
            hashMap.put(globalvariables.geo_distance, jsonObject.getString("geo_distance"));
            Preference.getInstance(this).putString(hashMap);

            updateLoginDetails(jsonObject.getString("emailid"));

        }else if(jsonObject.getInt("s")==0){
            mPasswordView.setError(jsonObject.getString("m"));
            mPasswordView.requestFocus();
        }else{
            mEmailView.setError(jsonObject.getString("m"));
            mEmailView.requestFocus();
        }
    }

    private void updateLoginDetails(String emailId){

        Map<String, String> params = new HashMap<>();
        params.put("email",emailId);
        params.put("time",DateUtils.getCurrentDateTime());
        params.put("updated_on", DateUtils.formatDate(apkUpdateTime()));
        params.put("installed_on",DateUtils.formatDate(getInstallTime()));
        params.put("version_name",BuildConfig.VERSION_NAME);
        params.put("version_code",String.valueOf(BuildConfig.VERSION_CODE));

        Log.d("params",params.toString());

        MyRequestQueue.getInstance(this).addToQueue(URL.UPDATE_LOGINDETAILS, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                    nextActivity();
            }
        });
    }

    private void nextActivity(){
        if(Preference.getInstance(this).getString(globalvariables.logout_initialdump).isEmpty()) {
            DumpFragment dumpFragment=new DumpFragment();
            getSupportFragmentManager().beginTransaction()
                    .replace(R.id.frameLayout,dumpFragment)
                    .commitNow();
        }else{
            Intent intent = new Intent(mycontext, dashboard.class);
            startActivity(intent);
            finish();
        }
    }

    private void showProgress(final boolean show) {
        int shortAnimTime = getResources().getInteger(android.R.integer.config_shortAnimTime);
        mLoginFormView.setVisibility(show ? View.GONE : View.VISIBLE);
        mLoginFormView.animate().setDuration(shortAnimTime).alpha(
                show ? 0 : 1).setListener(new AnimatorListenerAdapter() {
            @Override
            public void onAnimationEnd(Animator animation) {
                mLoginFormView.setVisibility(show ? View.GONE : View.VISIBLE);
            }
        });

        mProgressView.setVisibility(show ? View.VISIBLE : View.GONE);
        mProgressView.animate().setDuration(shortAnimTime).alpha(
                show ? 1 : 0).setListener(new AnimatorListenerAdapter() {
            @Override
            public void onAnimationEnd(Animator animation) {
                mProgressView.setVisibility(show ? View.VISIBLE : View.GONE);
            }
        });
        if(mLoginFormView.getVisibility()==View.VISIBLE)
        {
            snackBar.dismiss();
        }
        else
        {
            snackBar.dismiss();
            snackBar = Snackbar.make(findViewById(android.R.id.content),  "Please do not press back", Snackbar.LENGTH_INDEFINITE);
            toast();
        }

    }

    public boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager) mycontext.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        // if no network is available networkInfo will be null
        // otherwise check if we are connected
        if (networkInfo != null && networkInfo.isConnected()) {

            if( cm.getNetworkInfo(ConnectivityManager.TYPE_WIFI).isConnectedOrConnecting() ) {
                // do your stuff
//			    Log.d("wifi connectivity", "connected");
            }else {
//			    	   Log.d("wifi connectivity", "wifi not connected");

            }

            return true;
        }
        return false;
    }

    private void toast() {
        snackBar.setAction("CLOSE", new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                snackBar.dismiss();
            }
        }).setActionTextColor(getResources().getColor(android.R.color.holo_blue_dark )).show();
    }

    private void forgot() {

        snackBar.dismiss();
        snackBar = Snackbar.make(findViewById(android.R.id.content),  "Please do not press back", Snackbar.LENGTH_INDEFINITE);
        toast();
        Map<String, String> params = new HashMap<>();
        params.put("emailid", mEmailView.getText().toString());

        MyRequestQueue.getInstance(this).addToQueue(URL.FORGOT, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject=new JSONObject(response);
                    if (jsonObject.getInt("s")==1) {
                        snackBar.dismiss();
                        snackBar = Snackbar.make(findViewById(android.R.id.content), "Password sent to this mail address,please check it.", Snackbar.LENGTH_INDEFINITE);
                        toast();
                    } else if (forgotstatus == 0) {
                        mEmailView.setError("This email address is not registered");
                        mEmailView.requestFocus();
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public Date getInstallTime() {

        if(installTimeFromPackageManager()!= null ){
            return installTimeFromPackageManager();
        }else{
            return apkUpdateTime();
        }

    }

    private Date apkUpdateTime() {
        try {
            ApplicationInfo info = getPackageManager().getApplicationInfo(BuildConfig.APPLICATION_ID, 0);
            File apkFile = new File(info.sourceDir);
            return apkFile.exists() ? new Date(apkFile.lastModified()) : null;
        } catch (PackageManager.NameNotFoundException e) {
            return null; // package not found
        }
    }

    private Date installTimeFromPackageManager() {
        // API level 9 and above have the "firstInstallTime" field.
        // Check for it with reflection and return if present.
        try {
            PackageInfo info = getPackageManager().getPackageInfo(BuildConfig.APPLICATION_ID, 0);
            Field field = PackageInfo.class.getField("firstInstallTime");
            long timestamp = field.getLong(info);
            return new Date(timestamp);
        } catch (PackageManager.NameNotFoundException e) {
            return null; // package not found
        } catch (IllegalAccessException e) {
        } catch (NoSuchFieldException e) {
        } catch (IllegalArgumentException e) {
        } catch (SecurityException e) {
        }
        // field wasn't found
        return null;
    }



}

