package com.b2lmobitech.fieldcloudplus

import android.Manifest.permission
import android.content.Context
import android.content.Intent
import android.content.pm.PackageManager
import android.net.Uri
import android.os.Build
import android.os.Bundle
import android.provider.Settings
import android.util.Log
import android.view.View
import android.widget.TextView
import android.widget.Toast
import androidx.activity.result.ActivityResult
import androidx.activity.result.contract.ActivityResultContracts
import androidx.appcompat.app.AppCompatActivity
import androidx.core.app.ActivityCompat
import androidx.core.content.ContextCompat
import com.android.volley.Response
import com.android.volley.toolbox.StringRequest
import com.android.volley.toolbox.Volley
import com.b2lmobitech.fieldcloudplus.others.utils.Preference
import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables
import com.b2lmobitech.fieldcloudplus.task.service.LocationBatteryService
import com.b2lmobitech.fieldcloudplus.utils.LocationUtils
import com.b2lmobitech.fieldcloudplus.utils.openAppSettings
import com.google.firebase.ktx.Firebase
import com.google.firebase.remoteconfig.FirebaseRemoteConfig
import com.google.firebase.remoteconfig.ktx.remoteConfig
import com.google.firebase.remoteconfig.ktx.remoteConfigSettings
import org.json.JSONObject


class MainActivity : AppCompatActivity() {

    private var mycontext: Context? = null
    private lateinit var remoteConfig: FirebaseRemoteConfig

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        //  requestWindowFeature(Window.FEATURE_NO_TITLE);
        setContentView(R.layout.activity_main)
        mycontext = this


        remoteConfig = Firebase.remoteConfig
        val configSettings = remoteConfigSettings {
            minimumFetchIntervalInSeconds = 3600
        }
        remoteConfig.setConfigSettingsAsync(configSettings)
        remoteConfig.setDefaultsAsync(R.xml.remote_config_defaults)

        // permissionchecking();
        val textView = findViewById<TextView>(R.id.textView)
        textView.text = String.format("Version %s", BuildConfig.VERSION_NAME)
    }


    override fun onResume() {
        super.onResume()
        if (checkPermission()) {
            confirmLocationSetting()
        }else{
            requestPermission()
        }
    }

    private fun confirmLocationSetting(){
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q) {
            LocationUtils.requestBackgroundLocationPermission(this){
                if(it){
                    confirmNotificationSettings()
                }else{
                    Toast.makeText(this,"Please allow location access all the time",Toast.LENGTH_SHORT).show()
                    openAppSettings()
                }
            }
        }else{
            confirmNotificationSettings()
        }
    }

    private fun confirmNotificationSettings(){
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.TIRAMISU) {
            LocationUtils.requestNotificationPermission(this){
                if(it){
                    checkNewVerision()
                }else{
                    Toast.makeText(this,"Please enable notifications permission",Toast.LENGTH_SHORT).show()
                    openAppSettings()
                }
            }
        }else{
            checkNewVerision()
        }
    }

    private val requestPermissionLauncher = registerForActivityResult<Intent, ActivityResult>(
        ActivityResultContracts.StartActivityForResult()
    ) { _: ActivityResult? ->
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.S) {
            // Permission denied, open app settings
            val intent: Intent = Intent(Settings.ACTION_APPLICATION_DETAILS_SETTINGS)
            val uri =
                Uri.fromParts("package", packageName, null)
            intent.setData(uri)
            startActivity(intent)
        }
    }

    fun fetchValues(){
        remoteConfig.fetchAndActivate()
                .addOnCompleteListener(this) { task ->
                    if (task.isSuccessful) {
                        
                    }
                }
    }

    fun checking() {
        Log.d("checking","checking")
        val preference = Preference.getInstance(this)
        if (preference.emailId.isEmpty()) {
            val intent = Intent(mycontext, LoginActivity::class.java)
            startActivity(intent)
            finish()
        } else if (preference.getString(globalvariables.logout_initialdump).equals("Yes", ignoreCase = true)) {
            Log.d("checkingelseif","checkingelseif")
            val intent = Intent(mycontext, dashboard::class.java)
            startActivity(intent)
            finish()
        } else {
            Log.d("checkingelse","checkingelse")
            findViewById<View>(R.id.relativelayout).visibility = View.GONE
            val dumpFragment = DumpFragment()
            supportFragmentManager.beginTransaction()
                    .replace(R.id.frameLayout, dumpFragment)
                    .commitNow()
        }
    }

    fun checkNewVerision(){
        checking()
      /*  // Creates instance of the manager.
        //val appUpdateManager = AppUpdateManagerFactory.create(this)
        val appUpdateManager = FakeAppUpdateManager(this)
        appUpdateManager.setUpdateAvailable(6)

        val installStateUpdatedListener: InstallStateUpdatedListener = object : InstallStateUpdatedListener {
            override fun onStateUpdate(state: InstallState) {
                Log.i("Update", "InstallStateUpdatedListener: state: " + state.installStatus())

                if (state.installStatus() == InstallStatus.DOWNLOADED) {
                    checking()
                } else if (state.installStatus() == InstallStatus.INSTALLED) {
                    if (appUpdateManager != null) {
                        appUpdateManager.unregisterListener(this)
                    }
                } else {
                    Log.i("Update", "InstallStateUpdatedListener: state: " + state.installStatus())
                }
            }
        }

        appUpdateManager.registerListener(installStateUpdatedListener)
        val appUpdateInfoTask = appUpdateManager.appUpdateInfo
// Checks that the platform will allow the specified type of update.

        appUpdateInfoTask.addOnSuccessListener { appUpdateInfo ->
            Log.i("Update",appUpdateInfo.toString())

            if (appUpdateInfo.updateAvailability() == UpdateAvailability.UPDATE_AVAILABLE) {
                // Request the update.
                Log.i("Update","Request Started")
                appUpdateManager.startUpdateFlowForResult(appUpdateInfo, AppUpdateType.FLEXIBLE, this, 4)
            }else{
                checking()
            }
        }*/
    }

    //---permission---
    fun checkPermission(): Boolean {
        val FirstPermissionResult = ContextCompat.checkSelfPermission(applicationContext, permission.CAMERA)
        val secondPermissionResult = ContextCompat.checkSelfPermission(applicationContext, permission.ACCESS_FINE_LOCATION)
        val thirdPermissionResult = ContextCompat.checkSelfPermission(applicationContext, permission.ACCESS_COARSE_LOCATION)
        var fourthPermissionResult = ContextCompat.checkSelfPermission(applicationContext, permission.READ_EXTERNAL_STORAGE)
        var ninthPermissionResult = ContextCompat.checkSelfPermission(applicationContext, permission.WRITE_EXTERNAL_STORAGE)
        if(Build.VERSION.SDK_INT>=33)
        {
             fourthPermissionResult = ContextCompat.checkSelfPermission(applicationContext, permission.READ_EXTERNAL_STORAGE)
             ninthPermissionResult = ContextCompat.checkSelfPermission(applicationContext, permission.WRITE_EXTERNAL_STORAGE)
        }
        else
        {
             fourthPermissionResult = ContextCompat.checkSelfPermission(applicationContext, permission.READ_MEDIA_IMAGES)
             ninthPermissionResult = ContextCompat.checkSelfPermission(applicationContext, permission.READ_MEDIA_VIDEO)
        }

        val fifthPermissionResult = ContextCompat.checkSelfPermission(applicationContext, permission.RECEIVE_BOOT_COMPLETED)
        val sixthPermissionResult = ContextCompat.checkSelfPermission(applicationContext, permission.INTERNET)
        val seventhPermissionResult = ContextCompat.checkSelfPermission(applicationContext, permission.ACCESS_NETWORK_STATE)
        val eightPermissionResult = ContextCompat.checkSelfPermission(applicationContext, permission.ACCESS_WIFI_STATE)

        val tenthPermissionResult = ContextCompat.checkSelfPermission(applicationContext, permission.READ_PHONE_STATE)
        return FirstPermissionResult == PackageManager.PERMISSION_GRANTED && secondPermissionResult == PackageManager.PERMISSION_GRANTED && thirdPermissionResult == PackageManager.PERMISSION_GRANTED && fourthPermissionResult == PackageManager.PERMISSION_GRANTED && fifthPermissionResult == PackageManager.PERMISSION_GRANTED && sixthPermissionResult == PackageManager.PERMISSION_GRANTED && seventhPermissionResult == PackageManager.PERMISSION_GRANTED && eightPermissionResult == PackageManager.PERMISSION_GRANTED && ninthPermissionResult == PackageManager.PERMISSION_GRANTED && tenthPermissionResult == PackageManager.PERMISSION_GRANTED
    }

    private fun requestPermission() {
        ActivityCompat.requestPermissions(this,
            if(Build.VERSION.SDK_INT>=33)
            {
                arrayOf(
                    permission.CAMERA,
                    permission.ACCESS_FINE_LOCATION,
                    permission.ACCESS_COARSE_LOCATION,
                    permission.READ_MEDIA_IMAGES,
                    permission.RECEIVE_BOOT_COMPLETED,
                    permission.INTERNET,
                    permission.ACCESS_NETWORK_STATE,
                    permission.ACCESS_WIFI_STATE,
                    permission.READ_MEDIA_VIDEO,
                    permission.READ_PHONE_STATE
                )
            }
                    else{
            arrayOf(
                permission.CAMERA,
                permission.ACCESS_FINE_LOCATION,
                permission.ACCESS_COARSE_LOCATION,
                permission.READ_EXTERNAL_STORAGE,
                permission.RECEIVE_BOOT_COMPLETED,
                permission.INTERNET,
                permission.ACCESS_NETWORK_STATE,
                permission.ACCESS_WIFI_STATE,
                permission.WRITE_EXTERNAL_STORAGE,
                permission.READ_PHONE_STATE
        )}, RequestPermissionCode)
    }


    override fun onRequestPermissionsResult(requestCode: Int, permissions: Array<String>, grantResults: kotlin.IntArray) {
        when (requestCode) {
            4 -> if (requestCode != RESULT_OK){
               checking()
            }else{
                checking()
            }
            RequestPermissionCode -> if (grantResults.size > 0) {
                val CameraPermission = grantResults[0] == PackageManager.PERMISSION_GRANTED
                val LocationfinePermission = grantResults[1] == PackageManager.PERMISSION_GRANTED
                val LocationcorsePermission = grantResults[2] == PackageManager.PERMISSION_GRANTED
                val readexternalstoragePermission = grantResults[3] == PackageManager.PERMISSION_GRANTED
                val receivebootPermission = grantResults[4] == PackageManager.PERMISSION_GRANTED
                val internetPermission = grantResults[5] == PackageManager.PERMISSION_GRANTED
                val networkstatePermission = grantResults[6] == PackageManager.PERMISSION_GRANTED
                val wifistatePermission = grantResults[7] == PackageManager.PERMISSION_GRANTED
                val writeexternalstoragePermission = grantResults[8] == PackageManager.PERMISSION_GRANTED
                val readphonestatePermission = grantResults[9] == PackageManager.PERMISSION_GRANTED
                if (CameraPermission && LocationfinePermission && LocationcorsePermission && readexternalstoragePermission &&
                        receivebootPermission && internetPermission && networkstatePermission && wifistatePermission && writeexternalstoragePermission && readphonestatePermission) { //   Toast.makeText(this, "Permission Granted", Toast.LENGTH_LONG).show();
                   confirmLocationSetting()
                } else { /*     AlertDialog.Builder builder = new AlertDialog.Builder(this);
	     	                    builder.setMessage("You need to allow access to all the permissions")
	     	                            .setTitle("Important permission required");

	     	                    builder.setPositiveButton("OK", new DialogInterface.OnClickListener() {
	     	                        public void onClick(DialogInterface dialog, int id) {
	     	                        	  ActivityCompat.requestPermissions(FirstActivity.this, new String[]
	     	                 	                {
	     	                 	                        CAMERA,
	     	                 	                        READ_CONTACTS,
	     	                 	                        READ_PHONE_STATE,
	     	                 	                        SEND_SMS,
	     	                 	                        ACCESS_FINE_LOCATION,
	     	                 	                        WRITE_EXTERNAL_STORAGE
	     	                 	                }, RequestPermissionCode);
	     	                        }
	     	                    });

	     	                    return;
	     	                */
                    requestPermission()
                }
            }
        }
    }

    companion object {
        const val RequestPermissionCode = 1
    }
}