package com.b2lmobitech.fieldcloudplus;

import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import android.view.MenuItem;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.hcm.HCMURL;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

public class ProfileActivity extends AppCompatActivity {

    LinearLayout mainLayout;
    private final String NDA="no data available";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_profile);
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        getSupportActionBar().setTitle("Profile");
        mainLayout=findViewById(R.id.mainLayout);
        getProfile();
    }


    private void getProfile(){

        Preference preference=Preference.getInstance(this);
        Map<String, String> params = new HashMap<>();
        params.put("mail",preference.getEmailId());
        params.put("cname", preference.getCompanyName());


        MyRequestQueue.getInstance(this).addToQueue(HCMURL.GET_PROFILE, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    getProfile(new JSONObject(response));
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void getProfile(JSONObject jsonObject) throws JSONException{

        if(jsonObject.getJSONArray("profile").length()!=0){
            addProfile(jsonObject.getJSONArray("profile").getJSONObject(0));
        }
        if(jsonObject.getJSONArray("account").length()!=0){
            addBank(jsonObject.getJSONArray("account").getJSONObject(0));
        }
        if(jsonObject.getJSONArray("passport").length()!=0){
            addPassport(jsonObject.getJSONArray("passport").getJSONObject(0));
        }
        if(jsonObject.getJSONArray("education").length()!=0){
            addEducation(jsonObject.getJSONArray("education"));
        }
        if(jsonObject.getJSONArray("experience").length()!=0){
            addExperience(jsonObject.getJSONArray("experience"));
        }
        if(jsonObject.getJSONArray("address").length()!=0){
            addAddress(jsonObject.getJSONArray("address").getJSONObject(0));
        }
        if(jsonObject.getJSONArray("dependent").length()!=0){
            addDependent(jsonObject.getJSONArray("dependent"));
        }
    }

    private void addProfile(JSONObject jsonObject) throws JSONException {
        View view=getLayoutInflater().inflate(R.layout.model_layout_profile,null);
        TextView title=view.findViewById(R.id.detailTitle);
        final LinearLayout senderLayout=view.findViewById(R.id.detailsList);
        final ImageView imageView=view.findViewById(R.id.showHide);
        imageView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if(senderLayout.getVisibility()==View.VISIBLE){
                    senderLayout.setVisibility(View.GONE);
                    imageView.setImageResource(R.drawable.ic_expand_more);
                }else{
                    senderLayout.setVisibility(View.VISIBLE);
                    imageView.setImageResource(R.drawable.ic_expand_less);
                }
            }
        });
        title.setText("Profile");
        imageView.setImageResource(R.drawable.ic_expand_less);
        addView(senderLayout, "Employee Id", jsonObject.getString("emp_id"));
        addView(senderLayout, "First Name",jsonObject.getString("employeename"));
        addView(senderLayout, "Middle Name", jsonObject.getString("middle_name"));
        addView(senderLayout, "Last Name", jsonObject.getString("middle_name"));
        addView(senderLayout, "Nationality",jsonObject.getString("nationality"));
        addView(senderLayout, "Date of Birth",jsonObject.getString("date_of_birth"));
        addView(senderLayout, "Gender",jsonObject.getString("gender"));
      /*  addView(senderLayout, "Religion",jsonObject.getString("religion"));
        addView(senderLayout, "blood_group",jsonObject.getString("blood_group"));*/
        addView(senderLayout, "Designation",jsonObject.getString("designation"));
        addView(senderLayout, "Group Name",jsonObject.getString("groups"));
        addView(senderLayout, "SubGroup I", jsonObject.getString("subgroup1"));
        addView(senderLayout, "SubGroup II", jsonObject.getString("subgroup2"));
        addView(senderLayout, "Gender",jsonObject.getString("gender"));
        addView(senderLayout, "Email",jsonObject.getString("emailid"));
        addView(senderLayout, "Mobile",jsonObject.getString("mobilenumber"));
        //addView(senderLayout, "Join Date",jsonObject.getString("status"));

        mainLayout.addView(view);
    }

    private void addBank(JSONObject jsonObject) throws JSONException {
        View view=getLayoutInflater().inflate(R.layout.model_layout_profile,null);
        TextView title=view.findViewById(R.id.detailTitle);
        final LinearLayout senderLayout=view.findViewById(R.id.detailsList);
        title.setText("Bank Account");
        final ImageView imageView=view.findViewById(R.id.showHide);
        imageView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if(senderLayout.getVisibility()==View.VISIBLE){
                    senderLayout.setVisibility(View.GONE);
                    imageView.setImageResource(R.drawable.ic_expand_more);
                }else{
                    senderLayout.setVisibility(View.VISIBLE);
                    imageView.setImageResource(R.drawable.ic_expand_less);
                }
            }
        });
        senderLayout.setVisibility(View.GONE);
        addView(senderLayout, "Bank Name",jsonObject.getString("bank_name"));
        addView(senderLayout, "Account Number",jsonObject.getString("account_number"));
        addView(senderLayout, "IFSC Code",jsonObject.getString("ifsc_code"));
        addView(senderLayout, "Branch",jsonObject.getString("account_type"));
        mainLayout.addView(view);
    }

    private void addAddress(JSONObject jsonObject) throws JSONException {
        View view=getLayoutInflater().inflate(R.layout.model_layout_profile,null);
        TextView title=view.findViewById(R.id.detailTitle);
        final LinearLayout senderLayout=view.findViewById(R.id.detailsList);
        title.setText("Contact Information");
        final ImageView imageView=view.findViewById(R.id.showHide);
        imageView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if(senderLayout.getVisibility()==View.VISIBLE){
                    senderLayout.setVisibility(View.GONE);
                    imageView.setImageResource(R.drawable.ic_expand_more);
                }else{
                    senderLayout.setVisibility(View.VISIBLE);
                    imageView.setImageResource(R.drawable.ic_expand_less);
                }
            }
        });
        senderLayout.setVisibility(View.GONE);
        addAddressView1(jsonObject,senderLayout);
        addAddressView2(jsonObject,senderLayout);
        mainLayout.addView(view);
    }

    private void addDependent(JSONArray jsonArray) throws JSONException {
        View view=getLayoutInflater().inflate(R.layout.model_layout_profile,null);
        TextView title=view.findViewById(R.id.detailTitle);
        final LinearLayout senderLayout=view.findViewById(R.id.detailsList);
        title.setText("Dependent");
        final ImageView imageView=view.findViewById(R.id.showHide);
        imageView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if(senderLayout.getVisibility()==View.VISIBLE){
                    senderLayout.setVisibility(View.GONE);
                    imageView.setImageResource(R.drawable.ic_expand_more);
                }else{
                    senderLayout.setVisibility(View.VISIBLE);
                    imageView.setImageResource(R.drawable.ic_expand_less);
                }
            }
        });
        senderLayout.setVisibility(View.GONE);
        for(int i=0; i<jsonArray.length(); i++){
            addDependentView(jsonArray.getJSONObject(i),senderLayout);
        }
        mainLayout.addView(view);
    }

    private void addExperience(JSONArray jsonArray) throws JSONException {
        View view=getLayoutInflater().inflate(R.layout.model_layout_profile,null);
        TextView title=view.findViewById(R.id.detailTitle);
        final LinearLayout senderLayout=view.findViewById(R.id.detailsList);
        title.setText("Work Experience");
        final ImageView imageView=view.findViewById(R.id.showHide);
        imageView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if(senderLayout.getVisibility()==View.VISIBLE){
                    senderLayout.setVisibility(View.GONE);
                    imageView.setImageResource(R.drawable.ic_expand_more);
                }else{
                    senderLayout.setVisibility(View.VISIBLE);
                    imageView.setImageResource(R.drawable.ic_expand_less);
                }
            }
        });
        senderLayout.setVisibility(View.GONE);
        for(int i=0; i<jsonArray.length(); i++){
            addExperienceView(jsonArray.getJSONObject(i),senderLayout);
        }
        mainLayout.addView(view);
    }

    private void addEducation(JSONArray jsonArray) throws JSONException {
        View view=getLayoutInflater().inflate(R.layout.model_layout_profile,null);
        TextView title=view.findViewById(R.id.detailTitle);
        final LinearLayout senderLayout=view.findViewById(R.id.detailsList);
        title.setText("Education");
        final ImageView imageView=view.findViewById(R.id.showHide);
        imageView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if(senderLayout.getVisibility()==View.VISIBLE){
                    senderLayout.setVisibility(View.GONE);
                    imageView.setImageResource(R.drawable.ic_expand_more);
                }else{
                    senderLayout.setVisibility(View.VISIBLE);
                    imageView.setImageResource(R.drawable.ic_expand_less);
                }
            }
        });
        senderLayout.setVisibility(View.GONE);
        for(int i=0; i<jsonArray.length(); i++){
            addEducationsView(jsonArray.getJSONObject(i),senderLayout);
        }
        mainLayout.addView(view);
    }

    private void addPassport(JSONObject jsonObject) throws JSONException {
        View view=getLayoutInflater().inflate(R.layout.model_layout_profile,null);
        TextView title=view.findViewById(R.id.detailTitle);
        final LinearLayout senderLayout=view.findViewById(R.id.detailsList);
        final ImageView imageView=view.findViewById(R.id.showHide);
        imageView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if(senderLayout.getVisibility()==View.VISIBLE){
                    senderLayout.setVisibility(View.GONE);
                    imageView.setImageResource(R.drawable.ic_expand_more);
                }else{
                    senderLayout.setVisibility(View.VISIBLE);
                    imageView.setImageResource(R.drawable.ic_expand_less);
                }
            }
        });
        senderLayout.setVisibility(View.GONE);

        title.setText("Passport");
        addView(senderLayout, "Passport Number",jsonObject.getString("pass_number"));
        addView(senderLayout, "PassPort Type",jsonObject.getString("surname"));
        addView(senderLayout, "Place of Issue",jsonObject.getString("pass_Authority"));
        addView(senderLayout, "Issued Date",jsonObject.getString("pass_date_issue"));
        addView(senderLayout, "Expiry Date",jsonObject.getString("pass_expiry"));

        mainLayout.addView(view);
    }


    private void addAddressView1(JSONObject jsonObject,LinearLayout mainLayout) throws JSONException {
        View view=getLayoutInflater().inflate(R.layout.model_layout_address,null);
        TextView title=view.findViewById(R.id.detailTitle);
        final LinearLayout senderLayout=view.findViewById(R.id.detailsList);
        title.setText("Permanant Address");
        addView(senderLayout, "No",jsonObject.getString("permanent_door"));
        addView(senderLayout, "Address 1",jsonObject.getString("permanent_addr1"));
        addView(senderLayout, "Address 2",jsonObject.getString("permanent_addr2"));
        addView(senderLayout, "Country",jsonObject.getString("permanent_country"));
        addView(senderLayout, "State",jsonObject.getString("permanent_state"));
        addView(senderLayout, "City",jsonObject.getString("permanent_city"));
        addView(senderLayout, "Poistal  code",jsonObject.getString("permanent_zipcode"));
        mainLayout.addView(view);
    }

    private void addAddressView2(JSONObject jsonObject,LinearLayout mainLayout) throws JSONException {
        View view=getLayoutInflater().inflate(R.layout.model_layout_address,null);
        TextView title=view.findViewById(R.id.detailTitle);
        final LinearLayout senderLayout=view.findViewById(R.id.detailsList);
        title.setText("Present Address");
        addView(senderLayout, "No",jsonObject.getString("present_door"));
        addView(senderLayout, "Address 1",jsonObject.getString("present_addr1"));
        addView(senderLayout, "Address 2",jsonObject.getString("present_addr2"));
        addView(senderLayout, "Country",jsonObject.getString("present_country"));
        addView(senderLayout, "State",jsonObject.getString("present_state"));
        addView(senderLayout, "City",jsonObject.getString("present_city"));
        addView(senderLayout, "Poistal  code",jsonObject.getString("present_zipcode"));
        mainLayout.addView(view);
    }

    private void addEducationsView(JSONObject jsonObject,LinearLayout mainLayout) throws JSONException {
        View view=getLayoutInflater().inflate(R.layout.model_layout_address,null);
        TextView title=view.findViewById(R.id.detailTitle);
        final LinearLayout senderLayout=view.findViewById(R.id.detailsList);
        title.setVisibility(View.GONE);
        addView(senderLayout, "Institution Name",jsonObject.getString("institution_name"));
        addView(senderLayout, "Degree/Diploma",jsonObject.getString("degree"));
        addView(senderLayout, "Field of Study",jsonObject.getString("fieldofstudy"));
        addView(senderLayout, "Date of Completion",jsonObject.getString("dateofcompletion"));
        addView(senderLayout, "Additional Notes",jsonObject.getString("interests"));
        mainLayout.addView(view);
    }

    private void addExperienceView(JSONObject jsonObject,LinearLayout mainLayout) throws JSONException {
        View view=getLayoutInflater().inflate(R.layout.model_layout_address,null);
        TextView title=view.findViewById(R.id.detailTitle);
        final LinearLayout senderLayout=view.findViewById(R.id.detailsList);
        title.setVisibility(View.GONE);
        addView(senderLayout, "Company Name",jsonObject.getString("companyname"));
        addView(senderLayout, "Job Title",jsonObject.getString("jobtitle"));
        addView(senderLayout, "From Date",jsonObject.getString("from_date"));
        addView(senderLayout, "To Date",jsonObject.getString("to_date"));
        addView(senderLayout, "Job Description",jsonObject.getString("job_description"));
        mainLayout.addView(view);
    }

    private void addDependentView(JSONObject jsonObject,LinearLayout mainLayout) throws JSONException {
        View view=getLayoutInflater().inflate(R.layout.model_layout_address,null);
        TextView title=view.findViewById(R.id.detailTitle);
        final LinearLayout senderLayout=view.findViewById(R.id.detailsList);
        title.setVisibility(View.GONE);
        addView(senderLayout, "Name",jsonObject.getString("dependent_name"));
        addView(senderLayout, "Relationship",jsonObject.getString("relationship"));
        addView(senderLayout, "Mobile Number",jsonObject.getString("mobile"));
        mainLayout.addView(view);
    }

    private void addView(LinearLayout linearLayout,String titleText, String valueText){
        View view=getLayoutInflater().inflate(R.layout.model_profile_row,null);
        TextView title=view.findViewById(R.id.title);
        TextView value=view.findViewById(R.id.value);
        title.setText(titleText);
        value.setText(valueText);

        if(!valueText.equalsIgnoreCase(NDA) && !valueText.isEmpty()) {
            linearLayout.addView(view);
        }

    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()){
            case android.R.id.home:
                onBackPressed();
                return true;
        }
        return super.onOptionsItemSelected(item);
    }
}
