package com.b2lmobitech.fieldcloudplus

import android.Manifest
import android.app.AlertDialog
import android.app.PendingIntent
import android.content.Context
import android.content.DialogInterface
import android.content.Intent
import android.content.pm.PackageManager
import android.location.LocationManager
import android.net.ConnectivityManager
import android.os.Bundle
import android.os.StrictMode
import android.os.StrictMode.ThreadPolicy
import android.provider.Settings
import android.util.Log
import android.view.Menu
import android.view.MenuItem
import android.view.View
import android.widget.ImageView
import android.widget.ProgressBar
import android.widget.TextView
import android.widget.Toast
import androidx.appcompat.app.ActionBarDrawerToggle
import androidx.appcompat.app.AppCompatActivity
import androidx.appcompat.widget.Toolbar
import androidx.core.app.ActivityCompat
import androidx.core.view.GravityCompat
import androidx.drawerlayout.widget.DrawerLayout
import androidx.lifecycle.ViewModelProvider
import androidx.recyclerview.widget.GridLayoutManager
import androidx.recyclerview.widget.RecyclerView
import androidx.work.Constraints
import androidx.work.Data
import androidx.work.NetworkType
import androidx.work.PeriodicWorkRequest
import androidx.work.WorkManager
import com.android.volley.Response
import com.android.volley.toolbox.StringRequest
import com.android.volley.toolbox.Volley
import com.b2lmobitech.fieldcloudplus.MainActivity
import com.b2lmobitech.fieldcloudplus.defect.DefectReportsActivity
import com.b2lmobitech.fieldcloudplus.defect.PettyCashActivity
import com.b2lmobitech.fieldcloudplus.hcm.Attendance
import com.b2lmobitech.fieldcloudplus.hcm.AttendanceSummary
import com.b2lmobitech.fieldcloudplus.hcm.HCMURL
import com.b2lmobitech.fieldcloudplus.hcm.Leaveactivity
import com.b2lmobitech.fieldcloudplus.hcm.Location
import com.b2lmobitech.fieldcloudplus.hcm.activities.EmployeeActivity
import com.b2lmobitech.fieldcloudplus.hcm.activities.PayRollActivity
import com.b2lmobitech.fieldcloudplus.hcm.activities.TravelActivity
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.viewModel.DBViewModel
import com.b2lmobitech.fieldcloudplus.hcm.new_wroks.FacilityVisitsActivity
import com.b2lmobitech.fieldcloudplus.hcm.others.LocationUpdate
import com.b2lmobitech.fieldcloudplus.hcm.sql.HcmDatabase
import com.b2lmobitech.fieldcloudplus.hcm.timesheet.TimesheetSummaryActivity
import com.b2lmobitech.fieldcloudplus.hcm.timesheet.timesheet
import com.b2lmobitech.fieldcloudplus.kyc.KycActivity
import com.b2lmobitech.fieldcloudplus.notes.NotesActivity
import com.b2lmobitech.fieldcloudplus.others.encaps.DashBoardGridAdapter
import com.b2lmobitech.fieldcloudplus.others.encaps.Grid
import com.b2lmobitech.fieldcloudplus.others.encaps.GridItems
import com.b2lmobitech.fieldcloudplus.others.sql.sqlitehelper.sqldatabase
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue
import com.b2lmobitech.fieldcloudplus.others.utils.Preference
import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables
import com.b2lmobitech.fieldcloudplus.service.activities.PreventiveActivity
import com.b2lmobitech.fieldcloudplus.service.activities.ReportHistoryActivity
import com.b2lmobitech.fieldcloudplus.service.activities.TicketActivity
import com.b2lmobitech.fieldcloudplus.service.activities.expense
import com.b2lmobitech.fieldcloudplus.serviceold.CombinationsList_Offline
import com.b2lmobitech.fieldcloudplus.serviceold.MaintananceType
import com.b2lmobitech.fieldcloudplus.serviceold.ReportGraph
import com.b2lmobitech.fieldcloudplus.serviceold.helpcenter
import com.b2lmobitech.fieldcloudplus.task.Utility
import com.b2lmobitech.fieldcloudplus.task.activities.Dashboard
import com.b2lmobitech.fieldcloudplus.task.service.AccessToken
import com.b2lmobitech.fieldcloudplus.task.service.GeofenceBroadcastReceiver
import com.b2lmobitech.fieldcloudplus.task.service.LocationBatteryService
import com.b2lmobitech.fieldcloudplus.utils.LocationUtils
import com.b2lmobitech.fieldcloudplus.utils.openAppSettings
import com.bumptech.glide.Glide
import com.bumptech.glide.request.RequestOptions
import com.google.android.gms.location.Geofence
import com.google.android.gms.location.GeofencingRequest
import com.google.android.gms.location.LocationServices
import com.google.android.gms.tasks.OnCompleteListener
import com.google.android.gms.tasks.Task
import com.google.android.material.navigation.NavigationView
import com.google.android.material.snackbar.Snackbar
import com.google.firebase.messaging.FirebaseMessaging
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch
import org.json.JSONArray
import org.json.JSONException
import org.json.JSONObject
import java.text.SimpleDateFormat
import java.util.Date
import java.util.Locale
import java.util.concurrent.TimeUnit

//import com.firebase.jobdispatcher.Constraint;
//import com.firebase.jobdispatcher.FirebaseJobDispatcher;
//import com.firebase.jobdispatcher.GooglePlayDriver;
//import com.firebase.jobdispatcher.Job;
//import com.firebase.jobdispatcher.Lifetime;
//import com.firebase.jobdispatcher.Trigger;
//import com.google.firebase.iid.FirebaseInstanceId;
//import com.google.firebase.iid.InstanceIdResult;
class dashboard : AppCompatActivity(), NavigationView.OnNavigationItemSelectedListener {
    private var countnumbers: ArrayList<String>? = null
    private var mycontext: Context? = null
    private var progressBar: ProgressBar? = null
    private var mDbHelper: sqldatabase? = null
    private var locationbroadcastvalue: String? = null
    private var registeredcompany: String? = null
    private var registeredemailid: String? = null
    private var snackBar: Snackbar? = null
    private var isGPSEnabled = false
    private var isNetworkEnabled = false
    private var workManager: WorkManager? = null

    private lateinit var dbViewModel: DBViewModel

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_dashboard)

        mycontext = this
        workManager = WorkManager.getInstance(this)
        setDrawer()
        setGridAdapter()
        checkLocationEnables()

        try {
            progressBar = findViewById<View>(R.id.progressBar) as ProgressBar
            mDbHelper = sqldatabase(mycontext)
            snackBar = Snackbar.make(
                findViewById(android.R.id.content),
                "Please check internet connection",
                Snackbar.LENGTH_INDEFINITE
            )
            countnumbers = ArrayList()



            locationbroadcastvalue = globalvariables.Logoutsharedpreference.getString(
                globalvariables.logout_locationbroadcast,
                "No"
            )
            if (locationbroadcastvalue.equals("No", ignoreCase = true)) {
                call_location_every15mins()
            }
        } catch (e: Exception) {
            e.printStackTrace()
        }
        updateFirebaseToken()
        //the below 2 lines are for service->AccessToken class
        val policy = ThreadPolicy.Builder().permitAll().build()
        StrictMode.setThreadPolicy(policy)
        val accesstoken = AccessToken()
        val accesskey = accesstoken.accessToken
        Log.d("accesskeyval", accesskey)
        //        updateFirebasetokenval(accesskey);

        dbViewModel = ViewModelProvider.AndroidViewModelFactory.getInstance(application)
            .create(DBViewModel::class.java)
        checkForActiveDefectsAndStartLocationBatteryService()
    }

    private fun checkLocationEnables() {
        val locationManager = mycontext?.getSystemService(LOCATION_SERVICE) as LocationManager

        isGPSEnabled = locationManager.isProviderEnabled(LocationManager.GPS_PROVIDER)
        isNetworkEnabled = locationManager.isProviderEnabled(LocationManager.NETWORK_PROVIDER)
        if (!isGPSEnabled && !isNetworkEnabled) {
            //Toast.makeText(mycontext, "No network provider is enabled for location access", Toast.LENGTH_LONG).show();
            val alertdialog = AlertDialog.Builder(mycontext)

            alertdialog.setTitle("Access Location")
            alertdialog.setIcon(R.drawable.ic_action_location)
            alertdialog.setMessage("No network provider is enabled for location access!!")
            alertdialog.setPositiveButton(
                "Turn On"
            ) { dialog, whichButton -> startActivity(Intent(Settings.ACTION_LOCATION_SOURCE_SETTINGS)) }
            alertdialog.setNegativeButton("Cancel") { dialog, which -> dialog.dismiss() }.create()
            alertdialog.show()
        }
    }

    private fun setDrawer() {
        val toolbar = findViewById<Toolbar>(R.id.toolbar)
        setSupportActionBar(toolbar)

        val drawer = findViewById<DrawerLayout>(R.id.drawer_layout)
        val toggle = ActionBarDrawerToggle(
            this, drawer, toolbar, R.string.navigation_drawer_open, R.string.navigation_drawer_close
        )
        drawer.addDrawerListener(toggle)
        toggle.syncState()
        val navigationView = findViewById<NavigationView>(R.id.nav_view)
        navigationView.setNavigationItemSelectedListener(this)
        val companyheading = findViewById<TextView>(R.id.textView3)
        val header = navigationView.getHeaderView(0)

        header.findViewById<View>(R.id.imageView).setOnClickListener {
            if (!MyRequestQueue.getInstance(this@dashboard).isNoInternet) {
                val intent = Intent(applicationContext, ProfileActivity::class.java)
                startActivity(intent)
            }
        }

        val emailheading = header.findViewById<TextView>(R.id.emailtextView)
        val nameheading = header.findViewById<TextView>(R.id.personname)
        val preference = Preference.getInstance(this)
        val imageView = header.findViewById<ImageView>(R.id.imageView)

        globalvariables.Logoutsharedpreference =
            getSharedPreferences(globalvariables.LOGOUT_CHECKING, 0)
        registeredcompany =
            globalvariables.Logoutsharedpreference.getString(globalvariables.logout_companyname, "")
        registeredcompany = preference.companyName
        registeredemailid = preference.emailId

        nameheading.text = preference.getpersonname()
        companyheading.text = registeredcompany
        emailheading.text = registeredemailid

        if (!preference.getString("profile").isEmpty()) {
            Glide.with(this)
                .applyDefaultRequestOptions(RequestOptions.circleCropTransform())
                .load(Utility.bitmap(preference.getString("profile")))
                .into(imageView)
            imageView.setImageBitmap(Utility.bitmap(preference.getString("profile")))
        }

        supportActionBar!!.title = "Dashboard"
    }

    override fun onBackPressed() {
        super.onBackPressed()
        val drawer = findViewById<DrawerLayout>(R.id.drawer_layout)
        if (drawer.isDrawerOpen(GravityCompat.START)) {
            drawer.closeDrawer(GravityCompat.START)
        } else {
            val a = Intent(Intent.ACTION_MAIN)
            a.addCategory(Intent.CATEGORY_HOME)
            a.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
            startActivity(a)
            finish()
        }
    }

    override fun onCreateOptionsMenu(menu: Menu): Boolean {
        menuInflater.inflate(R.menu.dashboard, menu)
        return true
    }

    override fun onNavigationItemSelected(item: MenuItem): Boolean {
        //->menu->activity_dashboard_drawer.xml
        // Handle navigation view item clicks here.
        val id = item.itemId

        //        if (id == R.id.nav_home) {
//            // Handle the camera action
//        } else
//        if (id == R.id.nav_settings) {
//            Intent intent = new Intent(mycontext, SettingsActivity.class);
//            startActivity(intent);
//        }
//        else if (id == R.id.nav_sync) {
//
//        }
        if (id == R.id.nav_offline) {
            val intent = Intent(mycontext, CombinationsList_Offline::class.java)
            startActivity(intent)
        } else if (id == R.id.nav_about) {
            val intent = Intent(mycontext, Aboutusactivity::class.java)
            startActivity(intent)
        } else if (id == R.id.nav_kyc) {
            val intent = Intent(mycontext, KycActivity::class.java)
            startActivity(intent)
        } else if (id == R.id.nav_help) {
            val intent = Intent(mycontext, helpcenter::class.java)
            startActivity(intent)
        } else if (id == R.id.nav_share) {
            val sendIntent = Intent()
            sendIntent.setAction(Intent.ACTION_SEND)
            sendIntent.putExtra(
                Intent.EXTRA_TEXT,
                "Hey check out FieldCloudDesk app at: https://play.google.com/store/apps/details?id=com.b2lmobitech.fieldclouddesk&hl=en"
            )
            sendIntent.setType("text/plain")
            startActivity(sendIntent)
        } else if (id == R.id.nav_logout) {
            val alertdialog = AlertDialog.Builder(this)

            alertdialog.setTitle("Logout")
            alertdialog.setIcon(R.drawable.ic_action_logout)
            alertdialog.setMessage("Are you sure?")
            alertdialog.setPositiveButton("Yes",
                object : DialogInterface.OnClickListener {
                    override fun onClick(dialog: DialogInterface, whichButton: Int) {
                        if (this@dashboard.isNetworkAvailable) {
                            logout()
                        } else {
                            //Toast.makeText(mycontext,"Please check the internet connection", Toast.LENGTH_LONG).show();
                            snackBar?.dismiss()
                            snackBar = Snackbar.make(
                                findViewById(android.R.id.content),
                                "Please check internet connection",
                                Snackbar.LENGTH_INDEFINITE
                            )
                            toast()
                        }
                    }
                })
            alertdialog.setNegativeButton("No") { dialog, which ->
                // TODO Auto-generated method stub
            }.create()
            alertdialog.show()
        }

        val drawer = findViewById<View>(R.id.drawer_layout) as DrawerLayout
        drawer.closeDrawer(GravityCompat.START)
        return true
    }

    val isNetworkAvailable: Boolean
        get() {
            val cm = getSystemService(CONNECTIVITY_SERVICE) as ConnectivityManager
            val networkInfo = cm.activeNetworkInfo
            // if no network is available networkInfo will be null
            // otherwise check if we are connected
            if (networkInfo != null && networkInfo.isConnected) {
                if (cm.getNetworkInfo(ConnectivityManager.TYPE_WIFI)?.isConnectedOrConnecting == true) {
                    // do your stuff
//			    Log.d("wifi connectivity", "connected");
                } else {
//			    	   Log.d("wifi connectivity", "wifi not connecte?d");
                }

                return true
            }
            return false
        }

    override fun onDestroy() {
        mDbHelper?.close()
        super.onDestroy()
    }

    private fun call_location_every15mins() {
        if (HcmDatabase.getInstance(this).isCheckedIn) {
            if (!Preference.getInstance(this).isLocationUpdateRunning) {
                startLcoationUpdates()
            }
        } else {
            if (Preference.getInstance(this).isLocationUpdateRunning) {
                stopLocationUpdates()
            }
        }
    }

    private fun toast() {
        snackBar?.setAction("CLOSE") { snackBar?.dismiss() }
            ?.setActionTextColor(resources.getColor(android.R.color.holo_blue_dark))?.show()
    }

    private fun updateFirebasetokenval(token: String) {
        updateFirebaseToken(token)
    }

    private fun updateFirebaseToken() {
        FirebaseMessaging.getInstance().token.addOnCompleteListener(object :
            OnCompleteListener<String?> {
            override fun onComplete(task: Task<String?>) {
                if (task.isComplete) {
                    val token = task.result
                    if (token != null) {
                        Log.d("getToken", token)
                        updateFirebaseToken(token)
                    }
                }
            }
        })
        //        FirebaseInstanceId.getInstance().getInstanceId().addOnCompleteListener(new OnCompleteListener<InstanceIdResult>() {
//            @Override
//            public void onComplete(@NonNull Task<InstanceIdResult> task) {
//                updateFirebaseToken(task.getResult().getToken());
//            }
//        });
    }

    private fun updateFirebaseToken(token: String) {
        val postRequest: StringRequest = object : StringRequest(
            Method.POST, URL.FIREBASE,
            object : Response.Listener<String?> {
                override fun onResponse(response: String?) {
                    // response
                    if (response != null) {
                        Log.d("Responseval", response)
                    }
                    try {
                        val json = JSONObject(response)

                        val success = json.getInt("s")
                        if (response != null) {
                            Log.d("successval", response)
                        }
                        if (success == 1) {
                            val editor = globalvariables.Logoutsharedpreference.edit()
                            editor.putBoolean("firebase", false)
                            editor.apply()
                        }
                    } catch (e: JSONException) {
                        e.printStackTrace()
                    }
                }
            },
            Response.ErrorListener { error -> // error
                Log.d("Error.Response", error.toString())
            }
        ) {
            override fun getParams(): Map<String, String>? {
                val params: MutableMap<String, String> = HashMap()
                params["token"] = token
                params["emailid"] = registeredemailid ?: ""
                return params
            }
        }
        Volley.newRequestQueue(this).add(postRequest)
    }

    private fun arrayList(): ArrayList<Grid> {
        val gridArrayList = ArrayList<Grid>()
        val preference = Preference.getInstance(this)

        val type = preference.eCompanyType.lowercase(Locale.getDefault())
        if (type.contains("hcm") || type.contains("attendance")) {
            //attendance
            gridArrayList.add(
                Grid(
                    "MY ATTENDANCE",
                    R.drawable.ic_action_attendance2,
                    Attendance::class.java,
                    "attendance"
                )
            )
            gridArrayList.add(
                Grid(
                    "MY LEAVES",
                    R.drawable.ic_action_leave2,
                    Leaveactivity::class.java,
                    "attendance"
                )
            )
            gridArrayList.add(
                Grid(
                    "TIME SHEET",
                    R.drawable.ic_action_timesheet2,
                    timesheet::class.java,
                    "attendance"
                )
            )
            gridArrayList.add(
                Grid(
                    "MY LOCATION",
                    R.drawable.ic_action_location2,
                    Location::class.java,
                    "attendance"
                )
            )
            gridArrayList.add(
                Grid(
                    "MY TRAVELS",
                    R.drawable.ic_trip,
                    TravelActivity::class.java,
                    "attendance"
                )
            )
            gridArrayList.add(
                Grid(
                    "EMPLOYESS",
                    R.drawable.ic_emlpoyee2,
                    EmployeeActivity::class.java,
                    "attendance"
                )
            )
            gridArrayList.add(
                Grid(
                    "PAY ROLL",
                    R.drawable.ic_baseline_money2,
                    PayRollActivity::class.java,
                    "attendance"
                )
            )

            if (preference.isAdmin) {
                gridArrayList.add(
                    Grid(
                        "REPORT",
                        R.drawable.summary_report,
                        ReportGraph::class.java,
                        "admin"
                    )
                )
                gridArrayList.add(
                    Grid(
                        "ATTENDANCE SUMMARY",
                        R.drawable.attendance_summary,
                        AttendanceSummary::class.java,
                        "admin"
                    )
                )
                gridArrayList.add(
                    Grid(
                        "FACILITY VISITS",
                        R.drawable.attendance_summary,
                        FacilityVisitsActivity::class.java,
                        "admin"
                    )
                )
                gridArrayList.add(
                    Grid(
                        "TIMESHEET SUMMARY",
                        R.drawable.attendance_summary,
                        TimesheetSummaryActivity::class.java,
                        "admin"
                    )
                )
            }
        }
        if (type.contains("service")) {
            //service
            gridArrayList.add(
                Grid(
                    "FORMS",
                    R.drawable.ic_preventive2,
                    PreventiveActivity::class.java,
                    "service"
                )
            )
            gridArrayList.add(
                Grid(
                    "TICKETS",
                    R.drawable.ic_action_corrective2,
                    TicketActivity::class.java,
                    "service"
                )
            )
            gridArrayList.add(
                Grid(
                    "WORK REPORT",
                    R.drawable.ic_action_workreport2,
                    ReportHistoryActivity::class.java,
                    "service"
                )
            )
            gridArrayList.add(
                Grid(
                    "CONVEYANCE",
                    R.drawable.ic_action_name2,
                    expense::class.java,
                    "service"
                )
            )
            gridArrayList.add(
                Grid(
                    "Defects",
                    R.drawable.ic_action_workreport3,
                    DefectReportsActivity::class.java,
                    "service"
                )
            )
            gridArrayList.add(
                Grid(
                    "Petty Cash",
                    R.drawable.ic_payroll2,
                    PettyCashActivity::class.java,
                    "service"
                )
            )

            /*if(preference.isAdmin()){
                gridArrayList.add(new Grid("TICKET SUMMARY",R.drawable.ticket_summary,TicketSummary.class,"admin"));
                gridArrayList.add(new Grid("PREVENTIVE SUMMARY",R.drawable.employee_list,EmployeeList.class,"admin"));
                if(!type.contains("hcm") && !type.contains("attendance")) {
                    gridArrayList.add(new Grid("REPORT", R.drawable.summary_report, ReportGraph.class, "admin"));
                }
            }*/
        }

        if (type.contains("task") || type.contains("project")) {
            //project
            gridArrayList.add(
                Grid(
                    "PROJECT",
                    R.drawable.ic_project2,
                    Dashboard::class.java,
                    "project"
                )
            )
            //notes
            gridArrayList.add(
                Grid(
                    "NOTES",
                    R.drawable.ic_notepad2,
                    NotesActivity::class.java,
                    "notes"
                )
            )
        }

        // gridArrayList.add(new Grid("EXPENSES", R.drawable.ic_payroll, ExpenseDashboard.class, "attendance"));
        return gridArrayList
    }

    private fun setGridAdapter() {
        val recyclerView = findViewById<RecyclerView>(R.id.dashboard_recycle)
        recyclerView.layoutManager = GridLayoutManager(this, 2)
        val dashBoardGridAdapter = DashBoardGridAdapter(this, arrayList())
        recyclerView.adapter = dashBoardGridAdapter
    }

    private fun startLcoationUpdates() {
        val input = Data.Builder()
            .putString("registeredemailid", registeredemailid)
            .putString("registeredcompany", registeredcompany)
            .build()
        val constraints = Constraints.Builder() // The Worker needs Network connectivity
            .setRequiredNetworkType(NetworkType.CONNECTED) // Needs the device to be charging
            //                .setRequiresCharging(true)
            .build()
        val request =  // Executes MyWorker every 15 minutes
            PeriodicWorkRequest.Builder(
                LocationUpdate::class.java,
                15,
                TimeUnit.MINUTES
            ) // Sets the input data for the ListenableWorker
                .setInputData(input)
                .addTag("location") // If you want to delay the start of work by 60 seconds
                .setInitialDelay(
                    60,
                    TimeUnit.SECONDS
                ) // Set a backoff criteria to be used when retry-ing
                //                        .setBackoffCriteria(BackoffCriteria.EXPONENTIAL, 30000, TimeUnit.MILLISECONDS)
                // Set additional constraints
                .setConstraints(constraints)
                .build()
        Preference.getInstance(this).setLocationUpdateRunning()
    }

    private fun logout() {
        snackBar?.dismiss()
        Snackbar.make(findViewById(android.R.id.content), "Please wait..", Snackbar.LENGTH_SHORT)
            .setAction("Action", null).show()

        val params: MutableMap<String, String?> = HashMap()
        params["emailid"] = registeredemailid

        MyRequestQueue.getInstance(this).addToQueue(URL.LOGOUT, params) { response ->
            try {
                val jsonObject = JSONObject(response)
                if (jsonObject.getInt("s") == 1) {
                    Preference.getInstance(
                        applicationContext
                    ).clear()
                    startActivity(Intent(applicationContext, MainActivity::class.java))
                    val intent = Intent(mycontext, MainActivity::class.java)
                    intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP) //| Intent.FLAG_ACTIVITY_NEW_TASK
                    startActivity(intent)
                    stopLocationUpdates()
                    finish()
                } else {
                    snackBar?.dismiss()
                    snackBar = Snackbar.make(
                        findViewById(android.R.id.content),
                        "Please try again",
                        Snackbar.LENGTH_INDEFINITE
                    )
                    toast()
                }
            } catch (e: JSONException) {
                e.printStackTrace()
            }
        }
    }

    private fun stopLocationUpdates() {
//        FirebaseJobDispatcher dispatcher = new FirebaseJobDispatcher(new GooglePlayDriver(this));
//        dispatcher.cancel("location");
        workManager?.cancelUniqueWork("my-unique-name")
        Preference.getInstance(this).setLocationUpdateNotRunning()
    }

    private fun checkForActiveDefectsAndStartLocationBatteryService(){
        val requestQueue = Volley.newRequestQueue(applicationContext)
        val preference = com.b2lmobitech.fieldcloudplus.task.others.Preference.getInstance(this)
        val params: MutableMap<String, String> = java.util.HashMap()
        params["email"] = preference.emailId
        params["companyname"] = preference.companyName

        val postRequest: StringRequest = object : StringRequest(
            Method.POST, "${URL.API}/defect/get_active_defect.php",
            Response.Listener { response -> // response
                Log.d("Response", response.toString())
                try {
                    JSONObject(response).let {
                        if(it.getInt("s") == 1){
                            val latitude = it.getString("latitude").toDoubleOrNull()?:0.0
                            val longitude = it.getString("longitude").toDoubleOrNull()?:0.0
                            val geoDistance = it.getString("geo_distance").toFloatOrNull()?:100f
                            val atmId = it.getString("atmid")
                            GeofenceBroadcastReceiver.registerGeoFence(
                                this,
                                latitude,
                                longitude,
                                geoDistance,
                                atmId,
                                it.getString("defect_id")
                            )
                            if(it.has("defect_id")){
                                LocationBatteryService.startLocationService(this,it.getString("defect_id"),latitude,longitude,geoDistance,atmId)
                            }
                        }else{
                            LocationBatteryService.stopLocationService(context = this)
                        }
                    }
                } catch (e: Exception) {
                    e.printStackTrace()
                }
            },
            Response.ErrorListener { error -> // error
                Log.d("Error.Response", error.toString())
            }
        ) {
            override fun getParams(): Map<String, String> {
                return params
            }
        }
        requestQueue.add(postRequest)
    }

}
