package com.b2lmobitech.fieldcloudplus.defect

import android.content.Intent
import android.content.IntentFilter
import android.location.Location
import android.os.BatteryManager
import android.os.Bundle
import android.util.Log
import android.view.Menu
import android.view.MenuItem
import android.view.View
import android.widget.ArrayAdapter
import android.widget.Button
import android.widget.ImageView
import android.widget.LinearLayout
import android.widget.Spinner
import android.widget.TextView
import android.widget.Toast
import androidx.appcompat.app.AppCompatActivity
import androidx.core.app.NotificationManagerCompat
import androidx.lifecycle.ViewModelProvider
import androidx.recyclerview.widget.RecyclerView
import com.android.volley.Response
import com.android.volley.toolbox.StringRequest
import com.android.volley.toolbox.Volley
import com.b2lmobitech.fieldcloudplus.R
import com.b2lmobitech.fieldcloudplus.URL
import com.b2lmobitech.fieldcloudplus.databinding.ActivityDefectDetailsBinding
import com.b2lmobitech.fieldcloudplus.defect.adapter.NetworkImageAdapter
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.viewModel.DBViewModel
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue
import com.b2lmobitech.fieldcloudplus.others.utils.Preference
import com.b2lmobitech.fieldcloudplus.task.service.GeofenceBroadcastReceiver
import com.b2lmobitech.fieldcloudplus.task.service.LocationBatteryService
import com.b2lmobitech.fieldcloudplus.utils.*
import com.bumptech.glide.Glide
import com.google.android.material.bottomsheet.BottomSheetDialog
import com.google.android.material.textfield.TextInputLayout

import org.json.JSONArray
import org.json.JSONException
import org.json.JSONObject
import java.util.HashMap

class DefectDetailsActivity : AppCompatActivity() {

    private var jsonObject = JSONObject()
    private var imagesArray = JSONArray()
    private var accepct:MenuItem? = null
    private var reject:MenuItem? = null
    private lateinit var dbViewModel: DBViewModel


    private var reportId = ""
//    private lateinit var binding: ResultProfileBinding
private lateinit var binding: ActivityDefectDetailsBinding
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
//        setContentView(R.layout.activity_defect_details)
        binding = ActivityDefectDetailsBinding.inflate(layoutInflater)
        val view = binding.root
        setContentView(view)
//        setContentView(binding.root)
        intent.getStringExtra("id")?.let {
            getData(it)
            reportId = it
        }
        if (intent.getBooleanExtra("accept",false)) {
            getLocation()
        }

        val notificationId = intent.getIntExtra("notification_id", 0)
        if(notificationId != 0){
            val notificationManager = NotificationManagerCompat.from(this)
            notificationManager.cancel(notificationId)
        }

        supportActionBar?.run {
            setDisplayHomeAsUpEnabled(true)
            setTitle("Defect Details")
        }

        binding.submitAccept.setOnClickListener {
            getLocation()
        }

        binding.submitWorkReport.setOnClickListener {
            val bundle = Bundle()
            bundle.putString("json",jsonObject.toString())
            val intent = Intent(this,NewDefectWorkReport::class.java)
            intent.putExtras(bundle)
            startActivity(intent)
        }
        dbViewModel = ViewModelProvider.AndroidViewModelFactory.getInstance(application).create(DBViewModel::class.java)

    }

    override fun onRestart() {
        super.onRestart()
        binding.submitWorkReport.hidden()
        getData(jsonObject.getString("report_id"))
    }


    override fun onCreateOptionsMenu(menu: Menu?): Boolean {
        menuInflater.inflate(R.menu.menu_task_new,menu)
        accepct =  menu?.findItem(R.id.accept)
        reject =  menu?.findItem(R.id.reject)
        menu?.findItem(R.id.accept)?.isVisible = false
        menu?.findItem(R.id.reject)?.isVisible = false

       /* menu?.run {
            if(jsonObject.getInt("can_edit")==1){
                findItem(R.id.accept).setVisible(false)
                findItem(R.id.reject).setVisible(false)
            }else{
                findItem(R.id.accept).setVisible(true)
                findItem(R.id.reject).setVisible(true)
            }
        }*/

        return super.onCreateOptionsMenu(menu)
    }


    override fun onOptionsItemSelected(item: MenuItem): Boolean {
        when (item.itemId) {
            android.R.id.home -> onBackPressed()
            R.id.accept -> showApproveScreen()
            R.id.reject -> showRejectScreen(jsonObject.getString("report_id"),jsonObject.getString("open_user_id"))
        }

        return super.onOptionsItemSelected(item)
    }

    private fun checkActiveStatus(){
        val requestQueue = Volley.newRequestQueue(applicationContext)
        val preference = com.b2lmobitech.fieldcloudplus.task.others.Preference.getInstance(this)
        val params: MutableMap<String, String> = java.util.HashMap()
        params["email"] = preference.emailId
        params["companyname"] = preference.companyName
        params["report_id"] = preference.companyName

        val postRequest: StringRequest = object : StringRequest(
            Method.POST, "${URL.API}/defect/get_active_defect.php",
            Response.Listener { response -> // response
                Log.d("Response", response.toString())
                try {
                    JSONObject(response).let {
                        if(it.getInt("s") == 1){

                        }
                    }
                } catch (e: Exception) {
                    e.printStackTrace()
                }
            },
            Response.ErrorListener { error -> // error
                Log.d("Error.Response", error.toString())
            }
        ) {
            override fun getParams(): Map<String, String> {
                return params
            }
        }
        requestQueue.add(postRequest)
    }

    private fun getLocation(){
        LocationUtils.getLocation(this,locationCallback={
            getBattery(it)
        }, onPermissionDenied = {
            Toast.makeText(this,"Enable Location",Toast.LENGTH_SHORT).show()
        })
    }

    private fun getBattery(location: Location) {
        val batteryStatus: Intent? = IntentFilter(Intent.ACTION_BATTERY_CHANGED).let { ifilter ->
            applicationContext.registerReceiver(null, ifilter)
        }

        val level: Int = batteryStatus?.getIntExtra(BatteryManager.EXTRA_LEVEL, -1) ?: -1
        val scale: Int = batteryStatus?.getIntExtra(BatteryManager.EXTRA_SCALE, -1) ?: -1

        val batteryPct: Float = level / scale.toFloat() * 100
        accept(lat = location.latitude.toString(),
            lon = location.longitude.toString(),
            location = "${location.latitude},${location.longitude}",
            battery = batteryPct.toString())
    }

    private fun accept(lat:String,lon:String,location:String,battery:String){
        val params: MutableMap<String, String> = HashMap()
        params["email"] = Preference.getInstance(this).emailId
        params["cname"] = Preference.getInstance(this).companyName
        params["report_id"] = reportId
        params["lat"] = lat
        params["lon"] = lon
        params["location"] = location
        params["battery"] = battery

        MyRequestQueue.getInstance(this).addToQueue(DEFECTURL.DEFECT_ACCEPT, params) { _ ->
            try {
                startGeoFence()
                getData(reportId)
            } catch (e: JSONException) {
                e.printStackTrace()
            }
        }
    }

    private fun approve(amount: String, reason: String){
        val params: MutableMap<String, String> = HashMap()
        params["email"] = Preference.getInstance(this).emailId
        params["cname"] = Preference.getInstance(this).companyName
        params["emp_id"] = jsonObject.getString("open_user_id")
        params["id"] = jsonObject.getString("report_id")
        params["amount"] = amount
        if(reason.isEmpty()){
            params["reason"] = "NA"
        }else{
            params["reason"] = reason
        }

        //jsonObject.getString("report_id")

        MyRequestQueue.getInstance(this).addToQueue(DEFECTURL.DEFECT_APPROVE, params) { _ ->
            try {
                getData(jsonObject.getString("report_id"))
            } catch (e: JSONException) {
                e.printStackTrace()
            }
        }
    }

    private fun close(){
        val params: MutableMap<String, String> = HashMap()
        params["email"] = Preference.getInstance(this).emailId
        params["cname"] = Preference.getInstance(this).companyName
        params["emp_id"] = jsonObject.getString("open_user_id")
        params["id"] = jsonObject.getString("report_id")
        //jsonObject.getString("report_id")

        MyRequestQueue.getInstance(this).addToQueue(DEFECTURL.DEFECT_CLOSE, params) { _ ->
            try {
                getData(jsonObject.getString("report_id"))
            } catch (e: JSONException) {
                e.printStackTrace()
            }
        }
    }

    private fun reject(id:String,emp:String,reason:String){
        val params: MutableMap<String, String> = HashMap()
        params["email"] = Preference.getInstance(this).emailId
        params["cname"] = Preference.getInstance(this).companyName
        params["emp_id"] = emp
        params["id"] = id
        params["reason"] = reason

        //jsonObject.getString("report_id")

        MyRequestQueue.getInstance(this).addToQueue(DEFECTURL.DEFECT_REJECT, params) { _ ->
            try {
                getData(id)
            } catch (e: JSONException) {
                e.printStackTrace()
            }
        }
    }

    private fun getData(id:String) {
        val params: MutableMap<String, String> = HashMap()
        params["email"] = Preference.getInstance(this).emailId
        params["cname"] = Preference.getInstance(this).companyName
        params["id"] = id

        MyRequestQueue.getInstance(this).addToQueue(DEFECTURL.GET_DEFECT_REPORTS, params) { response ->
            try {
                val jsonArray = JSONArray(response)
                jsonObject=jsonArray.getJSONObject(0)
                getList()
            } catch (e: JSONException) {
                e.printStackTrace()
            }
        }
    }

    private fun setData(){
        binding.timelineLayout.removeAllViews();
        binding.txtDefectNo.text = jsonObject.getString("report_id")
        binding.txtStatus.text = jsonObject.getString("status")
        binding.txtSite.text = jsonObject.getString("sitename")
        binding.txtState.text = jsonObject.getString("state")
        binding.txtCity.text = jsonObject.getString("location")
        binding.txtDefect.text = jsonObject.getString("defect")
        binding.txtDefectEquipment.text = jsonObject.getString("equipment")
        binding.txtEstimation.text = jsonObject.getString("estimated_amount")
        binding.txtKitchen.text = jsonObject.getString("kitchen_number")

        jsonObject.getString("workreport_acitivity").let {
            if(it.equals("NA")){
                binding.txtExpenditure.hidden()
                binding.layoutActivity.hidden()
            }else{
                binding.txtExpenditure.text = it
                binding.txtActivity.text = it
            }
        }



        jsonObject.getString("workreport_amount").let {
            if(it.equals("NA")){
                binding.layoutExpenditure.hidden()
            }else{
                binding.layoutExpenditure.visible()
                binding.txtExpenditure.text = it
            }
        }

        jsonObject.getString("reject_reason").let {
            if(it.equals("NA")){
                binding.layoutRejectReason.hidden()
            }else{
                binding.layoutRejectReason.visible()
                binding.txtRejectedReason.text = it
            }
        }

        jsonObject.getString("approved_reason").let {
            if(it.equals("NA")){
              binding.layoutRejectReason.hidden()
            }else{
                binding.tvReasonTitle.text = "Comments"
                binding.layoutRejectReason.visible()
                binding.txtRejectedReason.text = it
            }
        }

        jsonObject.getString("approved_amount")?.let {
            if(it.equals("0") || it.isEmpty() || it.equals("NA")){
            binding.approvedAmountLayout.hidden()
            }else{
               binding.approvedAmountLayout.visible()
               binding.txtEstimationApproved.text = it
            }
        }


        if(jsonObject.getString("can_edit").equals("1") && Preference.getInstance(this).isMEP) {
            jsonObject.getString("status").equals("open", true).let {
                accepct?.setVisible(it)
                reject?.setVisible(it)
            }
        }

        var canDeleteImages = false

        var isMep = Preference.getInstance(this).isMEP;
        var completed = jsonObject.getString("status").equals("completed",true)
        var canEdit = jsonObject.getString("can_edit").equals("1")
        var resubmit = jsonObject.getString("resubmission").equals("1") &&
                jsonObject.getString("resubmission_DT").toDate("yyyy-MM-dd HH:mm:ss").after(jsonObject.getString("completed_status_DT").toDate("yyyy-MM-dd HH:mm:ss"))
        var workreport = false
        var billApproved = jsonObject.getString("bill_approval").equals("1")

        if(completed){
            LocationBatteryService.stopLocationService(context = this)
            if(canEdit && isMep){
                if(!billApproved && !resubmit) {
                    if (jsonObject.getString("billpay_type").equals("notpayable", true)) {
                        binding.submitAccept.hidden()
                        binding.submitWorkReport.visible(true)
                        binding.submitWorkReport.setText("Close")
                        binding.submitWorkReport.setOnClickListener {
                            close()
                        }
                    }else{
                        binding.submitAccept.hidden()
                        binding.btnResubmit.visible()
                        binding.btnApprove.visible()

                        canDeleteImages = true

                        binding.btnApprove.setOnClickListener {
                            getSubTypes()
                        }
                        binding.btnResubmit.setOnClickListener {
                            reSubmit()
                        }
                    }
                }
            }else if(!billApproved && resubmit && !isMep){
              binding.submitWorkReport.setOnClickListener {
                    val intent = Intent(applicationContext,UpdateDefectImagesActivity::class.java)
                    intent.putExtra("id",reportId)
                    intent.putExtra("amount",jsonObject.getString("workreport_amount"))
                    startActivity(intent)
                }
                binding.submitWorkReport.visible(true)
             binding.btnApprove.hidden()
                binding.btnResubmit.hidden()
                binding.submitAccept.hidden()
            }else {
                binding.submitAccept.hidden()
                binding.btnApprove.hidden()
                binding.btnResubmit.hidden()
                binding.submitWorkReport.hidden()
            }
        }else if(jsonObject.getString("dr_status").equals("pending")){
            binding.submitAccept.visible(true)
            binding.submitWorkReport.hidden()
            binding.btnApprove.hidden()
            binding.btnResubmit.hidden()
        }else if(!jsonObject.getString("approved_user_id").equals("NA") && jsonObject.getString("completed_user_id").equals("NA")){
            binding.submitAccept.hidden()
            binding.submitWorkReport.visible(!Preference.getInstance(this).isMEP)
            binding.btnApprove.hidden()
            binding.btnResubmit.hidden()
        }


       /* if(Preference.getInstance(this).isMEP &&
                jsonObject.getString("status").equals("completed",true) &&
                jsonObject.getString("can_edit").equals("1")){

            if( jsonObject.getString("billpay_type").equals("notpayable",true)) {
                submit_work_report.visible(true)
                submit_work_report.setText("Close")
                submit_work_report.setOnClickListener {
                    close()
                }
            }else if(jsonObject.getString("resubmission").equals("1") &&
                    jsonObject.getString("resubmission_DT").toDate("yyyy-MM-dd HH:mm:ss").after(jsonObject.getString("completed_status_DT").toDate("yyyy-MM-dd HH:mm:ss"))){
                if(jsonObject.getString("bill_approval").equals("0")){
                    canDeleteImages = true
                }
                submit_work_report.setOnClickListener {
                    val intent = Intent(applicationContext,UpdateDefectImagesActivity::class.java)
                    intent.putExtra("id",reportId)
                    startActivity(intent)
                }
                submit_work_report.visible(!Preference.getInstance(this).isMEP)
                btn_approve.hidden()
                btn_resubmit.hidden()
            }else if(jsonObject.getString("bill_approval").equals("0")){
                btn_resubmit.visible()
                btn_approve.visible()

                canDeleteImages = true

                btn_approve.setOnClickListener {
                    getSubTypes()
                }
                btn_resubmit.setOnClickListener {
                    reSubmit()
                }

            }else{
                btn_approve.hidden()
                btn_resubmit.hidden()
                submit_work_report.hidden()
            }

        }
        else if(!jsonObject.getString("approved_user_id").equals("NA") && jsonObject.getString("completed_user_id").equals("NA")){
            submit_work_report.visible(!Preference.getInstance(this).isMEP)
            btn_approve.hidden()
            btn_resubmit.hidden()
        }else {
            btn_approve.hidden()
            btn_resubmit.hidden()
            submit_work_report.hidden()
        }*/


        if(!jsonObject.getString("open_user_id").equals("NA")){
            val filteredImages = JSONArray()
            for(i in 0 until imagesArray.length()){
                imagesArray.getJSONObject(i)?.let {
                    if(it.getString("type").equals("defect",true)){
                        filteredImages.put(it)
                    }
                }
            }
            Log.d("imagesArray","$imagesArray")
            Log.d("filteredimages","$filteredImages")

            addTimeLine("Opened",jsonObject.getString("openedBy"),jsonObject.getString("open_status_DT"),filteredImages)
        }
        if(!jsonObject.getString("approved_user_id").equals("NA")){

            addTimeLine("Approved",jsonObject.getString("approvedBy"),jsonObject.getString("approved_status_DT"))
        }

        if(!jsonObject.getString("completed_user_id").equals("NA")){

            val filteredImages = JSONArray()

            for(i in 0 until imagesArray.length()){
                imagesArray.getJSONObject(i)?.let {
                    if(it.getString("type").equals("bill",true)
                            || it.getString("type").equals("complete",true)
                            || it.getString("type").equals("sign",true)){
                        filteredImages.put(it)
                    }
                }
            }

            addTimeLine(
                    "Completed",
                    jsonObject.getString("completedBy"),
                    jsonObject.getString("completed_status_DT"),
                    filteredImages,
                    canDeleteImages = canDeleteImages
            )

        }

        if(!jsonObject.getString("rejected_user_id").equals("NA")){
            addTimeLine("Rejected",jsonObject.getString("rejectedBy"),jsonObject.getString("rejected_status_DT"))
        }

        if(!jsonObject.getString("closed_user_id").equals("NA")){
            addTimeLine("Closed",jsonObject.getString("closedBy"),jsonObject.getString("closed_status_DT"))
        }

        binding.scrollView.visible()
    }

    private fun addTimeLine(
            status:String,
            name:String,
            time:String,jsonArray: JSONArray=JSONArray(),
            canDeleteImages:Boolean = false
    ){
        val view = layoutInflater.inflate(R.layout.item_defect_timeline,null)
        var txt_status: TextView = view.findViewById(R.id.txt_status)
        var txt_time: TextView = view.findViewById(R.id.txt_time)
        var txt_by: TextView = view.findViewById(R.id.txt_by)
        var recycler_image: RecyclerView = view.findViewById(R.id.recycler_image)
        txt_status.text = status
        txt_time.text = time
        txt_by.text = "by "+name

        if(jsonArray.length()!=0){
            recycler_image.setManager(this,true)
            val listener = object :NetworkImageAdapter.ImageSelectedLsitener{
                override fun onImageSelected(position: Int) {
                    showImageSheet(position,jsonArray,canDeleteImages)
                }
            }
            val adapter = NetworkImageAdapter(jsonArray,listener)
            recycler_image.adapter = adapter
        }

        binding.timelineLayout.addView(view)
    }

    private fun getList(canSkipRequest:Boolean = false) {
        if(imagesArray.length() != 0 && canSkipRequest){
            setData()
        }
        val params: MutableMap<String, String> = HashMap()
        params["id"] = jsonObject.getString("report_id")
        params["cname"] = Preference.getInstance(this).companyName

        MyRequestQueue.getInstance(this).addToQueue(DEFECTURL.GET_DEFECT_IMAGES, params) { response ->
            try {
                imagesArray = JSONArray(response)
                setData()
            } catch (e: JSONException) {
                e.printStackTrace()
            }
        }
    }

    private fun getSubTypes() {
        val params: MutableMap<String, String> = HashMap()
        params["cname"] = Preference.getInstance(this).companyName

        MyRequestQueue.getInstance(this).addToQueue(DEFECTURL.GET_DEFECT_SUB_TYPES, params) { response ->
            try {
                showBillAprove(JSONArray(response))
            } catch (e: JSONException) {
                e.printStackTrace()
            }
        }
    }

    private fun deleteImage(jsonObject: JSONObject) {

        val params: MutableMap<String, String> = HashMap()
        params["user_id"] = Preference.getInstance(this).emailId
        params["id"] = jsonObject.getString("id")

        MyRequestQueue.getInstance(this).addToQueue(DEFECTURL.DEFECT_IMAGE_DELETE, params)
        {
            response ->
            try {
                getList()
            } catch (e: JSONException) {
                e.printStackTrace()
            }
        }
    }

    private fun showBillAprove(jsonArray: JSONArray){
        val bottomSheetDialog = BottomSheetDialog(this)
        bottomSheetDialog.setContentView(R.layout.sheet_complete_defect)
        val list = ArrayList<String>()
        for(i in 0 until jsonArray.length()){
            list.add(jsonArray.getJSONObject(i).getString("name"))
        }
        val adapter = ArrayAdapter<String>(this, R.layout.simple_spinner_item,list)
        adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item)
        val spinner = bottomSheetDialog.findViewById<Spinner>(R.id.spinner_bearer).apply {
            this?.adapter = adapter
        }

        bottomSheetDialog.findViewById<View>(R.id.btn_submit)?.setOnClickListener {
            jsonArray.getJSONObject(spinner?.selectedItemPosition ?: 0).let {
                preClose(it.getString("substatus_id"))
            }
            bottomSheetDialog.dismiss()
        }

        bottomSheetDialog.show()

    }

    private fun preClose(bearer:String) {
        val params: MutableMap<String, String> = HashMap()
        params["user_id"] = Preference.getInstance(this).emailId
        params["report_id"] = reportId
        params["cname"] = Preference.getInstance(this).companyName
        params["bearer"] = bearer

        MyRequestQueue.getInstance(this).addToQueue(DEFECTURL.DEFECT_PRE_CLOSE, params)
        {
            response ->
            try {
                "Updated Successfully".toast(this)
                finish()
            } catch (e: JSONException) {
                e.printStackTrace()
            }
        }
    }

    private fun reSubmit() {
        val params: MutableMap<String, String> = HashMap()
        params["user_id"] = Preference.getInstance(this).emailId
        params["report_id"] = reportId
        params["cname"] = Preference.getInstance(this).companyName
        params["emp_id"] = jsonObject.getString("open_user_id")

        MyRequestQueue.getInstance(this).addToQueue(DEFECTURL.DEFECT_RE_SUBMIT, params)
        {
            response ->
            try {
                getData(reportId)
            } catch (e: JSONException) {
                e.printStackTrace()
            }
        }
    }

    private fun showImageSheet(position:Int,jsonArray: JSONArray,showDelete:Boolean = true){
        val bottomSheetDialog = BottomSheetDialog(this)
        bottomSheetDialog.setContentView(R.layout.sheet_defect_image)
        var imageView: ImageView? = bottomSheetDialog.findViewById(R.id.imageView)
        var inchargeLayout: LinearLayout? = bottomSheetDialog.findViewById(R.id.inchargeLayout)
        var txt_incharge_name: TextView? = bottomSheetDialog.findViewById(R.id.txt_incharge_name)
        var txt_incharge_number: TextView? = bottomSheetDialog.findViewById(R.id.txt_incharge_number)
        Glide.with(this)
                .load(DEFECTURL.IMAGE+jsonArray.getJSONObject(position).getString("image_path"))
                .into(imageView!!)
        val json = jsonArray.getJSONObject(position)
        if(showDelete){
            bottomSheetDialog.findViewById<View>(R.id.img_delete)?.let {
                it.visible(true)
                it.setOnClickListener {
                    deleteImage(json)
                    bottomSheetDialog.dismiss()
                }
            }
        }
        json.getString("incharge_name").let {
           if(it.isNotEmpty() && it.isNotBlank() && !it.equals("NA",true)){
               inchargeLayout!!.visible()
               txt_incharge_name!!.text = it
               txt_incharge_number!!.text =  json.getString("incharge_number")
           }else{
               inchargeLayout!!.hidden()
           }
       }

        bottomSheetDialog.show()
    }

    private fun showApproveScreen(){
        val bottomSheetDialog = BottomSheetDialog(this,R.style.DialogStyle)
        bottomSheetDialog.setContentView(R.layout.sheet_approve_defect)

        val ga = bottomSheetDialog.findViewById<TextInputLayout>(R.id.given_amount)
        val aa =  bottomSheetDialog.findViewById<TextInputLayout>(R.id.approved_amount)
        val comments =  bottomSheetDialog.findViewById<TextInputLayout>(R.id.comments)

        ga?.editText?.setText(jsonObject.getString("estimated_amount"))

        bottomSheetDialog.findViewById<View>(R.id.approve_button)?.setOnClickListener {
            aa?.let {
                if(it.editText!!.text.toString().isEmpty()){
                    it.error = "Enter Vaild Amount"
                }else {
                    approve(it.editText!!.text.toString(),comments?.editText?.text.toString())
                    bottomSheetDialog.dismiss()
                }
            }
        }
        bottomSheetDialog.show()
    }

    private fun showRejectScreen(id:String,emp:String){
        val bottomSheetDialog = BottomSheetDialog(this,R.style.DialogStyle)
        bottomSheetDialog.setContentView(R.layout.sheet_approve_defect)

        val ga = bottomSheetDialog.findViewById<TextInputLayout>(R.id.given_amount)
        val aa =  bottomSheetDialog.findViewById<TextInputLayout>(R.id.approved_amount)

        val comments =  bottomSheetDialog.findViewById<TextInputLayout>(R.id.comments)

        bottomSheetDialog.findViewById<Button>(R.id.approve_button)?.text = "Reject"
        ga?.hidden()
        aa?.hidden()

        bottomSheetDialog.findViewById<View>(R.id.approve_button)?.setOnClickListener {
            comments?.let {
                if(it.editText!!.text.toString().isEmpty()){
                    it.error = "Enter Vaild Comments"
                }else {
                    reject(id,emp,it.editText!!.text.toString())
                    bottomSheetDialog.dismiss()
                }
            }
        }
        bottomSheetDialog.show()
    }

    private fun startGeoFence() {
        dbViewModel.getAllFacilities().observe(this){ facilityEntities->
            try {
                facilityEntities.forEach { facilityEntity ->
                    if (facilityEntity.atmid.equals(jsonObject.getString("facility_id"))) {
                        if (facilityEntity.geofencing.equals("enable", true)) {
                            val geoLat = facilityEntity.latitude.toDouble()
                            val geoLon = facilityEntity.longitude.toDouble()
                            val geoDistance = facilityEntity.geo_distance.toFloatOrNull()?:0f
                            GeofenceBroadcastReceiver.registerGeoFence(this,geoLat,geoLon,geoDistance,facilityEntity.atmid,reportId)
                            LocationBatteryService.startLocationService(this,reportId,geoLat,geoLon,geoDistance,facilityEntity.atmid)
                        }
                    }
                }
            } catch (e: Exception) {
                e.printStackTrace()
            }
        }
    }
}
