package com.b2lmobitech.fieldcloudplus.defect

//import kotlinx.android.synthetic.main.activity_defect_list.*
//import kotlinx.android.synthetic.main.activity_new_defect_report.*
//import kotlinx.android.synthetic.main.activity_new_defect_report.recyclerView
//import kotlinx.android.synthetic.main.layout_defect_list.*
import android.app.DatePickerDialog
import android.content.Intent
import android.os.Bundle
import android.view.MenuItem
import androidx.appcompat.app.AppCompatActivity
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.b2lmobitech.fieldcloudplus.databinding.ActivityDefectListBinding
import com.b2lmobitech.fieldcloudplus.defect.adapter.DefectListAdapter
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue
import com.b2lmobitech.fieldcloudplus.others.utils.Preference
import com.b2lmobitech.fieldcloudplus.utils.EndlessRecyclerViewScrollListener
import com.b2lmobitech.fieldcloudplus.utils.addDivider
import com.b2lmobitech.fieldcloudplus.utils.hidden
import com.b2lmobitech.fieldcloudplus.utils.setManager
import com.b2lmobitech.fieldcloudplus.utils.toDate
import com.b2lmobitech.fieldcloudplus.utils.visible
import com.google.android.material.tabs.TabLayout
import org.json.JSONArray
import org.json.JSONException
import java.text.SimpleDateFormat
import java.util.Calendar
import java.util.Date

class DefectListActivity : AppCompatActivity(), DefectListAdapter.DefectSelectedListener {
    private lateinit var binding: ActivityDefectListBinding
    var status = DefectStatus.OPEN
    private lateinit var defectListAdapter: DefectListAdapter
    private var jsonArray = JSONArray()
    private var currentPage = 0
    private var isRequestInProgress = false
    private var isFullPageLoaded = false
    private var startDate = Calendar.getInstance()
    private var endDate = Calendar.getInstance()
    private var filterDates = false

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
//        setContentView(R.layout.activity_defect_list)
        binding = ActivityDefectListBinding.inflate(layoutInflater)
        val view = binding.root
        setContentView(view)
        status = intent?.getStringExtra("status") ?: ""

        supportActionBar?.run {
            setDisplayHomeAsUpEnabled(true)
            setTitle("Defect List")
            setSubtitle(status.capitalize())
        }

        if (status.equals(DefectStatus.COMPLETED)) {
            binding.l1.tabLayout.visible()
            binding.l1.tabLayout.addOnTabSelectedListener(object : TabLayout.OnTabSelectedListener {
                override fun onTabReselected(p0: TabLayout.Tab?) {

                }

                override fun onTabUnselected(p0: TabLayout.Tab?) {

                }

                override fun onTabSelected(p0: TabLayout.Tab?) {
                    setCompletedAdapter()
                }

            })
        } else {
            binding.l1.tabLayout.hidden()
        }

        binding.l1.recyclerView.setManager(this)
        binding.l1.recyclerView.addDivider(this)
        defectListAdapter = DefectListAdapter(listener = this)
        binding.l1.recyclerView.adapter = defectListAdapter
        if (status == DefectStatus.CLOSED) {

            binding.l1.recyclerView.addOnScrollListener(object :
                EndlessRecyclerViewScrollListener(binding.l1.recyclerView.layoutManager as LinearLayoutManager) {
                override fun onLoadMore(page: Int, totalItemsCount: Int, view: RecyclerView?) {
                    if (!isRequestInProgress && !isFullPageLoaded) {
                        binding.l1.paginationProgress.visible(true)
                        currentPage += 1
                        getList()
                    }
                }
            })
            binding.l1.imgClearDate.setOnClickListener {
                clearDates()
            }
            binding.dateFab.visible()
            binding.dateFab.setOnClickListener {
                openStartDatePicker()
            }
        }
        getList()
    }

    override fun onRestart() {
        super.onRestart()
        if (status != DefectStatus.CLOSED) {
            getList()
        }
    }

    override fun onOptionsItemSelected(item: MenuItem): Boolean {
        if (item?.itemId == android.R.id.home) {
            onBackPressed()
        }
        return super.onOptionsItemSelected(item)
    }

    private fun getList() {
        if (currentPage == 0) {
            binding.mainProgressBar.visible(true)
        } else {
            binding.l1.paginationProgress.visible(true)
        }
        isRequestInProgress = true
        val params: MutableMap<String, String> = HashMap()
        params["email"] = Preference.getInstance(this).emailId
        params["cname"] = Preference.getInstance(this).companyName
        params["status"] = status
        params["page"] = currentPage.toString()
        if (filterDates) {
            SimpleDateFormat("YYYY-MM-dd").let {
                params["start"] = it.format(Date(startDate.timeInMillis))
                params["end"] = it.format(Date(endDate.timeInMillis))
            }
        }

        val url = if (status.equals(DefectStatus.CLOSED, true)) {
            DEFECTURL.GET_DEFECT_REPORTS_PAGED
        } else {
            DEFECTURL.GET_DEFECT_REPORTS
        }





        MyRequestQueue.getInstance(this).addToQueue(url, params) { response ->
            try {
                val jsonArray = JSONArray(response)
                if (jsonArray.length() == 0) isFullPageLoaded = true
                setAdapter(jsonArray)
                isRequestInProgress = false
            } catch (e: JSONException) {
                e.printStackTrace()
            }
        }
    }

    private fun setAdapter(jsonArray: JSONArray) {
        this.jsonArray = jsonArray
        if (status.equals(DefectStatus.COMPLETED, true)) {
            setCompletedAdapter()
        } else {
            defectListAdapter.list = jsonArray
            defectListAdapter.notifyDataSetChanged()
            binding.txtListEmpty.visible(defectListAdapter.list.length() == 0)
        }
        binding.mainProgressBar.visible(false)
        binding.l1.paginationProgress.visible(false)
    }

    private fun setCompletedAdapter() {
        val filteredArray = JSONArray()
        val selectedTab = binding.l1.tabLayout.selectedTabPosition
        for (i in 0 until jsonArray.length()) {

            jsonArray.getJSONObject(i).let {
                if (it.getString("resubmission").equals("1") && it.getString("resubmission_DT")
                        .toDate("yyyy-MM-dd HH:mm:ss")
                        .after(it.getString("completed_status_DT").toDate("yyyy-MM-dd HH:mm:ss"))
                ) {
                    if (selectedTab == 2) {
                        filteredArray.put(it)
                    }
                } else if (it.getString("bill_approval").equals("0")) {
                    if (selectedTab == 0) {
                        filteredArray.put(it)
                    }
                } else {
                    if (selectedTab == 1) {
                        filteredArray.put(it)
                    }
                }
            }
        }
        binding.txtListEmpty.visible(filteredArray.length() == 0)
        defectListAdapter.list = filteredArray
        defectListAdapter.notifyDataSetChanged()
    }

    override fun onDefectSelected(position: Int) {
        val bundle = Bundle()
        bundle.putString(
            "id",
            defectListAdapter.list.getJSONObject(position).getString("report_id")
        )
        val intent = Intent(this, DefectDetailsActivity::class.java)
        intent.putExtras(bundle)
        startActivity(intent)
    }

    private fun openStartDatePicker() {
        val y = startDate.get(Calendar.YEAR)
        val m = startDate.get(Calendar.MONTH)
        val d = startDate.get(Calendar.DAY_OF_MONTH)
        val datepickerdialog = DatePickerDialog(
            this,
            DatePickerDialog.OnDateSetListener { _, year, monthOfYear, dayOfMonth ->
                startDate.set(Calendar.YEAR, year)
                startDate.set(Calendar.MONTH, monthOfYear)
                startDate.set(Calendar.DAY_OF_MONTH, dayOfMonth)
                openEndDatePicker()
            },
            y,
            m,
            d
        )
        datepickerdialog.datePicker.maxDate = Calendar.getInstance().timeInMillis
        datepickerdialog.setTitle("From Date")
        datepickerdialog.show()
    }

    private fun openEndDatePicker() {
        val y = endDate.get(Calendar.YEAR)
        val m = endDate.get(Calendar.MONTH)
        val d = endDate.get(Calendar.DAY_OF_MONTH)
        val datepickerdialog = DatePickerDialog(
            this,
            DatePickerDialog.OnDateSetListener { _, year, monthOfYear, dayOfMonth ->
                endDate.set(Calendar.YEAR, year)
                endDate.set(Calendar.MONTH, monthOfYear)
                endDate.set(Calendar.DAY_OF_MONTH, dayOfMonth)
                getFilteredList()
            },
            y,
            m,
            d
        )
        datepickerdialog.datePicker.maxDate = Calendar.getInstance().timeInMillis
        datepickerdialog.datePicker.minDate = startDate.timeInMillis
        datepickerdialog.setTitle("To Date")
        datepickerdialog.show()
    }

    private fun getFilteredList() {
        val sdf = SimpleDateFormat("dd/MM/YYYY")
        binding.l1.txtSlectedDate.text =
            sdf.format(Date(startDate.timeInMillis)) + " to " + sdf.format(Date(endDate.timeInMillis))
        binding.l1.txtSlectedDate.visible()
        binding.l1.imgClearDate.visible()
        filterDates = true
        defectListAdapter.list = JSONArray()
        defectListAdapter.notifyDataSetChanged()
        currentPage = 0
        getList()
    }

    private fun clearDates() {
        binding.l1.txtSlectedDate.visible(false)
        binding.l1.imgClearDate.visible(false)
        filterDates = false
        defectListAdapter.list = JSONArray()
        defectListAdapter.notifyDataSetChanged()
        currentPage = 0
        isFullPageLoaded = false
        getList()
    }

}
