package com.b2lmobitech.fieldcloudplus.defect

import android.content.Intent
import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import androidx.recyclerview.widget.GridLayoutManager
import android.view.MenuItem
import com.b2lmobitech.fieldcloudplus.R
import com.b2lmobitech.fieldcloudplus.databinding.ActivityDefectListBinding
import com.b2lmobitech.fieldcloudplus.databinding.ActivityDefectReportsBinding
import com.b2lmobitech.fieldcloudplus.others.utils.Preference
import com.b2lmobitech.fieldcloudplus.utils.hidden
import com.b2lmobitech.fieldcloudplus.utils.setManager
//import kotlinx.android.synthetic.main.activity_defect_reports.*

class DefectReportsActivity : AppCompatActivity() {
    private lateinit var binding: ActivityDefectReportsBinding
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
//        setContentView(R.layout.activity_defect_reports)
        binding = ActivityDefectReportsBinding.inflate(layoutInflater)
        val view = binding.root
        setContentView(view)
        supportActionBar?.run {
            setTitle("Defects")
            setDisplayHomeAsUpEnabled(true)
        }

        if(Preference.getInstance(this).isMEP){
            binding.newDefect.hidden()
        }else {
            binding.newDefect.setOnClickListener {
                startActivity(Intent(this, NewDefectReportActivity::class.java))
            }
        }

        fun startActivity(string: String){
            val bundle = Bundle()
            bundle.putString("status",string)
            val intent = Intent(this,DefectListActivity::class.java)
            intent.putExtras(bundle)
            startActivity(intent)
        }

        binding.cardApproved.setOnClickListener { startActivity(DefectStatus.APPROVED) }
        binding.cardClosed.setOnClickListener { startActivity(DefectStatus.CLOSED) }
        binding.cardCompleted.setOnClickListener { startActivity(DefectStatus.COMPLETED) }
        binding.cardOpen.setOnClickListener { startActivity(DefectStatus.OPEN) }
        binding.cardRejected.setOnClickListener { startActivity(DefectStatus.REJECTED) }

    }


    override fun onOptionsItemSelected(item: MenuItem): Boolean {
        if(item?.itemId == android.R.id.home){
            onBackPressed()
        }
        return super.onOptionsItemSelected(item)
    }



}
