package com.b2lmobitech.fieldcloudplus.defect

import android.Manifest
import android.app.Activity
import android.app.AlertDialog
import androidx.lifecycle.Observer
import androidx.lifecycle.ViewModelProvider
import android.content.Context
import android.content.Intent
import android.content.IntentSender
import android.content.pm.PackageManager
import android.graphics.Bitmap
import android.graphics.BitmapFactory
import android.graphics.Canvas
import android.location.Geocoder
import android.location.LocationManager
import android.net.Uri
import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.os.Environment
import android.os.Looper
import android.provider.MediaStore
import com.google.android.material.bottomsheet.BottomSheetDialog
import com.google.android.material.snackbar.Snackbar
import androidx.core.app.ActivityCompat
import androidx.core.content.FileProvider
import android.util.Log
import android.view.Menu
import android.view.MenuItem
import android.view.View
import android.widget.AdapterView
import android.widget.ArrayAdapter
import android.widget.ImageView
import android.widget.TextView
import com.b2lmobitech.fieldcloudplus.BuildConfig
import com.b2lmobitech.fieldcloudplus.R
import com.b2lmobitech.fieldcloudplus.databinding.ActivityDefectReportsBinding
import com.b2lmobitech.fieldcloudplus.databinding.ActivityNewDefectReportBinding
import com.b2lmobitech.fieldcloudplus.defect.adapter.ImagesAdapter
import com.b2lmobitech.fieldcloudplus.hcm.HCMURL
import com.b2lmobitech.fieldcloudplus.hcm.attendanceimage
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.entities.FacilityEntity
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.viewModel.DBViewModel
import com.b2lmobitech.fieldcloudplus.others.MaterialSpinner
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue
import com.b2lmobitech.fieldcloudplus.others.utils.Preference
import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables
import com.b2lmobitech.fieldcloudplus.task.others.RequestProgress
import com.b2lmobitech.fieldcloudplus.task.others.Utility
import com.b2lmobitech.fieldcloudplus.utils.*
import com.bumptech.glide.Glide
import com.google.android.gms.common.api.ApiException
import com.google.android.gms.common.api.ResolvableApiException
import com.google.android.gms.location.*
//import kotlinx.android.synthetic.main.activity_new_defect_report.*
//import kotlinx.android.synthetic.main.activity_new_defect_report.recyclerView
//import kotlinx.android.synthetic.main.activity_new_defect_report.textInputLayout
//import kotlinx.android.synthetic.main.activity_new_defect_report.textInputLayout2
//import kotlinx.android.synthetic.main.custom_timesheet.*
//import kotlinx.android.synthetic.main.fragment_choose_facility.*
//import kotlinx.android.synthetic.main.sheet_defect_image.*
import org.json.JSONArray
import org.json.JSONException
import org.json.JSONObject
import java.io.*
import java.text.SimpleDateFormat
import java.util.*
import kotlin.collections.HashSet
import kotlin.collections.LinkedHashMap

class NewDefectReportActivity : AppCompatActivity() {
    private lateinit var binding: ActivityNewDefectReportBinding
    private var facilityEntities: List<FacilityEntity> = ArrayList<FacilityEntity>()
    private lateinit var dbViewModel: DBViewModel
    private val stateList = HashSet<String>()
    private var cityList = LinkedHashMap<String, HashSet<String>>()
    private var facilityList = LinkedHashMap<String, List<FacilityEntity>>()
    private var equipmentsList = JSONArray()
    private var kitchensList = JSONArray()

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
//        setContentView(R.layout.activity_new_defect_report)
        binding = ActivityNewDefectReportBinding.inflate(layoutInflater)
        val view = binding.root
        setContentView(view)
        dbViewModel = ViewModelProvider.AndroidViewModelFactory.getInstance(application).create(DBViewModel::class.java)
        getEquipments()
        setAapter()
        supportActionBar?.run {
            setTitle("New Defect")
            setDisplayHomeAsUpEnabled(true)
        }


    }

    override fun onCreateOptionsMenu(menu: Menu?): Boolean {
        menuInflater.inflate(R.menu.menu_form, menu)
        return super.onCreateOptionsMenu(menu)
    }

    private fun getEquipments() {
        val params: MutableMap<String, String> = HashMap()
        params["cname"] = Preference.getInstance(this).companyName

        MyRequestQueue.getInstance(this).addToQueue(DEFECTURL.GET_EQUIPMENTS, params) { response ->
            try {
                equipmentsList = JSONArray(response)
                setEquipmentsSpinner()
                getKitchens()
            } catch (e: JSONException) {
                e.printStackTrace()
            }
        }
    }

    private fun getKitchens() {
        val params: MutableMap<String, String> = HashMap()
        params["cname"] = Preference.getInstance(this).companyName

        MyRequestQueue.getInstance(this).addToQueue(DEFECTURL.GET_KITCHENS, params) { response ->
            try {
                kitchensList = JSONArray(response)
                getFacilities()
            } catch (e: JSONException) {
                e.printStackTrace()
            }
        }
    }

    private fun getFacilities() {
        val params: MutableMap<String, String> = HashMap()
        params["email"] = Preference.getInstance(this).emailId

        MyRequestQueue.getInstance(this).addToQueue(HCMURL.GET_FACILITIES, params) { response ->
            try {
                val jsonArray = JSONArray(response)
                val listener = object : DBViewModel.CompletedCallBack {
                    override fun onTaskCompleted() {
                        runOnUiThread {
                            getFacilitiesOffline()
                        }
                    }
                }


                dbViewModel.addAllFacilities(jsonArray, listener)
            } catch (e: JSONException) {
                e.printStackTrace()
            }
        }
    }

    private fun getFacilitiesOffline() {
        dbViewModel.getAllFacilities().removeObservers(this)

        dbViewModel.getAllFacilities()?.observe(this, Observer { result ->
            dbViewModel.getAllFacilities().removeObservers(this)
            setfacilityEntities(result!!)
        })
    }

    fun setfacilityEntities(list: List<FacilityEntity>) {

        facilityEntities = list
        facilityEntities.forEach {
            stateList.add(it.state)
        }

        stateList.forEach { state ->
            val city = HashSet<String>()
            facilityEntities.forEach {
                if (it.state.equals(state, ignoreCase = true)) {
                    city.add(it.location)
                }
            }
            cityList.put(state, city)
        }

        cityList.forEach { states ->
            states.value.forEach { city ->
                val facilities = ArrayList<FacilityEntity>()
                list.forEach { facility ->
                    if (facility.location.equals(city, true)) {
                        facilities.add(facility)
                    }
                }
                facilityList.put(city, facilities)
            }
        }

        setSpinners()
        binding.scrollView.visible()
    }

    private var selectedFacilitiesList = ArrayList<FacilityEntity>()
    private var selectedKitchensList = JSONArray()

    private fun setEquipmentsSpinner() {
        val arrayList = ArrayList<String>()

        for (i in 0 until equipmentsList.length()) {
            arrayList.add(equipmentsList.getJSONObject(i).getString("equipment"))
        }
        val cityAdapter = ArrayAdapter<String>(this, R.layout.simple_spinner_item, arrayList)
        cityAdapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item)
        binding.spinnerMaterial.adapter = cityAdapter
        binding.spinnerMaterial.setSelection(0)
    }


    private fun setSpinners() {

        fun setFacilitiesSpinner(selectedCity: String) {
            selectedFacilitiesList.clear()
            selectedFacilitiesList.addAll(facilityList.get(selectedCity)!!)
            val arrayList = ArrayList<String>()
            selectedFacilitiesList.forEach {
                arrayList.add(it.sitename)
            }
            val cityAdapter = ArrayAdapter<String>(this, R.layout.simple_spinner_item, arrayList)
            cityAdapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item)
            binding.spinnerSite.adapter = cityAdapter
            binding.spinnerSite.setSelection(0)
        }

        fun setCitySpinner(selectedState: String) {
            val cityAdapter = ArrayAdapter<String>(this, R.layout.simple_spinner_item, cityList.get(selectedState)!!.toList())
            cityAdapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item)
            binding.spinnerCity.adapter = cityAdapter
            binding.spinnerCity.setSelection(0)
        }

        fun filterFacilities(selectedCity: String) {
            val filteredList = ArrayList<FacilityEntity>()
            facilityEntities.forEach {
                if (it.location.equals(selectedCity, true)) {
                    filteredList.add(it)
                }

            }
            setFacilitiesSpinner(selectedCity)
        }


        val stateAdapter = ArrayAdapter<String>(this, R.layout.simple_spinner_item, ArrayList(stateList))
        stateAdapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item)
        binding.spinnerState.adapter = stateAdapter
        binding.spinnerState.setSelection(0)

        binding.spinnerCity.onItemSelectedListener = object : AdapterView.OnItemSelectedListener {
            override fun onNothingSelected(parent: AdapterView<*>?) {
            }

            override fun onItemSelected(parent: AdapterView<*>?, view: View?, position: Int, id: Long) {
                binding.spinnerCity.selectedItem?.let { setFacilitiesSpinner(it.toString()) }
            }
        }

        binding.spinnerState.onItemSelectedListener = object : AdapterView.OnItemSelectedListener {
            override fun onNothingSelected(parent: AdapterView<*>?) {
            }

            override fun onItemSelected(parent: AdapterView<*>?, view: View?, position: Int, id: Long) {
                binding.spinnerState.selectedItem?.let { setCitySpinner(it.toString()) }
            }

        }

        setKitchensSpinner()
    }

    fun setKitchensSpinner() {
        val arrayList = ArrayList<String>()

        for (i in 0 until kitchensList.length()) {
            arrayList.add(kitchensList.getJSONObject(i).getString("subfacility_name"))
        }
        val cityAdapter = ArrayAdapter<String>(this, R.layout.simple_spinner_item, arrayList)
        cityAdapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item)
        binding.materialSpinner5.adapter = cityAdapter
        binding.materialSpinner5.setSelection(0)
    }

    override fun onOptionsItemSelected(item: MenuItem): Boolean {
        if (item?.itemId == R.id.done) {
            checkGeoFence()
        } else if (item?.itemId == android.R.id.home) {
            onBackPressed()
        }
        return super.onOptionsItemSelected(item)

    }

    private var geoFenceEnabled = false
    private var geoLat = 0.0
    private var geoLon = 0.0
    private var geoDistance = 0
    private var geoFacility = "NA"
    private fun checkGeoFence() {
        selectedFacilitiesList.get(binding.spinnerSite.selectedItemPosition).let { facilityEntity ->

            if (facilityEntity.geofencing.equals("enable", true) && !BuildConfig.DEBUG) {
                geoFenceEnabled = true
                geoLat = facilityEntity.latitude.toDouble()
                geoLon = facilityEntity.longitude.toDouble()
                geoDistance = facilityEntity.geo_distance.toInt()
                geoFacility = facilityEntity.atmid
                connectLocation()
            } else {
                addDefect()
            }

        }
    }

    var locationManager: LocationManager? = null

    fun connectLocation() {
        RequestProgress.getInstance(this).showProgressBar()
        val locationRequest = LocationRequest.create()
        locationRequest.priority = LocationRequest.PRIORITY_HIGH_ACCURACY
        locationRequest.interval = 10000
        locationRequest.fastestInterval = 10000 / 2.toLong()
        locationRequest.numUpdates = 1
        val builder = LocationSettingsRequest.Builder().addLocationRequest(locationRequest)
        builder.setAlwaysShow(true)
        val task = LocationServices.getSettingsClient(this).checkLocationSettings(builder.build())

        task.addOnCompleteListener { task ->
            try {
                task.getResult(ApiException::class.java)
                findlocation()
            } catch (exception: ApiException) {
                when (exception.statusCode) {
                    LocationSettingsStatusCodes.RESOLUTION_REQUIRED -> try {
                        val resolvable = exception as ResolvableApiException
                        resolvable.startResolutionForResult(this, 4)
                    } catch (e: IntentSender.SendIntentException) { // Ignore the error.
                    } catch (e: ClassCastException) { // Ignore, should be an impossible error.
                    }
                }
            }
        }
    }

    private lateinit var mFusedLocationClient: FusedLocationProviderClient
    private lateinit var mLocationRequest: LocationRequest
    private var currentlocationlaltitue = 0.0
    private var currentlocationlongitude = 0.0

    fun findlocation() {

        mFusedLocationClient = LocationServices.getFusedLocationProviderClient(this)
        if (ActivityCompat.checkSelfPermission(this, Manifest.permission.ACCESS_FINE_LOCATION) != PackageManager.PERMISSION_GRANTED
                && ActivityCompat.checkSelfPermission(this, Manifest.permission.ACCESS_COARSE_LOCATION) != PackageManager.PERMISSION_GRANTED) {
            return
        }


        mFusedLocationClient.getCurrentLocation(LocationRequest.PRIORITY_HIGH_ACCURACY, null).addOnCompleteListener {
            it.result?.let { location ->
                //Place current location marker
                Log.e("Location", location.latitude.toString() + "" + location.longitude)
                currentlocationlaltitue = location.latitude
                currentlocationlongitude = location.longitude
                calculateDistance(currentlocationlaltitue, currentlocationlongitude)
            }
        }.addOnCanceledListener {
            "Try Again".toast(this)
        }

        //				 Log.d("currentlocationlaltitue",""+currentlocationlaltitue);
//				 Log.d("currentlocationlongitude",""+currentlocationlongitude);
    }

    private fun calculateDistance(lat: Double, lon: Double) {
        fun alertNotInFacility() {
            val alertdialog = AlertDialog.Builder(this)
            alertdialog.setMessage("It seems you are out of the geofence")
            alertdialog.setPositiveButton("Close"
            ) { dialog, whichButton ->
            }.create()
            alertdialog.setCancelable(false)
            alertdialog.show()
        }

        val distance = DistanceCalculator.distance(lat, lon, geoLat, geoLon)
        if (!geoFenceEnabled || distance <= geoDistance) {
            MyRequestQueue.getInstance(this).hideProgressBar()
            addDefect()
        } else {
            alertNotInFacility()
        }
    }


    private fun addDefect() {

        if (imagesList.isEmpty()) {
            "Please Capture Some Images".toast(this)
            return
        }


        val params: MutableMap<String, String> = HashMap()
        if (selectedFacilitiesList.isEmpty()) {
            "Select Valid Facility".toast(this)
            return
        }
        selectedFacilitiesList.get(binding.spinnerSite.selectedItemPosition).let {
            if (it == null) {
                "Select Valid Facility".toast(this)
                return
            } else {
                params["facility_id"] = it.atmid
            }
        }
        params["de"] = equipmentsList.getJSONObject(binding.spinnerMaterial.selectedItemPosition).getString("equipment_id")

        params["kitchen"] = kitchensList.getJSONObject(binding.materialSpinner5.selectedItemPosition).getString("subfacility_id")
        binding.textInputLayout2.editText?.text.toString().let {
            if (it.isEmpty()) {
                "Enter Valid Amount".toast(this)
                return
            } else {
                params["eamount"] = it
            }
        }

        binding.textInputLayout.editText?.text.toString().let {
            if (it.isEmpty()) {
                "Defect Can't be empty".toast(this)
                return
            } else {
                params["defect"] = it
            }
        }

        params["empemail"] = Preference.getInstance(this).emailId
        params["cname"] = Preference.getInstance(this).companyName


        MyRequestQueue.getInstance(this).addToQueue(DEFECTURL.ADD_DEFECT, params) { response ->
            try {
                val json = JSONObject(response)
                if (json.getInt("s") == 1) {
                    if (imagesList.isEmpty()) {
                        "Add Scussesfully".toast(this)
                        finish()
                    } else {
                        addDefectImages(json.getString("id"))
                    }

                }
            } catch (e: JSONException) {
                e.printStackTrace()
            }
        }
    }

    private fun addDefectImages(reportId: String) {
        var currentImage = 0

        fun addImage(file: File) {
            val params: MutableMap<String, String> = HashMap()
            params["facility_id"] = selectedFacilitiesList.get(binding.spinnerSite.selectedItemPosition).atmid
            params["id"] = reportId
            params["type"] = "defect"
            params["cname"] = Preference.getInstance(this).companyName
            file.toBase64String().let {
                if (it == null) "Unable To Upload Images".toast(this)
                else params["data"] = it
            }



            MyRequestQueue.getInstance(this).addToQueue(DEFECTURL.ADD_DEFECT_IMAGE, params) { response ->
                runOnUiThread {
                    try {
                        val json = JSONObject(response)
                        if (json.getInt("s") == 1) {
                            currentImage++
                            if (imagesList.size > currentImage) {
                                addImage(imagesList.get(currentImage))
                            } else {
                                "Defect Added Successfully".toast(this)
                                finish()
                            }
                        } else {
                            "Unable To Upload Images".toast(this)
                            finish()
                        }
                    } catch (e: JSONException) {
                        e.printStackTrace()
                    }
                }
            }
        }

        addImage(imagesList.first())
    }

    private fun captureImage() {
        fun getoutputMediaFileUri(): File {

            val mediaFile: File = Utility.getSignFile(this)

            /* val mediaStorageDir = Environment.getDataDirectory()
     //        val mediaStorageDir = File("/sdcard/Android/data/com.B2lmobitech.FieldCloudDesk/" + "AttendanceImages")
             if (!mediaStorageDir.exists()) {
                 mediaStorageDir.mkdirs()
             }
             val dateFormatter2 = SimpleDateFormat("yyyyMMdd_HHmmss")
             mediaFile = File(mediaStorageDir.path + File.separator
                     + "IMG_" + dateFormatter2.format(Date()) + ".jpg")*/
            picturefilename = mediaFile.name
            try {
                mediaFile.createNewFile()
            } catch (e: IOException) { // TODO Auto-generated catch block
                e.printStackTrace()
            }
            imagefilepath = mediaFile
            return mediaFile
        }

        fun getoutputMediaFileUriException(): Uri? {
            val mediaFile: File = Utility.getSignFile(this)

            /* var mediaFile: File? = null
             val mediaStorageDir = Environment.getDataDirectory()
             if (!mediaStorageDir.exists()) {
                 if (!mediaStorageDir.mkdirs()) {
                     return null
                 }
             }
             val dateFormatter2 = SimpleDateFormat("yyyyMMdd_HHmmss")
             mediaFile = File(mediaStorageDir.path + File.separator
                     + "IMG_" + dateFormatter2.format(Date()) + ".jpg")*/
            picturefilename = mediaFile.name
            try {
                mediaFile.createNewFile()
            } catch (e: IOException) { // TODO Auto-generated catch block
                e.printStackTrace()
            }
            imagefilepath = mediaFile
            return Uri.fromFile(mediaFile)
        }

        try {
            val intent = Intent(MediaStore.ACTION_IMAGE_CAPTURE)
            //   Uri fileUri = getOutputMediaFileUri();
            val fileUri = FileProvider.getUriForFile(this,
                    BuildConfig.APPLICATION_ID + ".provider", getoutputMediaFileUri())
            intent.putExtra(MediaStore.EXTRA_OUTPUT, fileUri)
            startActivityForResult(intent, CAMERA_CAPTURE_IMAGE_REQUEST_CODE)
        } catch (e: Exception) { //Toast.makeText(mycontext,"error"+e.toString(),Toast.LENGTH_LONG).show();
// Log.e("erroe",e.toString());
            try {
                val intent = Intent(MediaStore.ACTION_IMAGE_CAPTURE)
                val fileUri = getoutputMediaFileUriException()
                intent.putExtra(MediaStore.EXTRA_OUTPUT, fileUri)
                startActivityForResult(intent, CAMERA_CAPTURE_IMAGE_REQUEST_CODE)
            } catch (e1: Exception) { //Toast.makeText(mycontext,"error"+e.toString(),Toast.LENGTH_LONG).show();
                e.printStackTrace()
            }
        }

    }

    private var picturefilename = "no data available"
    private var imagefilepath: File? = null
    private val CAMERA_CAPTURE_IMAGE_REQUEST_CODE = 100


    override fun onActivityResult(requestCode: Int, resultCode: Int, data: Intent?) {
        super.onActivityResult(requestCode, resultCode, data)
        if (requestCode == CAMERA_CAPTURE_IMAGE_REQUEST_CODE) {
            if (resultCode == RESULT_OK) {
                try {
                    val filename = imagefilepath
                    filename?.let {
                        imagesList.add(filename)
                        updateAdatper()
                    }
                    decodemyFile(filename)
                } catch (e: Exception) {
                    "please try again".toast(this)
                }
            }
        } else if (requestCode == 4) {
            when (resultCode) {
                RESULT_OK -> findlocation()
                RESULT_CANCELED -> {
                    val snackBar = Snackbar.make(window.decorView, "Please enable location", Snackbar.LENGTH_INDEFINITE)
                    snackBar.show()
                    RequestProgress.getInstance(this).hideProgressBar()
                }
                else -> {
                }
            }
        }
    }

    private fun decodemyFile(f: File?): Bitmap? {
        try { // Decode image size
            val o = BitmapFactory.Options()
            o.inJustDecodeBounds = true
            BitmapFactory.decodeStream(FileInputStream(f), null, o)
            o.inSampleSize = 4
            o.inJustDecodeBounds = false
            //---
            val imgbmp = BitmapFactory.decodeStream(FileInputStream(f), null, o) //o2
            val stream = ByteArrayOutputStream()
            //bmp.creates
            imgbmp?.compress(Bitmap.CompressFormat.JPEG, 80, stream)
            val byteArray = stream.toByteArray()
            try { //convert file into array of bytes
                val fileOuputStream = FileOutputStream(f) //outputfile
                fileOuputStream.write(byteArray)
                fileOuputStream.flush()
                fileOuputStream.close()
                val filename = imagefilepath
            } catch (e: Exception) {
                e.printStackTrace()
                Log.e("result erroe", e.toString())
            }
            return imgbmp
        } catch (e: FileNotFoundException) {
            return null
        }
        // return null;
    }


    private var imagesList = ArrayList<File>()
    private lateinit var adapter: ImagesAdapter

    private fun setAapter() {
        binding.recyclerView.setManager(this, horizontal = true)
        val listener = object : ImagesAdapter.AddImageListener {
            override fun onNewImageSelected() {
                captureImage()
            }

            override fun onImageSelected(position: Int) {
                showImageSheet(position)
            }

        }
        adapter = ImagesAdapter(imagesList, listener)
        binding.recyclerView.adapter = adapter
    }

    private fun updateAdatper() {
        adapter.list = imagesList
        adapter.notifyDataSetChanged()
    }

    private fun showImageSheet(position: Int) {
        val bottomSheetDialog = BottomSheetDialog(this)
        bottomSheetDialog.setContentView(R.layout.sheet_defect_image)
        var imageView: ImageView? = bottomSheetDialog.findViewById(R.id.imageView)
        var img_delete: ImageView? = bottomSheetDialog.findViewById(R.id.img_delete)
        Glide.with(this)
                .load(imagesList.get(position))
                .into(imageView!!)
        img_delete!!.run {
            visible()
            setOnClickListener {
                imagesList.removeAt(position)
                updateAdatper()
                bottomSheetDialog.dismiss()
            }
        }
        bottomSheetDialog.show()
    }


}
