package com.b2lmobitech.fieldcloudplus.defect

import android.Manifest
import android.app.Activity
import android.app.AlertDialog
import androidx.lifecycle.ViewModelProvider
import android.content.Context
import android.content.Intent
import android.content.IntentSender
import android.content.pm.PackageManager
import android.graphics.Bitmap
import android.graphics.BitmapFactory
import android.graphics.Canvas
import android.location.*
import android.location.LocationListener
import android.net.Uri
import android.os.Bundle
import android.os.Environment
import android.os.Looper
import android.provider.MediaStore
import com.google.android.material.bottomsheet.BottomSheetDialog
import com.google.android.material.snackbar.Snackbar
import androidx.core.app.ActivityCompat
import androidx.core.content.FileProvider
import androidx.appcompat.app.AppCompatActivity
import android.util.Base64
import android.util.Log
import android.view.Menu
import android.view.MenuItem
import android.view.View
import android.view.View.OnTouchListener
import android.widget.ImageView
import com.b2lmobitech.fieldcloudplus.BuildConfig
import com.b2lmobitech.fieldcloudplus.R
import com.b2lmobitech.fieldcloudplus.databinding.ActivityNewDefectReportBinding
import com.b2lmobitech.fieldcloudplus.databinding.ActivityNewDefectWorkReportBinding
import com.b2lmobitech.fieldcloudplus.defect.adapter.ImagesAdapter
import com.b2lmobitech.fieldcloudplus.hcm.HCMURL
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.entities.FacilityEntity
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.viewModel.DBViewModel
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue
import com.b2lmobitech.fieldcloudplus.others.utils.Preference
import com.b2lmobitech.fieldcloudplus.task.others.RequestProgress
import com.b2lmobitech.fieldcloudplus.task.others.Utility
import com.b2lmobitech.fieldcloudplus.task.service.GeofenceBroadcastReceiver
import com.b2lmobitech.fieldcloudplus.utils.*
import com.bumptech.glide.Glide
import com.bumptech.glide.Priority
import com.google.android.gms.common.ConnectionResult
import com.google.android.gms.common.api.ApiException
import com.google.android.gms.common.api.GoogleApiClient
import com.google.android.gms.common.api.ResolvableApiException
import com.google.android.gms.location.*
import com.google.android.gms.location.LocationRequest
import com.google.android.gms.tasks.CancellationToken
import com.google.android.gms.tasks.OnTokenCanceledListener
//import kotlinx.android.synthetic.main.activity_new_defect_work_report.*
//import kotlinx.android.synthetic.main.custom_timesheet.*
//import kotlinx.android.synthetic.main.sheet_defect_image.*
import org.json.JSONArray
import org.json.JSONException
import org.json.JSONObject
import java.io.*
import java.text.SimpleDateFormat
import java.util.*
import kotlin.collections.HashMap

class NewDefectWorkReport : AppCompatActivity() {
    private lateinit var binding: ActivityNewDefectWorkReportBinding
    private var jsonObject = JSONObject()
    private var facilityEntities: List<FacilityEntity> = ArrayList<FacilityEntity>()
    private lateinit var dbViewModel: DBViewModel

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
//        setContentView(R.layout.activity_new_defect_work_report)
        binding = ActivityNewDefectWorkReportBinding.inflate(layoutInflater)
        val view = binding.root
        setContentView(view)
        jsonObject = JSONObject(intent.getStringExtra("json"))
        dbViewModel = ViewModelProvider.AndroidViewModelFactory.getInstance(application).create(DBViewModel::class.java)

        initCallBacks()
        setAapter()
        setBillsAdapter()

        binding.signaturePad.setOnTouchListener(OnTouchListener { v, event ->
            binding.scrollView.requestDisallowInterceptTouchEvent(true) //very important
            false
        })

        binding.signaturePad2.setOnTouchListener(OnTouchListener { v, event ->
            binding.scrollView.requestDisallowInterceptTouchEvent(true) //very important
            false
        })

        supportActionBar?.run {
            setDisplayHomeAsUpEnabled(true)
            setTitle("Work Report")
        }

        getFacilitiesOffline()

    }


    fun initCallBacks() {
        binding.showSecondIncharge.setOnClickListener {
            binding.secondlayout.visible()
            binding.showSecondIncharge.hidden()
        }
    }

    private fun getFacilitiesOffline() {
        dbViewModel.getAllFacilities().observeForever {
            facilityEntities = it!!
        }
    }

    private var geoFenceEnabled = false
    private var geoLat = 0.0
    private var geoLon = 0.0
    private var geoDistance = 0

    private fun checkGeoFence() {
        facilityEntities.forEach { facilityEntity ->
            if (facilityEntity.atmid.equals(jsonObject.getString("facility_id"))) {
                if (facilityEntity.geofencing.equals("enable", true)) {
                    geoFenceEnabled = true
                    geoLat = facilityEntity.latitude.toDouble()
                    geoLon = facilityEntity.longitude.toDouble()
                    geoDistance = facilityEntity.geo_distance.toInt()
                }
            }
        }

        if (geoFenceEnabled) {
            connectLocation()
        } else {
            checkDefectAmount();
        }
    }

    var locationManager: LocationManager? = null

    fun connectLocation() {
        RequestProgress.getInstance(this).showProgressBar()
        val locationRequest = LocationRequest.create()
        locationRequest.priority = LocationRequest.PRIORITY_HIGH_ACCURACY
        locationRequest.interval = 10000
        locationRequest.fastestInterval = 10000 / 2.toLong()
        locationRequest.numUpdates = 1
        val builder = LocationSettingsRequest.Builder().addLocationRequest(locationRequest)
        builder.setAlwaysShow(true)
        val task = LocationServices.getSettingsClient(this).checkLocationSettings(builder.build())

        task.addOnCompleteListener { task ->
            try {
                task.getResult(ApiException::class.java)
                findlocation()
            } catch (exception: ApiException) {
                when (exception.statusCode) {
                    LocationSettingsStatusCodes.RESOLUTION_REQUIRED -> try {
                        val resolvable = exception as ResolvableApiException
                        resolvable.startResolutionForResult(this, 4)
                    } catch (e: IntentSender.SendIntentException) { // Ignore the error.
                    } catch (e: ClassCastException) { // Ignore, should be an impossible error.
                    }
                }
            }
        }
    }

    private lateinit var mFusedLocationClient: FusedLocationProviderClient
    private lateinit var mLocationRequest: LocationRequest
    private var currentlocationlaltitue = 0.0
    private var currentlocationlongitude = 0.0

    fun findlocation() {

        mFusedLocationClient = LocationServices.getFusedLocationProviderClient(this)
        if (ActivityCompat.checkSelfPermission(this, Manifest.permission.ACCESS_FINE_LOCATION) != PackageManager.PERMISSION_GRANTED && ActivityCompat.checkSelfPermission(this, Manifest.permission.ACCESS_COARSE_LOCATION) != PackageManager.PERMISSION_GRANTED) {
            return
        }

        mFusedLocationClient.getCurrentLocation(LocationRequest.PRIORITY_HIGH_ACCURACY, null).addOnCompleteListener {
            it.result?.let { location ->
                //Place current location marker
                Log.e("Location", location.latitude.toString() + "" + location.longitude)
                currentlocationlaltitue = location.latitude
                currentlocationlongitude = location.longitude
                calculateDistance(currentlocationlaltitue, currentlocationlongitude)
            }
        }.addOnCanceledListener {
            "Try Again".toast(this)
        }
    }

    private fun calculateDistance(lat: Double, lon: Double) {
        fun alertNotInFacility() {
            val alertdialog = AlertDialog.Builder(this)
            alertdialog.setMessage("It seems you are out of the geofence")
            alertdialog.setPositiveButton("Close") { dialog, whichButton ->
                binding.progressBar.hidden()
            }.create()
            alertdialog.setCancelable(false)
            alertdialog.show()
        }

        val distance = DistanceCalculator.distance(lat, lon, geoLat, geoLon)
        if (!geoFenceEnabled || distance <= geoDistance) {
            MyRequestQueue.getInstance(this).hideProgressBar()
            checkDefectAmount()
        } else {
            alertNotInFacility()
        }
    }

    private lateinit var imagesAdapter: ImagesAdapter
    private lateinit var billsAdapter: ImagesAdapter

    override fun onCreateOptionsMenu(menu: Menu?): Boolean {
        menuInflater.inflate(R.menu.menu_form, menu)
        return super.onCreateOptionsMenu(menu)
    }

    override fun onOptionsItemSelected(item: MenuItem): Boolean {
        if (item?.itemId == R.id.done) {
            if (isValid()) {
                checkGeoFence()
            }
        } else if (item?.itemId == android.R.id.home) {
            onBackPressed()
        }
        return super.onOptionsItemSelected(item)
    }

    private fun setAapter() {

        binding.recyclerView2.setManager(this, horizontal = true)

        fun showImageSheet(position: Int) {
            val bottomSheetDialog = BottomSheetDialog(this)
            bottomSheetDialog.setContentView(R.layout.sheet_defect_image)
            var imageView: ImageView? = bottomSheetDialog.findViewById(R.id.imageView)
            var img_delete: ImageView? = bottomSheetDialog.findViewById(R.id.img_delete)
            Glide.with(this)
                    .load(billsAdapter.list.get(position))
                    .into(imageView!!)
            img_delete!!.run {
                visible()
                setOnClickListener {
                    billsAdapter.list.removeAt(position)
                    billsAdapter.notifyDataSetChanged()
                    bottomSheetDialog.dismiss()
                }
            }
            bottomSheetDialog.show()
        }

        val listener = object : ImagesAdapter.AddImageListener {
            override fun onNewImageSelected() {
                captureImage(BILL_CAPTURE_IMAGE_REQUEST_CODE)
            }

            override fun onImageSelected(position: Int) {
                showImageSheet(position)
            }
        }
        billsAdapter = ImagesAdapter(listener = listener)
        binding.recyclerView2.adapter = billsAdapter
    }


    private fun setBillsAdapter() {
        binding.recyclerView.setManager(this, horizontal = true)

        fun showImageSheet(position: Int) {
            val bottomSheetDialog = BottomSheetDialog(this)
            bottomSheetDialog.setContentView(R.layout.sheet_defect_image)
            var imageView: ImageView? = bottomSheetDialog.findViewById(R.id.imageView)
            var img_delete: ImageView? = bottomSheetDialog.findViewById(R.id.img_delete)
            Glide.with(this)
                    .load(imagesAdapter.list.get(position))
                    .into(imageView!!)
            img_delete!!.run {
                visible()
                setOnClickListener {
                    imagesAdapter.list.removeAt(position)
                    imagesAdapter.notifyDataSetChanged()
                    bottomSheetDialog.dismiss()
                }
            }
            bottomSheetDialog.show()
        }

        val listener = object : ImagesAdapter.AddImageListener {
            override fun onNewImageSelected() {
                captureImage(CAMERA_CAPTURE_IMAGE_REQUEST_CODE)
            }

            override fun onImageSelected(position: Int) {
                showImageSheet(position)
            }
        }
        imagesAdapter = ImagesAdapter(listener = listener)
        binding.recyclerView.adapter = imagesAdapter


    }

    private fun captureImage(requestCode: Int) {

        fun getoutputMediaFileUri(): File {

            val mediaFile: File = Utility.getSignFile(this)

            /* val mediaStorageDir = Environment.getDataDirectory()
     //        val mediaStorageDir = File("/sdcard/Android/data/com.B2lmobitech.FieldCloudDesk/" + "AttendanceImages")
             if (!mediaStorageDir.exists()) {
                 mediaStorageDir.mkdirs()
             }
             val dateFormatter2 = SimpleDateFormat("yyyyMMdd_HHmmss")
             mediaFile = File(mediaStorageDir.path + File.separator
                     + "IMG_" + dateFormatter2.format(Date()) + ".jpg")*/
            picturefilename = mediaFile.name
            try {
                mediaFile.createNewFile()
            } catch (e: IOException) { // TODO Auto-generated catch block
                e.printStackTrace()
            }
            imagefilepath = mediaFile
            return mediaFile
        }

        fun getoutputMediaFileUriException(): Uri? {
            val mediaFile: File = Utility.getSignFile(this)

            /* var mediaFile: File? = null
             val mediaStorageDir = Environment.getDataDirectory()
             if (!mediaStorageDir.exists()) {
                 if (!mediaStorageDir.mkdirs()) {
                     return null
                 }
             }
             val dateFormatter2 = SimpleDateFormat("yyyyMMdd_HHmmss")
             mediaFile = File(mediaStorageDir.path + File.separator
                     + "IMG_" + dateFormatter2.format(Date()) + ".jpg")*/
            picturefilename = mediaFile.name
            try {
                mediaFile.createNewFile()
            } catch (e: IOException) { // TODO Auto-generated catch block
                e.printStackTrace()
            }
            imagefilepath = mediaFile
            return Uri.fromFile(mediaFile)
        }

        try {
            val intent = Intent(MediaStore.ACTION_IMAGE_CAPTURE)
            //   Uri fileUri = getOutputMediaFileUri();
            val fileUri = FileProvider.getUriForFile(this,
                    BuildConfig.APPLICATION_ID + ".provider", getoutputMediaFileUri())
            intent.putExtra(MediaStore.EXTRA_OUTPUT, fileUri)
            startActivityForResult(intent, requestCode)
        } catch (e: Exception) { //Toast.makeText(mycontext,"error"+e.toString(),Toast.LENGTH_LONG).show();
// Log.e("erroe",e.toString());
            try {
                val intent = Intent(MediaStore.ACTION_IMAGE_CAPTURE)
                val fileUri = getoutputMediaFileUriException()
                intent.putExtra(MediaStore.EXTRA_OUTPUT, fileUri)
                startActivityForResult(intent, requestCode)
            } catch (e1: Exception) { //Toast.makeText(mycontext,"error"+e.toString(),Toast.LENGTH_LONG).show();
            }
        }
    }

    private var picturefilename = "no data available"
    private var imagefilepath: File? = null
    private val CAMERA_CAPTURE_IMAGE_REQUEST_CODE = 100
    private val BILL_CAPTURE_IMAGE_REQUEST_CODE = 101

    override fun onActivityResult(requestCode: Int, resultCode: Int, data: Intent?) {
        super.onActivityResult(requestCode, resultCode, data)
        if (requestCode == CAMERA_CAPTURE_IMAGE_REQUEST_CODE || requestCode == BILL_CAPTURE_IMAGE_REQUEST_CODE) {
            if (resultCode == Activity.RESULT_OK) {
                try {
                    val filename = imagefilepath
                    filename?.let {
                        if (requestCode == CAMERA_CAPTURE_IMAGE_REQUEST_CODE) {
                            imagesAdapter.list.add(it)
                            imagesAdapter.notifyDataSetChanged()
                        } else {
                            billsAdapter.list.add(it)
                            billsAdapter.notifyDataSetChanged()
                        }
                    }
                } catch (e: Exception) {
                    "please try again".toast(this)
                }
            } else if (requestCode == 4) {
                when (resultCode) {
                    Activity.RESULT_OK -> findlocation()
                    Activity.RESULT_CANCELED -> {
                        val snackBar = Snackbar.make(window.decorView, "Please enable location", Snackbar.LENGTH_INDEFINITE)
                        snackBar.show()
                        RequestProgress.getInstance(this).hideProgressBar()
                    }
                }
            }
        }
    }

    private fun isValid(): Boolean {
        if (imagesAdapter.list.isEmpty()) {
            "Please Capture Recipt".toast(this)
            return false
        }

        if (billsAdapter.list.isEmpty()) {

            "Please Capture Some Images".toast(this)
            return false
        }

        binding.textInputLayout.editText?.text.toString().let {
            if (it.isEmpty()) {
                "Please Fill activity".toast(this)
                return false
            }
        }

        binding.textInputLayout2.editText?.text.toString().let {
            if (it.isEmpty()) {
                "Enter Valid Amount".toast(this)
                return false
            }
        }

        if (binding.inchargeName.editText!!.text.toString().isEmpty()) {
            "Enter Valid Incharge Name".toast(this)
            return false
        }

        if (binding.inchargeMobile.editText!!.text.toString().isEmpty()) {
            "Enter Valid Incharge Mobile".toast(this)
            return false
        }
        if (binding.signaturePad.gesture.strokesCount == 0) {
            "Please get Signature".toast(this)
        }

        if (binding.secondlayout.visibility == View.VISIBLE) {
            if (binding.inchargeName2.editText!!.text.toString().isEmpty()) {
                "Enter Valid Incharge Name".toast(this)
                return false
            }

            if (binding.inchargeMobile2.editText!!.text.toString().isEmpty()) {
                "Enter Valid Incharge Mobile".toast(this)
                return false
            }
            if (binding.signaturePad2.gesture.strokesCount == 0) {
                "Please get Signature".toast(this)
            }
        }





        if (MyRequestQueue.getInstance(this).isNoNetwork) {
            return false
        }

        return true
    }

    private fun checkDefectAmount() {

        if (imagesAdapter.list.isEmpty()) {
            "Please Capture Some Images".toast(this)
            return
        }
        binding.textInputLayout.editText?.text.toString().let {
            if (it.isEmpty()) {
                "Defect Can't be empty".toast(this)
                return
            }
        }

        val params: MutableMap<String, String> = HashMap()
        binding.textInputLayout2.editText?.text.toString().let {
            if (it.isEmpty()) {
                "Enter Valid Amount".toast(this)
                return
            } else {
                params["amount"] = it
            }
        }
        params["empemail"] = Preference.getInstance(this).emailId
        params["cname"] = Preference.getInstance(this).companyName
        params["id"] = jsonObject.getString("report_id")

        MyRequestQueue.getInstance(this).addToQueue(DEFECTURL.DEFECT_CHECK_AMOUNT, params) { response ->
            try {
                val json = JSONObject(response)

                if (json.getInt("s") == 1) {
                    addDefectReport()
                } else {
                    json.getString("m").toast(applicationContext)
                }
            } catch (e: JSONException) {
                e.printStackTrace()
            }
        }
    }

    private fun addDefectReport() {

        val params: MutableMap<String, String> = HashMap()

        if (imagesAdapter.list.isEmpty()) {
            "Please Capture Some Images".toast(this)
            return
        }
        binding.textInputLayout.editText?.text.toString().let {
            if (it.isEmpty()) {
                "Defect Can't be empty".toast(this)
                return
            } else {
                params["activity"] = it
            }
        }

        binding.textInputLayout2.editText?.text.toString().let {
            if (it.isEmpty()) {
                "Enter Valid Amount".toast(this)
                return
            } else {
                params["amount"] = it
            }
        }

        params["empemail"] = Preference.getInstance(this).emailId
        params["cname"] = Preference.getInstance(this).companyName
        params["id"] = jsonObject.getString("report_id")


        MyRequestQueue.getInstance(this).addToQueue(DEFECTURL.DEFECT_WORK_REPORT, params) { response ->
            try {
                val json = JSONObject(response)
                if (json.getInt("s") == 1) {
                    addBiillImages(jsonObject.getString("report_id"))
                }
            } catch (e: JSONException) {
                e.printStackTrace()
            }
        }
    }

    private fun addBiillImages(reportId: String) {
        if (billsAdapter.list.isEmpty()) {
            addImages(reportId)
            return
        }
        var currentImage = 0

        fun addImage(file: File) {
            val params: MutableMap<String, String> = HashMap()
            params["id"] = reportId
            params["type"] = "complete"
            params["cname"] = Preference.getInstance(this).companyName
            params["data"] = file.toBase64String()!!


            MyRequestQueue.getInstance(this).addToQueue(DEFECTURL.ADD_DEFECT_IMAGE, params) { response ->
                runOnUiThread {
                    try {
                        val json = JSONObject(response)
                        if (json.getInt("s") == 1) {
                            currentImage++
                            if (billsAdapter.list.size > currentImage) {
                                addImage(billsAdapter.list.get(currentImage))
                            } else {
                                addImages(reportId)
                            }
                        } else {
                            "Unable To Upload Images".toast(this)
                            finish()
                        }
                    } catch (e: JSONException) {
                        e.printStackTrace()
                    }
                }
            }
        }

        addImage(billsAdapter.list.first())

    }

    private fun addImages(reportId: String) {
        var currentImage = 0

        fun addImage(file: File) {
            val params: MutableMap<String, String> = HashMap()
            params["id"] = reportId
            params["type"] = "bill"
            params["cname"] = Preference.getInstance(this).companyName
            params["data"] = file.toBase64String()!!


            MyRequestQueue.getInstance(this).addToQueue(DEFECTURL.ADD_DEFECT_IMAGE, params) { response ->
                runOnUiThread {
                    try {
                        val json = JSONObject(response)
                        if (json.getInt("s") == 1) {
                            currentImage++
                            if (imagesAdapter.list.size > currentImage) {
                                addImage(imagesAdapter.list.get(currentImage))
                            } else {
                                addSign(false)
                            }
                        } else {
                            "Unable To Upload Images".toast(this)
                            finish()
                        }
                    } catch (e: JSONException) {
                        e.printStackTrace()
                    }
                }
            }
        }

        addImage(imagesAdapter.list.first())

    }

    private fun addSign(sign2: Boolean = false) {
        val params: MutableMap<String, String> = HashMap()
        params["id"] = jsonObject.getString("report_id")
        params["type"] = "sign"
        params["cname"] = Preference.getInstance(this).companyName
        //params["data"] = file.toBase64String()!!
        params["name"] = if (sign2) binding.inchargeName2.editText!!.text.toString() else binding.inchargeName.editText!!.text.toString()
        params["number"] = if (sign2) binding.inchargeMobile2.editText!!.text.toString() else binding.inchargeMobile.editText!!.text.toString()

        val sigbmp = if (sign2) convertViewToDrawable(binding.signaturePad2) else convertViewToDrawable(binding.signaturePad)
        val baos = ByteArrayOutputStream()
        sigbmp.compress(Bitmap.CompressFormat.PNG, 100, baos) //JPEG
        params["data"] = Base64.encodeToString(baos.toByteArray(), Base64.DEFAULT)
        baos.close()

        MyRequestQueue.getInstance(this).addToQueue(DEFECTURL.ADD_DEFECT_IMAGE, params) { response ->
            runOnUiThread {
                try {
                    val json = JSONObject(response)
                    if (json.getInt("s") == 1) {
                        if (!sign2 && binding.secondlayout.visibility == View.VISIBLE) {
                            addSign(true)
                        } else {
                            finishAll()
                        }
                    } else {
                        "Unable To Upload Images".toast(this)
                        finish()
                    }
                } catch (e: JSONException) {
                    e.printStackTrace()
                }
            }
        }
    }

    private fun finishAll() {
        "Work Report Submited Successfully".toast(this)
        finish()
    }

    private fun convertViewToDrawable(view: View): Bitmap {
        val b = Bitmap.createBitmap(view.measuredWidth, view.measuredHeight,
                Bitmap.Config.ARGB_8888)
        val c = Canvas(b)
        c.translate((-view.scrollX).toFloat(), (-view.scrollY).toFloat())
        view.draw(c)
        return b
    }

}

