package com.b2lmobitech.fieldcloudplus.defect

import android.content.Intent
import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.view.MenuItem
import com.b2lmobitech.fieldcloudplus.R
import com.b2lmobitech.fieldcloudplus.databinding.ActivityNewDefectWorkReportBinding
import com.b2lmobitech.fieldcloudplus.databinding.ActivityPettyCashBinding
import com.b2lmobitech.fieldcloudplus.defect.adapter.PettyCashAdapter
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue
import com.b2lmobitech.fieldcloudplus.others.utils.Preference
import com.b2lmobitech.fieldcloudplus.utils.addDivider
import com.b2lmobitech.fieldcloudplus.utils.setManager
import com.b2lmobitech.fieldcloudplus.utils.string
//import kotlinx.android.synthetic.main.activity_petty_cash.*
import org.json.JSONArray
import org.json.JSONException
import java.util.HashMap

class PettyCashActivity : AppCompatActivity() {

    private var jsonArray = JSONArray()
    private lateinit var pettyCashAdapter: PettyCashAdapter
    private lateinit var binding: ActivityPettyCashBinding
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
//        setContentView(R.layout.activity_petty_cash)
        binding = ActivityPettyCashBinding.inflate(layoutInflater)
        val view = binding.root
        setContentView(view)
        supportActionBar?.run {
            setDisplayHomeAsUpEnabled(true)
            setTitle("Petty Cash")
        }

        binding.recyclerView.setManager(this)
        binding.recyclerView.addDivider(this)
        pettyCashAdapter = PettyCashAdapter(onclikck = {
            pettyCashAdapter.list.getJSONObject(it).getString("report_id").let {
                if(!it.equals("NA")){
                    val bundle = Bundle()
                    bundle.putString("id",it)
                    val intent = Intent(this,DefectDetailsActivity::class.java)
                    intent.putExtras(bundle)
                    startActivity(intent)
                }
            }

        })
        binding.recyclerView.adapter = pettyCashAdapter
        getData()
    }



    override fun onOptionsItemSelected(item: MenuItem): Boolean {
        if(item?.itemId == android.R.id.home){
            onBackPressed()
        }
        return super.onOptionsItemSelected(item)
    }

    private fun getData() {
        val params: MutableMap<String, String> = HashMap()
        params["email"] = Preference.getInstance(this).emailId
        params["cname"] = Preference.getInstance(this).companyName

        MyRequestQueue.getInstance(this).addToQueue(DEFECTURL.DEFECT_PETTYCASH_SUMMARY, params) { response ->
            try {
                val jsonArray = JSONArray(response)
                jsonArray.getJSONObject(0)?.let {
                    binding.textView14.text = "₹"+(it.getDouble("total_credit")-it.getDouble("total_debit")).string()
                    binding.textView21.text = "₹"+it.getDouble("total_credit").string()
                    if(it.getDouble("today_credit") != 0.0){
                        binding.textView21.text = "₹${it.getDouble("total_credit").string()} ( ${it.getDouble("today_credit").string()})"
                    }
                    binding.textView22.text = "₹"+it.getDouble("total_debit").string()
                    if(it.getDouble("today_debit") != 0.0){
                        binding.textView22.text = "₹${it.getDouble("total_debit").string()} ( ${it.getDouble("today_debit").string()})"
                    }
                }
                getList()
            } catch (e: JSONException) {
                e.printStackTrace()
            }
        }
    }

    private fun getList() {
        val params: MutableMap<String, String> = HashMap()
        params["email"] = Preference.getInstance(this).emailId
        params["cname"] = Preference.getInstance(this).companyName

        MyRequestQueue.getInstance(this).addToQueue(DEFECTURL.DEFECT_PETTYCASH_LIST, params) { response ->
            try {
                val jsonArray = JSONArray(response)
                setAdapter(jsonArray)
            } catch (e: JSONException) {
                e.printStackTrace()
            }
        }
    }

    private fun setAdapter(jsonArray: JSONArray) {
        pettyCashAdapter.list = jsonArray
        pettyCashAdapter.notifyDataSetChanged()
    }


}