package com.b2lmobitech.fieldcloudplus.defect

import android.app.Activity
import android.content.Intent
import android.graphics.Bitmap
import android.graphics.BitmapFactory
import android.net.Uri
import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.provider.MediaStore
import android.util.Log
import android.view.View
import android.widget.ImageView
import android.widget.TextView
import androidx.core.content.FileProvider
import com.b2lmobitech.fieldcloudplus.BuildConfig
import com.b2lmobitech.fieldcloudplus.R
import com.b2lmobitech.fieldcloudplus.databinding.ActivityPettyCashBinding
import com.b2lmobitech.fieldcloudplus.databinding.ActivityUpdateDefectImagesBinding
import com.b2lmobitech.fieldcloudplus.defect.adapter.ReportImage
import com.b2lmobitech.fieldcloudplus.defect.adapter.ReportImageAdapter
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue
import com.b2lmobitech.fieldcloudplus.others.utils.Preference
import com.b2lmobitech.fieldcloudplus.task.others.RequestProgress
import com.b2lmobitech.fieldcloudplus.task.others.Utility
import com.b2lmobitech.fieldcloudplus.utils.*
import com.bumptech.glide.Glide
import com.google.android.material.bottomsheet.BottomSheetDialog
import com.google.android.material.snackbar.Snackbar
//import kotlinx.android.synthetic.main.activity_new_defect_work_report.*
//import kotlinx.android.synthetic.main.activity_update_defect_images.*
//import kotlinx.android.synthetic.main.activity_update_defect_images.recyclerView
//import kotlinx.android.synthetic.main.activity_update_defect_images.textInputLayout2
//import kotlinx.android.synthetic.main.sheet_defect_image.*
import org.json.JSONArray
import org.json.JSONException
import org.json.JSONObject
import java.io.*
import java.util.HashMap

class UpdateDefectImagesActivity : AppCompatActivity() {

    private var reportId = ""
    private var amount = ""

    private var imagesArray = JSONArray()

    var billList: ArrayList<ReportImage> = ArrayList()
    private lateinit var reportImageAdapter:ReportImageAdapter
    private lateinit var binding: ActivityUpdateDefectImagesBinding
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
//        setContentView(R.layout.activity_update_defect_images)
        binding = ActivityUpdateDefectImagesBinding.inflate(layoutInflater)
        val view = binding.root
        setContentView(view)

        intent.getStringExtra("id")?.let {
            reportId = it
        }
        intent.getStringExtra("amount")?.let {
            amount = it
            binding.textInputLayout2.editText?.setText(amount);
        }


        reportImageAdapter = ReportImageAdapter(billList,object :ReportImageAdapter.AddImageListener{
            override fun onNewImageSelected() {
                captureImage(IMAGE_REQUEST_CODE)
            }

            override fun onImageSelected(position: Int) {
                showImageSheet(position,billList.get(position))
            }

        })

        binding.recyclerView.adapter = reportImageAdapter
        getList()

        binding.button.setOnClickListener {
            if( binding.textInputLayout2.editText!!.text.toString().isEmpty()){
                "Enter Valid amount".toast(this)
            }else {
                checkDefectAmount()
            }
        }
    }

    private fun showImageSheet(position:Int, reportImage: ReportImage){
        val bottomSheetDialog = BottomSheetDialog(this)
        bottomSheetDialog.setContentView(R.layout.sheet_defect_image)
        var imageView: ImageView? = bottomSheetDialog.findViewById(R.id.imageView)
        reportImage.first?.let {
            imageView!!.setImageBitmap(it.toBitmap())
        }
        reportImage.second?.let {
            Glide.with(this)
                    .load(DEFECTURL.IMAGE+it.getString("image_path"))
                    .into(imageView!!)
        }


        bottomSheetDialog.findViewById<View>(R.id.img_delete)?.let {
            it.visible(true)
            it.setOnClickListener {
                reportImage.first?.let {
                    billList.removeAt(position)
                    reportImageAdapter.list = billList
                    reportImageAdapter.notifyDataSetChanged()
                }
                reportImage.second?.let {
                    deleteImage(position,it)
                }

                bottomSheetDialog.dismiss()
            }
        }

        bottomSheetDialog.show()
    }

    private fun deleteImage(position:Int,jsonObject: JSONObject) {

        val params: MutableMap<String, String> = HashMap()
        params["user_id"] = Preference.getInstance(this).emailId
        params["id"] = jsonObject.getString("id")

        MyRequestQueue.getInstance(this).addToQueue(DEFECTURL.DEFECT_IMAGE_DELETE, params)
        {
            response ->
            try {
                billList.removeAt(position)
                reportImageAdapter.list = billList
                reportImageAdapter.notifyDataSetChanged()
            } catch (e: JSONException) {
                e.printStackTrace()
            }
        }
    }

    private fun getList() {
        val params: MutableMap<String, String> = HashMap()
        params["id"] = reportId
        params["cname"] = Preference.getInstance(this).companyName

        MyRequestQueue.getInstance(this).addToQueue(DEFECTURL.GET_DEFECT_IMAGES, params) { response ->
            try {
                imagesArray = JSONArray(response)
                updateAdapters()
            } catch (e: JSONException) {
                e.printStackTrace()
            }
        }
    }

    private fun updateAdapters(){
        for(i in 0 until imagesArray.length()){
            imagesArray.getJSONObject(i)?.let {
                if(it.getString("type").equals("bill",true)){
                    billList.add(ReportImage(null, it))
                }
            }
        }

        reportImageAdapter.list = billList
        reportImageAdapter.notifyDataSetChanged()

    }

    private fun captureImage(requestCode: Int) {

        fun getoutputMediaFileUri(): File {

            val mediaFile: File = Utility.getSignFile(this)

            /* val mediaStorageDir = Environment.getDataDirectory()
     //        val mediaStorageDir = File("/sdcard/Android/data/com.B2lmobitech.FieldCloudDesk/" + "AttendanceImages")
             if (!mediaStorageDir.exists()) {
                 mediaStorageDir.mkdirs()
             }
             val dateFormatter2 = SimpleDateFormat("yyyyMMdd_HHmmss")
             mediaFile = File(mediaStorageDir.path + File.separator
                     + "IMG_" + dateFormatter2.format(Date()) + ".jpg")*/
            picturefilename = mediaFile.name
            try {
                mediaFile.createNewFile()
            } catch (e: IOException) { // TODO Auto-generated catch block
                e.printStackTrace()
            }
            imagefilepath = mediaFile
            return mediaFile
        }

        fun getoutputMediaFileUriException(): Uri? {
            val mediaFile: File = Utility.getSignFile(this)

            /* var mediaFile: File? = null
             val mediaStorageDir = Environment.getDataDirectory()
             if (!mediaStorageDir.exists()) {
                 if (!mediaStorageDir.mkdirs()) {
                     return null
                 }
             }
             val dateFormatter2 = SimpleDateFormat("yyyyMMdd_HHmmss")
             mediaFile = File(mediaStorageDir.path + File.separator
                     + "IMG_" + dateFormatter2.format(Date()) + ".jpg")*/
            picturefilename = mediaFile.name
            try {
                mediaFile.createNewFile()
            } catch (e: IOException) { // TODO Auto-generated catch block
                e.printStackTrace()
            }
            imagefilepath = mediaFile
            return Uri.fromFile(mediaFile)
        }

        try {
            val intent = Intent(MediaStore.ACTION_IMAGE_CAPTURE)
            //   Uri fileUri = getOutputMediaFileUri();
            val fileUri = FileProvider.getUriForFile(this,
                    BuildConfig.APPLICATION_ID + ".provider", getoutputMediaFileUri())
            intent.putExtra(MediaStore.EXTRA_OUTPUT, fileUri)
            startActivityForResult(intent, requestCode)
        } catch (e: Exception) { //Toast.makeText(mycontext,"error"+e.toString(),Toast.LENGTH_LONG).show();
// Log.e("erroe",e.toString());
            try {
                val intent = Intent(MediaStore.ACTION_IMAGE_CAPTURE)
                val fileUri = getoutputMediaFileUriException()
                intent.putExtra(MediaStore.EXTRA_OUTPUT, fileUri)
                startActivityForResult(intent, requestCode)
            } catch (e1: Exception) { //Toast.makeText(mycontext,"error"+e.toString(),Toast.LENGTH_LONG).show();
            }
        }
    }

    private var picturefilename = "no data available"
    private var imagefilepath: File? = null
    private val IMAGE_REQUEST_CODE = 100

    override fun onActivityResult(requestCode: Int, resultCode: Int, data: Intent?) {
        super.onActivityResult(requestCode, resultCode, data)
        if (resultCode == Activity.RESULT_OK) {
                try {
                    val filename = imagefilepath
                    filename?.let {
                        billList.add(Pair(it,null))
                        reportImageAdapter.list = billList
                        reportImageAdapter.notifyDataSetChanged()
                    }
                } catch (e: Exception) {
                    "please try again".toast(this)
                }
            }
    }


    private fun checkDefectAmount(){

        val params: MutableMap<String, String> = HashMap()
        binding.textInputLayout2.editText?.text.toString().let {
            if(it.isEmpty()){
                "Enter Valid Amount".toast(this)
                return
            }else{
                params["amount"]=it
            }
        }
        params["empemail"]=Preference.getInstance(this).emailId
        params["cname"]=Preference.getInstance(this).companyName
        params["id"]=reportId

        MyRequestQueue.getInstance(this).addToQueue(DEFECTURL.DEFECT_CHECK_AMOUNT, params) { response ->
            try {
                val json = JSONObject(response)

                if(json.getInt("s")==1){
                    addBiillImages(reportId);
                }else{
                    json.getString("m").toast(applicationContext)
                }
            } catch (e: JSONException) {
                e.printStackTrace()
            }
        }
    }

    private fun addBiillImages(reportId:String){
        val newImages = ArrayList<File>()
        billList.forEach {
            it.first?.let {
                newImages.add(it)
            }
        }
        var currentImage = 0

        fun addImage(file: File){
            val params: MutableMap<String, String> = HashMap()
            params["id"]= reportId
            params["type"]= "bill"
            params["cname"]= Preference.getInstance(this).companyName
            params["data"] = file.toBase64String()!!


            MyRequestQueue.getInstance(this).addToQueue(DEFECTURL.ADD_DEFECT_IMAGE, params) { response ->
                runOnUiThread {
                    try {
                        val json = JSONObject(response)
                        if(json.getInt("s")==1){
                            currentImage++
                            if( newImages.size > currentImage) {
                                addImage(newImages.get(currentImage))
                            }else{
                                updateCompleted()
                            }
                        }else{
                            "Unable To Upload Images".toast(this)
                            finish()
                        }
                    } catch (e: JSONException) {
                        e.printStackTrace()
                    }
                }
            }
        }

        if(newImages.size == 0){
            "Add Atlease On Image".toast(this)
        }else {
            addImage(newImages.first())
        }
    }

    private fun updateCompleted(){

        val params: MutableMap<String, String> = HashMap()
        params["user_id"]=Preference.getInstance(this).emailId
        params["cname"]=Preference.getInstance(this).companyName
        params["report_id"]=reportId
        params["amount"]=binding.textInputLayout2.editText!!.text.toString()

        MyRequestQueue.getInstance(this).addToQueue(DEFECTURL.DEFECT_COMPLETE, params) { response ->
            try {
               "Submitted Successfully".toast(this)
                finish()
            } catch (e: JSONException) {
                e.printStackTrace()
            }
        }
    }

}
