package com.b2lmobitech.fieldcloudplus.defect.adapter

import android.graphics.drawable.Drawable
import androidx.recyclerview.widget.RecyclerView
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.TextView
import com.b2lmobitech.fieldcloudplus.R
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.entities.FacilityEntity
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener
//import kotlinx.android.synthetic.main.item_defect_menu.view.*
import kotlin.reflect.KClass

/**
 * Created by home on 10/31/2017.
 */
class DefectGirdAdapter(var list: List<Triple<String,Drawable,KClass<*>>>, var listener: DefectMenuSelectedListener)
    : androidx.recyclerview.widget.RecyclerView.Adapter<DefectGirdAdapter.viewHolder>() {

    override fun onBindViewHolder(holder: viewHolder, position: Int) {
        val triple = list.get(holder.layoutPosition)
        holder.itemView.run {
            holder.txt_defect.text = triple.first
            holder.img_defect.setImageDrawable(triple.second)
        }
    }

    override fun getItemCount(): Int {
        return list.size
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): viewHolder {
        val itemView = LayoutInflater.from(parent.context).inflate(R.layout.item_defect_menu, parent, false)
        return viewHolder(itemView)
    }

    inner class viewHolder(itemView: View) : androidx.recyclerview.widget.RecyclerView.ViewHolder(itemView){
        init {
            itemView.setOnClickListener {
                listener.onDefectMenuSelected(layoutPosition)
            }
        }
        val txt_defect: TextView = itemView.findViewById(R.id.txt_defect)
        val img_defect: ImageView = itemView.findViewById(R.id.img_defect)
    }

    interface  DefectMenuSelectedListener{
        fun onDefectMenuSelected(position: Int)
    }
}