package com.b2lmobitech.fieldcloudplus.defect.adapter

import android.graphics.Color
import android.graphics.drawable.Drawable
import androidx.recyclerview.widget.RecyclerView
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.TextView
import com.b2lmobitech.fieldcloudplus.R
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.entities.FacilityEntity
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener
import com.b2lmobitech.fieldcloudplus.others.utils.Preference
import com.b2lmobitech.fieldcloudplus.utils.DateConstant
import com.b2lmobitech.fieldcloudplus.utils.string
import com.b2lmobitech.fieldcloudplus.utils.toDate
//import kotlinx.android.synthetic.main.item_defect.view.*
//import kotlinx.android.synthetic.main.item_defect_menu.view.*
import org.json.JSONArray
import kotlin.reflect.KClass

/**
 * Created by home on 10/31/2017.
 */
class DefectListAdapter(var list: JSONArray = JSONArray(), var listener: DefectSelectedListener)
    : androidx.recyclerview.widget.RecyclerView.Adapter<DefectListAdapter.viewHolder>() {

    override fun onBindViewHolder(holder: viewHolder, position: Int) {
        val triple = list.getJSONObject(holder.layoutPosition)
        holder.itemView.run {
            if(Preference.getInstance(context).isMEP &&
                    triple.getString("status").equals("completed",true) &&
                    triple.getString("can_edit").equals("1") &&
                    triple.getString("billpay_type").equals("notpayable",true)){
                holder.itemView.setBackgroundColor(Color.parseColor("#22ff0000"))
            }else{
                holder.itemView.background = null
            }
            holder.txt_equipment.text = triple.getString("equipment")
            holder.txt_details.text = triple.getString("defect")
            holder.txt_defect_number.text = triple.getString("sitename")
            holder.txt_datetime.text = triple.getString("status").let {
                if(it.equals("open")) triple.getString("open_status_DT")
                else if(it.equals("approved")) triple.getString("approved_status_DT")
                else if(it.equals("rejected")) triple.getString("rejected_status_DT")
                else if(it.equals("completed")) triple.getString("completed_status_DT")
                else if(it.equals("closed")) triple.getString("closed_status_DT")
                else ""
            }.toDate("yyyy-MM-dd HH:mm:ss").string(DateConstant.DATE_TIME_REDABLE)
        }
    }

    override fun getItemCount(): Int {
        return list.length()
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): viewHolder {
        val itemView = LayoutInflater.from(parent.context).inflate(R.layout.item_defect, parent, false)
        return viewHolder(itemView)
    }

    inner class viewHolder(itemView: View) : androidx.recyclerview.widget.RecyclerView.ViewHolder(itemView){
        init {
            itemView.setOnClickListener {
                listener.onDefectSelected(layoutPosition)
            }
        }
        val txt_equipment: TextView = itemView.findViewById(R.id.txt_equipment)
        val txt_details: TextView = itemView.findViewById(R.id.txt_details)
        val txt_defect_number: TextView = itemView.findViewById(R.id.txt_defect_number)
        val txt_datetime: TextView = itemView.findViewById(R.id.txt_datetime)
    }

    interface  DefectSelectedListener{
        fun onDefectSelected(position: Int)
    }
}