package com.b2lmobitech.fieldcloudplus.defect.adapter

import android.graphics.drawable.Drawable
import androidx.recyclerview.widget.RecyclerView
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.TextView
import com.b2lmobitech.fieldcloudplus.R
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.entities.FacilityEntity
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener
import com.b2lmobitech.fieldcloudplus.utils.toBitmap
//import kotlinx.android.synthetic.main.item_defect_menu.view.*
//import kotlinx.android.synthetic.main.item_image.view.*
import java.io.File
import kotlin.reflect.KClass

/**
 * Created by home on 10/31/2017.
 */
class ImagesAdapter(var list: ArrayList<File> = ArrayList<File>(), var listener: AddImageListener)
    : androidx.recyclerview.widget.RecyclerView.Adapter<ImagesAdapter.viewHolder>() {

    override fun onBindViewHolder(holder: viewHolder, position: Int) {
        holder.itemView.run {
            if(list.size < 4 && holder.adapterPosition == list.size ){
                holder.imageView.setImageResource(R.drawable.ic_action_camera)
            }else {
                list.get(holder.layoutPosition).toBitmap()?.let {
                    holder.imageView.setImageBitmap(it)
                }
            }
        }
    }

    override fun getItemCount(): Int {
        if(list.size < 4) {
            return list.size + 1
        }else{
            return list.size
        }
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): viewHolder {
        val itemView = LayoutInflater.from(parent.context).inflate(R.layout.item_image, parent, false)
        return viewHolder(itemView)
    }

    inner class viewHolder(itemView: View) : androidx.recyclerview.widget.RecyclerView.ViewHolder(itemView){
        init {
            itemView.setOnClickListener {
                if(adapterPosition == list.size ){
                    listener.onNewImageSelected()
                }else{
                    listener.onImageSelected(layoutPosition)
                }
            }
        }
        val imageView: ImageView = itemView.findViewById(R.id.imageView)
    }

    interface AddImageListener{
        fun onNewImageSelected()
        fun onImageSelected(position: Int)
    }
}