package com.b2lmobitech.fieldcloudplus.defect.adapter

import android.graphics.drawable.Drawable
import androidx.recyclerview.widget.RecyclerView
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import com.b2lmobitech.fieldcloudplus.R
import com.b2lmobitech.fieldcloudplus.defect.DEFECTURL
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.entities.FacilityEntity
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener
import com.b2lmobitech.fieldcloudplus.utils.toBitmap
import com.bumptech.glide.Glide
//import kotlinx.android.synthetic.main.item_defect_menu.view.*
//import kotlinx.android.synthetic.main.item_image.view.*
import org.json.JSONArray
import java.io.File
import kotlin.reflect.KClass

/**
 * Created by home on 10/31/2017.
 */
class NetworkImageAdapter(var list: JSONArray, var listener: ImageSelectedLsitener)
    : androidx.recyclerview.widget.RecyclerView.Adapter<NetworkImageAdapter.viewHolder>() {

    override fun onBindViewHolder(holder: viewHolder, position: Int) {
        holder.itemView.run {
            Glide.with(this)
                    .load(DEFECTURL.IMAGE+list.getJSONObject(holder.layoutPosition).getString("image_path"))
                    .into(holder.imageView)

        }
    }

    override fun getItemCount(): Int {
        return list.length()
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): viewHolder {
        val itemView = LayoutInflater.from(parent.context).inflate(R.layout.item_image, parent, false)
        return viewHolder(itemView)
    }

    inner class viewHolder(itemView: View) : androidx.recyclerview.widget.RecyclerView.ViewHolder(itemView){
        init {
            itemView.setOnClickListener {
                listener.onImageSelected(layoutPosition)
            }
        }
        val imageView: ImageView = itemView.findViewById(R.id.imageView)
    }

    interface ImageSelectedLsitener{
        fun onImageSelected(position: Int)
    }
}