package com.b2lmobitech.fieldcloudplus.defect.adapter

import android.graphics.Color
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.TextView
import com.b2lmobitech.fieldcloudplus.R
import com.b2lmobitech.fieldcloudplus.utils.DateConstant
import com.b2lmobitech.fieldcloudplus.utils.string
import com.b2lmobitech.fieldcloudplus.utils.toDate
//import kotlinx.android.synthetic.main.item_defect.view.txt_datetime
//import kotlinx.android.synthetic.main.item_pettycash.view.*
import org.json.JSONArray
import kotlin.reflect.KClass

/**
 * Created by home on 10/31/2017.
 */
class PettyCashAdapter(var list: JSONArray = JSONArray(), var onclikck : (position:Int) -> Unit)
    : androidx.recyclerview.widget.RecyclerView.Adapter<PettyCashAdapter.viewHolder>() {

    override fun onBindViewHolder(holder: viewHolder, position: Int) {
        val triple = list.getJSONObject(holder.layoutPosition)
        holder.itemView.run {

            if(triple.getString("ref_num").equals("NA")){
                holder.txt_datetime.text = triple.getString("report_id")
            }else{
                holder.txt_datetime.text = triple.getString("transfer_mode") +", " + triple.getString("ref_num")
            }



            holder.txt_reference.text = triple.getString("datetime").toDate("yyyy-MM-dd HH:mm:ss").string(DateConstant.DATE_TIME_REDABLE)
            with(holder.txt_amount){
                if(triple.getString("type").equals("credit")){
                    setTextColor(Color.parseColor("#228B22"))
                }else{
                    setTextColor(Color.RED)
                }
                triple.getString("amount").let {
                    text = "\u20B9"+it
                }
            }

        }
    }

    override fun getItemCount(): Int {
        return list.length()
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): viewHolder {
        val itemView = LayoutInflater.from(parent.context).inflate(R.layout.item_pettycash, parent, false)
        return viewHolder(itemView)
    }

    inner class viewHolder(itemView: View) : androidx.recyclerview.widget.RecyclerView.ViewHolder(itemView){
        init {
            itemView.setOnClickListener {
                onclikck.invoke(layoutPosition)
            }

        }
        val txt_datetime: TextView = itemView.findViewById(R.id.txt_datetime)
        val txt_reference: TextView = itemView.findViewById(R.id.txt_reference)
        val txt_amount: TextView = itemView.findViewById(R.id.txt_amount)
    }
}