package com.b2lmobitech.fieldcloudplus.defect.adapter

import android.graphics.drawable.Drawable
import androidx.recyclerview.widget.RecyclerView
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.TextView
import com.b2lmobitech.fieldcloudplus.R
import com.b2lmobitech.fieldcloudplus.defect.DEFECTURL
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.entities.FacilityEntity
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener
import com.b2lmobitech.fieldcloudplus.utils.toBitmap
import com.bumptech.glide.Glide
//import kotlinx.android.synthetic.main.item_defect_menu.view.*
//import kotlinx.android.synthetic.main.item_image.view.*
import org.json.JSONObject
import java.io.File
import kotlin.reflect.KClass

/**
 * Created by home on 10/31/2017.
 */
class ReportImageAdapter(var list: ArrayList<ReportImage> = ArrayList(), var listener: AddImageListener)
    : androidx.recyclerview.widget.RecyclerView.Adapter<ReportImageAdapter.viewHolder>() {

    override fun onBindViewHolder(holder: viewHolder, position: Int) {
        holder.itemView.run {
            if(list.size < 4 && holder.adapterPosition == list.size ){
                holder.imageView.setImageResource(R.drawable.ic_action_camera)
            }else {
                val pair = list[holder.layoutPosition]
                pair.first?.let {
                    holder.imageView.setImageBitmap(it.toBitmap())
                }
                pair.second?.let {
                    Glide.with(this)
                            .load(DEFECTURL.IMAGE+it.getString("image_path"))
                            .into(holder.imageView)
                }
            }
        }
    }

    override fun getItemCount(): Int {
        if(list.size < 4) {
            return list.size + 1
        }else{
            return list.size
        }
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): viewHolder {
        val itemView = LayoutInflater.from(parent.context).inflate(R.layout.item_report_image, parent, false)
        return viewHolder(itemView)
    }

    inner class viewHolder(itemView: View) : androidx.recyclerview.widget.RecyclerView.ViewHolder(itemView){
        init {
            itemView.setOnClickListener {
                if(adapterPosition == list.size ){
                    listener.onNewImageSelected()
                }else{
                    listener.onImageSelected(layoutPosition)
                }
            }
        }
        val imageView: ImageView = itemView.findViewById(R.id.imageView)
    }

    interface AddImageListener{
        fun onNewImageSelected()
        fun onImageSelected(position: Int)
    }
}

typealias ReportImage = Pair<File?,JSONObject?>