package com.b2lmobitech.fieldcloudplus.expense

import android.content.Context
import android.content.Intent
import android.graphics.Bitmap
import android.graphics.BitmapFactory
import android.net.ConnectivityManager
import android.net.NetworkCapabilities
import android.os.Bundle
import android.util.Base64
import android.util.Log
import android.view.MenuItem
import android.view.View
import android.widget.Toast
import androidx.annotation.NonNull
import androidx.appcompat.app.AppCompatActivity
import androidx.lifecycle.coroutineScope
import com.b2lmobitech.fieldcloudplus.BuildConfig
import com.b2lmobitech.fieldcloudplus.expense.api.ApiStatus
import com.b2lmobitech.fieldcloudplus.others.utils.Preference
import com.b2lmobitech.fieldcloudplus.utils.CustomDialog
import com.google.android.material.textfield.TextInputLayout
import com.goozi.customer.data.remote.ApiHelper
import com.goozi.customer.data.remote.RetrofitFactory
//import kotlinx.android.synthetic.main.activity_login.*
import kotlinx.coroutines.launch
import pl.aprilapps.easyphotopicker.DefaultCallback
import pl.aprilapps.easyphotopicker.EasyImage
import pl.aprilapps.easyphotopicker.MediaFile
import pl.aprilapps.easyphotopicker.MediaSource
import retrofit2.Response
import java.io.ByteArrayOutputStream
import java.io.File
import java.io.FileInputStream
import java.io.FileNotFoundException
import java.net.ConnectException
import java.net.SocketTimeoutException
import java.net.UnknownHostException


open class BaseActivity(val title: String = "") : AppCompatActivity() {

    private lateinit var mCustomLoaderDialog: CustomDialog
    var email = ""
    var companyName = ""

    private lateinit var easyImage: EasyImage

    override fun onCreate(savedInstanceState: Bundle?) {
        mCustomLoaderDialog = CustomDialog(this)
        email = Preference.getInstance(this).emailId
        companyName = Preference.getInstance(this).companyName

        supportActionBar?.setDisplayHomeAsUpEnabled(true)
        supportActionBar?.setTitle(title)
        super.onCreate(savedInstanceState)
    }


    override fun onOptionsItemSelected(item: MenuItem): Boolean {
        if (item.itemId == android.R.id.home) {
            onBackPressed()
        }
        return super.onOptionsItemSelected(item)
    }

    fun showToast(string: String) {
        Toast.makeText(applicationContext, string, Toast.LENGTH_SHORT).show()
    }

    fun openCamera(onComplete: (medialFiles: List<MediaFile>) -> Unit){
        onImageCaptured = onComplete
        if(!::easyImage.isInitialized){
            easyImage = EasyImage.Builder(this).build()
        }
        easyImage.openCameraForImage(this)
    }

    lateinit var onImageCaptured : (List<MediaFile>) -> Unit

    override fun onActivityResult(requestCode: Int, resultCode: Int, data: Intent?) {
        super.onActivityResult(requestCode, resultCode, data)


        if(::easyImage.isInitialized) {
            easyImage.handleActivityResult(requestCode, resultCode, data, this, object : DefaultCallback() {
                override fun onMediaFilesPicked(imageFiles: Array<MediaFile>, source: MediaSource) {
                    onImageCaptured(imageFiles.toList())
                }

                override fun onImagePickerError(@NonNull error: Throwable, @NonNull source: MediaSource) {
                    //Some error handling
                    error.printStackTrace()
                }

                override fun onCanceled(@NonNull source: MediaSource) {
                    //Not necessary to remove any files manually anymore
                }
            })
        }
    }


    fun showLoading() {
        try {
            if (mCustomLoaderDialog.window != null) {
                mCustomLoaderDialog.window!!.setBackgroundDrawableResource(android.R.color.transparent)
                mCustomLoaderDialog.show()
            }
        } catch (e: Exception) {
            e.printStackTrace()
        }
    }

    fun <T> apiLaunch(
            request: suspend (ApiHelper) -> Response<T>,
            progressView: View? = null,
            toast: Boolean = true,
            response: (T?) -> Unit = ::println
    ) =
            lifecycle.coroutineScope.launch {
                // Network Check
                if (isOnline().not()) {
                    error("No Internet Connection")
                    return@launch
                }
                // Original Process
                showLoading()
                try {
                    with(request(RetrofitFactory.api)) {
                        hideLoading()
                        body()?.let {
                            response(it)
                        }
                        errorBody()?.let {
                            when (code()) {
                                ApiStatus.INTERNAL_SERVER_ERROR.code -> error(ApiStatus.INTERNAL_SERVER_ERROR.message)
                                ApiStatus.SERVER_NOT_FOUND.code -> error(ApiStatus.SERVER_NOT_FOUND.message)
                                ApiStatus.SERVICE_UNAVAILABLE.code -> error(ApiStatus.SERVICE_UNAVAILABLE.message)
                                ApiStatus.TIMEOUT_ERROR.code -> error(ApiStatus.TIMEOUT_ERROR.message)
                                ApiStatus.UNAUTHORIZED_ACCESS.code -> {
                                    error(ApiStatus.UNAUTHORIZED_ACCESS.message)
                                }
                                else -> {
                                    error("Something went wrong in response")
                                    /* val baseResponse = try {
                                     Gson().fromJson(it.charStream(), BaseResponse::class.java)
                                 } catch (e: ClassCastException) {
                                     response(null)
                                     BaseResponse<Any>()
                                 }
                                 if(toast) {
                                     when {
                                         !baseResponse.message.isNullOrEmpty() -> Toast.error(
                                             baseResponse.message
                                         )
                                         !baseResponse.error.isNullOrEmpty() -> Toast.error(
                                             baseResponse!!.error!!.values.first().toString()
                                         )
                                         else -> Toast.error("Something went wrong in response")
                                     }
                                 }*/
                                    response(null)
                                }
                            }
                        }
                    }
                } catch (e: Exception) {
                    e.printStackTrace()
                    when (e) {
                        is SocketTimeoutException -> error(ApiStatus.TIMEOUT_ERROR.message)
                        is UnknownHostException -> error(ApiStatus.INTERNAL_SERVER_ERROR.message + " Please contact admin...")
                        is ConnectException -> error(ApiStatus.CONNECT_ERROR.message)
                        else -> if (BuildConfig.DEBUG) error(e.message.toString() + " by Developer")
                    }
                }
            }

    fun hideLoading() = mCustomLoaderDialog.cancel()


    fun error(string: String) {
        Toast.makeText(applicationContext, string, Toast.LENGTH_SHORT).show()
    }

    fun isOnline(): Boolean {
        val connectivityManager =
                getSystemService(Context.CONNECTIVITY_SERVICE) as ConnectivityManager
        if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.Q) {
            val capabilities = connectivityManager.getNetworkCapabilities(connectivityManager.activeNetwork)
            if (capabilities != null) {
                if (capabilities.hasTransport(NetworkCapabilities.TRANSPORT_CELLULAR)) {
                    Log.i("Internet", "NetworkCapabilities.TRANSPORT_CELLULAR")
                    return true
                } else if (capabilities.hasTransport(NetworkCapabilities.TRANSPORT_WIFI)) {
                    Log.i("Internet", "NetworkCapabilities.TRANSPORT_WIFI")
                    return true
                } else if (capabilities.hasTransport(NetworkCapabilities.TRANSPORT_ETHERNET)) {
                    Log.i("Internet", "NetworkCapabilities.TRANSPORT_ETHERNET")
                    return true
                }
            }
        } else {
            val activeNetworkInfo = connectivityManager.activeNetworkInfo
            if (activeNetworkInfo != null && activeNetworkInfo.isConnected) {
                return true
            }
        }
        return false
    }

    fun convertImageFileToBase64(imageFile: File): String {
        return encodeImage(imageFile.path.toString())?:""
    }

    private  fun encodeImage(path: String): String? {
        val imagefile = File(path)
        var fis: FileInputStream? = null
        try {
            fis = FileInputStream(imagefile)
        } catch (e: FileNotFoundException) {
            e.printStackTrace()
        }
        var bitmap = BitmapFactory.decodeStream(fis)
        val stream = ByteArrayOutputStream()

        val x = ( bitmap.getHeight() / bitmap.getWidth() ).toFloat()

        val s43 = ( 4 / 3).toFloat()
        if (x == s43) {
            bitmap = Bitmap.createScaledBitmap(bitmap, 360, 480, true)
        } else {
            bitmap = Bitmap.createScaledBitmap(bitmap, 360, 640, true)
        }
        bitmap.compress(Bitmap.CompressFormat.JPEG, 100, stream)

        val byteArray: ByteArray = stream.toByteArray()


        if (byteArray.size > 160000) { //200KB
            bitmap.compress(Bitmap.CompressFormat.JPEG, 90, stream)
        }

        Log.e("IamgeSize", byteArray.size.toString() + " b")
        //bitmap.compress(Bitmap.CompressFormat.JPEG, 80, stream)
        val b = stream.toByteArray()
        //Base64.de
        return Base64.encodeToString(b, Base64.DEFAULT)
    }

    private fun encodeImage(bm: Bitmap): String? {
        val baos = ByteArrayOutputStream()
        bm.compress(Bitmap.CompressFormat.JPEG, 80, baos)
        val b = baos.toByteArray()
        return Base64.encodeToString(b, Base64.DEFAULT)
    }

}

fun TextInputLayout.isEmpty(): Boolean {

    if (editText == null) return true;

    if (editText?.text.toString().isNullOrEmpty()) {
        return true
    }

    return false
}

fun TextInputLayout.getText(): String {

    if (editText == null) return "";

    if (editText?.text.toString().isNullOrEmpty()) {
        return ""
    }

    return editText?.text.toString()
}

