package com.b2lmobitech.fieldcloudplus.expense

import android.content.Intent
import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import com.b2lmobitech.fieldcloudplus.R
import com.b2lmobitech.fieldcloudplus.databinding.ActivityExpenseBinding
import com.b2lmobitech.fieldcloudplus.databinding.ActivityExpenseDashboardBinding
import com.b2lmobitech.fieldcloudplus.expense.adapter.ReportsAdapter
//import kotlinx.android.synthetic.main.activity_expense_dashboard.*

class ExpenseDashboard : AppCompatActivity() {
    private lateinit var binding: ActivityExpenseDashboardBinding
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

//        setContentView(R.layout.activity_expense_dashboard)
        binding = ActivityExpenseDashboardBinding.inflate(layoutInflater)
        val view = binding.root
        setContentView(view)
        supportActionBar?.run {
            setDisplayHomeAsUpEnabled(true)
            setTitle("Expense Dashboard")
        }

        binding.recyclerReports.adapter = ReportsAdapter()


        binding.cardSubmittedReports.setOnClickListener {
            startActivity(Intent(this,SubmittedReportsActivity::class.java))
        }

        binding.cardUnSubmitted.setOnClickListener {
            startActivity(Intent(this,UnSubmittedReportsActivity::class.java))
        }

    }
}