package com.b2lmobitech.fieldcloudplus.expense

import android.app.DatePickerDialog
import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import com.b2lmobitech.fieldcloudplus.R
import com.b2lmobitech.fieldcloudplus.databinding.ActivityExpenseDashboardBinding
import com.b2lmobitech.fieldcloudplus.databinding.ActivityNewReportBinding
//import kotlinx.android.synthetic.main.activity_new_report.*
import java.text.SimpleDateFormat
import java.util.*

class NewReportActivity : BaseActivity("New Report") {
    private lateinit var binding: ActivityNewReportBinding
    private var startDate = Calendar.getInstance()
    private var endDate = Calendar.getInstance()

    override fun onCreate(savedInstanceState: Bundle?) {
//        setContentView(R.layout.activity_new_report)

        super.onCreate(savedInstanceState)
        binding = ActivityNewReportBinding.inflate(layoutInflater)
        val view = binding.root
        setContentView(view)
        binding.editStartDate.setOnClickListener {
            openStartDatePicker()
        }

        binding.editEndDate.setOnClickListener {
            openEndDatePicker()
        }

        binding.btnAddReport.setOnClickListener {
            addReport()
        }
    }

    private fun addReport() {
        val title = binding.editReportTitle.text.toString()
        val purpose = binding.editPurpose.text.toString()

        if (title.isEmpty()) {
            error("Enter Valid Title")
            return
        }

        if (purpose.isEmpty()) {
            error("Enter Valid Bussiness Purpose")
            return
        }

        if (binding.editStartDate.text.toString().isEmpty() || binding.editEndDate.text.toString().isEmpty()) {
            error("Enter Valid Dates")
            return
        }

        val sdf = SimpleDateFormat("YYYY-MM-dd")

        apiLaunch({
            showLoading()
            it.addReport(companyName, email, title,
                    sdf.format(Date(startDate.timeInMillis)),
                    sdf.format(Date(endDate.timeInMillis)), "drfat", purpose)
        }) {
            if (it == true) {
                error("Added Successfully")
                finish()
            } else {
                error("Something Went wrong")
            }
        }

    }

    private fun openStartDatePicker() {
        val y = startDate.get(Calendar.YEAR)
        val m = startDate.get(Calendar.MONTH)
        val d = startDate.get(Calendar.DAY_OF_MONTH)
        val datepickerdialog = DatePickerDialog(this, DatePickerDialog.OnDateSetListener { _, year, monthOfYear, dayOfMonth ->
            startDate.set(Calendar.YEAR, year)
            startDate.set(Calendar.MONTH, monthOfYear)
            startDate.set(Calendar.DAY_OF_MONTH, dayOfMonth)
            val date = Date(startDate.timeInMillis)
            binding.editStartDate.setText(SimpleDateFormat("dd-MM-YYYY").format(date))
            binding.editEndDate.setText("")
            openEndDatePicker()
        }, y, m, d)
        datepickerdialog.datePicker.maxDate = Calendar.getInstance().timeInMillis
        datepickerdialog.setTitle("From Date")
        datepickerdialog.show()
    }

    private fun openEndDatePicker() {
        val y = endDate.get(Calendar.YEAR)
        val m = endDate.get(Calendar.MONTH)
        val d = endDate.get(Calendar.DAY_OF_MONTH)
        val datepickerdialog = DatePickerDialog(this, DatePickerDialog.OnDateSetListener { _, year, monthOfYear, dayOfMonth ->
            endDate.set(Calendar.YEAR, year)
            endDate.set(Calendar.MONTH, monthOfYear)
            endDate.set(Calendar.DAY_OF_MONTH, dayOfMonth)
            val date = Date(endDate.timeInMillis)
            binding.editEndDate.setText(SimpleDateFormat("dd-MM-YYYY").format(date))
        }, y, m, d)
        datepickerdialog.datePicker.maxDate = Calendar.getInstance().timeInMillis
        datepickerdialog.datePicker.minDate = startDate.timeInMillis
        datepickerdialog.setTitle("To Date")
        datepickerdialog.show()
    }


}