package com.b2lmobitech.fieldcloudplus.expense

import android.content.Intent
import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import com.b2lmobitech.fieldcloudplus.R
import com.b2lmobitech.fieldcloudplus.databinding.ActivitySubmittedReportsBinding
import com.b2lmobitech.fieldcloudplus.databinding.ActivityUnSubmittedReportsBinding
import com.b2lmobitech.fieldcloudplus.expense.adapter.UnsubmittedReportAdapter
//import kotlinx.android.synthetic.main.activity_un_submitted_reports.*

class UnSubmittedReportsActivity : BaseActivity("Unsubmitted Reports") {

    private lateinit var adapter : UnsubmittedReportAdapter
    private lateinit var binding: ActivityUnSubmittedReportsBinding
    override fun onCreate(savedInstanceState: Bundle?) {
//        setContentView(R.layout.activity_un_submitted_reports)
        super.onCreate(savedInstanceState)
        binding = ActivityUnSubmittedReportsBinding.inflate(layoutInflater)
        val view = binding.root
        setContentView(view)
        adapter = UnsubmittedReportAdapter(emptyList())
        binding.recyclerView.adapter = adapter

        binding.fabAddReport.setOnClickListener {
            startActivity(Intent(this,NewReportActivity::class.java))
        }

    }

    override fun onResume() {
        super.onResume()
        getUnSubmittedReports()
    }

    private fun getUnSubmittedReports(){
        apiLaunch({
            it.getUnbumittedReports(companyName,email)
        }){
            adapter.list = it ?: emptyList()
            adapter.notifyDataSetChanged()
        }
    }

}