package com.b2lmobitech.fieldcloudplus.expense.api

import android.content.Context
import android.net.ConnectivityManager
import android.net.Network
import android.net.NetworkCapabilities
import android.net.NetworkRequest
import android.os.Build
import androidx.annotation.RequiresApi

enum class ApiStatus(val code: Int, val message: String) {
    SUCCESS(200, "Success"),
    UNAUTHORIZED_ACCESS(401, "OOPS!!! Your Access Key Expired"),
    SERVER_NOT_FOUND(404, "OOPS!!! Server Not Found, Please contact admin"),
    TIMEOUT_ERROR(408, "OOPS!!! Please Try again Later"),
    INTERNAL_SERVER_ERROR(500, "OOPS!!! Something went wrong"),
    SERVICE_UNAVAILABLE(503, "We are busy updating the Website for you and will be back shortly"),
    CONNECT_ERROR(0, "OOPS!!! Please check your internet connection")
}
