package com.goozi.customer.data.remote

import com.b2lmobitech.fieldcloudplus.BuildConfig
import com.google.gson.FieldNamingPolicy
import com.google.gson.GsonBuilder
import okhttp3.OkHttpClient
import okhttp3.logging.HttpLoggingInterceptor
import retrofit2.Retrofit
import retrofit2.converter.gson.GsonConverterFactory
import java.util.concurrent.TimeUnit

object RetrofitFactory {


    // okhttp logging interceptor
    private val loggingInterceptor = HttpLoggingInterceptor().apply {
        level = when (BuildConfig.DEBUG) {
            true -> HttpLoggingInterceptor.Level.BODY
            false -> HttpLoggingInterceptor.Level.NONE
        }
    }

    // OkhttpClient for building http request url
    private val client = OkHttpClient()
        .newBuilder()
        .addInterceptor(loggingInterceptor)
        .connectTimeout(120, TimeUnit.SECONDS)
        .readTimeout(120, TimeUnit.SECONDS)
        .retryOnConnectionFailure(true)
        .build()

    private val gson = GsonBuilder()
        .setDateFormat("yyyy-MM-dd HH:mm:ss")
        .setFieldNamingPolicy(FieldNamingPolicy.IDENTITY)
        .create()

    private fun retrofit(): Retrofit = Retrofit.Builder()
        .client(client)
        .baseUrl("http://fieldcloud.in/Eversendai/App/api/expense/")
        .addConverterFactory(GsonConverterFactory.create(gson))
        .build()

    val api: ApiHelper = retrofit().create(ApiHelper::class.java)
}