package com.b2lmobitech.fieldcloudplus.hcm

//import com.firebase.jobdispatcher.*
//import com.whiteelephant.monthpicker.MonthPickerDialog
//import kotlinx.android.synthetic.main.activity_attendance.*
import android.Manifest
import android.app.Activity
import android.app.AlertDialog
import android.content.Context
import android.content.Intent
import android.content.IntentSender.SendIntentException
import android.content.pm.PackageManager
import android.database.Cursor
import android.location.Address
import android.location.Geocoder
import android.location.LocationManager
import android.net.ConnectivityManager
import android.os.Bundle
import android.provider.Settings
import android.util.Log
import android.view.Menu
import android.view.MenuItem
import android.view.View
import android.view.animation.Animation
import android.view.animation.AnimationUtils
import android.widget.*
import androidx.appcompat.app.AppCompatActivity
import androidx.appcompat.widget.Toolbar
import androidx.core.app.ActivityCompat
import androidx.lifecycle.Observer
import androidx.lifecycle.ViewModelProvider
import androidx.work.BackoffPolicy
import androidx.work.Constraints
import androidx.work.Data
import androidx.work.NetworkType
import androidx.work.OneTimeWorkRequest
import androidx.work.OneTimeWorkRequestBuilder
import androidx.work.PeriodicWorkRequest
import androidx.work.PeriodicWorkRequestBuilder
import androidx.work.WorkManager
import androidx.work.workDataOf
import com.b2lmobitech.fieldcloudplus.Attendancemonthlysummary
import com.b2lmobitech.fieldcloudplus.R
import com.b2lmobitech.fieldcloudplus.databinding.ActivityAttendanceBinding
import com.b2lmobitech.fieldcloudplus.hcm.adapter.attendanceadapter
import com.b2lmobitech.fieldcloudplus.hcm.attendanceimage
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.entities.AttendenceEntity
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.entities.FacilityEntity
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.viewModel.DBViewModel
import com.b2lmobitech.fieldcloudplus.hcm.new_wroks.ChooseFacilityFragment
import com.b2lmobitech.fieldcloudplus.hcm.new_wroks.ChooseFacilityFragment.FacilitySelectedListener
import com.b2lmobitech.fieldcloudplus.hcm.others.LocationUpdate
import com.b2lmobitech.fieldcloudplus.hcm.sql.HcmDatabase
import com.b2lmobitech.fieldcloudplus.others.sql.sqlitehelper.sqldatabase
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue
import com.b2lmobitech.fieldcloudplus.others.utils.Preference
import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables
import com.b2lmobitech.fieldcloudplus.task.others.RequestProgress
import com.b2lmobitech.fieldcloudplus.utils.*
import com.google.android.gms.common.ConnectionResult
import com.google.android.gms.common.api.ApiException
import com.google.android.gms.common.api.GoogleApiClient.OnConnectionFailedListener
import com.google.android.gms.common.api.ResolvableApiException
import com.google.android.gms.location.*
import com.google.android.material.snackbar.Snackbar
import org.json.JSONArray
import org.json.JSONException
import org.json.JSONObject
import java.lang.System.*
import java.text.SimpleDateFormat
import java.util.*
import java.util.concurrent.TimeUnit

class Attendance : AppCompatActivity(), OnConnectionFailedListener {

    private lateinit var fab_open: Animation
    private lateinit var fab_close: Animation
    private lateinit var rotate_forward: Animation
    private lateinit var rotate_backward: Animation

    private var isFabOpen = false
    private var isBottom = false

    private var sublayout: RelativeLayout? = null
    private var attendancelistview: ListView? = null

    private var date = ArrayList<String>()
    private var presentdate = ArrayList<String>()
    private var time = ArrayList<String>()
    private var place = ArrayList<String>()
    private var status = ArrayList<String>()
    private var insynclist = ArrayList<String>()
    private var outsynclist = ArrayList<String>()

    private var todaydate: TextView? = null
    private var nowtime: TextView? = null
    private var indetails: TextView? = null
    private var outdetails: TextView? = null
    private var history: TextView? = null
    private var addattendancetext: TextView? = null
    private var addcalendartext: TextView? = null
    private var pull: TextView? = null
    private var totaldays: TextView? = null
    private var totalpresent: TextView? = null
    private var absent: TextView? = null
    private var leave: TextView? = null
    private var mycontext: Context? = null
    private var currentlocation = "0.0,0.0"
    private var currentlocationlaltitue = 0.0
    private var currentlocationlongitude = 0.0
    private var addresses: List<Address>? = null
    private var inbutton: Button? = null
    private var outbutton: Button? = null
    private var sdf: SimpleDateFormat? = null
    private var sdf2: SimpleDateFormat? = null
    private var mDbHelper: sqldatabase? = null
    private var registeredemailid: String? = null
    private var registeredcompany: String? = null
    private var attendacecheckin_cursor: Cursor? = null
    private var attendacecheckout_cursor: Cursor? = null


    private var checkintime: String? = null
    private val diff: String? = null
    private var month: String? = null
    private var day: String? = null
    private var snackBar: Snackbar? = null
    private var swipeContainer: androidx.swiperefreshlayout.widget.SwipeRefreshLayout? = null
    private var refreshicon: ImageView? = null

    private lateinit var mFusedLocationClient: FusedLocationProviderClient
    private lateinit var mLocationRequest: LocationRequest
    private lateinit var dbViewModel: DBViewModel

    private var totaldaysvalue = "0"
    private var today_totaldaysvalue = "0"
            private var leavevalue = "0"
    private var today_leavevalue = "0"
    private lateinit var binding: ActivityAttendanceBinding
    private lateinit var  workManager: WorkManager
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_attendance)
        binding = ActivityAttendanceBinding.inflate(layoutInflater)
        val view = binding.root
        setContentView(view)
        workManager = WorkManager.getInstance(this)
        date = ArrayList()
        time = ArrayList()
        place = ArrayList()
        status = ArrayList()
        insynclist = ArrayList()
        outsynclist = ArrayList()
        presentdate = ArrayList()
        mycontext = this

        globalvariables.Logoutsharedpreference = getSharedPreferences(globalvariables.LOGOUT_CHECKING, 0)
        registeredemailid = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_emailid, "")
        registeredcompany = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_companyname, "")
        mDbHelper = sqldatabase(mycontext)

        snackBar = Snackbar.make(findViewById(android.R.id.content), "Please check internet connection", Snackbar.LENGTH_INDEFINITE)
        binding.fab.setOnClickListener {
            //                Snackbar.make(view, "Replace with your own action", Snackbar.LENGTH_LONG)
            //                        .setAction("Action", null).show();
            animateFAB()
        }

        dbViewModel = ViewModelProvider.AndroidViewModelFactory.getInstance(application).create(DBViewModel::class.java)
        initToolBar()
        getWidgets()
        setViews()
        setListeners()
        getFacilities()
        setAdapter()
        getShifts()
        getpresent()
    }

    private fun getShifts(){
        val params: MutableMap<String, String> = HashMap()
        params["cname"] = Preference.getInstance(this).companyName

        MyRequestQueue.getInstance(this).addToQueue(HCMURL.GET_SHIFTS, params) { response ->
            try {
                val jsonArray = JSONArray(response)
                dbViewModel.addAllShits(jsonArray)
            } catch (e: JSONException) {
                e.printStackTrace()
            }
        }
    }

    private fun initToolBar(){
        val toolbar = findViewById<View>(R.id.toolbar) as Toolbar
        setSupportActionBar(toolbar)
        supportActionBar!!.setDisplayHomeAsUpEnabled(true)

            supportActionBar!!.setHomeAsUpIndicator(R.drawable.ic_action_backarrow);


    }

    private fun getWidgets() {
        //datepicker = (DatePicker) findViewById(R.id.datePicker);
        //private DatePicker datepicker;
        //datepicker = (DatePicker) findViewById(R.id.datePicker);
        //private DatePicker datepicker;

        val historylayout = findViewById<View>(R.id.historylayout) as RelativeLayout
        sublayout = findViewById<View>(R.id.sublayout) as RelativeLayout
        attendancelistview = findViewById<View>(R.id.attendancelistview) as ListView
        addattendancetext = findViewById<View>(R.id.addattendancetext) as TextView
        addcalendartext = findViewById<View>(R.id.addcalendartext) as TextView
        todaydate = findViewById<View>(R.id.date) as TextView
        nowtime = findViewById<View>(R.id.time) as TextView
        inbutton = findViewById<View>(R.id.`in`) as Button
        outbutton = findViewById<View>(R.id.out) as Button
        indetails = findViewById<View>(R.id.indetails) as TextView
        outdetails = findViewById<View>(R.id.outdetails) as TextView
        history = findViewById<View>(R.id.history) as TextView
        refreshicon = findViewById<View>(R.id.refreshicon) as ImageView
        pull = findViewById<View>(R.id.pull) as TextView
        totaldays = findViewById<View>(R.id.totaldays) as TextView
        totalpresent = findViewById<View>(R.id.totalpresent) as TextView
        absent = findViewById<View>(R.id.absent) as TextView
        leave = findViewById<View>(R.id.leave) as TextView
        fab_open = AnimationUtils.loadAnimation(applicationContext, R.anim.fab_open)
        fab_close = AnimationUtils.loadAnimation(applicationContext, R.anim.fab_close)
        rotate_forward = AnimationUtils.loadAnimation(applicationContext, R.anim.rotate_forward)
        rotate_backward = AnimationUtils.loadAnimation(applicationContext, R.anim.rotate_backward)
        swipeContainer = findViewById<View>(R.id.swipeContainer) as androidx.swiperefreshlayout.widget.SwipeRefreshLayout
    }

    private fun setListeners() {
        swipeContainer!!.setOnRefreshListener {
            setAdapter()
            if (isNetworkAvailable()) {
                syncCheckInData(true)
            }
            swipeContainer!!.isRefreshing = false
        }


        attendancelistview!!.onItemClickListener = AdapterView.OnItemClickListener { parent, view, position, id ->
            sublayout!!.visibility = View.VISIBLE
            isBottom = true
            var status_show: String
            var date_show: String
            var checkoutlocation_show: String
            var checkouttime_show: String
            var checkinlocation_show: String
            var checkintime_show: String

            val query = dbViewModel.getAttendance(date[position], currentShift)

            val observer = object :Observer<List<AttendenceEntity>>{
                override fun onChanged(t: List<AttendenceEntity>) {
                    query.removeObserver(this)
                    t?.firstOrNull()?.let {
                        todaydate!!.text = "Date: " + date!![position]
                        nowtime!!.text = ""
                        status_show = it.status
                        checkintime_show = it.checkintime
                        checkinlocation_show = it.checkinlocation
                        if (status_show.equals("IN", ignoreCase = true)) {
                            indetails!!.text = "You have successfully 'Checked In' at $checkintime_show from $checkinlocation_show"
                            outdetails!!.text = ""
                        } else {
                            checkouttime_show = it.checkouttime
                            checkoutlocation_show = it.checkoutlocation
                            indetails!!.text = "You have successfully 'Checked In' at $checkintime_show from $checkinlocation_show"
                            outdetails!!.text = "You have successfully 'Checked Out' at $checkouttime_show from $checkoutlocation_show"
                        }
                    }
                }


            }
            query.observe(this, observer)
        }
        /*  fab2.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                final Calendar c = Calendar.getInstance();
                int mYear = c.get(Calendar.YEAR); // current year
                int mMonth = c.get(Calendar.MONTH); // current month
                int mDay = c.get(Calendar.DAY_OF_MONTH); // current day
                // date picker dialog
                DatePickerDialog datePickerDialog = new DatePickerDialog(mycontext,
                        new DatePickerDialog.OnDateSetListener() {

                            @Override
                            public void onDateSet(DatePicker view, int year,
                                                  int monthOfYear, int dayOfMonth) {
                                monthOfYear = monthOfYear + 1;
                                if (monthOfYear < 10) {
                                    month = "0" + monthOfYear;
                                } else {
                                    month = "" + monthOfYear;
                                }
                                if (dayOfMonth < 10) {

                                    day = "0" + dayOfMonth;
                                } else {
                                    day = "" + dayOfMonth;
                                }
                                attendancedatewise_cursor = mDbHelper.get_attendancetable_datewise(registeredcompany, registeredemailid, year + "-" + month + "-" + day);
                                setAdapter(attendancedatewise_cursor);
                            }
                        }, mYear, mMonth, mDay);
                datePickerDialog.show();
            }
        });*/

        binding.fab2!!.setOnClickListener {
//            val c = Calendar.getInstance()
//            val mYear = c[Calendar.YEAR] // current year
//            val mMonth = c[Calendar.MONTH] // current month
//            val mDay = c[Calendar.DAY_OF_MONTH] // current day
//            // date picker dialog
//            val datePickerDialog = DatePickerDialog(this, DatePickerDialog.OnDateSetListener { view, year, monthOfYear, dayOfMonth ->
//                c[Calendar.YEAR] = year
//                c[Calendar.MONTH] = monthOfYear
//                c[Calendar.DAY_OF_MONTH] = dayOfMonth
//                setAdapter(c.format("yyyy-MM-dd"))
//            }, mYear, mMonth, mDay)
//
//            datePickerDialog.show()
            val intent = Intent(mycontext, Attendancemonthlysummary::class.java)
            startActivity(intent)
//            createDialogWithoutDateField()!!.show()
            //---month selection--
//            var  today:Calendar = Calendar.getInstance()
//            val builder = MonthPickerDialog.Builder(this, { selectedMonth, selectedYear ->
////                Log.d(TAG, "selectedMonth : $selectedMonth selectedYear : $selectedYear")
////                Toast.makeText(this, "Date set with month" + getMonthString(selectedMonth) + " year $selectedYear", Toast.LENGTH_SHORT).show()
//                val intent = Intent(mycontext, Attendancemonthlysummary::class.java)
//                intent.putExtra("selectedMonth", (selectedMonth+1).toString() )
//                intent.putExtra("selectedyear", selectedYear.toString() )
//                       startActivity(intent)
//            }, today.get(Calendar.YEAR), today.get(Calendar.MONTH))
//            val yearFormat: DateFormat = SimpleDateFormat("YYYY")
//            val monthFormat: DateFormat = SimpleDateFormat("MM")
//            val date = Date()
////            Log.d("Month", dateFormat.format(date))
//            builder.setActivatedMonth(monthFormat.format(date).toInt()!! - 1)
//                    .setMinYear(1980)
//                    .setActivatedYear(yearFormat.format(date).toInt()!!)
//                    .setMaxYear(2200)
//                    .setTitle("Select Month & Year")
////                    .setMonthRange(Calendar.FEBRUARY, Calendar.NOVEMBER) // .setMaxMonth(Calendar.OCTOBER)
//                    // .setYearRange(1890, 1890)
//                    // .setMonthAndYearRange(Calendar.FEBRUARY, Calendar.OCTOBER, 1890, 1890)
//                    //.showMonthOnly()
//                    // .showYearOnly()
//                    .setOnMonthChangedListener { selectedMonth ->
////                        Log.d(TAG, "Selected month : $selectedMonth")
//                        // Toast.makeText(MainActivity.this, " Selected month : " + selectedMonth, Toast.LENGTH_SHORT).show();
//                    }
//                    .setOnYearChangedListener { selectedYear ->
////                        Log.d(TAG, "Selected year : $selectedYear")
//                        // Toast.makeText(MainActivity.this, " Selected year : " + selectedYear, Toast.LENGTH_SHORT).show();
//                    }
//                    .build()
//                    .show()
//            //---month selection----
        }

        binding.fab1!!.setOnClickListener {
            if (isBottom) {
                sublayout!!.visibility = View.GONE
                isBottom = false
            } else {
                sublayout!!.visibility = View.VISIBLE
                isBottom = true
            }
            nowtime!!.text = "Time: " + sdf!!.format(Date())
            todaydate!!.text = "Date: " + sdf2!!.format(Date())
            var status_show: String
            var date_show: String
            var checkoutlocation_show: String
            var checkouttime_show: String
            var checkinlocation_show: String
            var checkintime_show: String

            val query = dbViewModel.getAttendance(sdf2!!.format(Date()))
            val observer = object :Observer<List<AttendenceEntity>>{
                override fun onChanged(t: List<AttendenceEntity>) {
                    query.removeObserver(this)
                    t?.firstOrNull()?.let {
                        todaydate!!.text = "Date: ${sdf2!!.format(Date())}"
                        nowtime!!.text = ""
                        status_show = it.status
                        checkintime_show = it.checkintime
                        checkinlocation_show = it.checkinlocation
                        if (status_show.equals("IN", ignoreCase = true)) {
                            indetails!!.text = "You have successfully 'Checked In' at $checkintime_show from $checkinlocation_show"
                            outdetails!!.text = ""
                        } else {
                            checkouttime_show = it.checkouttime
                            checkoutlocation_show = it.checkintime
                            indetails!!.text = "You have successfully 'Checked In' at $checkintime_show from $checkinlocation_show"
                            outdetails!!.text = "You have successfully 'Checked Out' at $checkouttime_show from $checkoutlocation_show"
                        }
                    }
                }
            }
            query.observe(this, observer)
        }

        inbutton!!.setOnClickListener {
            try {
                getFacilitiesOffline(true)
            }catch (E: Exception)
            {
                Toast.makeText(applicationContext, E.toString(), Toast.LENGTH_SHORT).show()
            }
           /* getCurrentShift { isEmpty, shiftId ->
                if(isEmpty || shiftId.isNotEmpty()){
                    getFacilitiesOffline(true)
                }else{
                    Toast.makeText(applicationContext,"No Shifts available at this time",Toast.LENGTH_SHORT).show()
                }
            }*/
        }
        outbutton!!.setOnClickListener { getFacilitiesOffline(false) }
    }

    private fun getFacilities() {
        val params: MutableMap<String, String> = HashMap()
        params["email"] = Preference.getInstance(this).emailId

        MyRequestQueue.getInstance(this).addToQueue(HCMURL.GET_FACILITIES, params) { response ->
            try {
                val jsonArray = JSONArray(response)
                dbViewModel.addAllFacilities(jsonArray)
            } catch (e: JSONException) {
                e.printStackTrace()
            }
        }
    }


    private var currentShift = ""

    private fun getCurrentShift(onResult: (isEmpty: Boolean, shiftId: String) -> Unit){
        val livedata = dbViewModel.getSifts()

        livedata.observe(this){
            var shitId = ""
            if(it.isNullOrEmpty().not()) {
                it.forEach {
                    val date = Date().string("dd/MM/yyyy")
                    val startTime = date.plus(" ").plus(it.timeFrom).toDate(DateConstant.DATE_TIME_FORMAT)
                    val endTime = date.plus(" ").plus(it.timeto).toDate(DateConstant.DATE_TIME_FORMAT)

                    if (currentTimeMillis() >= startTime.time && currentTimeMillis() <= endTime.time) {
                        shitId = it.shiftId
                    }
                }
                currentShift = shitId
                onResult.invoke(false, shitId)
            }else{
                onResult.invoke(true, shitId)
            }
            livedata.removeObservers(this)
        }
    }

    private fun getFacilitiesOffline(checkIn: Boolean) {
        dbViewModel.getAllFacilities().removeObservers(this)

        dbViewModel.getAllFacilities().observe(this, Observer { facilityEntities ->
            dbViewModel.getAllFacilities().removeObservers(this)
            showChooseFacilityDialog(facilityEntities!!, checkIn)
        })
    }

    private val facilityEntity: FacilityEntity? = null
    private var geoFenceEnabled = false
    private var geoLat = 0.0
    private var geoLon = 0.0
    private var geoDistance = 0
    private var geoFacility = "NA"

    private fun showChooseFacilityDialog(facilityEntities: List<FacilityEntity>?, checkIn: Boolean) {
        val chooseFacilityFragment = ChooseFacilityFragment()
        chooseFacilityFragment.setfacilityEntities(facilityEntities!!)
        val facilitySelectedListener: FacilitySelectedListener = object : FacilitySelectedListener {
            override fun onFacilitySelected(facilityEntity: FacilityEntity) {
                if (facilityEntity.geofencing.equals("enable", ignoreCase = true)) {
                    geoFenceEnabled = true
                    if(facilityEntity.latitude.toString().equals("no data available"))
                    {
                        geoLat = 0.0
                    }
                    else {
                        geoLat = facilityEntity.latitude.toDouble()
                    }
                    if(facilityEntity.longitude.toString().equals("no data available"))
                    {
                        geoLon = 0.0
                    }
                    else {

                        geoLon = facilityEntity.longitude.toDouble()
                    }
                    geoDistance = facilityEntity.geo_distance.toInt()
                    geoFacility = facilityEntity.atmid
                } else {
                    geoFenceEnabled = false
                }

                if (chooseFacilityFragment.isAdded) chooseFacilityFragment.dismiss()

                if (checkIn) {
                    preCheckIn()
                } else {
                    preCheckOut()
                }
            }
        }
        chooseFacilityFragment.setFacilitySelectedListener(facilitySelectedListener)
        if (facilityEntities!!.isEmpty()) {
            if (checkIn) {
                preCheckIn()
            } else {
                preCheckOut()
            }
        }
                else if (facilityEntities!!.size == 1) {
            facilitySelectedListener.onFacilitySelected(facilityEntities[0])
        } else {
            chooseFacilityFragment.show(supportFragmentManager, "facility_dialog")
        }
    }

    private fun setViews() {
        sdf = SimpleDateFormat("HH:mm:ss")
        nowtime!!.text = "Time: " + sdf!!.format(Date())
        sdf2 = SimpleDateFormat("yyyy-MM-dd")
//        sdf2 = SimpleDateFormat("dd MMM yyyy")
        todaydate!!.text = "Date: " + sdf2!!.format(Date())
        setAdapter()
    }

    fun animateFAB() {
        if (isFabOpen) {
            binding.fab!!.startAnimation(rotate_backward)
            binding.fab1!!.startAnimation(fab_close)
            binding.fab2!!.startAnimation(fab_close)
            addattendancetext!!.visibility = View.GONE
            addcalendartext!!.visibility = View.GONE
            binding.fab1!!.isClickable = false
            binding.fab2!!.isClickable = false
            isFabOpen = false
            // Log.d("Raj", "close");
        } else {
            binding.fab!!.startAnimation(rotate_forward)
            binding.fab1!!.startAnimation(fab_open)
            binding.fab2!!.startAnimation(fab_open)
            addattendancetext!!.visibility = View.VISIBLE
            addcalendartext!!.visibility = View.VISIBLE
            binding.fab1!!.isClickable = true
            binding.fab2!!.isClickable = true
            isFabOpen = true
            // Log.d("Raj","open");
        }
    }

    override fun onDestroy() {
        mDbHelper!!.close()
        super.onDestroy()
    }

    override fun onCreateOptionsMenu(menu: Menu): Boolean { // Inflate the menu; this adds items to the action bar if it is present.
        menuInflater.inflate(R.menu.attendance, menu)
        return super.onCreateOptionsMenu(menu)
        // return true;
    }

    override fun onOptionsItemSelected(item: MenuItem): Boolean { // Handle action bar item clicks here. The action bar will
// automatically handle clicks on the Home/Up button, so long
// as you specify a parent activity in AndroidManifest.xml.
        val id = item.itemId
        if (id == R.id.attendance_sync) {
            try {
                if (isNetworkAvailable()) { // Toast.makeText(mycontext, "Please wait..", Toast.LENGTH_LONG).show();
                    Snackbar.make(findViewById(android.R.id.content), "Please wait..", Snackbar.LENGTH_LONG)
                            .setAction("Action", null).show()
                    syncCheckInData(true)
                } else {
                    snackBar!!.dismiss()
                    snackBar = Snackbar.make(findViewById(android.R.id.content), "Please check internet connection", Snackbar.LENGTH_INDEFINITE)
                    toast()
                }
            } catch (e: Exception) { // TODO Auto-generated catch block
                e.printStackTrace()
            }
            return true
        }
        return super.onOptionsItemSelected(item)
    }

    override fun onConnectionFailed(connectionResult: ConnectionResult) {}

    //Log.d("wifi connectivity", "wifi not connected");// do your stuff
    //			    Log.d("wifi connectivity", "connected");
    // if no network is available networkInfo will be null
    // otherwise check if we are connected

    fun isNetworkAvailable():Boolean {
            val cm = mycontext!!.getSystemService(Context.CONNECTIVITY_SERVICE) as ConnectivityManager
            val networkInfo = cm.activeNetworkInfo
            // if no network is available networkInfo will be null
// otherwise check if we are connected
            if (networkInfo != null && networkInfo.isConnected) {
                if (cm.getNetworkInfo(ConnectivityManager.TYPE_WIFI)?.isConnectedOrConnecting == true) { // do your stuff
//			    Log.d("wifi connectivity", "connected");
                } else { //			    	   Log.d("wifi connectivity", "wifi not connected");
                }
                return true
            }
            return false
        }

    override fun onActivityResult(requestCode: Int, resultCode: Int, data: Intent?) {
        super.onActivityResult(requestCode, resultCode, data)
        if (requestCode == 1) {
            if (resultCode == Activity.RESULT_OK) {
                val result = data!!.getStringExtra("result")
                indetails!!.text = result
                history!!.visibility = View.GONE
                refreshicon!!.visibility = View.GONE
                pull!!.visibility = View.GONE
               // dbViewModel.getAllAttendance()
                //----getcurrentmonth--
                val currendate = Date()
                val formatter = SimpleDateFormat("yyyy-MM-dd")
                val str = formatter.format(currendate)
                val startdate = str.substring(0, str.length - 2) + "01"
                val c = Calendar.getInstance()
                c[Calendar.DAY_OF_MONTH] = c.getActualMaximum(Calendar.DAY_OF_MONTH)
                val enddate = formatter.format(c.getTime())
                dbViewModel.getcurrentmonthpresent(startdate,enddate)
                //--getcurrentmonth--
                startLcoationUpdates()
                setAdapter()
                if (isNetworkAvailable()) {
                    syncCheckInData(syncCheckoutData = false)
                }
            }
        }else if(requestCode == 2 || requestCode == 4) {
            when (resultCode) {
                Activity.RESULT_OK -> if (requestCode == 2) {
                    doCheckIn()
                } else {
                    findlocation(4)
                }
                Activity.RESULT_CANCELED -> {
                    snackBar!!.dismiss()
                    snackBar = Snackbar.make(findViewById(android.R.id.content), "Please enable location", Snackbar.LENGTH_INDEFINITE)
                    RequestProgress.getInstance(this).hideProgressBar()
                }
                else -> {
                }
            }
        }
    }

    private fun toast() {
        snackBar!!.setAction("CLOSE") { snackBar!!.dismiss() }.setActionTextColor(resources.getColor(android.R.color.holo_blue_dark)).show()
    }

    override fun onResume() {
        super.onResume()
    }

    private fun preCheckIn() {

        todaydate!!.text = "Date: ".plus(sdf2!!.format(Date()))
        nowtime!!.text = "Time: " + sdf!!.format(Date())


        val query = dbViewModel.getAttendance(sdf2!!.format(Date()), currentShift)

        val observer = object : Observer<List<AttendenceEntity>>{
            override fun onChanged(it: List<AttendenceEntity>) {
                query.removeObserver(this)
                if( it?.isEmpty() == true ){
                    connectLocation(2)
                }else{
                    it?.lastOrNull()?.let { attendanceEntity ->
                        val status_show: String
                        val checkoutlocation_show: String
                        val checkouttime_show: String
                        val checkinlocation_show: String
                        val checkintime_show: String

                        status_show = attendanceEntity.status
                        checkintime_show = attendanceEntity.checkintime
                        checkinlocation_show = attendanceEntity.checkinlocation
                        indetails!!.text = "You have successfully 'Checked In' at $checkintime_show from $checkinlocation_show"
                        outdetails!!.text = ""

                        if (!status_show.equals("IN", ignoreCase = true)) {
                            checkouttime_show = attendanceEntity.checkouttime
                            checkoutlocation_show = attendanceEntity.checkoutlocation
                            outdetails!!.text = "You have successfully 'Checked Out' at $checkouttime_show from $checkoutlocation_show"
                        }
                        snackBar!!.dismiss()
                        snackBar = Snackbar.make(findViewById(android.R.id.content), "you are already checked in", Snackbar.LENGTH_INDEFINITE)
                        toast()
                    }
                }
            }

        }

        query.observe(this, observer)

    }

    private fun doCheckIn() {
        indetails!!.text = "Please take attendance"
        outdetails!!.text = ""
        val onedayvalidation1 = mDbHelper!!.get_leavetable_validationforoneday1(registeredcompany, registeredemailid, sdf2!!.format(Date()))
        if (onedayvalidation1.count == 0) {
            val onedayvalidation2 = mDbHelper!!.get_leavetable_validationforoneday2(registeredcompany, registeredemailid, sdf2!!.format(Date()))
            if (onedayvalidation2.count == 0) {
                // indetails.setText("You have successfully 'Checked In' at " + sdf.format(new Date()) + " from " + currentlocationlaltitue + " , " + currentlocationlongitude);
//mDbHelper.insert_attendancetable(registeredcompany, registeredemailid, sdf2.format(new Date()), sdf.format(new Date()), "", currentlocationlaltitue + "," + currentlocationlongitude, "", "IN", "","No","No");
                val intent = Intent(mycontext, attendanceimage::class.java)
                val extras = Bundle()
                extras.putString("companyname", registeredcompany)
                extras.putString("emailid", registeredemailid)
                extras.putString("date", sdf2!!.format(Date()))
                extras.putString("checkintime", sdf!!.format(Date()))
                extras.putString("checkouttime", "")
                if (currentlocation.equals("Not found", ignoreCase = true)) {
                    extras.putString("checkinlocation", "$currentlocationlaltitue,$currentlocationlongitude")
                } else {
                    extras.putString("checkinlocation", currentlocation)
                }
                extras.putString("checkoutlocation", "")
                extras.putString("status", "IN")
                extras.putString("totaltime", "")
                extras.putString("Insync", "No")
                extras.putString("Outsync", "No")
                extras.putString("display", "You have successfully 'Checked In' at " + sdf!!.format(Date()) + " from " + currentlocationlaltitue + " , " + currentlocationlongitude)
                extras.putBoolean("geo", geoFenceEnabled)
                extras.putDouble("lat", geoLat)
                extras.putDouble("lon", geoLon)
                extras.putInt("distance", geoDistance)
                extras.putString("facility", geoFacility)
                extras.putString("shiftId", currentShift)
                intent.putExtras(extras)
                startActivityForResult(intent, 1)
                place!!.add("$currentlocationlaltitue , $currentlocationlongitude")
                //---
            }else{
                snackBar!!.dismiss()
                snackBar = Snackbar.make(findViewById(android.R.id.content), "" +
                        "You Already applied leave for this day.So you can't able to 'check in' today", Snackbar.LENGTH_INDEFINITE)
                toast()
            }
            onedayvalidation2.close()
        } else  //applied leave on the same day
        {
            snackBar!!.dismiss()
            snackBar = Snackbar.make(findViewById(android.R.id.content), "You already applied leave for this day.So you can't able to 'check in' today", Snackbar.LENGTH_INDEFINITE)
            toast()
        }
        onedayvalidation1.close()
    }

    private fun preCheckOut() {
        todaydate!!.text = "Date: " + sdf2!!.format(Date())
        nowtime!!.text = "Time: " + sdf!!.format(Date())

        todaydate!!.text = "Date: " + sdf2!!.format(Date())
        nowtime!!.text = "Time: " + sdf!!.format(Date())

        val query = dbViewModel.getAttendance(sdf2!!.format(Date()), currentShift)
        val observer = object : Observer<List<AttendenceEntity>>{

            override fun onChanged(it: List<AttendenceEntity>) {
                query.removeObserver(this)
                if(it == null || it.size == 0){
                    snackBar!!.dismiss()
                    snackBar = Snackbar.make(findViewById(android.R.id.content), "please do check in first", Snackbar.LENGTH_INDEFINITE)
                    toast()
                }else{
                    it?.lastOrNull()?.let { attendanceEntity ->
                        val status_show: String
                        val checkoutlocation_show: String
                        val checkouttime_show: String
                        val checkinlocation_show: String
                        val checkintime_show: String

                        status_show = attendanceEntity.status
                        checkintime_show = attendanceEntity.checkintime
                        checkinlocation_show = attendanceEntity.checkinlocation
                        indetails!!.text = "You have successfully 'Checked In' at $checkintime_show from $checkinlocation_show"
                        outdetails!!.text = ""

                        if (!status_show.equals("In", ignoreCase = true)) {
                            checkouttime_show = attendanceEntity.checkouttime
                            checkoutlocation_show = attendanceEntity.checkoutlocation
                            outdetails!!.text = "You have successfully 'Checked Out' at $checkouttime_show from $checkoutlocation_show"
                            snackBar!!.dismiss()
                            snackBar = Snackbar.make(findViewById(android.R.id.content), "you are already checked out today", Snackbar.LENGTH_INDEFINITE)
                            toast()
                        }else{
                            connectLocation(4)
                        }
                    }
                }
            }

        }
        query.observe(this, observer)
    }

    private fun doCheckOut() {

        val query =  dbViewModel.getAttendance(sdf2!!.format(Date()), currentShift)
        val observer = object : Observer<List<AttendenceEntity>> {
            override fun onChanged(it: List<AttendenceEntity>) {
                query.removeObserver(this)
                val checkouttime = sdf!!.format(Date())
                val Date1 = sdf!!.parse(it?.first()?.checkintime)
                val Date2 = sdf!!.parse(checkouttime)
                var diffmillis = Date2.time - Date1.time
                val secondsInMilli: Long = 1000
                val minutesInMilli = 1000 * 60.toLong()
                val hoursInMilli = 1000 * 60 * 60.toLong()
                val daysInMilli = 1000 * 60 * 60 * 24.toLong()
                diffmillis = diffmillis % daysInMilli
                val Hours = diffmillis / hoursInMilli
                diffmillis = diffmillis % hoursInMilli
                val Mins = diffmillis / minutesInMilli
                diffmillis = diffmillis % minutesInMilli
                val secs = diffmillis / secondsInMilli
                val hoursvalue: String
                hoursvalue = if (Hours < 10) {
                    "0$Hours"
                } else {
                    "" + Hours
                }
                val minutesvalue: String
                minutesvalue = if (Mins < 10) {
                    "0$Mins"
                } else {
                    "" + Mins
                }
                val secondsvalue: String
                secondsvalue = if (secs < 10) {
                    "0$secs"
                } else {
                    "" + secs
                }
                val totaltime = "$hoursvalue:$minutesvalue:$secondsvalue"
                //----
                if (currentlocation.equals("Not found", ignoreCase = true)) {
                    outdetails!!.text = "You have successfully 'Checked Out' at " + sdf!!.format(Date()) + " from " + currentlocationlaltitue + " , " + currentlocationlongitude
                    place[0] = "$currentlocationlaltitue,$currentlocationlongitude"
                } else {
                    outdetails!!.text = "You have successfully 'Checked Out' at " + sdf!!.format(Date()) + " from " + currentlocation
                    place[0] = currentlocation
                }

                dbViewModel.updateCheckout(checkouttime = checkouttime, checkoutlocation = currentlocation, toaltime = totaltime, id = it?.last()?.id!!, facility_id_out = geoFacility, status = "Present", completedCallBack = object : DBViewModel.CompletedCallBack {
                    override fun onTaskCompleted() {
                        stopLocationUpdates()
                        setAdapter()
                        history!!.visibility = View.GONE
                        refreshicon!!.visibility = View.GONE
                        pull!!.visibility = View.GONE
                        if (isNetworkAvailable()) {
                            syncCheckInData(syncCheckoutData = true)
                        }
                    }
                })
            }
        }
        query.observe(this, observer)
    }

    private fun setAdapter(selectedDate: String = "") {

        try {
            runOnUiThread {

                val currendate = Date()
                val formatter = SimpleDateFormat("yyyy-MM-dd")
                val str = formatter.format(currendate)
                val startdate = str.substring(0, str.length - 2) + "01"
                val c = Calendar.getInstance()
                c[Calendar.DAY_OF_MONTH] = c.getActualMaximum(Calendar.DAY_OF_MONTH)
                val enddate = formatter.format(c.getTime())
                dbViewModel.getcurrentmonthpresent(startdate,enddate).observeForever {
//            dbViewModel.getAllAttendance(selectedDate).observeForever {
                try {
                    history!!.visibility = View.GONE
                    refreshicon!!.visibility = View.GONE
                    pull!!.visibility = View.GONE

                    date.clear()
                    place.clear()
                    status.clear()
                    time.clear()
                    insynclist.clear()
                    outsynclist.clear()
                    it?.forEach {
                        date.add(it.date)
                        if (it.checkouttime.equals("00:00:00", ignoreCase = true)
                                || it.checkouttime.equals("", ignoreCase = true)) {
                            place!!.add(it.checkinlocation)
                        } else {
                            place!!.add(it.checkoutlocation)
                        }
                        status.add(it.status)
                        time.add(it.totaltime)
                        insynclist.add(it.INSYNC)
                        outsynclist.add(it.OUTSYNC)
                    }
                    val adapter = attendanceadapter(this, date, time, place, status, insynclist, outsynclist)
                    val parcelable = attendancelistview!!.onSaveInstanceState()
                    attendancelistview!!.adapter = adapter
                    if (parcelable != null) {
                        attendancelistview!!.onRestoreInstanceState(parcelable)
                    }
                }catch (e: Exception){
                    e.printStackTrace()
                }
            }
            }
        } catch (e: Exception) {
            e.printStackTrace()
        }
    }

    private fun syncCheckInData(syncCheckoutData: Boolean) {
        snackBar!!.dismiss()
        Snackbar.make(findViewById(android.R.id.content), "Please wait..", Snackbar.LENGTH_SHORT)
                .setAction("Action", null).show()

        val query = dbViewModel.getCheckInNotSynced()

        val observer = object:Observer<List<AttendenceEntity>>{
            override fun onChanged(it: List<AttendenceEntity>) {
                query.removeObserver(this)
                if(it == null || it.isEmpty()){
                    Log.d("CheckIn", "Check In Data Empty")
                    snackBar?.dismiss()
                    if (syncCheckoutData) {
                        syncCheckOutData()
                    }
                }else{

                    val params: MutableMap<String, String> = HashMap()
                    dbViewModel.attendenceToJSON(it, isCheckIn = true).toString().let {
                        Log.d("json", it)
                    }
                    params["JSON"] = dbViewModel.attendenceToJSON(it, isCheckIn = true).toString()
                    MyRequestQueue.getInstance(this@Attendance).addToQueue(HCMURL.INSERT_ATTENDANCE, params) { response ->
                        try {
                            val jsonObject = JSONObject(response)
                            dbViewModel.updateAttendanceSynced(jsonObject.getJSONArray("list"),
                                    completedCallBack = object : DBViewModel.CompletedCallBack {
                                        override fun onTaskCompleted() {
                                            runOnUiThread {
                                                snackBar!!.dismiss()
                                                snackBar = Snackbar.make(findViewById(android.R.id.content), "Data is synced.", Snackbar.LENGTH_INDEFINITE)
                                                toast()
                                                setAdapter()
                                                syncCheckInData(syncCheckoutData)
                                            }
                                        }

                                    })
                        } catch (e: JSONException) {
                            e.printStackTrace()
                        }
                    }
                }
            }

        }
        runOnUiThread {
            try {
                query.observe(this@Attendance, observer)
            } catch (e: Exception) {
            }
        }

    }

    private fun syncCheckOutData() {
        snackBar!!.dismiss()
        Snackbar.make(findViewById(android.R.id.content), "Please wait..", Snackbar.LENGTH_SHORT)
                .setAction("Action", null).show()
        val params: MutableMap<String, String> = HashMap()

        Log.d("call", "check_out")

        val query = dbViewModel.getCheckOutNotSynced()
        val observer = object:Observer<List<AttendenceEntity>>{
            override fun onChanged(it: List<AttendenceEntity>) {
                query.removeObserver(this)
                if(it == null || it.isEmpty()) {
                    snackBar?.dismiss()
                }else{
                    params["JSON"] = dbViewModel.attendenceToJSON(it, isCheckIn = false).toString()
                    MyRequestQueue.getInstance(this@Attendance).addToQueue(HCMURL.UPDATE_ATTENDANCE, params) { response ->
                        try {
                            val jsonObject = JSONObject(response)
                            dbViewModel.updateAttendanceSynced(jsonObject.getJSONArray("list"), object : DBViewModel.CompletedCallBack {
                                override fun onTaskCompleted() {
                                    snackBar?.dismiss()
                                    snackBar = Snackbar.make(findViewById(android.R.id.content), "Data is synced.", Snackbar.LENGTH_INDEFINITE)
                                    toast()
                                    setAdapter()
                                }
                            })

                        } catch (e: JSONException) {
                            e.printStackTrace()
                        }
                    }
                }
            }
        }
        query.observe(this, observer)
    }

    var locationManager: LocationManager? = null

    fun connectLocation(REQUEST_CHECK_SETTINGS: Int) {
        RequestProgress.getInstance(this).showProgressBar()
        val locationRequest = LocationRequest.create()
        locationRequest.priority = LocationRequest.PRIORITY_HIGH_ACCURACY
        locationRequest.interval = 10000
        locationRequest.fastestInterval = 10000 / 2.toLong()
        locationRequest.numUpdates = 1
        val builder = LocationSettingsRequest.Builder().addLocationRequest(locationRequest)
        builder.setAlwaysShow(true)
        val task = LocationServices.getSettingsClient(this).checkLocationSettings(builder.build())

        task.addOnCompleteListener { task ->
            try {
                task.getResult(ApiException::class.java)
                // All location settings are satisfied. The client can initialize location
                if (REQUEST_CHECK_SETTINGS == 2) {
                    doCheckIn()
                    RequestProgress.getInstance(this@Attendance).hideProgressBar()
                }else {
                    findlocation(REQUEST_CHECK_SETTINGS)
                }
            } catch (exception: ApiException) {
                when (exception.statusCode) {
                    LocationSettingsStatusCodes.RESOLUTION_REQUIRED -> try {
                        val resolvable = exception as ResolvableApiException
                        resolvable.startResolutionForResult(
                                this@Attendance,
                                REQUEST_CHECK_SETTINGS)
                    } catch (e: SendIntentException) { // Ignore the error.
                    } catch (e: ClassCastException) { // Ignore, should be an impossible error.
                    }
                }
            }
        }
    }

    //----Location
    fun findlocation(REQUEST_CHECK_SETTINGS: Int) {
        try {
            val geocoder = Geocoder(mycontext!!, Locale.getDefault())
            //--location
            val locationManager = mycontext!!.getSystemService(Context.LOCATION_SERVICE) as LocationManager
            mFusedLocationClient = LocationServices.getFusedLocationProviderClient(this)
            if (ActivityCompat.checkSelfPermission(this, Manifest.permission.ACCESS_FINE_LOCATION) != PackageManager.PERMISSION_GRANTED && ActivityCompat.checkSelfPermission(this, Manifest.permission.ACCESS_COARSE_LOCATION) != PackageManager.PERMISSION_GRANTED) {
                return
            }
            mLocationRequest = LocationRequest()
            mLocationRequest.priority = LocationRequest.PRIORITY_HIGH_ACCURACY
            val UPDATE_INTERVAL = 10 * 1000.toLong()
            mLocationRequest.interval = UPDATE_INTERVAL
            val FASTEST_INTERVAL: Long = 1000
            mLocationRequest.fastestInterval = FASTEST_INTERVAL
            mLocationRequest.maxWaitTime = 2000
            mLocationRequest.numUpdates = 1
            mLocationRequest.setExpirationDuration(5000)

            val locationCallback: LocationCallback = object : LocationCallback() {
                override fun onLocationResult(locationResult: LocationResult) {
                    if (locationResult.locations.size == 0) {
                        Log.e("Location", "No lcoations found")
                        return
                    }
                    val location = locationResult.lastLocation
                    //Place current location marker
                    Log.e("Location", location?.latitude.toString() + "" + location?.longitude)
                    currentlocationlaltitue = location?.latitude?:0.0
                    currentlocationlongitude = location?.longitude?:0.0
                    try {
                        addresses = geocoder.getFromLocation(currentlocationlaltitue, currentlocationlongitude, 1) // Here 1 represent max location result to returned, by documents it recommended 1 to 5
                        val address = addresses?.get(0)
                        currentlocation = if (address != null) {
                            address.getAddressLine(0)
                        } else {
                            "$currentlocationlaltitue,$currentlocationlongitude"
                        }
                    } catch (e: Exception) { // TODO Auto-generated catch block
//											e.printStackTrace();
                        currentlocation = "$currentlocationlaltitue,$currentlocationlongitude"
                    } finally {
                        if (REQUEST_CHECK_SETTINGS == 4) {
                            calculateDistance(currentlocationlaltitue, currentlocationlongitude)
                        }
                    }
                }
            }
           // mFusedLocationClient.requestLocationUpdates(mLocationRequest, locationCallback, Looper.myLooper())

        } catch (e: Exception) { // TODO Auto-generated catch block
            e.printStackTrace()
        }
        //				 Log.d("currentlocationlaltitue",""+currentlocationlaltitue);
//				 Log.d("currentlocationlongitude",""+currentlocationlongitude);

        mFusedLocationClient.getCurrentLocation(LocationRequest.PRIORITY_HIGH_ACCURACY, null).addOnCompleteListener {
            it.result?.let { location->
                //Place current location marker
                Log.e("Location", location.latitude.toString() + "" + location.longitude)
                currentlocationlaltitue = location.latitude
                currentlocationlongitude = location.longitude

                currentlocation = "$currentlocationlaltitue,$currentlocationlongitude"
                try {
                    addresses =  Geocoder(mycontext!!, Locale.getDefault()).getFromLocation(currentlocationlaltitue, currentlocationlongitude, 1) // Here 1 represent max location result to returned, by documents it recommended 1 to 5
                    val address = addresses?.get(0)
                    currentlocation = if (address != null) {
                        address.getAddressLine(0)
                    } else {
                        "$currentlocationlaltitue,$currentlocationlongitude"
                    }
                } catch (e: Exception) { // TODO Auto-generated catch block
//											e.printStackTrace();
                    currentlocation = "$currentlocationlaltitue,$currentlocationlongitude"
                } finally {
                    if (REQUEST_CHECK_SETTINGS == 4) {
                        calculateDistance(currentlocationlaltitue, currentlocationlongitude)
                    }
                }
            }
        }.addOnCanceledListener {
            "Try Again".toast(this)
        }
    }

    private fun calculateDistance(lat: Double, lon: Double) {
        val distance = DistanceCalculator.distance(lat, lon, geoLat, geoLon)
        if (!geoFenceEnabled || distance <= geoDistance) {
            doCheckOut()
        } else {
            alertNotInFacility()
        }
    }

    private fun alertNotInFacility() {
        val alertdialog = AlertDialog.Builder(this)
        alertdialog.setMessage("It seems you are out of the geofence")
        alertdialog.setPositiveButton("Close"
        ) { dialog, whichButton -> finish() }.create()
        alertdialog.setCancelable(false)
        alertdialog.show()
    }

    private fun startLcoationUpdates() {
        val input = workDataOf("registeredemailid" to registeredemailid,
            "registeredcompany" to registeredcompany)

        val constraints: Constraints = Constraints.Builder().apply {
            setRequiredNetworkType(NetworkType.CONNECTED)
//            setRequiresCharging(true)
        }.build()
//        val request: OneTimeWorkRequest =
//            // Tell which work to execute
//            OneTimeWorkRequestBuilder<LocationUpdate>()
        val request: PeriodicWorkRequest =
            PeriodicWorkRequestBuilder<LocationUpdate>(15, TimeUnit.MINUTES)
                // Sets the input data for the ListenableWorker
                .setInputData(input)
                .addTag("location")
                // If you want to delay the start of work by 60 seconds
                .setInitialDelay(60, TimeUnit.SECONDS)
                // Set a backoff criteria to be used when retry-ing
//                .setBackoffCriteria(BackoffPolicy.EXPONENTIAL, 30000, TimeUnit.MILLISECONDS)
                // Set additional constraints
                .setConstraints(constraints)

                .build()
//        val dispatcher = FirebaseJobDispatcher(GooglePlayDriver(this))
//        val bundle = Bundle()
//        bundle.putString("registeredemailid", registeredemailid)
//        bundle.putString("registeredcompany", registeredcompany)
//        val constraintReminderJob = dispatcher.newJobBuilder()
//                .setService(LocationUpdate::class.java)
//                .setTag("location")
//                .setConstraints(Constraint.ON_ANY_NETWORK)
//                .setLifetime(Lifetime.FOREVER)
//                .setRecurring(true)
//            // start between 900 and 960 seconds from now
//                .setTrigger(Trigger.executionWindow(900, 960))
//                .setExtras(bundle)
//                .setReplaceCurrent(true)
//                .build()
//        dispatcher.schedule(constraintReminderJob)
        Preference.getInstance(this).setLocationUpdateRunning()
    }

    private fun stopLocationUpdates() {
//        val dispatcher = FirebaseJobDispatcher(GooglePlayDriver(this))
//        dispatcher.cancel("location")
        workManager.cancelUniqueWork("location")
        Preference.getInstance(this).setLocationUpdateNotRunning()
    }

    private fun checkLocationEnabled(REQUEST_CHECK_SETTINGS: Int) {
        locationManager = this.getSystemService(Context.LOCATION_SERVICE) as LocationManager
        val isGPSEnabled = locationManager!!.isProviderEnabled(LocationManager.GPS_PROVIDER)
        val isNetworkEnabled = locationManager!!.isProviderEnabled(LocationManager.NETWORK_PROVIDER)
        var message = ""
        var positivebutton = ""
        var title = ""
        if (!isGPSEnabled || !isNetworkEnabled) { //Toast.makeText(mycontext, "No network provider is enabled for location access", Toast.LENGTH_LONG).show();
            val alertdialog = AlertDialog.Builder(this)
            alertdialog.setIcon(R.drawable.ic_action_location)
            alertdialog.setCancelable(false)
            if (!isGPSEnabled && !isNetworkEnabled) {
                message = "No location provider is enabled for location access!!"
                positivebutton = "Turn On"
                title = "Enable Lcoation"
            } else {
                message = "Change Lcoation accuracy to high"
                positivebutton = "Change"
                title = "Accuracy is Low"
            }
            alertdialog.setTitle(title)
            alertdialog.setMessage(message)
            alertdialog.setPositiveButton(positivebutton
            ) { dialog, whichButton -> startActivity(Intent(Settings.ACTION_LOCATION_SOURCE_SETTINGS)) }
            alertdialog.setNegativeButton("Cancel") { dialog, which ->
                // TODO Auto-generated method stub
                finish()
            }.create()
            alertdialog.show()
        } else {
            findlocation(REQUEST_CHECK_SETTINGS)
        }
    }
    private fun getpresent() {
        presentdate = ArrayList<String>();
        val date = Date()
        val formatter = SimpleDateFormat("yyyy-MM-dd")
        val str = formatter.format(date)
        val startdate = str.substring(0, str.length - 2) + "01"
        val c = Calendar.getInstance()
        c[Calendar.DAY_OF_MONTH] = c.getActualMaximum(Calendar.DAY_OF_MONTH)
        val enddate = formatter.format(c.getTime())
         totaldaysvalue =  enddate.substring(enddate.length - 2, enddate.length)
        val today = Calendar.getInstance()
        val today_enddate = formatter.format(today.getTime())
        today_totaldaysvalue =  today_enddate.substring(today_enddate.length - 2, today_enddate.length)
//        try {
            totaldays!!.text =  "TotalDays: " + totaldaysvalue!!
//        }catch(E:Exception)
//        {
//            Toast.makeText(applicationContext,
//                    E.toString(), Toast.LENGTH_SHORT)
//                    .show()
//        }

        try {
            runOnUiThread {


                dbViewModel.getcurrentmonthpresent(startdate, enddate).observeForever {
                    try {
                        presentdate = ArrayList<String>();
                        it?.forEach {
                            presentdate.add(it.date)

                        }
                        //presentdate.size
                        totalpresent!!.text = "Present: "+presentdate.size.toString()
                        val hcmDatabase = HcmDatabase.getInstance(applicationContext)

                        leavevalue = hcmDatabase.getLeavesmonthlycount(startdate, enddate)
//                        leave!!.text = "Leaves: "+leavevalue
                        today_leavevalue = hcmDatabase.getLeavesmonthlycount(startdate, today_enddate)
//                        absent!!.text = "Absent:"+(today_totaldaysvalue!!.toInt() - presentdate.size.toInt() - today_leavevalue.toInt())
                    }catch (e: Exception){
                        e.printStackTrace()
                    }
//                    val hcmDatabase = HcmDatabase.getInstance(applicationContext)
//
//                     leavevalue = hcmDatabase.getLeavesmonthlycount(startdate, enddate)
                    leave!!.text = "Leaves: "+leavevalue
//                    today_leavevalue = hcmDatabase.getLeavesmonthlycount(startdate, today_enddate)
                    absent!!.text = "Absent:"+(totaldaysvalue!!.toInt() - presentdate.size!!.toInt() - today_leavevalue!!.toInt())
//                    Toast.makeText(applicationContext, totaldaysvalue+","+presentdate.size+","+today_leavevalue, Toast.LENGTH_SHORT)
//                    .show()
                }
            }
        } catch (e: Exception) {
          //  e.printStackTrace()
            Toast.makeText(applicationContext, e.toString(), Toast.LENGTH_SHORT)
                    .show()
        }
    }
//    private fun createDialogWithoutDateField(): DatePickerDialog? {
//        val dpd = DatePickerDialog(this, null, 2014, 1, 24)
//        try {
//            val datePickerDialogFields = dpd.javaClass.declaredFields
//            for (datePickerDialogField in datePickerDialogFields) {
//                if (datePickerDialogField.name == "mDatePicker") {
//                    datePickerDialogField.isAccessible = true
//                    val datePicker = datePickerDialogField[dpd] as DatePicker
//                    val datePickerFields = datePickerDialogField.type.declaredFields
//                    for (datePickerField in datePickerFields) {
//                        Log.i("test", datePickerField.name)
//                        if ("mDaySpinner" == datePickerField.name) {
//                            datePickerField.isAccessible = true
//                            val dayPicker = datePickerField[datePicker]
//                            (dayPicker as View).visibility = View.GONE
//                        }
//                    }
//                }
//            }
//        } catch (ex: java.lang.Exception) {
//        }
//        return dpd
//    }
private fun getMonthString(month: Int): String {
    val result = when (month) {
        0 -> "Jan"
        1 -> "Feb"
        2 -> "Mar"
        3 -> "Apr"
        4 -> "May"
        5 -> "Jun"
        6 -> "Jul"
        7 -> "Aug"
        8 -> "Sept"
        9 -> "Oct"
        10 -> "Nov"
        11 -> "Dec"
        else -> {
            "Apr"
        }
    }
    return result
}
}