package com.b2lmobitech.fieldcloudplus.hcm;


import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;

import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;

import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;
import android.util.DisplayMetrics;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;

import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.widget.ListView;
import android.widget.TextView;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.serviceold.adapterclass.attendancereportadapter;
import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables;

import com.b2lmobitech.fieldcloudplus.others.utils.JSONParser;
import com.b2lmobitech.fieldcloudplus.R;
import com.github.mikephil.charting.charts.HorizontalBarChart;
import com.github.mikephil.charting.data.BarData;
import com.github.mikephil.charting.data.BarDataSet;
import com.github.mikephil.charting.data.BarEntry;

import com.github.mikephil.charting.interfaces.datasets.IBarDataSet;

public class AttendanceReportDaily extends AppCompatActivity {

    TextView total,month,present,leave,absent,result;
    ListView attendancelv;
    private Context mycontext;


    private ProgressDialog pDialog;


    JSONArray employees = null;

    JSONParser jsonParser = new JSONParser();


    private static final String ALL_EMP_URL ="http://fieldcloud.in/App/get_allemployee.php";

    private static final String ATTENDANCE_EMP_URL ="http://fieldcloud.in/App/get_attendancereportdaily.php";
    private static final String LEAVE_EMP_URL ="http://fieldcloud.in/App/get_leavereportdaily.php";

    private static final String EMP_SUCCESS = "success";
    private static final String EMP_MESSAGE = "message";



    JSONArray products = null;



    String registeredcompany,registeredemailid;



String startdate="",enddate="";




    int totalemp=0;

    ActionBar ab;

    int first=0;

    String collectpresent[]=null;
    String collectleave[]=null;
    String collectabsent[]=null;


    String[] presentdate=null;
    String[] leavefrom=null;
    String[] leaveto=null;



    MenuItem chart ;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);


        setContentView(R.layout.content_attendancereportlist);

        mycontext = this;


        Intent intent = getIntent();

        startdate=intent.getStringExtra("startdate");
        enddate=intent.getStringExtra("enddate");


        total=(TextView) findViewById(R.id.total);
        month=(TextView) findViewById(R.id.month);
        present=(TextView) findViewById(R.id.present);
        leave=(TextView) findViewById(R.id.leave);
        absent=(TextView) findViewById(R.id.absent);

        result=(TextView) findViewById(R.id.result);

        attendancelv=(ListView) findViewById(R.id.attendancelistview);


        DisplayMetrics displaymetrics = new DisplayMetrics();
        getWindowManager().getDefaultDisplay().getMetrics(displaymetrics);


        int width = displaymetrics.widthPixels;
        int txtwidth=(width-10)/4;

        //   route.setWidth(txtwidth);
        month.setWidth(txtwidth);
        present.setWidth(txtwidth);
        leave.setWidth(txtwidth);
        absent.setWidth(txtwidth);

        globalvariables.Logoutsharedpreference = getSharedPreferences(globalvariables.LOGOUT_CHECKING, 0);
        registeredcompany = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_companyname, "");
        registeredemailid = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_emailid, "");

        if(isNetworkAvailable())
        {

            getSummary();
        }
        else{
            result.setVisibility(View.VISIBLE);
            result.setText("No Internet Connection");
            total.setVisibility(View.GONE);
            present.setVisibility(View.GONE);
            leave.setVisibility(View.GONE);
            month.setVisibility(View.GONE);
            attendancelv.setVisibility(View.GONE);
            AlertDialog.Builder alertdialog = new AlertDialog.Builder(mycontext);
            alertdialog.setTitle("No Internet Connection");
            alertdialog.setIcon(R.drawable.ic_action_location);
            alertdialog.setMessage("Try Again!!");
            alertdialog.setPositiveButton("OK",
                    new DialogInterface.OnClickListener() {
                        public void onClick(DialogInterface dialog, int whichButton) {
                            finish();
                        }
                    }).create();

            alertdialog.show();

        }

        getSupportActionBar().setBackgroundDrawable(
                new ColorDrawable(Color.parseColor("#8bbb4b")));
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
    }




    public boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager) mycontext.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        // if no network is available networkInfo will be null
        // otherwise check if we are connected
        if (networkInfo != null && networkInfo.isConnected()) {

            if( cm.getNetworkInfo(ConnectivityManager.TYPE_WIFI).isConnectedOrConnecting() ) {
                // do your stuff
//			    Log.d("wifi connectivity", "connected");
            }else {
//			    	   Log.d("wifi connectivity", "wifi not connected");

            }

            return true;
        }
        return false;
    }


    @Override
    public void onBackPressed() {
        Intent intent = new Intent(getApplicationContext(), AttendanceReport.class);
        intent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP|
                Intent.FLAG_ACTIVITY_CLEAR_TASK
        ); // To clean up all activities
        startActivity(intent);
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.chart, menu);

        chart = menu.findItem(R.id.chart);

        chart.setVisible(false);

        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();

        switch(id)
        {
            case R.id.chart:
                setContentView(R.layout.activity_chart);

                HorizontalBarChart  barChart = (HorizontalBarChart ) findViewById(R.id.chart);

                ArrayList<BarEntry> bargroup1 = new ArrayList<>();
                for(int i=0;i<presentdate.length;i++)
                {
                    bargroup1.add(new BarEntry((float) Double.parseDouble(collectpresent[i]), i));
                }


                ArrayList<BarEntry> bargroup2 = new ArrayList<>();
                for(int i=0;i<presentdate.length;i++)
                {
                    bargroup2.add(new BarEntry((float) Double.parseDouble(collectleave[i]), i));
                }

                ArrayList<BarEntry> bargroup3 = new ArrayList<>();
                for(int i=0;i<presentdate.length;i++)
                {
                    bargroup3.add(new BarEntry((float) Double.parseDouble(collectabsent[i]), i));
                }

                BarDataSet barDataSet1 = new BarDataSet(bargroup1, "Present");
                barDataSet1.setColor(Color.rgb(0, 155, 0));
             //   barDataSet1.setColors(ColorTemplate.COLORFUL_COLORS);


                BarDataSet barDataSet2 = new BarDataSet(bargroup2, "Leave");
                barDataSet2.setColor(Color.rgb(0, 0, 155));
              //  barDataSet2.setColors(ColorTemplate.COLORFUL_COLORS);


                BarDataSet barDataSet3 = new BarDataSet(bargroup3, "Absent");
                barDataSet3.setColor(Color.rgb(155, 0, 0));
               // barDataSet3.setColors(ColorTemplate.COLORFUL_COLORS);

                ArrayList<String> labels = new ArrayList<String>();
                for(int i=0;i<presentdate.length;i++)
                {
                    labels.add(presentdate[i]);
                }

                ArrayList<IBarDataSet> dataSets = new ArrayList<>();  // combined all dataset into an arraylist
                dataSets.add(barDataSet1);
                dataSets.add(barDataSet2);
                dataSets.add(barDataSet3);

// initialize the Bardata with argument labels and dataSet
                BarData data = new BarData(labels, dataSets);
                barChart.setData(data);
                break;

            default:
                break;
        }
        // Activate the navigation drawer toggle

        return super.onOptionsItemSelected(item);
    }

    private ArrayList<String> getXAxisValues() {
        ArrayList<String> labels = new ArrayList<>();

        for(int i=0;i<presentdate.length;i++)
        {
            labels.add(presentdate[i]);

        }
        return labels;
    }


    private void getSummary() {
        Map<String, String> params = new HashMap<>();
        params.put("startdate",startdate);
        params.put("enddate",enddate);
        params.put("companyname",registeredcompany);

        MyRequestQueue.getInstance(this).addToQueue(HCMURL.GET_ATTENDANCE_SUMMARY, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject = new JSONObject(response);
                    setSummary(jsonObject);
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void setSummary(JSONObject jsonObject) throws JSONException {

        totalemp=jsonObject.getJSONArray("emp").length();
        if(totalemp==0)
        {
            result.setVisibility(View.VISIBLE);
            result.setText("No Employees Added");
            total.setVisibility(View.GONE);
            present.setVisibility(View.GONE);
            leave.setVisibility(View.GONE);
            month.setVisibility(View.GONE);
            attendancelv.setVisibility(View.GONE);
            return;
        }

        JSONArray present = jsonObject.getJSONArray("present");

        if(present.length()!=0) {
            int count=present.length();

            collectpresent=new String[count];
            collectleave=new String[count];
            collectabsent=new String[count];
            presentdate=new String[count];
            for (int i = 0; i <count; i++) {
                JSONObject photoobj=present.getJSONObject(i);
                collectpresent[i]=photoobj.getString("present");
                collectleave[i]="0";
                collectabsent[i]="0";
                presentdate[i]=photoobj.getString("date");
            }
        }else{
            result.setVisibility(View.VISIBLE);
            result.setText("No Results!!");
            total.setVisibility(View.GONE);
            this.present.setVisibility(View.GONE);
            leave.setVisibility(View.GONE);
            absent.setVisibility(View.GONE);
            month.setVisibility(View.GONE);
            attendancelv.setVisibility(View.GONE);
            chart.setVisible(false);
            return;
        }


        JSONArray leaves = jsonObject.getJSONArray("leaves");
        if(leaves.length()!=0){
            int count=leaves.length();

            leavefrom=new String[count];
            leaveto=new String[count];
            for (int i = 0; i <count; i++) {
                JSONObject photoobj=leaves.getJSONObject(i);
                leavefrom[i]=photoobj.getString("leavefrom");
                leaveto[i]=photoobj.getString("leaveto");
            }
        }

        setViews();

    }

    private void setViews(){
        DateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if(presentdate!=null && leavefrom!=null){

            collectleave=null;
            collectleave=new String[presentdate.length];
            collectabsent=null;
            collectabsent=new String[presentdate.length];

            for(int i=0;i<presentdate.length;i++){
                collectleave[i]="0";
                collectabsent[i]="0";
            }

            for(int i=0;i<presentdate.length;i++) {
                int leave=0;
                for(int j=0;j<leavefrom.length;j++){
                    try {
                        if((((sdf.parse(presentdate[i])).compareTo(sdf.parse(leavefrom[j]))>0) || ((sdf.parse(presentdate[i])).compareTo(sdf.parse(leavefrom[j]))==0))
                                && (((sdf.parse(presentdate[i])).compareTo(sdf.parse(leaveto[j]))<0) || ((sdf.parse(presentdate[i])).compareTo(sdf.parse(leaveto[j]))==0))
                                ){
                            leave+=1;
                            collectleave[i]=String.valueOf(leave);
                        }
                    } catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
            }

            total.setText("Total employees: "+String.valueOf(totalemp));

            for(int i=0;i<presentdate.length;i++) {
                int absent=totalemp-(Integer.parseInt(collectpresent[i])+Integer.parseInt(collectleave[i]));
                collectabsent[i]=String.valueOf(absent);
            }

            attendancereportadapter adapter =new attendancereportadapter(AttendanceReportDaily.this,presentdate,collectpresent,collectleave,collectabsent);
            attendancelv.setAdapter(adapter);
            chart.setVisible(true);
        }else if(presentdate!=null && leavefrom==null){

            for(int i=0;i<presentdate.length;i++){
                int absent=totalemp-(Integer.parseInt(collectpresent[i])+Integer.parseInt(collectleave[i]));
                collectabsent[i]=String.valueOf(absent);
            }
            total.setText("Total employees: "+String.valueOf(totalemp));
            attendancereportadapter adapter =new attendancereportadapter(AttendanceReportDaily.this,presentdate,collectpresent,collectleave,collectabsent);
            attendancelv.setAdapter(adapter);
            chart.setVisible(true);
        }else{
            result.setVisibility(View.VISIBLE);
            result.setText("No Results!!");
            total.setVisibility(View.GONE);
            present.setVisibility(View.GONE);
            leave.setVisibility(View.GONE);
            absent.setVisibility(View.GONE);
            month.setVisibility(View.GONE);
            attendancelv.setVisibility(View.GONE);
            chart.setVisible(false);

        }
    }

}
