package com.b2lmobitech.fieldcloudplus.hcm;


import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;

import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.AsyncTask;
import android.os.Bundle;

import androidx.fragment.app.FragmentTransaction;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;
import android.util.Log;
import android.view.View;

import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.widget.ListView;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.others.utils.JSONParser;
import com.b2lmobitech.fieldcloudplus.R;

import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import com.b2lmobitech.fieldcloudplus.serviceold.adapterclass.attendancesummaryadapter;
import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables;


public class AttendanceReportonDate extends AppCompatActivity implements ActionBar.TabListener{

    TextView total,present,leave,permission,absent,result;
    ListView attendancelv;
    private Context mycontext;


    private ProgressDialog pDialog;


    JSONArray employees = null;

    JSONParser jsonParser = new JSONParser();


    private static final String ALL_EMP_URL ="http://fieldcloud.in/App/get_allemployee.php";

    private static final String ATTENDANCE_EMP_URL ="http://fieldcloud.in/App/get_attendanceemployee.php";

    private static final String LEAVE_EMP_URL ="http://fieldcloud.in/App/get_leaveemployee.php";

    private static final String EMP_SUCCESS = "success";
    private static final String EMP_MESSAGE = "message";



    JSONArray products = null;



    String registeredcompany,registeredemailid;


    String[] all_email;
    String[] all_name;
    String[] all_mobile;
    String[] all_designation;
    String[] all_group;
    String[] all_subgroup;
    String[] all_team;


    String[] attendance_email;
    String[] attendance_status;
    String[] attendance_checkin;
    String[] attendance_checkout;
    String[] attendance_checkinloc;
    String[] attendance_checkoutloc;

    String[] leave_email;
    String[] leavetype;
    String[] leavefrom;
    String[] leaveto;
    String[] permissionfrom;
    String[] permissionto;
    String[] permissioninminutes;
    String[] applyreason;
    String[] status;
    String[] rejectreason;


    String[] listemail;
    String[] listtype;
    String[] listintime;
    String[] listpermissiontime;
    String[] listapplyreason;
    String[] liststatus;
    String[] listname;
    String[] listdesignation;
    // String[] listrejectreason;


    String[] newlistemail;
    String[] newlisttype;
    String[] newlistintime;
    String[] newlistpermissiontime;
    String[] newlistapplyreason;
    String[] newliststatus;
    String[] newlistname;
    String[] newlistdesignation;

    int presentemp=0;
    int leaveemp=0;
    int permissionemp=0;
    int absentemp=0;

    ActionBar ab;

    int first=0;

    String [] absentemail=null;

    String searchdate;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);


        setContentView(R.layout.content_attendancesummary);

        mycontext = this;


        Intent intent = getIntent();

        searchdate=intent.getStringExtra("date");

        total=(TextView) findViewById(R.id.total);
        present=(TextView) findViewById(R.id.present);
        leave=(TextView) findViewById(R.id.leave);
        permission=(TextView) findViewById(R.id.permission);
        absent=(TextView) findViewById(R.id.absent);
        result=(TextView) findViewById(R.id.result);
        attendancelv=(ListView) findViewById(R.id.attendancelistview);

        globalvariables.Logoutsharedpreference = getSharedPreferences(globalvariables.LOGOUT_CHECKING, 0);
        registeredcompany = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_companyname, "");
        registeredemailid = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_emailid, "");

        if(isNetworkAvailable())
        {

            new GetAllEmployees().execute();
        }
        else
        {
            result.setVisibility(View.VISIBLE);
            result.setText("No Internet Connection");
            total.setVisibility(View.GONE);
            present.setVisibility(View.GONE);
            leave.setVisibility(View.GONE);
            permission.setVisibility(View.GONE);
            absent.setVisibility(View.GONE);
            attendancelv.setVisibility(View.GONE);

            AlertDialog.Builder alertdialog = new AlertDialog.Builder(mycontext);

            alertdialog.setTitle("No Internet Connection");
            alertdialog.setIcon(R.drawable.ic_action_location);
            alertdialog.setMessage("Try Again!!");
            alertdialog.setPositiveButton("OK",
                    new DialogInterface.OnClickListener() {
                        public void onClick(DialogInterface dialog, int whichButton) {
                            finish();
                        }
                    }).create();

            alertdialog.show();

        }

        getSupportActionBar().setBackgroundDrawable(
                new ColorDrawable(Color.parseColor("#8bbb4b")));

        getSupportActionBar().setTitle("Today Attendance");

        getSupportActionBar().setDisplayHomeAsUpEnabled(true);

        ab = getSupportActionBar();
        ab.setNavigationMode(ActionBar.NAVIGATION_MODE_TABS);

        ab.addTab(ab.newTab().setText("All").setTabListener(this));
        ab.addTab(ab.newTab().setText("Present").setTabListener(this));
        ab.addTab(ab.newTab().setText("Permission").setTabListener(this));
        ab.addTab(ab.newTab().setText("Leave").setTabListener(this));
        ab.addTab(ab.newTab().setText("Absent").setTabListener(this));
    }


    @Override
    public void onTabReselected(ActionBar.Tab arg0, FragmentTransaction arg1) {
        // TODO Auto-generated method stub

    }


    @Override
    public void onTabSelected(ActionBar.Tab tab, FragmentTransaction fragmentTransaction) {


        int nTabSelected = tab.getPosition();

        switch (nTabSelected) {
            case 0:

                if(first==0)
                {
                    first=1;

                }
                else
                {

                    Intent main = new Intent(AttendanceReportonDate.this, AttendanceReportonDate.class);

                    main.putExtra("date", searchdate);
                    startActivity(main);


                }

                break;
            case 1:
                attendancelv.setAdapter(null);

                if(presentemp>0) {
                    newlistemail = new String[presentemp];
                    newlisttype = new String[presentemp];
                    newlistintime = new String[presentemp];
                    newlistpermissiontime = new String[presentemp];
                    newlistapplyreason = new String[presentemp];
                    newliststatus = new String[presentemp];
                    newlistname = new String[presentemp];
                    newlistdesignation = new String[presentemp];


                    for (int j = 0; j < presentemp; j++) {
                        newlistemail[j] = attendance_email[j];
                        newlisttype[j] = attendance_status[j];
                        newlistintime[j] = attendance_checkin[j];
                        newlistpermissiontime[j] = "no data";
                        newlistapplyreason[j] = "no data";
                        newliststatus[j] = "no data";

                    }


                    for(int k=0;k<newlistemail.length;k++)
                    {
                        for(int l=0;l<all_email.length;l++)

                        {
                            if(newlistemail[k].equals(all_email[l]))
                            {
                                newlistname[k]=all_name[l];
                                newlistdesignation[k]=all_designation[l];
                            }
                        }
                    }




                    attendancesummaryadapter adapter =new

                            attendancesummaryadapter(AttendanceReportonDate.this, newlistemail,newlisttype,newlistintime,newlistpermissiontime,newlistapplyreason,newliststatus,newlistname,newlistdesignation);


                    attendancelv.setAdapter(adapter);

                    result.setVisibility(View.GONE);
                    attendancelv.setVisibility(View.VISIBLE);


                }

                else{
                    result.setVisibility(View.VISIBLE);
                    result.setText("No Employees Added");
                    attendancelv.setVisibility(View.GONE);
                }

                break;
            case 2:

                attendancelv.setAdapter(null);
                if(permissionemp>0){

                    newlistemail = new String[permissionemp];
                    newlisttype = new String[permissionemp];
                    newlistintime = new String[permissionemp];
                    newlistpermissiontime = new String[permissionemp];
                    newlistapplyreason = new String[permissionemp];
                    newliststatus = new String[permissionemp];
                    newlistname = new String[permissionemp];
                    newlistdesignation = new String[permissionemp];

                    if(leave_email!=null) {

                        int i=0;

                        for (int j = 0; j < leave_email.length; j++) {

                            if(leavetype[j].equalsIgnoreCase("permission")) {
                                newlistemail[i] = leave_email[j];
                                newlisttype[i] = leavetype[j];
                                newlistintime[i] = "no data";
                                newlistpermissiontime[i] = permissioninminutes[j];
                                newlistapplyreason[i] = applyreason[j];
                                newliststatus[i] = status[j];

                                i++;
                            }
                        }

                        for(int k=0;k<newlistemail.length;k++)
                        {
                            for(int l=0;l<all_email.length;l++)

                            {
                                if(newlistemail[k].equals(all_email[l]))
                                {
                                    newlistname[k]=all_name[l];
                                    newlistdesignation[k]=all_designation[l];
                                }
                            }
                        }




                        attendancesummaryadapter adapter =new

                                attendancesummaryadapter(AttendanceReportonDate.this, newlistemail,newlisttype,newlistintime,newlistpermissiontime,newlistapplyreason,newliststatus,newlistname,newlistdesignation);


                        attendancelv.setAdapter(adapter);

                        result.setVisibility(View.GONE);
                        attendancelv.setVisibility(View.VISIBLE);

                    }



                }

                else{
                    result.setVisibility(View.VISIBLE);
                    result.setText("No Employees Added");
                    attendancelv.setVisibility(View.GONE);
                }

                break;
            case 3:

                attendancelv.setAdapter(null);
                if(leaveemp>0){

                    newlistemail = new String[leaveemp];
                    newlisttype = new String[leaveemp];
                    newlistintime = new String[leaveemp];
                    newlistpermissiontime = new String[leaveemp];
                    newlistapplyreason = new String[leaveemp];
                    newliststatus = new String[leaveemp];
                    newlistname = new String[leaveemp];
                    newlistdesignation = new String[leaveemp];

                    if(leave_email!=null) {

                        int i=0;

                        for (int j = 0; j < leave_email.length; j++) {

                            if(!leavetype[j].equalsIgnoreCase("permission")) {
                                newlistemail[i] = leave_email[j];
                                newlisttype[i] = leavetype[j];
                                newlistintime[i] = "no data";
                                newlistpermissiontime[i] = permissioninminutes[j];
                                newlistapplyreason[i] = applyreason[j];
                                newliststatus[i] = status[j];

                                i++;
                            }
                        }

                        for(int k=0;k<newlistemail.length;k++)
                        {
                            for(int l=0;l<all_email.length;l++)

                            {
                                if(newlistemail[k].equals(all_email[l]))
                                {
                                    newlistname[k]=all_name[l];
                                    newlistdesignation[k]=all_designation[l];
                                }
                            }
                        }




                        attendancesummaryadapter adapter =new

                                attendancesummaryadapter(AttendanceReportonDate.this, newlistemail,newlisttype,newlistintime,newlistpermissiontime,newlistapplyreason,newliststatus,newlistname,newlistdesignation);


                        attendancelv.setAdapter(adapter);
                        result.setVisibility(View.GONE);
                        attendancelv.setVisibility(View.VISIBLE);

                    }


                }

                else{
                    result.setVisibility(View.VISIBLE);
                    result.setText("No Employees Added");
                    attendancelv.setVisibility(View.GONE);
                }


                break;
            case 4:

                attendancelv.setAdapter(null);
                if(absentemp>0) {

                    newlistemail = new String[absentemp];
                    newlisttype = new String[absentemp];
                    newlistintime = new String[absentemp];
                    newlistpermissiontime = new String[absentemp];
                    newlistapplyreason = new String[absentemp];
                    newliststatus = new String[absentemp];
                    newlistname = new String[absentemp];
                    newlistdesignation = new String[absentemp];


                    if(absentemail!=null) {
                        for (int j = 0; j < absentemail.length; j++) {

                            newlistemail[j]=absentemail[j];
                            newlisttype[j]="Absent";
                            newlistintime[j]="no data";
                            newlistpermissiontime[j]="no data";
                            newlistapplyreason[j]="no data";
                            newliststatus[j]="no data";


                        }


                        for(int k=0;k<newlistemail.length;k++)
                        {
                            for(int l=0;l<all_email.length;l++)

                            {
                                if(newlistemail[k].equals(all_email[l]))
                                {
                                    newlistname[k]=all_name[l];
                                    newlistdesignation[k]=all_designation[l];
                                }
                            }
                        }




                        attendancesummaryadapter adapter =new

                                attendancesummaryadapter(AttendanceReportonDate.this, newlistemail,newlisttype,newlistintime,newlistpermissiontime,newlistapplyreason,newliststatus,newlistname,newlistdesignation);


                        attendancelv.setAdapter(adapter);

                        result.setVisibility(View.GONE);
                        attendancelv.setVisibility(View.VISIBLE);

                    }


                }

                else{
                    result.setVisibility(View.VISIBLE);
                    result.setText("No Employees Added");
                    attendancelv.setVisibility(View.GONE);
                }
                break;
            default:
                break;


        }



    }


    @Override
    public void onTabUnselected(ActionBar.Tab arg0, FragmentTransaction arg1) {
        // TODO Auto-generated method stub

    }

    public boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager) mycontext.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        // if no network is available networkInfo will be null
        // otherwise check if we are connected
        if (networkInfo != null && networkInfo.isConnected()) {

            if( cm.getNetworkInfo(ConnectivityManager.TYPE_WIFI).isConnectedOrConnecting() ) {
                // do your stuff
//			    Log.d("wifi connectivity", "connected");
            }else {
//			    	   Log.d("wifi connectivity", "wifi not connected");

            }

            return true;
        }
        return false;
    }


    @Override
    public void onBackPressed() {
        Intent intent = new Intent(getApplicationContext(), AttendanceReport.class);
        intent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP|
                Intent.FLAG_ACTIVITY_CLEAR_TASK
        ); // To clean up all activities
        startActivity(intent);
    }



    class GetAllEmployees extends AsyncTask<String, String, String> {

        /**
         * Before starting background thread Show Progress Dialog
         * */


        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            pDialog = new ProgressDialog(AttendanceReportonDate.this);
            pDialog.setMessage("Loading...");
            pDialog.setIndeterminate(false);
            pDialog.setCancelable(false);
            pDialog.show();
        }

        @Override
        protected String doInBackground(String... args) {
            // TODO Auto-generated method stub
            // Check for success tag
            int success;





            try {
                // Building Parameters
                List<NameValuePair> params = new ArrayList<NameValuePair>();
                params.add(new BasicNameValuePair("companyname",registeredcompany ));

                //Posting user data to script
                final JSONObject json = jsonParser.makeHttpRequest(
                        ALL_EMP_URL, "GET", params);


                success = json.getInt(EMP_SUCCESS);
                if (success == 1) {


                    employees = json.getJSONArray("empdetails");

                    JSONObject photoobj;
                    int count=employees.length();



                    if(count>=1)
                    {


                        all_email=new String[count];
                        all_name=new String[count];
                        all_mobile=new String[count];
                        all_designation=new String[count];
                        all_group=new String[count];
                        all_subgroup=new String[count];
                        all_team=new String[count];

                        for (int i = 0; i <count; i++) {
                            photoobj=employees.getJSONObject(i);

                            all_email[i]=photoobj.getString("emailid");

                            all_name[i]=photoobj.getString("employeename");

                            all_mobile[i]=photoobj.getString("mobilenumber");

                            all_designation[i]=photoobj.getString("designation");

                            all_group[i]=photoobj.getString("attendancegroup");

                            all_subgroup[i]=photoobj.getString("attendancesubgroup");

                            all_team[i]=photoobj.getString("attendanceteam");

                        }

                    }


                    return json.getString(EMP_MESSAGE);


                }

                else if(success==0){

                    return json.getString(EMP_MESSAGE);

                }

                else if(success==2){

                    return json.getString(EMP_MESSAGE);

                }

                else{

                    String error="no success";
                    return error;

                }

            } catch (JSONException e) {
                e.printStackTrace();
                String error="php error";
                return error;
            }



        }
        /**
         * After completing background task Dismiss the progress dialog
         * **/
        protected void onPostExecute(String file_url) {
            // dismiss the dialog once product deleted
            pDialog.dismiss();

            if(all_email!=null)
            {

                new GetAttendanceEmployees().execute();

            }
            else
            {
                result.setVisibility(View.VISIBLE);
                result.setText("No Employees Added");
                total.setVisibility(View.GONE);
                present.setVisibility(View.GONE);
                leave.setVisibility(View.GONE);
                permission.setVisibility(View.GONE);
                absent.setVisibility(View.GONE);
                attendancelv.setVisibility(View.GONE);

            }

        }
    }



    class GetAttendanceEmployees extends AsyncTask<String, String, String> {

        /**
         * Before starting background thread Show Progress Dialog
         * */


        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            pDialog = new ProgressDialog(AttendanceReportonDate.this);
            pDialog.setMessage("Loading...");
            pDialog.setIndeterminate(false);
            pDialog.setCancelable(false);
            pDialog.show();
        }

        @Override
        protected String doInBackground(String... args) {
            // TODO Auto-generated method stub
            // Check for success tag
            int success;

            Date date = new Date();
            Calendar c = Calendar.getInstance();
            SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd");
            String todaydate= df1.format(c.getTime());



            try {
                // Building Parameters
                List<NameValuePair> params = new ArrayList<NameValuePair>();
                params.add(new BasicNameValuePair("companyname",registeredcompany ));
                params.add(new BasicNameValuePair("date",searchdate ));

                //Posting user data to script
                final JSONObject json = jsonParser.makeHttpRequest(
                        ATTENDANCE_EMP_URL, "GET", params);

                // full json response
                //   Log.d("Login attempt", json.toString());

                // json success element




                success = json.getInt(EMP_SUCCESS);
                if (success == 1) {


                    employees = json.getJSONArray("empdetails");

                    JSONObject photoobj;
                    int count=employees.length();



                    if(count>=1)
                    {


                        attendance_email=new String[count];
                        attendance_status=new String[count];
                        attendance_checkin=new String[count];
                        attendance_checkout=new String[count];
                        attendance_checkinloc=new String[count];
                        attendance_checkoutloc=new String[count];


                        for (int i = 0; i <count; i++) {
                            photoobj=employees.getJSONObject(i);

                            attendance_email[i]=photoobj.getString("emailid");

                            attendance_checkin[i]=photoobj.getString("checkintime");

                            attendance_checkout[i]=photoobj.getString("checkouttime");

                            attendance_checkinloc[i]=photoobj.getString("checkinlocation");

                            attendance_checkoutloc[i]=photoobj.getString("checkoutlocation");

                            attendance_status[i]="Present";



                        }

                    }


                    return json.getString(EMP_MESSAGE);


                }

                else if(success==0){

                    return json.getString(EMP_MESSAGE);

                }

                else if(success==2){

                    return json.getString(EMP_MESSAGE);

                }

                else{

                    String error="no success";
                    return error;

                }

            } catch (JSONException e) {
                e.printStackTrace();
                String error="php error";
                return error;
            }



        }
        /**
         * After completing background task Dismiss the progress dialog
         * **/
        protected void onPostExecute(String file_url) {
            // dismiss the dialog once product deleted
            pDialog.dismiss();



            new GetLeaveEmployees().execute();



        }
    }

    class GetLeaveEmployees extends AsyncTask<String, String, String> {

        /**
         * Before starting background thread Show Progress Dialog
         * */


        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            pDialog = new ProgressDialog(AttendanceReportonDate.this);
            pDialog.setMessage("Loading...");
            pDialog.setIndeterminate(false);
            pDialog.setCancelable(false);
            pDialog.show();
        }

        @Override
        protected String doInBackground(String... args) {
            // TODO Auto-generated method stub
            // Check for success tag
            int success;

            Date date = new Date();
            Calendar c = Calendar.getInstance();
            SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd");
            String todaydate= df1.format(c.getTime());



            try {
                // Building Parameters
                List<NameValuePair> params = new ArrayList<NameValuePair>();
                params.add(new BasicNameValuePair("companyname",registeredcompany ));
                params.add(new BasicNameValuePair("date",searchdate ));

                //Posting user data to script
                final JSONObject json = jsonParser.makeHttpRequest(
                        LEAVE_EMP_URL, "GET", params);

                // full json response
                //   Log.d("Login attempt", json.toString());

                // json success element




                success = json.getInt(EMP_SUCCESS);
                if (success == 1) {


                    employees = json.getJSONArray("empdetails");

                    JSONObject photoobj;
                    int count=employees.length();



                    if(count>=1)
                    {


                        leave_email=new String[count];
                        leavetype=new String[count];
                        leavefrom=new String[count];
                        leaveto=new String[count];
                        permissionfrom=new String[count];
                        permissionto=new String[count];
                        permissioninminutes=new String[count];
                        applyreason=new String[count];
                        status=new String[count];
                        rejectreason=new String[count];


                        for (int i = 0; i <count; i++) {
                            photoobj=employees.getJSONObject(i);

                            leave_email[i]=photoobj.getString("employeemailid");

                            leavetype[i]=photoobj.getString("leavetype");

                            leavefrom[i]=photoobj.getString("leavefrom");

                            leaveto[i]=photoobj.getString("leaveto");

                            permissionfrom[i]=photoobj.getString("permissionfrom");

                            permissionto[i]=photoobj.getString("permissionto");

                            permissioninminutes[i]=photoobj.getString("permissioninminutes");

                            applyreason[i]=photoobj.getString("applyreason");

                            Log.e("apply reason",applyreason[i]);

                            status[i]=photoobj.getString("status");

                            Log.e("status",status[i]);

                            rejectreason[i]=photoobj.getString("rejectreason");



                        }

                    }


                    return json.getString(EMP_MESSAGE);


                }

                else if(success==0){

                    return json.getString(EMP_MESSAGE);

                }

                else if(success==2){

                    return json.getString(EMP_MESSAGE);

                }

                else{

                    String error="no success";
                    return error;

                }

            } catch (JSONException e) {
                e.printStackTrace();
                String error="php error";
                return error;
            }



        }
        /**
         * After completing background task Dismiss the progress dialog
         * **/
        protected void onPostExecute(String file_url) {
            // dismiss the dialog once product deleted
            pDialog.dismiss();

            presentemp=0;

            int totalemp=all_email.length;
            leaveemp=0;
            permissionemp=0;

            if(attendance_email!=null)
            {
                presentemp=attendance_email.length;
            }

            else{
                presentemp=0;
            }

            if(leave_email!=null) {
                for (int i=0;i<leave_email.length;i++)
                {
                    if(leavetype[i].equalsIgnoreCase("permission"))
                    {
                        permissionemp++;
                    }
                    else{

                        leaveemp++;
                    }
                }
            }




            if(attendance_email!=null || leave_email!=null) {
                if (attendance_email != null && leave_email != null) {

                    ArrayList<String> attendancelist = new ArrayList<String>( Arrays.asList(attendance_email));
                    ArrayList<String> leavelist =new ArrayList<String>( Arrays.asList(leave_email));
                    ArrayList<String> alllist = new ArrayList<String>(Arrays.asList(all_email));

                    attendancelist.addAll(leavelist);
                    alllist.removeAll(attendancelist);

                    absentemail = alllist.toArray(new String[alllist.size()]);
                }

                else if (attendance_email != null && leave_email == null) {

                    ArrayList<String> attendancelist = new ArrayList<String>(Arrays.asList(attendance_email));

                    ArrayList<String> alllist = new ArrayList<String>(Arrays.asList(all_email));

                    alllist.removeAll(attendancelist);

                    absentemail = alllist.toArray(new String[alllist.size()]);
                }


                else if (attendance_email == null && leave_email != null) {

                    ArrayList<String> leavelist =new ArrayList<String>( Arrays.asList(leave_email));

                    ArrayList<String> alllist = new ArrayList<String>(Arrays.asList(all_email));

                    alllist.removeAll(leavelist);

                    absentemail = alllist.toArray(new String[alllist.size()]);
                }
            }
            else{
                ArrayList<String> alllist = new ArrayList<String>(Arrays.asList(all_email));

                absentemail = alllist.toArray(new String[alllist.size()]);
            }



            absentemp=absentemail.length;

            total.setText("Total Employees: "+String.valueOf(totalemp));
            present.setText("Present: "+String.valueOf(presentemp));
            leave.setText("Leave: "+String.valueOf(leaveemp));
            permission.setText("Permission: "+String.valueOf(permissionemp));
            absent.setText("Absent: "+String.valueOf(absentemp));



            int listemp=presentemp+leaveemp+permissionemp+absentemp;
            if(listemp>0)
            {
                listemail=new String[listemp];
                listtype=new String[listemp];
                listintime=new String[listemp];
                listpermissiontime=new String[listemp];
                listapplyreason=new String[listemp];
                liststatus=new String[listemp];
                listname=new String[listemp];
                listdesignation=new String[listemp];

                int i=0;
                for(int j=0;j<presentemp;j++)
                {
                    listemail[i]=attendance_email[j];
                    listtype[i]=attendance_status[j];
                    listintime[i]=attendance_checkin[j];
                    listpermissiontime[i]="no data";
                    listapplyreason[i]="no data";
                    liststatus[i]="no data";

                    i++;
                }

                if(leave_email!=null) {
                    for (int j = 0; j < leave_email.length; j++) {

                        listemail[i]=leave_email[j];
                        listtype[i]=leavetype[j];
                        listintime[i]="no data";
                        listpermissiontime[i]=permissioninminutes[j];
                        listapplyreason[i]=applyreason[j];
                        liststatus[i]=status[j];

                        i++;
                    }

                }




                if(absentemail!=null) {
                    for (int j = 0; j < absentemail.length; j++) {

                        listemail[i]=absentemail[j];
                        listtype[i]="Absent";
                        listintime[i]="no data";
                        listpermissiontime[i]="no data";
                        listapplyreason[i]="no data";
                        liststatus[i]="no data";

                        i++;
                    }

                }

                for(int k=0;k<listemail.length;k++)
                {
                    for(int l=0;l<all_email.length;l++)

                    {
                        if(listemail[k].equalsIgnoreCase(all_email[l]))
                        {
                            listname[k]=all_name[l];
                            listdesignation[k]=all_designation[l];
                        }
                    }
                }




                attendancesummaryadapter adapter =new

                        attendancesummaryadapter(AttendanceReportonDate.this, listemail,listtype,listintime,listpermissiontime,listapplyreason,liststatus,listname,listdesignation);


                attendancelv.setAdapter(adapter);

            }


            else{

                result.setVisibility(View.VISIBLE);
                result.setText("No Employees Added");
                total.setVisibility(View.GONE);
                present.setVisibility(View.GONE);
                leave.setVisibility(View.GONE);
                permission.setVisibility(View.GONE);
                absent.setVisibility(View.GONE);
                attendancelv.setVisibility(View.GONE);

            }



        }
    }

}
