package com.b2lmobitech.fieldcloudplus.hcm;

import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import com.google.android.material.snackbar.Snackbar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;

import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.DateUtils;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.serviceold.adapterclass.emp_timesheetadapter;
import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables;
import com.b2lmobitech.fieldcloudplus.others.sql.sqlitehelper.sqldatabase;

public class Employee_Timesheet extends AppCompatActivity {
    private Context mycontext;

    private String registeredcompany = "",todaydate="",registeredemailid="";

    private sqldatabase mDbHelper;
    private ListView list;
    private emp_timesheetadapter adapter;
    private ArrayList<String> timesheetdates,teams,starttimes,endtimes,activities;
    private TextView nohistory;
    private Snackbar snackBar;

    int status=0;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_combination_list);
        Toolbar toolbar = (Toolbar) findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);
        mycontext = this;
        mDbHelper = new sqldatabase(mycontext);

        timesheetdates = new ArrayList<String>();
        teams = new ArrayList<String>();
        starttimes = new ArrayList<String>();
        endtimes = new ArrayList<String>();
        activities = new ArrayList<String>();

        //progressbar = new ProgressBar(mycontext, null, android.R.attr.progressBarStyleSmall);
        ProgressBar progressbar = (ProgressBar) findViewById(R.id.progressBar);
        list = (ListView) findViewById(R.id.categorylist);
        nohistory = (TextView) findViewById(R.id.nohistory);
        snackBar = Snackbar.make(findViewById(android.R.id.content), "Please check internet connection", Snackbar.LENGTH_INDEFINITE);

        SimpleDateFormat dateFormatter = new SimpleDateFormat
                ("yyyy-MM-dd");
        todaydate = dateFormatter.format(new Date());

        globalvariables.Logoutsharedpreference = getSharedPreferences(globalvariables.LOGOUT_CHECKING, 0);
        registeredcompany = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_companyname, "");

        Intent intent = getIntent();

        registeredemailid = intent.getStringExtra("emp_mail");


        if(isNetworkAvailable())
        {
            nohistory.setVisibility(View.GONE);
            getData();
        }
        else
        {
            // nohistory.setVisibility(View.VISIBLE);
            // Toast.makeText(mycontext,"Please check the internet connection",Toast.LENGTH_LONG).show();
            snackBar.dismiss();
            snackBar = Snackbar.make(findViewById(android.R.id.content),  "Please check internet connection", Snackbar.LENGTH_INDEFINITE);
            toast();
        }

//        SimpleDateFormat dateFormatter = new SimpleDateFormat
//                ("yyyy-MM-dd");
//        todaydate = dateFormatter.format(new Date());
//        FloatingActionButton fab = (FloatingActionButton) findViewById(R.id.fab);
//        fab.setOnClickListener(new View.OnClickListener() {
//            @Override
//            public void onClick(View view) {
//                Snackbar.make(view, "Replace with your own action", Snackbar.LENGTH_LONG)
//                        .setAction("Action", null).show();
//            }
//        });
        //  getSupportActionBar().setDisplayHomeAsUpEnabled(true);
//        globalvariables.Logoutsharedpreference = getSharedPreferences(globalvariables.LOGOUT_CHECKING, 0);
//        registeredcompany = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_companyname, "");
//        registeredemailid = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_emailid, "");
//        if(isNetworkAvailable())
//        {
//            mDbHelper.delete_dynamicquestionstable();
//                       mytask = new getdynamicquestions();
//                       StartAsyncTaskInParallel(mytask);
//        }
//        else
//        {
//            Toast.makeText(mycontext,"Please check the internet connection",Toast.LENGTH_LONG).show();
//        }

    }

    @Override
    protected void onResume() {
        super.onResume();


        //   registeredemailid = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_emailid, "");
        //   registeredcustomername = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_customername, "");
        //registeredquestionmode



    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.combination, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        // int id = item.getItemId();

        //noinspection SimplifiableIfStatement
//        if (id == an) {
//
//        }
        switch (item.getItemId()) {
            case android.R.id.home:
                onBackPressed();
                break;

        }
        return  true;
        //return super.onOptionsItemSelected(item);
    }

    public boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager) mycontext.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        // if no network is available networkInfo will be null
        // otherwise check if we are connected
        if (networkInfo != null && networkInfo.isConnected()) {

            if( cm.getNetworkInfo(ConnectivityManager.TYPE_WIFI).isConnectedOrConnecting() ) {
                // do your stuff
//			    Log.d("wifi connectivity", "connected");
            }else {
//			    	   Log.d("wifi connectivity", "wifi not connected");

            }

            return true;
        }
        return false;
    }

    @Override
    protected void onDestroy() {
        mDbHelper.close();
        super.onDestroy();
    }

    private void toast() {
        snackBar.setAction("CLOSE", new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                snackBar.dismiss();
            }
        }).setActionTextColor(getResources().getColor(android.R.color.holo_blue_dark )).show();
    }

    private void getData() {
        Snackbar.make(findViewById(android.R.id.content), "Please wait..", Snackbar.LENGTH_LONG)
                .setAction("Action", null).show();
        Map<String, String> params = new HashMap<>();
        params.put("date",DateUtils.getCurrentDate());
        params.put("companyname",registeredcompany);
        params.put("employeemailid",registeredemailid);



        MyRequestQueue.getInstance(this).addToQueue(HCMURL.GET_EMPLOYEE_TIMESHEET, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject = new JSONObject(response);
                    setData(jsonObject);
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void setData(JSONObject jsonObjec) throws JSONException {
        JSONArray jsonArray = jsonObjec.getJSONArray("list"); // JSON Array
        for(int i=0;i<jsonArray.length();i++) {
            JSONObject object = jsonArray.getJSONObject(i);
            timesheetdates.add (object.getString("timesheetdate"));
            teams.add(object.getString("attendenceteam"));
            activities.add( object.getString("activity"));
            starttimes.add( object.getString("starttime"));
            endtimes.add( object.getString("endtime"));
        }

        if(jsonArray.length()!=0){
            emp_timesheetadapter adapter = new emp_timesheetadapter(mycontext,timesheetdates,teams,starttimes,endtimes,activities);
            list.setAdapter(adapter);
        }else{
            nohistory.setVisibility(View.VISIBLE);
            nohistory.setText("Not yet Added Timesheet!!");
        }
        snackBar.dismiss();

    }

}
