package com.b2lmobitech.fieldcloudplus.hcm;

import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.os.Parcelable;
import com.google.android.material.floatingactionbutton.FloatingActionButton;
import com.google.android.material.snackbar.Snackbar;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.Toast;

import com.b2lmobitech.fieldcloudplus.R;

import org.json.JSONException;
import org.json.JSONObject;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import com.b2lmobitech.fieldcloudplus.hcm.sql.HcmDatabase;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.sql.Tables.leavetable;
import com.b2lmobitech.fieldcloudplus.hcm.adapter.leaveadapter;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables;
import com.b2lmobitech.fieldcloudplus.others.sql.sqlitehelper.sqldatabase;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;

public class Leaveactivity extends AppCompatActivity implements leaveadapter.leaveListener{

    private FloatingActionButton fab,fab1,fab2;
    private Context mycontext;
    private Animation fab_open, fab_close, rotate_forward, rotate_backward;
    private Boolean isFabOpen = false;
    private TextView addcalendartext,applyleavetext,history,pull;
    private ImageView refreshicon;
    private String registeredcompany,registeredemailid;
    private Snackbar snackBar;
    private ListView leavelistview;
    private ArrayList<String> status,leavedays,permissioninminutes,leavefrom,leaveto,permissionfrom,permissionto,leavetype,
            applieddateandtime,leavereason,rejectedreason,optionfordelete,synctoshow;
    private SwipeRefreshLayout swipeContainer;
    private sqldatabase mDbHelper;
    private ArrayList<String> selectleavetype,selectstatustype;
    private String selectedleavetype="",selectedstatustype="";
    public ProgressBar progressBar;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_leaveactivity);
        Toolbar toolbar = (Toolbar) findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);
        mycontext = this;
        mDbHelper = new sqldatabase(mycontext);

        globalvariables.Logoutsharedpreference = getSharedPreferences(globalvariables.LOGOUT_CHECKING, 0);
        registeredcompany = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_companyname, "");
        registeredemailid = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_emailid, "");

        snackBar = Snackbar.make(findViewById(android.R.id.content), "Please check internet connection", Snackbar.LENGTH_INDEFINITE);

        getSupportActionBar().setDisplayHomeAsUpEnabled(true);

        status = new ArrayList<String>();
        leavedays = new ArrayList<String>();
        permissioninminutes = new ArrayList<String>();
        leavefrom = new ArrayList<String>();
        leaveto = new ArrayList<String>();
        permissionfrom = new ArrayList<String>();
        permissionto = new ArrayList<String>();
        leavetype= new ArrayList<String>();
        applieddateandtime= new ArrayList<String>();
        leavereason = new ArrayList<String>();
        rejectedreason =  new ArrayList<String>();
        selectleavetype = new ArrayList<String>();
        selectstatustype = new ArrayList<String>();
        optionfordelete = new ArrayList<String>();
        synctoshow = new ArrayList<String>();

        getWidgets();
        setListeners();
        setAdapter();
        getLeaves();
    }

    @Override
    protected void onRestart() {
        super.onRestart();
        setAdapter();
        syncData();
    }

    private void getWidgets(){
        // myview =  findViewById(android.R.id.content);
        fab = (FloatingActionButton) findViewById(R.id.fab);
        fab1 = (FloatingActionButton) findViewById(R.id.fab1);
        fab2 = (FloatingActionButton) findViewById(R.id.fab2);

        fab_open = AnimationUtils.loadAnimation(getApplicationContext(), R.anim.fab_open);
        fab_close = AnimationUtils.loadAnimation(getApplicationContext(), R.anim.fab_close);
        rotate_forward = AnimationUtils.loadAnimation(getApplicationContext(), R.anim.rotate_forward);
        rotate_backward = AnimationUtils.loadAnimation(getApplicationContext(), R.anim.rotate_backward);
        applyleavetext = (TextView) findViewById(R.id.applyleavetext);
        addcalendartext = (TextView) findViewById(R.id.addcalendartext);
        leavelistview = (ListView) findViewById(R.id.leavelistview);
        history = (TextView) findViewById(R.id.history);
        refreshicon = (ImageView) findViewById(R.id.refreshicon);
        pull = (TextView) findViewById(R.id.pull);
        swipeContainer = (SwipeRefreshLayout) findViewById(R.id.swipeContainer);
        progressBar = (ProgressBar) findViewById(R.id.progressBar);
    }

    private void setListeners(){
        fab1.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                Intent intent = new Intent(mycontext, leaveapply.class);
                startActivity(intent);
            }
        });

        fab.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                animateFAB();
            }
        });


        swipeContainer.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener() {
            @Override
            public void onRefresh() {
                    snackBar.dismiss();
                    if (isNetworkAvailable()) {
                        getLeaves();
                    } else {
                        setAdapter();
                    }
                    swipeContainer.setRefreshing(false);

            }
        });

        fab2.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                showLeaveFilter();
            }
        });
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.leave, menu);
        return super.onCreateOptionsMenu(menu);
        // return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {

        int id = item.getItemId();
        if (id == R.id.leave_sync) {
            try {
                if(isNetworkAvailable()) {
                    syncData();
                    snackBar.dismiss();
                }else{
                    toast();
                }
            } catch (Exception e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
            return true;
        }

        return super.onOptionsItemSelected(item);
    }

    public void animateFAB() {

        if (isFabOpen) {

            fab.startAnimation(rotate_backward);
            fab1.startAnimation(fab_close);
            fab2.startAnimation(fab_close);
            applyleavetext.setVisibility(View.GONE);
            addcalendartext.setVisibility(View.GONE);
            fab1.setClickable(false);
            fab2.setClickable(false);
            isFabOpen = false;
            // Log.d("Raj", "close");

        } else {

            fab.startAnimation(rotate_forward);
            fab1.startAnimation(fab_open);
            fab2.startAnimation(fab_open);
            applyleavetext.setVisibility(View.VISIBLE);
            addcalendartext.setVisibility(View.VISIBLE);
            fab1.setClickable(true);
            fab2.setClickable(true);
            isFabOpen = true;
            // Log.d("Raj","open");

        }
    }

    public boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager) mycontext.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        // if no network is available networkInfo will be null
        // otherwise check if we are connected
        if (networkInfo != null && networkInfo.isConnected()) {

            if( cm.getNetworkInfo(ConnectivityManager.TYPE_WIFI).isConnectedOrConnecting() ) {
                // do your stuff
//			    Log.d("wifi connectivity", "connected");
            }else {
//			    	   Log.d("wifi connectivity", "wifi not connected");

            }

            return true;
        }
        return false;
    }

    private void toast() {
    snackBar.setAction("CLOSE", new View.OnClickListener() {
        @Override
        public void onClick(View v) {
            snackBar.dismiss();
        }
    }).setActionTextColor(getResources().getColor(android.R.color.holo_blue_dark )).show();
}

    @Override
    protected void onDestroy() {
        mDbHelper.close();
        super.onDestroy();
    }

    private void getLeaves() {

        final HcmDatabase hcmDatabase = HcmDatabase.getInstance(this);
        Preference preference = Preference.getInstance(this);
        ;
        Map<String, String> params = new HashMap<>();
        params.put("email", preference.getEmailId());
        params.put("companyname", preference.getCompanyName());

        MyRequestQueue.getInstance(this).addToQueue(HCMURL.GET_LEAVESFULL, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject = new JSONObject(response);
                    if (jsonObject.getInt("s") == 1) {
                        hcmDatabase.insertLeaves(jsonObject.getJSONArray("list"));
                    }
                    setAdapter();
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });

    }

    private String displaydelete(String syncvalue,String statusvalue,String leavetype,String permissiondate,String permissionstarttime,String leavestartdate) {
        String deleteicon = "No";
        if(syncvalue.equalsIgnoreCase("No"))
        {
            deleteicon = "Yes";
        }
        else
        {
            if(statusvalue.equalsIgnoreCase("rejected"))
            {
                deleteicon = "No";
            }
            else
            {
                if(leavetype.equalsIgnoreCase("Permission"))
                {
                    SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd");
                    SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
                    String todaydate = sdf2.format(new Date());
                    String todaytime = sdf.format(new Date());

                    if(todaydate.equals(permissiondate))
                    {
                        try {
                            Date date1 = sdf.parse(todaytime);
                            Date date2 = sdf.parse(permissionstarttime);
                            long difference = date2.getTime() - date1.getTime();
                            int days = (int) (difference / (1000*60*60*24));
                            int hours = (int) ((difference - (1000*60*60*24*days)) / (1000*60*60));
                            int min = (int) (difference - (1000*60*60*24*days) - (1000*60*60*hours)) / (1000*60);
                            if(min>0)
                            {
                                deleteicon = "Yes";
                            }
                            else
                            {
                                deleteicon = "No";
                            }
                        }catch(Exception e)
                        {
                            deleteicon = "No";
                        }

                    }
                    else
                    {
                        deleteicon = "No";
                    }
                }
                else
                {
                    SimpleDateFormat sdf3 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String todaydateandtime = sdf3.format(new Date());
                    try {
                        Date date3 = sdf3.parse(todaydateandtime);
                        Date date4 = sdf3.parse(leavestartdate+" 10:00:00");
                        long difference = date4.getTime() - date3.getTime();
                        int days = (int) (difference / (1000*60*60*24));
                        int hours = (int) ((difference - (1000*60*60*24*days)) / (1000*60*60));
                        int min = (int) (difference - (1000*60*60*24*days) - (1000*60*60*hours)) / (1000*60);
                        if(min>0)
                        {
                            deleteicon = "Yes";
                        }
                        else
                        {
                            deleteicon = "No";
                        }
                    }catch(Exception e)
                    {
                        deleteicon = "No";
                    }
                }
            }
        }
        return deleteicon;
    }

    private void setAdapter(){
        Cursor leavecursor = mDbHelper.get_leavetable(registeredcompany, registeredemailid);
        setAdapter(leavecursor);
    }

    private void setAdapter(Cursor leavecursor){
        status.clear();
        leavedays.clear();
        permissioninminutes.clear();
        leavefrom.clear();
        leaveto.clear();
        permissionfrom.clear();
        permissionto.clear();
        leavereason.clear();
        rejectedreason.clear();
        optionfordelete.clear();
        applieddateandtime.clear();
        leavetype.clear();

        if (leavecursor!=null&&(leavecursor.moveToFirst())) {
            do {
                status.add(leavecursor.getString(leavecursor.getColumnIndex(leavetable.STATUS)));
                leavedays.add(leavecursor.getString(leavecursor.getColumnIndex(leavetable.LEAVEDAYS)));
                permissioninminutes.add(leavecursor.getString(leavecursor.getColumnIndex(leavetable.PERMISSIONINMINUTES)));
                leavefrom.add(leavecursor.getString(leavecursor.getColumnIndex(leavetable.LEAVEFROM)));
                leaveto.add(leavecursor.getString(leavecursor.getColumnIndex(leavetable.LEAVETO)));
                permissionfrom.add(leavecursor.getString(leavecursor.getColumnIndex(leavetable.PERMISSIONFROM)));
                permissionto.add(leavecursor.getString(leavecursor.getColumnIndex(leavetable.PERMISSIONTO)));
                leavetype.add(leavecursor.getString(leavecursor.getColumnIndex(leavetable.LEAVETYPE)));
                applieddateandtime.add(leavecursor.getString(leavecursor.getColumnIndex(leavetable.APPLIEDDATEANDTIME)));
                leavereason.add(leavecursor.getString(leavecursor.getColumnIndex(leavetable.REASONFORLEAVEORPERMISSION)));
                rejectedreason.add(leavecursor.getString(leavecursor.getColumnIndex(leavetable.REJECTEDREASON)));

                optionfordelete.add(displaydelete(leavecursor.getString(leavecursor.getColumnIndex(leavetable.SYNC)),
                        leavecursor.getString(leavecursor.getColumnIndex(leavetable.STATUS)),
                        leavecursor.getString(leavecursor.getColumnIndex(leavetable.LEAVETYPE)),
                        leavecursor.getString(leavecursor.getColumnIndex(leavetable.PERMISSIONDATE)),
                        leavecursor.getString(leavecursor.getColumnIndex(leavetable.PERMISSIONFROM)),
                        leavecursor.getString(leavecursor.getColumnIndex(leavetable.LEAVEFROM))));

                synctoshow.add(leavecursor.getString(leavecursor.getColumnIndex(leavetable.SYNC)));
            } while (leavecursor.moveToNext());
            history.setVisibility(View.GONE);
            refreshicon.setVisibility(View.GONE);
            pull.setVisibility(View.GONE);
            leaveadapter adapter = new leaveadapter(mycontext, status,leavedays,permissioninminutes,leavefrom,leaveto,permissionfrom,permissionto,leavetype,applieddateandtime,leavereason,rejectedreason,optionfordelete,synctoshow);
            Parcelable parcelable=leavelistview.onSaveInstanceState();
            leavelistview.setAdapter(adapter);
            if(parcelable!=null){
                leavelistview.onRestoreInstanceState(parcelable);
            }
            leavelistview.setVisibility(View.VISIBLE);
        } else {
            history.setVisibility(View.VISIBLE);
            refreshicon.setVisibility(View.VISIBLE);
            pull.setVisibility(View.VISIBLE);
            leavelistview.setVisibility(View.GONE);
        }

    }

    private void showLeaveFilter(){
        AlertDialog.Builder dialogBuilder = new AlertDialog.Builder(mycontext);
        LayoutInflater inflater = (LayoutInflater) mycontext.getSystemService(mycontext.LAYOUT_INFLATER_SERVICE);
        View dialogView = inflater.inflate(R.layout.custom_leaveactivity_filter, null);
        dialogBuilder.setView(dialogView);
        final Spinner leavetypespinner = (Spinner) dialogView.findViewById(R.id.leavetype);
        final Spinner statustypespinner = (Spinner) dialogView.findViewById(R.id.statustype);
        Button cancel = (Button) dialogView.findViewById(R.id.cancel);
        Button apply = (Button) dialogView.findViewById(R.id.apply);
        final AlertDialog alertDialog = dialogBuilder.create();
        alertDialog.show();
        selectleavetype.clear();
        selectleavetype.add("Select Leave type");
        selectleavetype.add("All");
        selectleavetype.add("Permission");
        selectleavetype.add("Sick Leave");
        selectleavetype.add("Casual Leave");
        selectleavetype.add("Earned Leave");
        ArrayAdapter<String> leavetypeAdapter = new ArrayAdapter<String>(mycontext,
                android.R.layout.simple_spinner_item, selectleavetype);
        leavetypeAdapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        leavetypespinner.setAdapter(leavetypeAdapter);
        selectstatustype.clear();
        selectstatustype.add("Select Status type");
        selectstatustype.add("All");
        selectstatustype.add("accepted");
        selectstatustype.add("rejected");
        selectstatustype.add("pending");
        ArrayAdapter<String> statustypeAdapter = new ArrayAdapter<String>(mycontext,
                android.R.layout.simple_spinner_item, selectstatustype);
        statustypeAdapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        statustypespinner.setAdapter(statustypeAdapter);

        leavetypespinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
                selectedleavetype = leavetypespinner.getSelectedItem().toString();
            }

            @Override
            public void onNothingSelected(AdapterView<?> parent) {

            }
        });

        statustypespinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
                selectedstatustype = statustypespinner.getSelectedItem().toString();
            }

            @Override
            public void onNothingSelected(AdapterView<?> parent) {

            }
        });

        cancel.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                alertDialog.dismiss();
            }
        });

        apply.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                snackBar.dismiss();
                if(selectedleavetype.equalsIgnoreCase("Select Leave type")||selectedstatustype.equalsIgnoreCase("Select Status type"))
                {
                    Toast.makeText(mycontext, "All fields are manditory",Toast.LENGTH_LONG).show();
                }
                else
                {
                    try {
                        alertDialog.dismiss();
                        Cursor showcursor = mDbHelper.get_leavetable_filter(registeredcompany, registeredemailid, selectedleavetype, selectedstatustype);
                        setAdapter(showcursor);
                    }catch(Exception e)
                    {

                    }
                }
            }
        });
    }

    private void syncData(){
        final HcmDatabase hcmDatabase=HcmDatabase.getInstance(this);

        snackBar.dismiss();
        Snackbar.make(findViewById(android.R.id.content), "Please wait..", Snackbar.LENGTH_SHORT)
                .setAction("Action", null).show();

        Map<String, String> params = new HashMap<>();
        params.put("JSON",hcmDatabase.getLeavesNotSynced().toString());

        MyRequestQueue.getInstance(this).addToQueue(HCMURL.INSERT_LEAVES, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject=new JSONObject(response);
                    hcmDatabase.updateLeavesSynced(jsonObject.getJSONArray("list"));
                    getLeaves();
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    public void deleteLeave(final String type, final String datetime) {
        final HcmDatabase hcmDatabase=HcmDatabase.getInstance(this);
        Preference preference=Preference.getInstance(this);

        snackBar.dismiss();
        Snackbar.make(findViewById(android.R.id.content), "Please wait..", Snackbar.LENGTH_SHORT)
                .setAction("Action", null).show();

        Map<String, String> params = new HashMap<>();
        params.put("companyname",preference.getCompanyName());
        params.put("employeemailid",preference.getEmailId());
        params.put("leavetype",type);
        params.put("appliedateandtime",datetime);

        MyRequestQueue.getInstance(this).addToQueue(HCMURL.DELETE_LEAVES, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject=new JSONObject(response);
                    snackBar.dismiss();
                    if(jsonObject.getInt("s")==1){
                        hcmDatabase.updateLeaveDeleted(type,datetime);
                    }
                    setAdapter();
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

}
