package com.b2lmobitech.fieldcloudplus.hcm;

import android.Manifest;
import android.app.Activity;
import android.app.DatePickerDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.location.Address;
import android.location.Geocoder;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Looper;
import android.os.Parcelable;
import android.provider.Settings;
import androidx.annotation.NonNull;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import com.google.android.material.floatingactionbutton.FloatingActionButton;
import com.google.android.material.snackbar.Snackbar;
import androidx.core.app.ActivityCompat;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.Button;
import android.widget.DatePicker;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.hcm.sql.HcmDatabase;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationResult;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.tasks.OnSuccessListener;

import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import com.b2lmobitech.fieldcloudplus.others.sql.Tables.locationtable;
import com.b2lmobitech.fieldcloudplus.hcm.adapter.locationadapter;
import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables;
import com.b2lmobitech.fieldcloudplus.others.sql.sqlitehelper.sqldatabase;

public class Location extends AppCompatActivity implements GoogleApiClient.OnConnectionFailedListener {
    private Context mycontext;
    private Animation fab_open, fab_close, rotate_forward, rotate_backward;
    private Boolean isFabOpen = false;
    private FloatingActionButton fab, addfab, viewfab;
    private boolean isBottom = false;
    private RelativeLayout locationsublayout;
    private ListView locationlistview;
    private ArrayList<String> date, locationval, customcheckin, time, syncval;
    private ImageButton autolocater;
    private TextView locationdetail, explanation, locationhistory, addlocationtext, addcalendartext;
    private Boolean autolocaterclick = false;
    private SimpleDateFormat sdf, sdf2;
    private sqldatabase mDbHelper;
    private String registeredemailid, registeredcompany, table_latitude = "0.0", table_longitude, table_location, table_date = " ", table_time = " ", table_checkinname = "";
    private String month, day;

    //---location
    private boolean running = false;
    private String currentlocation = "Not found";
    private Double currentlocationlaltitue = 0.0, currentlocationlongitude = 0.0;
    private List<Address> addresses = null;
    private static final HttpClient ANDROID_HTTP_CLIENT = new DefaultHttpClient();
    private Button okbutton, cancelbutton;
    private EditText checkinname;
    private SwipeRefreshLayout swipeContainer;
    private Snackbar snackBar;
    GoogleApiClient mGoogleApiClient;
    FusedLocationProviderClient mFusedLocationClient;
    LocationRequest mLocationRequest;
    private long UPDATE_INTERVAL = 10 * 1000;  /* 10 secs */
    private long FASTEST_INTERVAL = 1000; /* 2 sec */
    LocationManager locationManager;
    private CoordinatorLayout coordinatorLayout;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_location);
        Toolbar toolbar = (Toolbar) findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        fab = (FloatingActionButton) findViewById(R.id.locationfab);
        addfab = (FloatingActionButton) findViewById(R.id.addlocation);
        addlocationtext = (TextView) findViewById(R.id.addlocationtext);
        viewfab = (FloatingActionButton) findViewById(R.id.showlocation);
        addcalendartext = (TextView) findViewById(R.id.addcalendartext);
        locationsublayout = (RelativeLayout) findViewById(R.id.locationsublayout);
        locationlistview = (ListView) findViewById(R.id.locationlistview);
        autolocater = (ImageButton) findViewById(R.id.autolocater);
        locationdetail = (TextView) findViewById(R.id.locationdetail);
        explanation = (TextView) findViewById(R.id.explanation);
        locationhistory = (TextView) findViewById(R.id.locationhistory);
        okbutton = (Button) findViewById(R.id.ok);
        cancelbutton = (Button) findViewById(R.id.cancel);
        checkinname = (EditText) findViewById(R.id.check);
        date = new ArrayList<String>();
        locationval = new ArrayList<String>();
        customcheckin = new ArrayList<String>();
        time = new ArrayList<String>();
        syncval = new ArrayList<String>();
        mycontext = this;
        mDbHelper = new sqldatabase(mycontext);
        globalvariables.Logoutsharedpreference = getSharedPreferences(globalvariables.LOGOUT_CHECKING, 0);
        registeredemailid = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_emailid, "");
        registeredcompany = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_companyname, "");

        swipeContainer = (SwipeRefreshLayout) findViewById(R.id.swipeContainer);
        // Setup refresh listener which triggers new data loading

        fab.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
//                Snackbar.make(view, "Replace with your own action", Snackbar.LENGTH_LONG)
//                        .setAction("Action", null).show();
                animateFAB();
            }
        });
        addfab.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if (isBottom) {
                    locationsublayout.setVisibility(View.GONE);
                    isBottom = false;
                } else {
                    locationsublayout.setVisibility(View.VISIBLE);
                    isBottom = true;
                }
            }
        });
        viewfab.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                final Calendar c = Calendar.getInstance();
                int mYear = c.get(Calendar.YEAR); // current year
                int mMonth = c.get(Calendar.MONTH); // current month
                int mDay = c.get(Calendar.DAY_OF_MONTH); // current day
                // date picker dialog
                DatePickerDialog datePickerDialog = new DatePickerDialog(mycontext,
                        new DatePickerDialog.OnDateSetListener() {

                            @Override
                            public void onDateSet(DatePicker view, int year,
                                                  int monthOfYear, int dayOfMonth) {
                                // set day of month , month and year value in the edit text
//                                Toast.makeText(mycontext,dayOfMonth + "/"
//                                        + (monthOfYear + 1) + "/" + year,Toast.LENGTH_LONG).show();
                                monthOfYear = monthOfYear + 1;
                                if (monthOfYear < 10) {
                                    month = "0" + monthOfYear;
                                } else {
                                    month = "" + monthOfYear;
                                }
                                if (dayOfMonth < 10) {

                                    day = "0" + dayOfMonth;
                                } else {
                                    day = "" + dayOfMonth;
                                }
                                Cursor locationlist_cursor = mDbHelper.get_location_datewise(registeredcompany, registeredemailid, year + "-" + month + "-" + day);
                                setAdapter(locationlist_cursor);
                            }
                        }, mYear, mMonth, mDay);
                datePickerDialog.show();
            }
        });
        autolocater.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                // Toast.makeText(mycontext,"Please wait",Toast.LENGTH_SHORT).show();

                findlocation();

            }
        });
        okbutton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                table_checkinname = checkinname.getText().toString();
                try {
                    Cursor locationcursor = mDbHelper.get_location_duplicacy(registeredcompany, registeredemailid, table_date, table_time);
                    if (locationcursor.getCount() == 0) {
                        if (locationdetail.getText().equals("")) {
                            //Toast.makeText(mycontext, "please click autolocate", Toast.LENGTH_LONG).show();
                            showSnack("please click autolocate",true);
                        } else {
                            if (currentlocation.equalsIgnoreCase("Not found") || currentlocation.equalsIgnoreCase("ot foun")) {
                                mDbHelper.insert_locationtable(registeredcompany, registeredemailid, table_latitude + "," + table_longitude, table_checkinname, table_latitude, table_longitude, table_date, table_time, "No");
                                explanation.setText("You have successfully 'In' at " + sdf.format(new Date()) + " from " + currentlocationlaltitue + "," + currentlocationlongitude);
                            } else {
                                mDbHelper.insert_locationtable(registeredcompany, registeredemailid, table_location, table_checkinname, table_latitude, table_longitude, table_date, table_time, "No");
                                explanation.setText("You have successfully 'In' at " + sdf.format(new Date()) + " from " + currentlocation);
                            }

                            setAdapter();
                            try {
                                if (isNetworkAvailable()) {
                                   syncData();
                                }
                            } catch (Exception e) {
                                // TODO Auto-generated catch block
                                e.printStackTrace();
                            }
                        }
                    } else {
                        if (locationdetail.getText().equals("")) {
                            // Toast.makeText(mycontext, "please click autolocate", Toast.LENGTH_LONG).show();
                            showSnack("please click autolocate",true);
                        } else {
                            // Toast.makeText(mycontext, "Data is already entered", Toast.LENGTH_LONG).show();
                            showSnack("Data is already entered",true);

                        }
                    }
                    locationcursor.close();
                } catch (Exception e) {
                    // Toast.makeText(mycontext, "error"+e.toString(), Toast.LENGTH_LONG).show();
                }
            }
        });
        cancelbutton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                checkinname.getText().clear();
                locationdetail.setText("");
                explanation.setText("");
                if (isBottom) {
                    locationsublayout.setVisibility(View.GONE);
                    isBottom = false;
                } else {
                    locationsublayout.setVisibility(View.VISIBLE);
                    isBottom = true;
                }

            }
        });


        swipeContainer.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener() {
            @Override
            public void onRefresh() {
                setAdapter();
            }
        });
        setAdapter();

    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.location, menu);
        return super.onCreateOptionsMenu(menu);
        // return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();

        //noinspection SimplifiableIfStatement
        if (id == R.id.location_sync) {
            try {
                if (isNetworkAvailable()) {
                    syncData();
                } else {
                    //Toast.makeText(mycontext, "Please check internet connection", Toast.LENGTH_LONG).show();
                    showSnack("Please check internet connection",true);
                }
            } catch (Exception e) {
                // e.printStackTrace();
            }
            return true;
        }

        return super.onOptionsItemSelected(item);
    }

    public void animateFAB() {
        fab_open = AnimationUtils.loadAnimation(getApplicationContext(), R.anim.fab_open);
        fab_close = AnimationUtils.loadAnimation(getApplicationContext(), R.anim.fab_close);
        rotate_forward = AnimationUtils.loadAnimation(getApplicationContext(), R.anim.rotate_forward);
        rotate_backward = AnimationUtils.loadAnimation(getApplicationContext(), R.anim.rotate_backward);

        if (isFabOpen) {

            fab.startAnimation(rotate_backward);
            addfab.startAnimation(fab_close);
            addlocationtext.setVisibility(View.GONE);
            addcalendartext.setVisibility(View.GONE);
            viewfab.startAnimation(fab_close);
            addfab.setClickable(false);
            viewfab.setClickable(false);
            isFabOpen = false;
            // Log.d("Raj", "close");

        } else {

            fab.startAnimation(rotate_forward);
            addfab.startAnimation(fab_open);
            addlocationtext.setVisibility(View.VISIBLE);
            addcalendartext.setVisibility(View.VISIBLE);
            viewfab.startAnimation(fab_open);
            addfab.setClickable(true);
            viewfab.setClickable(true);
            isFabOpen = true;
            // Log.d("Raj","open");

        }
    }

    public boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager) mycontext.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        // if no network is available networkInfo will be null
        // otherwise check if we are connected
        if (networkInfo != null && networkInfo.isConnected()) {

            if (cm.getNetworkInfo(ConnectivityManager.TYPE_WIFI).isConnectedOrConnecting()) {
                // do your stuff
//			    Log.d("wifi connectivity", "connected");
            } else {
//			    	   Log.d("wifi connectivity", "wifi not connected");

            }

            return true;
        }
        return false;
    }

    LocationCallback mLocationCallback = new LocationCallback(){
        @Override
        public void onLocationResult(LocationResult locationResult) {
            for (android.location.Location location : locationResult.getLocations()) {
                Log.i("MapsActivity", "Location: " + location.getLatitude() + " " + location.getLongitude());
                android.location.Location mLastLocation = location;

                Log.e("Location",mLastLocation.getLatitude() + "" + mLastLocation.getLongitude());
                //Place current location marker
            }
        };

    };

    //----Location
    public void findlocation() {

        locationManager = (LocationManager) this.getSystemService(Context.LOCATION_SERVICE);
        boolean isGPSEnabled = locationManager.isProviderEnabled(LocationManager.GPS_PROVIDER);
        boolean isNetworkEnabled = locationManager.isProviderEnabled(LocationManager.NETWORK_PROVIDER);
        if (!isGPSEnabled || !isNetworkEnabled) {
            //Toast.makeText(mycontext, "No network provider is enabled for location access", Toast.LENGTH_LONG).show();
            String message="";
            String positivebutton="";
            String title="";

            android.app.AlertDialog.Builder alertdialog = new android.app.AlertDialog.Builder(this);

            alertdialog.setIcon(R.drawable.ic_action_location);
            alertdialog.setCancelable(false);
            if(!isGPSEnabled && !isNetworkEnabled){
                message="No location provider is enabled for location access!!";
                positivebutton="Turn On";
                title="Enable Lcoation";
            }else{
                message="Change Lcoation accuracy to high";
                positivebutton="Change";
                title="Accuracy is Low";
            }
            alertdialog.setTitle(title);
            alertdialog.setMessage(message);
            alertdialog.setPositiveButton(positivebutton,
                    new DialogInterface.OnClickListener() {
                        public void onClick(DialogInterface dialog, int whichButton) {
                            startActivity(new Intent(Settings.ACTION_LOCATION_SOURCE_SETTINGS));
                        }
                    });
            alertdialog.setNegativeButton("Cancel", new DialogInterface.OnClickListener() {

                @Override
                public void onClick(DialogInterface dialog, int which) {
                    // TODO Auto-generated method stub

                }
            }).create();
            alertdialog.show();
            return;
        }
        try {
            final Geocoder geocoder = new Geocoder(mycontext, Locale.getDefault());
            locationManager = (LocationManager) mycontext.getSystemService(Context.LOCATION_SERVICE);


            // getting GPS status
            isGPSEnabled = locationManager.isProviderEnabled(LocationManager.GPS_PROVIDER);
//            if (!isGPSEnabled) {
//



            showSnack("Please wait...",true);
            autolocaterclick = true;

            mGoogleApiClient = new GoogleApiClient.Builder(this)
                    .addOnConnectionFailedListener(this)
                    .addApi(LocationServices.API).build();
            mGoogleApiClient.connect();
            mFusedLocationClient = LocationServices.getFusedLocationProviderClient(this);

            // Location mLastLocation;

            if (ActivityCompat.checkSelfPermission(Location.this, Manifest.permission.ACCESS_FINE_LOCATION) != PackageManager.PERMISSION_GRANTED && ActivityCompat.checkSelfPermission(Location.this, Manifest.permission.ACCESS_COARSE_LOCATION) != PackageManager.PERMISSION_GRANTED) {
                return;
            }
            mLocationRequest = new LocationRequest();
            mLocationRequest.setPriority(LocationRequest.PRIORITY_HIGH_ACCURACY);
            mLocationRequest.setInterval(UPDATE_INTERVAL);
            mLocationRequest.setFastestInterval(FASTEST_INTERVAL);
            mLocationRequest.setMaxWaitTime(2000);
            mLocationRequest.setNumUpdates(1);
            mLocationRequest.setExpirationDuration(5000);


            LocationCallback locationCallback=new LocationCallback(){

                @Override
                public void onLocationResult(LocationResult locationResult) {

                    Log.e("Location","in result");
                    if(locationResult.getLocations().size()==0){
                        Log.e("Location","No lcoations found");
                        return;
                    }
                    android.location.Location location =locationResult.getLastLocation();

                    //Place current location marker
                    Log.e("Location", location.getLatitude() + "" + location.getLongitude());
                    currentlocationlaltitue = location.getLatitude();
                    currentlocationlongitude = location.getLongitude();

                    try {
                        addresses = geocoder.getFromLocation(currentlocationlaltitue, currentlocationlongitude, 1); // Here 1 represent max location result to returned, by documents it recommended 1 to 5

                        Address address = addresses.get(0);

                        if (address != null) {
                            currentlocation = address.getAddressLine(0);
                        } else {
                            currentlocation = currentlocationlaltitue + "," + currentlocationlongitude;
                        }

                        //addressFragments.add(address.getAdminArea());

                        // currentlocation = currentlocation.substring(1,currentlocation.length()-1);
                    } catch (Exception e) {
                        // TODO Auto-generated catch block
//											e.printStackTrace();
                        currentlocation = currentlocationlaltitue + "," + currentlocationlongitude;
                    }
                    if (autolocaterclick) {
                        sdf = new SimpleDateFormat("HH:mm:ss");
                        sdf2 = new SimpleDateFormat("yyyy-MM-dd");

                        if (currentlocation.equalsIgnoreCase("Not found") || currentlocation.equalsIgnoreCase("ot foun")) {
                            locationdetail.setText(currentlocationlaltitue + "," + currentlocationlongitude);
                        } else {
                            locationdetail.setText(currentlocation);
                        }
                        table_latitude = String.valueOf(currentlocationlaltitue);
                        table_longitude = String.valueOf(currentlocationlongitude);
                        table_location = currentlocation;
                        table_date = sdf2.format(new Date());
                        table_time = sdf.format(new Date());
                        autolocaterclick = false;
                    }
                };

            };

            Log.e("called","yes");
            //  mFusedLocationClient.requestLocationUpdates(mLocationRequest, mLocationCallback, Looper.myLooper());
            mFusedLocationClient.requestLocationUpdates(mLocationRequest, locationCallback, Looper.myLooper());

        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }

//				 Log.d("currentlocationlaltitue",""+currentlocationlaltitue);
//				 Log.d("currentlocationlongitude",""+currentlocationlongitude);
    }

    public void getLocation(String provider) {

        final Geocoder geocoder = new Geocoder(mycontext, Locale.getDefault());

        if (ActivityCompat.checkSelfPermission(this, Manifest.permission.ACCESS_FINE_LOCATION) != PackageManager.PERMISSION_GRANTED && ActivityCompat.checkSelfPermission(this, Manifest.permission.ACCESS_COARSE_LOCATION) != PackageManager.PERMISSION_GRANTED) {
            return;
        }

        GoogleApiClient mGoogleApiClient;

        mGoogleApiClient = new GoogleApiClient.Builder(this)
                .addOnConnectionFailedListener(this)
                .addApi(LocationServices.API).build();
        mGoogleApiClient.connect();

        // Location mLastLocation;


        if (ActivityCompat.checkSelfPermission(this, android.Manifest.permission.ACCESS_FINE_LOCATION) != PackageManager.PERMISSION_GRANTED && ActivityCompat.checkSelfPermission(this, android.Manifest.permission.ACCESS_COARSE_LOCATION) != PackageManager.PERMISSION_GRANTED) {
            return ;
        }


        LocationServices.getFusedLocationProviderClient(this).getLastLocation().addOnSuccessListener((Activity) this, new OnSuccessListener<android.location.Location>() {
                        @Override
                        public void onSuccess(android.location.Location location) {
                            if (location != null) {
                                Log.e("Location", location.getLatitude() + "" + location.getLongitude());
                                currentlocationlaltitue = location.getLatitude();
                                currentlocationlongitude = location.getLongitude();

                                try {
                                    addresses = geocoder.getFromLocation(currentlocationlaltitue, currentlocationlongitude, 1); // Here 1 represent max location result to returned, by documents it recommended 1 to 5

                                    Address address = addresses.get(0);

                                    if (address != null) {
                                        currentlocation = address.getAddressLine(0);
                                    } else {
                                        currentlocation = currentlocationlaltitue + "," + currentlocationlongitude;
                                    }
                                    //addressFragments.add(address.getAdminArea());

                                    // currentlocation = currentlocation.substring(1,currentlocation.length()-1);
                                } catch (Exception e) {
                                    // TODO Auto-generated catch block
//											e.printStackTrace();
                                    currentlocation = currentlocationlaltitue + "," + currentlocationlongitude;
                                }
                                //location=mLastLocation;
                            } else {
                                Log.e("Location", "Not Found");
                            }
                        }
                    });
                /*if (mLastLocation != null) {
                    latLang.setLatitude(mLastLocation.getLatitude()+"");
                    latLang.setLatitude(mLastLocation.getLatitude()+"");
                }*/



    }

    public void fetchCityName(final Context contex, final android.location.Location location) {
        if (running)
            return;

        new AsyncTask<Void, Void, String>()
        {
            protected void onPreExecute()
            {
                running = true;
            };

            @Override
            protected String doInBackground(Void... params)
            {
                String cityName = null;

                if (Geocoder.isPresent())
                {
                    try
                    {
                        Geocoder geocoder = new Geocoder(contex, Locale.getDefault());
                        List<Address> addresses = geocoder.getFromLocation(location.

                                getLatitude(), location.getLongitude(), 1);
                        if (addresses.size() > 0)
                        {
                            cityName = addresses.get(0).getLocality();
                        }
                    }
                    catch (Exception ignored)
                    {
                        // after a while, Geocoder start to trhow "Service not availalbe" exception. really weird since it was working before (same device, same Android version etc..
                    }
                }

                if (cityName != null) // i.e., Geocoder succeed
                {
                    return cityName;
                }
                else // i.e., Geocoder failed
                {
                    return fetchCityNameUsingGoogleMap();
                }
            }

            // Geocoder failed :-(
            // Our B Plan : Google Map
            private String fetchCityNameUsingGoogleMap()
            {
                String googleMapUrl = "http://maps.googleapis.com/maps/api/geocode/json?latlng=" + location.getLatitude() + ","
                        + location.getLongitude() + "&sensor=false&language=fr";

                try
                {
                    JSONObject googleMapResponse = new JSONObject(ANDROID_HTTP_CLIENT.execute(new HttpGet(googleMapUrl),
                            new BasicResponseHandler()));

                    // many nested loops.. not great -> use expression instead
                    // loop among all results
                    JSONArray results = (JSONArray) googleMapResponse.get("results");
                    String cityName = results.getJSONObject(0).getString("formatted_address");
//		                    Log.d("address check", results.getJSONObject(0).getString("formatted_address"));

                    return cityName;
                }
                catch (Exception ignored)
                {
                    ignored.printStackTrace();
                }
                return null;
            }

            protected void onPostExecute(String cityName)
            {
                running = false;
//		                Toast.makeText(mycontext, "cityName"+cityName, Toast.LENGTH_LONG).show();
                if (cityName != null)
                {
                    // Do something with cityName
//		                    Log.i("GeocoderHelper", cityName);
//		                    alertdialog(cityName);
                    currentlocation = cityName;
                    currentlocation = currentlocation.substring(1,currentlocation.length()-1);
//		                    Imagecaption.setText("Latitude:"+currentlocationlaltitue+",\nLongitude:"+currentlocationlongitude+",\nLocation:"+currentlocation);

                }

//		                Toast.makeText(mycontext, currentlocation, Toast.LENGTH_LONG).show();
            };
        }.execute();
    }

    @Override
    protected void onDestroy() {
        mDbHelper.close();
        super.onDestroy();
    }


    private void syncData(){
        final HcmDatabase hcmDatabase=HcmDatabase.getInstance(this);


        showSnack("Please wait.",false);

        Map<String, String> params = new HashMap<>();
        params.put("JSON",hcmDatabase.getLocationNotSynced().toString());

        MyRequestQueue.getInstance(this).addToQueue(HCMURL.INSERT_LOCATION, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject=new JSONObject(response);
                    hcmDatabase.updateLocationSynced(jsonObject.getJSONArray("list"));

                    showSnack("Data is synced.",false);

                    setAdapter();
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void toast() {

    }


    @Override
    public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {

    }

    private void setAdapter(){
        Cursor locationcursor = mDbHelper.get_location(registeredcompany, registeredemailid);
        setAdapter(locationcursor);
    }

    private void setAdapter(Cursor locationlist_cursor){
        date.clear();
        locationval.clear();
        customcheckin.clear();
        time.clear();
        syncval.clear();
        if (locationlist_cursor.moveToFirst()) {
            do {
                date.add(locationlist_cursor.getString(locationlist_cursor.getColumnIndex(locationtable.DATE)));
                locationval.add(locationlist_cursor.getString(locationlist_cursor.getColumnIndex(locationtable.LOCATION)));
                customcheckin.add(locationlist_cursor.getString(locationlist_cursor.getColumnIndex(locationtable.CHECKINNAME)));
                time.add(locationlist_cursor.getString(locationlist_cursor.getColumnIndex(locationtable.TIME)));
                syncval.add(locationlist_cursor.getString(locationlist_cursor.getColumnIndex(locationtable.SYNC)));
            } while (locationlist_cursor.moveToNext());

        }
        Parcelable parcelable=locationlistview.onSaveInstanceState();
        locationadapter adapter = new locationadapter(mycontext, date, locationval, customcheckin, time, syncval);
        locationlist_cursor.close();
        locationlistview.setAdapter(adapter);
        if(parcelable!=null){
            locationlistview.onRestoreInstanceState(parcelable);
        }
    }

    private void showSnack(String text,boolean infinity){
        if(coordinatorLayout==null){
            coordinatorLayout=findViewById(R.id.coordinatorLayout);
        }
        if(snackBar!=null && snackBar.isShown()){
            snackBar.dismiss();
        }
        snackBar = Snackbar.make(coordinatorLayout, text, Snackbar.LENGTH_LONG);
        if(infinity){
            snackBar.setDuration(Snackbar.LENGTH_INDEFINITE);
        }
        snackBar.setAction("CLOSE", new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                snackBar.dismiss();
            }
        });
        snackBar.setActionTextColor(getResources().getColor(android.R.color.holo_blue_dark));
        snackBar.show();
    }



}
