package com.b2lmobitech.fieldcloudplus.hcm.activities;

import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import android.view.MenuItem;
import android.view.View;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.hcm.HCMURL;
import com.b2lmobitech.fieldcloudplus.hcm.adapter.ContractAdapter;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

public class ContractActivity extends AppCompatActivity implements OnItemClickListener {

    RecyclerView recyclerView;
    TextView errorText;
    ContractAdapter contractAdapter;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_contract);

        errorText=findViewById(R.id.errorText);
        recyclerView=findViewById(R.id.recycleView);
        recyclerView.setLayoutManager(new LinearLayoutManager(this));
        recyclerView.addItemDecoration(new DividerItemDecoration(this, LinearLayoutManager.VERTICAL));
        recyclerView.setHasFixedSize(true);
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        getSupportActionBar().setTitle("Trainings");

        getContracts();
    }

    private void getContracts(){
        Preference preference=Preference.getInstance(this);
        Map<String, String> params = new HashMap<>();
        params.put("mail",preference.getEmailId());
        params.put("cname", preference.getCompanyName());
        params.put("role", preference.getDesignation());

        MyRequestQueue.getInstance(this).addToQueue(HCMURL.GET_CONTRACTS, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    getContracts(new JSONObject(response));
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void getContracts(JSONObject jsonObject) throws JSONException{
        JSONArray jsonArray=jsonObject.getJSONArray("list");
        contractAdapter=new ContractAdapter(this,jsonArray);
        recyclerView.setAdapter(contractAdapter);

        if(jsonArray.length()==0){
            errorText.setText("No Contracts Found");
            errorText.setVisibility(View.VISIBLE);
        }else if(errorText.getVisibility()==View.VISIBLE){
            errorText.setVisibility(View.GONE);
        }
    }


    @Override
    public void itemClicked(int position) {

    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()){
            case android.R.id.home:
                onBackPressed();
                return true;
        }
        return super.onOptionsItemSelected(item);
    }

}
