package com.b2lmobitech.fieldcloudplus.hcm.activities;

import android.content.Intent;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import androidx.cardview.widget.CardView;
import android.view.MenuItem;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;

public class EmployeeActivity extends AppCompatActivity {

    LinearLayout mainLayout;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_employee);
        mainLayout=findViewById(R.id.mainLayout);
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        getSupportActionBar().setTitle("Employee");
        addViews();
    }

    private void addViews(){
        addView("Warnings",WarningActivity.class,null);
        addView("Trainings",TrainigActivity.class,null);
        addView("Transfers",TransferActivity.class,null);
        addView("Contracts",ContractActivity.class,null);
        addView("Resignations",ResignationActivity.class,null);
        //addView("Terminations",TerminationActivity.class,null);
    }

    private void addView(String text, final Class activity, final Intent extra){

        View view=getLayoutInflater().inflate(R.layout.model_list,null);
        TextView textView=view.findViewById(R.id.textView);
        CardView cardView=view.findViewById(R.id.cardView);
        ImageView imageView=view.findViewById(R.id.imageView);

        textView.setText(text);

        cardView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if(!MyRequestQueue.getInstance(EmployeeActivity.this).isNoNetwork()) {
                    Intent intent = new Intent(getApplicationContext(), activity);
                    if (extra != null) {
                        intent.putExtras(extra);
                    }
                    startActivity(intent);
                }
            }
        });
        mainLayout.addView(view);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()){
            case android.R.id.home:
                onBackPressed();
                return true;
        }
        return super.onOptionsItemSelected(item);
    }

}
