package com.b2lmobitech.fieldcloudplus.hcm.activities;

import android.content.Intent;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import android.view.MenuItem;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.hcm.HCMURL;
import com.b2lmobitech.fieldcloudplus.hcm.sql.HcmDatabase;
import com.b2lmobitech.fieldcloudplus.hcm.sql.tables.TripExpenseTable;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.RequestOptions;

import org.json.JSONException;
import org.json.JSONObject;

public class ExpenseInfoActivity extends AppCompatActivity {

    LinearLayout mainLayout;
    String expenseId;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_travelexpenseinfo);
        mainLayout=findViewById(R.id.mainLayout);
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        getSupportActionBar().setTitle("Expense Details");
        expenseId=getIntent().getStringExtra("id");
        try {
            addDetais();
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    private void addDetais() throws JSONException {
        JSONObject jsonObject = HcmDatabase.getInstance(this).getExpenseInfo(expenseId);
        mainLayout.removeAllViews();

        addView("Travel Id",jsonObject.getString(TripExpenseTable.TRIPID));
        addView("Expense Id",jsonObject.getString(TripExpenseTable.EXPENSEID));
        addView("Start",jsonObject.getString(TripExpenseTable.FROM));
        addView("End",jsonObject.getString(TripExpenseTable.TO));
        addView("Amount",jsonObject.getString(TripExpenseTable.AMOUNT));
        addView("Expense Type", jsonObject.getString(TripExpenseTable.TYPE));
        addView("Created By",jsonObject.getString(TripExpenseTable.CREATEDBY));
        addView("Created Datetime",jsonObject.getString(TripExpenseTable.DATETIME));

        addViewWithImage("Scanned Copy",jsonObject.getString(TripExpenseTable.PATH));

    }

    private void addView(String key,String pair){
        View view=getLayoutInflater().inflate(R.layout.mode_keypair,null);
        TextView keyText=view.findViewById(R.id.keyText);
        TextView pairText=view.findViewById(R.id.pairText);
        keyText.setText(key);
        pairText.setText(pair);
        mainLayout.addView(view);
    }

    private void addViewWithImage(String key, final String pair){
        final View view=getLayoutInflater().inflate(R.layout.model_hcmimage,null);
        TextView keyText=view.findViewById(R.id.keyText);
        final TextView pairText=view.findViewById(R.id.pairText);

        pairText.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

               // networkImageView.setImageUrl(HCMURL.IAMGE_ROOT+pair, mImageLoader);
                ImageView imageView=view.findViewById(R.id.imageView);
                Glide.with(getApplicationContext())
                        .load(HCMURL.IAMGE_ROOT+pair)
                        .apply(RequestOptions.placeholderOf(R.drawable.ic_loading))
                        .into(imageView);

                pairText.setVisibility(View.GONE);
            }
        });

        keyText.setText(key);
        pairText.setText("Load Image");
        mainLayout.addView(view);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()){
            case R.id.add:
                startActivity(new Intent(getApplicationContext(),TravelApplyActivtiy.class));
                break;
            case android.R.id.home:
                onBackPressed();
                return true;
        }
        return super.onOptionsItemSelected(item);
    }

}
