package com.b2lmobitech.fieldcloudplus.hcm.activities;

import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import android.view.MenuItem;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;

import org.json.JSONException;
import org.json.JSONObject;

public class LoanInfoActivity extends AppCompatActivity {

    LinearLayout mainLayout;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_loaninfo);
        mainLayout=findViewById(R.id.mainLayout);
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        getSupportActionBar().setTitle("Loan Details");
        try {
            addDetais(new JSONObject(getIntent().getStringExtra("json")));
        }catch (Exception e){
            e.printStackTrace();
        }

    }

    private void addDetais(JSONObject jsonObject) throws JSONException {
        mainLayout.removeAllViews();
        addView("Loan Amount",jsonObject.getString("loan_amount"));
        addView("Taked On",jsonObject.getString("from_date"));
        addView("Due On",jsonObject.getString("to_date"));
        addView("Monthly Deduction",jsonObject.getString("monthly_deduction"));
        addView("Reason",jsonObject.getString("reason"));
        addView("Due Remaining",jsonObject.getString("pending_amount"));
        addView("Remaining Months", jsonObject.getString("rem_month"));
        addView("Created On",jsonObject.getString("t_datetime"));
    }

    private void addView(String key,String pair){
        View view=getLayoutInflater().inflate(R.layout.mode_keypair,null);
        TextView keyText=view.findViewById(R.id.keyText);
        TextView pairText=view.findViewById(R.id.pairText);
        keyText.setText(key);
        pairText.setText(pair);
        mainLayout.addView(view);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()){
            case android.R.id.home:
                onBackPressed();
                return true;
        }
        return super.onOptionsItemSelected(item);
    }

}
