package com.b2lmobitech.fieldcloudplus.hcm.activities;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.provider.MediaStore;
import com.google.android.material.textfield.TextInputLayout;
import androidx.core.content.FileProvider;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;

import com.b2lmobitech.fieldcloudplus.BuildConfig;
import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.hcm.HCMURL;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.task.Utility;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.others.utils.Preference;
import com.b2lmobitech.fieldcloudplus.others.utils.Validations;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Map;

public class NewExpenseActivity extends AppCompatActivity {

    TextInputLayout travelId,fromLocation,toLocation,expenseAmount,expenseType;
    ImageView openCamera,snappedImage;
    TextView removeImage;
    private final int TRAVEL_REQUEST_CODE=23;
    String imageString="";

    Uri imageUri;
    File mediaFile = null;
    Bitmap cambmp;

    protected static final int CAPTURE_IMAGE_ACTIVITY_REQUEST_CODE = 0;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_new_travel_expense);

        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        getSupportActionBar().setTitle("New Expense");

        getWidgets();
    }

    private void getWidgets(){
        travelId=findViewById(R.id.travelId);
        fromLocation=findViewById(R.id.fromLocation);
        toLocation=findViewById(R.id.toLocation);
        expenseAmount=findViewById(R.id.expenseAmount);
        expenseType=findViewById(R.id.expenseType);
        openCamera=findViewById(R.id.openCamera);
        snappedImage=findViewById(R.id.snappedImage);
        removeImage=findViewById(R.id.removeImage);
        removeImage.setVisibility(View.GONE);
        snappedImage.setVisibility(View.GONE);

        openCamera.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                openCamera();
            }
        });

        removeImage.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                imageString="";
                removeImage.setVisibility(View.GONE);
                snappedImage.setVisibility(View.GONE);
                openCamera.setVisibility(View.VISIBLE);
            }
        });

        travelId.getEditText().setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent intent=new Intent(getApplicationContext(), TravelsByStatusActivity.class);
                intent.putExtra("status","approved");
                intent.putExtra("title","Select Travel");
                intent.putExtra("result",true);
                startActivityForResult(intent, TRAVEL_REQUEST_CODE);
            }
        });

    }

    protected void openCamera(){
        Intent intent = new Intent(MediaStore.ACTION_IMAGE_CAPTURE);

        imageUri = getOutputMediaFileUri();

        intent.putExtra(MediaStore.EXTRA_OUTPUT, imageUri);

        startActivityForResult(intent, CAPTURE_IMAGE_ACTIVITY_REQUEST_CODE);
    }

    public Uri getOutputMediaFileUri() {

        //return FileProvider.getUriForFile(this,com.Rover.BuildConfig.APPLICATION_ID + ".provider",getOutputMediaFile(type));
        //Uri.fromFile(mediaFile);
        mediaFile= Utility.getCapturedImageFile();

        Uri uri;
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
            uri = FileProvider.getUriForFile(this,
                    BuildConfig.APPLICATION_ID + ".provider",
                    mediaFile);
        }else{
            uri= Uri.fromFile(mediaFile);
        }
        return uri;
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {

        switch(requestCode){
            case TRAVEL_REQUEST_CODE:
                if (resultCode == RESULT_OK) {
                    travelId.getEditText().setText(data.getStringExtra("id"));
                    toLocation.getEditText().setText(data.getStringExtra("to"));
                    expenseType.getEditText().setText(data.getStringExtra("type"));
                }

                break;
            case CAPTURE_IMAGE_ACTIVITY_REQUEST_CODE:
                if (resultCode == RESULT_OK) {
                    try {
                        if (imageUri != null) {
                            try {
                                cambmp= BitmapFactory.decodeStream(this.getContentResolver().openInputStream(imageUri), null, null);
                                cambmp=Utility.processImage(cambmp);
                                snappedImage.setImageBitmap(cambmp);
                                snappedImage.setVisibility(View.VISIBLE);
                                removeImage.setVisibility(View.VISIBLE);
                                openCamera.setVisibility(View.GONE);
                            } catch (FileNotFoundException e) {
                                    //e.printStackTrace();
                            }
                            imageString= Utility.bitmap2string(cambmp);
                        }
                    } catch (Exception e) {
                        Toast.makeText(getApplicationContext(), "please try again", Toast.LENGTH_SHORT).show();
                    }
                }else if (resultCode == RESULT_CANCELED) {
                    Toast.makeText(getApplicationContext(), "You cancelled image capture", Toast.LENGTH_SHORT).show();
                } else {
                    Toast.makeText(getApplicationContext(), "Sorry! Failed to capture image", Toast.LENGTH_SHORT).show();
                }
                if(mediaFile!=null){
                    mediaFile.delete();
                }
                break;
        }

    }

    private boolean isValid(){
        boolean valid=true;
        Validations validations=Validations.getInstance(this);
        if(travelId.getEditText().getText().toString().isEmpty()){
            validations.setError(travelId,"Select Travel Id");
            valid=false;
        }
        if(fromLocation.getEditText().getText().toString().isEmpty()){
            validations.setError(fromLocation,"Provide Lcoation");
            valid=false;
        }

        if(toLocation.getEditText().getText().toString().isEmpty()){
            validations.setError(toLocation,"Provide Lcoation");
            valid=false;
        }

        if(expenseAmount.getEditText().getText().toString().isEmpty()){
            Validations.getInstance(this).setError(expenseAmount,"Enter Amount");
            valid=false;
        }

        if(expenseType.getEditText().getText().toString().isEmpty()){
            Validations.getInstance(this).setError(expenseType,"Enter Expense Type");
            valid=false;
        }

        if(imageString.isEmpty()){
            Toast.makeText(getApplicationContext(),"Please Capture Source Image",Toast.LENGTH_SHORT).show();
            valid=false;
        }
        return valid;
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.menu_form, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()){
            case R.id.done:
                closeKeyboard();
                if(isValid()) {
                    try {
                        addExpense();
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
                break;
            case android.R.id.home:
                onBackPressed();
                return true;
        }
        return super.onOptionsItemSelected(item);
    }

    private void addExpense() throws JSONException {

        Preference preference= Preference.getInstance(this);
        Map<String, String> params = new HashMap<>();
        JSONObject jsonObject=new JSONObject();
        jsonObject.put("cname",preference.getCompanyName());
        jsonObject.put("mail",preference.getEmailId());
        jsonObject.put("type",preference.getCompnayType());
        jsonObject.put("role", preference.getDesignation());
        jsonObject.put("id",travelId.getEditText().getText().toString().trim());
        jsonObject.put("from",fromLocation.getEditText().getText().toString().trim());
        jsonObject.put("to",toLocation.getEditText().getText().toString().trim());
        jsonObject.put("amount",expenseAmount.getEditText().getText().toString().trim());
        jsonObject.put("type",expenseType.getEditText().getText().toString().trim());
        jsonObject.put("image",imageString);

        params.put("data",jsonObject.toString());

        MyRequestQueue.getInstance(this).addToQueue(HCMURL.ADD_EXPENSE, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject=new JSONObject(response);
                    if(jsonObject.getBoolean("s")){
                        Toast.makeText(getApplicationContext(),"Travel Added Successfully",Toast.LENGTH_SHORT).show();
                        finish();
                    }else{
                        Toast.makeText(getApplicationContext(),"Unable to Add",Toast.LENGTH_SHORT).show();
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void closeKeyboard() {
        InputMethodManager inputManager = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
        inputManager.hideSoftInputFromWindow(getCurrentFocus().getWindowToken(), InputMethodManager.HIDE_NOT_ALWAYS);

    }


}
