package com.b2lmobitech.fieldcloudplus.hcm.activities;

import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import android.view.MenuItem;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.others.utils.DateUtils;

import org.json.JSONException;
import org.json.JSONObject;

import java.text.ParseException;

public class SalaryInfoActivity extends AppCompatActivity {

    LinearLayout mainLayout;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_salaryinfo);

        mainLayout=findViewById(R.id.mainLayout);
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        getSupportActionBar().setTitle("Salary Details");
        try {
            addDetais(new JSONObject(getIntent().getStringExtra("json")));
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    private void addDetais(JSONObject jsonObject) throws JSONException {
        mainLayout.removeAllViews();

        try {
            addView("Month & Year", DateUtils.monthYearFromDate(jsonObject.getString("sa_datetime")));
        } catch (ParseException e) {
            e.printStackTrace();
        }
        addView("Basic Salary",jsonObject.getString("basic_salary"));
        if(!jsonObject.getString("DA").equalsIgnoreCase("0") && !jsonObject.getString("DA").isEmpty()) {
            addView("DA", jsonObject.getString("DA"));
        }
        if(!jsonObject.getString("house_rent_allowance").equalsIgnoreCase("0") && !jsonObject.getString("house_rent_allowance").isEmpty()) {
            addView("Rent", jsonObject.getString("house_rent_allowance"));
        }
        if(!jsonObject.getString("conveyance").equalsIgnoreCase("0") && !jsonObject.getString("conveyance").isEmpty()) {
            addView("Coveyance", jsonObject.getString("conveyance"));
        }
        if(!jsonObject.getString("food").equalsIgnoreCase("0") && !jsonObject.getString("food").isEmpty()) {
            addView("Food", jsonObject.getString("food"));
        }
        if(!jsonObject.getString("special").equalsIgnoreCase("0") && !jsonObject.getString("special").isEmpty()) {
            addView("Special", jsonObject.getString("special"));
        }
        if(!jsonObject.getString("cca").equalsIgnoreCase("0") && !jsonObject.getString("cca").isEmpty()) {
            addView("CCA", jsonObject.getString("cca"));
        }
        if(!jsonObject.getString("other").equalsIgnoreCase("0") && !jsonObject.getString("other").isEmpty()) {
            addView("Others", jsonObject.getString("other"));
        }
        if(!jsonObject.getString("loan").equalsIgnoreCase("0") && !jsonObject.getString("loan").isEmpty()) {
            addView("Loan Deduction", jsonObject.getString("loan"));
        }
        if(!jsonObject.getString("advance").equalsIgnoreCase("0") && !jsonObject.getString("advance").isEmpty()) {
            addView("Advance Deduction", jsonObject.getString("advance"));
        }
        if(!jsonObject.getString("my_leaves").equalsIgnoreCase("0") && !jsonObject.getString("my_leaves").isEmpty()) {
            addView("Total Leaves", jsonObject.getString("my_leaves"));
        }
        if(!jsonObject.getString("lop").equalsIgnoreCase("0") && !jsonObject.getString("lop").isEmpty()) {
            addView("LOP", jsonObject.getString("lop"));
        }
        if(!jsonObject.getString("sa_net_pay").equalsIgnoreCase("0") && !jsonObject.getString("sa_net_pay").isEmpty()) {
            addView("Net Pay", jsonObject.getString("sa_net_pay"));
        }
    }

    private void addView(String key,String pair){
        View view=getLayoutInflater().inflate(R.layout.mode_keypair,null);
        TextView keyText=view.findViewById(R.id.keyText);
        TextView pairText=view.findViewById(R.id.pairText);
        keyText.setText(key);
        pairText.setText(pair);
        mainLayout.addView(view);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()){
            case android.R.id.home:
                onBackPressed();
                return true;
        }
        return super.onOptionsItemSelected(item);
    }

}
