package com.b2lmobitech.fieldcloudplus.hcm.activities;

import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import android.view.MenuItem;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;

import org.json.JSONException;
import org.json.JSONObject;

public class TrainingInfoActivity extends AppCompatActivity {

    LinearLayout mainLayout;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_traininginfo);

        mainLayout=findViewById(R.id.mainLayout);
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        getSupportActionBar().setTitle("Training Details");

        try {
            addDetais(new JSONObject(getIntent().getStringExtra("json")));
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    private void addDetais(JSONObject jsonObject) throws JSONException {
        mainLayout.removeAllViews();

        addView("Organized Training",jsonObject.getString("train_organized"));

        addView("Trainer",jsonObject.getString("trainer_name"));


        addView("Title",jsonObject.getString("train_title"));
        addView("Type",jsonObject.getString("train_type"));
        addView("Subject",jsonObject.getString("train_subject"));
        addView("Lcoation",jsonObject.getString("train_location"));
        addView("From",jsonObject.getString("start_date"));
        addView("To", jsonObject.getString("end_date"));
        addView("Sponsered",jsonObject.getString("train_sponser"));

    }

    private void addView(String key,String pair){
        View view=getLayoutInflater().inflate(R.layout.mode_keypair,null);
        TextView keyText=view.findViewById(R.id.keyText);
        TextView pairText=view.findViewById(R.id.pairText);
        keyText.setText(key);
        pairText.setText(pair);
        mainLayout.addView(view);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()){
            case android.R.id.home:
                onBackPressed();
                return true;
        }
        return super.onOptionsItemSelected(item);
    }
}
