package com.b2lmobitech.fieldcloudplus.hcm.activities;

import android.content.Intent;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import android.view.MenuItem;
import android.view.View;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.hcm.HCMURL;
import com.b2lmobitech.fieldcloudplus.hcm.adapter.TransferAdapter;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

public class TransferActivity extends AppCompatActivity implements OnItemClickListener{

    RecyclerView recyclerView;
    TextView errorText;
    TransferAdapter transferAdapter;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_transfer);

        errorText=findViewById(R.id.errorText);
        recyclerView=findViewById(R.id.recycleView);
        recyclerView.setLayoutManager(new LinearLayoutManager(this));
        recyclerView.addItemDecoration(new DividerItemDecoration(this, LinearLayoutManager.VERTICAL));
        recyclerView.setHasFixedSize(true);
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        getSupportActionBar().setTitle("Transfers");

        getTransfers();
    }

    private void getTransfers(){
        Preference preference=Preference.getInstance(this);
        Map<String, String> params = new HashMap<>();
        params.put("mail",preference.getEmailId());
        params.put("cname", preference.getCompanyName());
        params.put("role", preference.getDesignation());

        MyRequestQueue.getInstance(this).addToQueue(HCMURL.GET_TRANSFERS, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    getTransfers(new JSONObject(response));
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void getTransfers(JSONObject jsonObject) throws JSONException{
        JSONArray jsonArray=jsonObject.getJSONArray("list");
        transferAdapter=new TransferAdapter(this,jsonArray);
        recyclerView.setAdapter(transferAdapter);

        if(jsonArray.length()==0){
            errorText.setText("No Transfers");
            errorText.setVisibility(View.VISIBLE);
        }else if(errorText.getVisibility()==View.VISIBLE){
            errorText.setVisibility(View.GONE);
        }

    }

    @Override
    public void itemClicked(int position) {
        Intent intent=new Intent(getApplicationContext(),TransferInfoActivity.class);
        try {
            intent.putExtra("json",transferAdapter.getJsonArray().getJSONObject(position).toString());
        } catch (JSONException e) {
            e.printStackTrace();
        }
        startActivity(intent);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()){
            case android.R.id.home:
                onBackPressed();
                return true;
        }
        return super.onOptionsItemSelected(item);
    }
}
