package com.b2lmobitech.fieldcloudplus.hcm.activities;

import android.content.Intent;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import android.view.MenuItem;
import android.view.View;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;

public class TravelActivity extends AppCompatActivity {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_travel);
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        getSupportActionBar().setTitle("My Travels");
        setListeners();
    }


    private void setListeners(){
        findViewById(R.id.newTravelCard).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if(!MyRequestQueue.getInstance(TravelActivity.this).isNoNetwork()) {
                    startActivity(new Intent(getApplicationContext(), TravelApplyActivtiy.class));
                }
            }
        });

        findViewById(R.id.newExpenseCard).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if(!MyRequestQueue.getInstance(TravelActivity.this).isNoNetwork()) {
                    startActivity(new Intent(getApplicationContext(), NewExpenseActivity.class));
                }
            }
        });

        findViewById(R.id.requestedTravelsCard).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if(!MyRequestQueue.getInstance(TravelActivity.this).isNoNetwork()) {
                    Intent intent = new Intent(getApplicationContext(), TravelsByStatusActivity.class);
                    intent.putExtra("status", "request");
                    intent.putExtra("title", "Requested Travels");
                    startActivity(intent);
                }
            }
        });

        findViewById(R.id.approvedTravelsCard).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if(!MyRequestQueue.getInstance(TravelActivity.this).isNoNetwork()) {
                    Intent intent = new Intent(getApplicationContext(), TravelsByStatusActivity.class);
                    intent.putExtra("status", "approved");
                    intent.putExtra("title", "Approved Travels");
                    startActivity(intent);
                }
            }
        });

        findViewById(R.id.cancelledTravelsCard).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if(!MyRequestQueue.getInstance(TravelActivity.this).isNoNetwork()) {
                    Intent intent = new Intent(getApplicationContext(), TravelsByStatusActivity.class);
                    intent.putExtra("status", "cancel");
                    intent.putExtra("title", "Cancelled Travels");
                    startActivity(intent);
                }
            }
        });

        findViewById(R.id.travelExpenseCard).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if(!MyRequestQueue.getInstance(TravelActivity.this).isNoNetwork()) {
                    startActivity(new Intent(getApplicationContext(), TravelExpenseActivity.class));
                }
            }
        });
    }


    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()){
            case R.id.add:
                startActivity(new Intent(getApplicationContext(),TravelApplyActivtiy.class));
                break;
            case android.R.id.home:
                onBackPressed();
                return true;
        }
        return super.onOptionsItemSelected(item);
    }



}
