package com.b2lmobitech.fieldcloudplus.hcm.activities;

import android.app.DatePickerDialog;
import android.content.Context;
import com.google.android.material.textfield.TextInputLayout;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.DatePicker;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.Toast;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.hcm.HCMURL;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.others.utils.Preference;
import com.b2lmobitech.fieldcloudplus.others.utils.Validations;

import org.json.JSONException;
import org.json.JSONObject;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

import fr.ganfra.materialspinner.MaterialSpinner;

public class TravelApplyActivtiy extends AppCompatActivity {

    TextInputLayout purposeOfVisit,customerName,travelDuration,aDate,dDate,travelPlace;
    MaterialSpinner travelType;
    RadioGroup customerBillable;
    RadioButton billable,nonBillable;


    Calendar calendarStart=Calendar.getInstance(),calendarEnd=Calendar.getInstance();

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_travelapply);

        getSupportActionBar().setTitle("Request Travel");
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        getWidgets();
        setLsiteners();
    }

    private void getWidgets(){
        purposeOfVisit=findViewById(R.id.purposeOfVisit);
        customerName=findViewById(R.id.customerName);
        travelDuration=findViewById(R.id.travelDuration);
        aDate=findViewById(R.id.aDate);
        dDate=findViewById(R.id.dDate);
        travelPlace=findViewById(R.id.travelPlace);
        travelType=findViewById(R.id.travelType);
        customerBillable=findViewById(R.id.customerBillable);
        billable=findViewById(R.id.billable);
        nonBillable=findViewById(R.id.nonBillable);
        nonBillable.setChecked(true);

    }

    private void setLsiteners(){
        aDate.getEditText().setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                selectEndDate();
            }
        });

        dDate.getEditText().setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                selectStartDate();

            }
        });

    }

    private void selectStartDate(){
        DatePickerDialog.OnDateSetListener fromDate = new DatePickerDialog.OnDateSetListener() {

            @Override
            public void onDateSet(DatePicker view, int year, int monthOfYear,
                                  int dayOfMonth) {
                // TODO Auto-generated method stub
                calendarStart.set(Calendar.YEAR, year);
                calendarStart.set(Calendar.MONTH, monthOfYear);
                calendarStart.set(Calendar.DAY_OF_MONTH, dayOfMonth);
                String myFormat = "yyyy-MM-dd"; //In which you need put here
                SimpleDateFormat sdf = new SimpleDateFormat(myFormat, Locale.US);
                dDate.getEditText().setText(sdf.format(calendarStart.getTime()));
                aDate.getEditText().getText().clear();
            }

        };
        DatePickerDialog datePicker =  new DatePickerDialog(this, fromDate, calendarStart
                .get(Calendar.YEAR), calendarStart.get(Calendar.MONTH),
                calendarStart.get(Calendar.DAY_OF_MONTH));
        datePicker.setTitle("Start Date");
        datePicker.show();
    }

    private void selectEndDate(){
        final DatePickerDialog.OnDateSetListener toDate = new DatePickerDialog.OnDateSetListener() {

            @Override
            public void onDateSet(DatePicker view, int year, int monthOfYear,
                                  int dayOfMonth) {
                // TODO Auto-generated method stub
                calendarEnd.set(Calendar.YEAR, year);
                calendarEnd.set(Calendar.MONTH, monthOfYear);
                calendarEnd.set(Calendar.DAY_OF_MONTH, dayOfMonth);
                String myFormat = "yyyy-MM-dd"; //In which you need put here
                SimpleDateFormat sdf = new SimpleDateFormat(myFormat, Locale.US);
                aDate.getEditText().setText(sdf.format(calendarEnd.getTime()));
                //edittext.setText(sdf.format(myCalendar.getTime()));
            }

        };
        if(dDate.getEditText().getText().toString().isEmpty()){
            Validations.getInstance(this).setError(dDate,"Select Departure Date");
            return;
        }

        DatePickerDialog datePicker = new DatePickerDialog(this, toDate, calendarEnd
                .get(Calendar.YEAR), calendarEnd.get(Calendar.MONTH),
                calendarEnd.get(Calendar.DAY_OF_MONTH));
        datePicker.getDatePicker().setMinDate(calendarStart.getTimeInMillis());
        datePicker.setTitle("End Date");
        datePicker.show();
    }

    private boolean isValid(){
        boolean valid=true;
        Validations validations=Validations.getInstance(this);
        if(purposeOfVisit.getEditText().getText().toString().isEmpty()){
            validations.setError(purposeOfVisit,"Provide Purpose of Visit");
            valid=false;
        }
        if(customerName.getEditText().getText().toString().isEmpty()){
            validations.setError(customerName,"Provide Customer Name");
            valid=false;
        }

        if(travelDuration.getEditText().getText().toString().isEmpty()){
            validations.setError(travelDuration,"Provide Travel Duration");
            valid=false;
        }

        if(dDate.getEditText().getText().toString().isEmpty()){
            Validations.getInstance(this).setError(dDate,"Select Departure Date");
            valid=false;
        }

        if(aDate.getEditText().getText().toString().isEmpty()){
            Validations.getInstance(this).setError(aDate,"Select Arrival Date");
            valid=false;
        }
        if(travelPlace.getEditText().getText().toString().isEmpty()){
            validations.setError(travelPlace,"Provide Travel Place");
            valid=false;
        }
        if(travelType.getSelectedItemPosition()==0){
            Validations.getInstance(this).setError(travelType,"Select Travel Type");
            valid=false;
        }



        return valid;
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.menu_form, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()){
            case R.id.done:
                closeKeyboard();
                if(isValid()) {
                    try {
                        requestTravel();
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
                break;
            case android.R.id.home:
                onBackPressed();
                return true;
        }
        return super.onOptionsItemSelected(item);
    }

    private void closeKeyboard() {
        InputMethodManager inputManager = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
        inputManager.hideSoftInputFromWindow(getCurrentFocus().getWindowToken(), InputMethodManager.HIDE_NOT_ALWAYS);

    }

    private void requestTravel() throws JSONException {

        Preference preference= Preference.getInstance(this);
        Map<String, String> params = new HashMap<>();
        JSONObject jsonObject=new JSONObject();
        jsonObject.put("cname",preference.getCompanyName());
        jsonObject.put("mail",preference.getEmailId());
        jsonObject.put("type",preference.getCompnayType());
        jsonObject.put("role", preference.getDesignation());
        String[] arrayList=getResources().getStringArray(R.array.travel_types1);
        jsonObject.put("place",travelPlace.getEditText().getText().toString().trim());
        jsonObject.put("travel_type",arrayList[travelType.getSelectedItemPosition()-1]);
        if(nonBillable.isChecked()){
            jsonObject.put("billable","no");
        }else{
            jsonObject.put("billable","yes");
        }
        jsonObject.put("customer",customerName.getEditText().getText().toString().trim());
        jsonObject.put("purpose",purposeOfVisit.getEditText().getText().toString().trim());
        jsonObject.put("start",dDate.getEditText().getText().toString().trim());
        jsonObject.put("end",aDate.getEditText().getText().toString().trim());
        jsonObject.put("duration",travelDuration.getEditText().getText().toString().trim());

        params.put("data",jsonObject.toString());

        MyRequestQueue.getInstance(this).addToQueue(HCMURL.REQUEST_TRAVEL, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject=new JSONObject(response);
                    if(jsonObject.getBoolean("s")){
                        Toast.makeText(getApplicationContext(),"Travel Requested Successfully",Toast.LENGTH_SHORT).show();
                        finish();
                    }else{
                        Toast.makeText(getApplicationContext(),"Unable to Request Travel",Toast.LENGTH_SHORT).show();
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

}
