package com.b2lmobitech.fieldcloudplus.hcm.activities;

import android.app.SearchManager;
import android.content.Context;
import android.content.Intent;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.appcompat.widget.SearchView;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.hcm.HCMURL;
import com.b2lmobitech.fieldcloudplus.hcm.adapter.ExpenseAdapter;
import com.b2lmobitech.fieldcloudplus.hcm.sql.HcmDatabase;
import com.b2lmobitech.fieldcloudplus.hcm.sql.tables.TripExpenseTable;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

public class TravelExpenseActivity extends AppCompatActivity implements OnItemClickListener {

    JSONArray jsonArray,adapterArray;
    RecyclerView recyclerView;
    ExpenseAdapter expenseAdapter;
    TextView errorText;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_travelexpense);


        errorText=findViewById(R.id.errorText);
        recyclerView=findViewById(R.id.recycleView);
        recyclerView.setLayoutManager(new LinearLayoutManager(this));
        recyclerView.addItemDecoration(new DividerItemDecoration(this, LinearLayoutManager.VERTICAL));
        recyclerView.setHasFixedSize(true);
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        getSupportActionBar().setTitle("Expenses");
        getExpenses();

    }

    @Override
    protected void onResume() {
        super.onResume();
        getExpensesOffline();
    }

    private void getExpenses(){
        Preference preference=Preference.getInstance(this);
        Map<String, String> params = new HashMap<>();
        params.put("mail",preference.getEmailId());
       // params.put("list", HcmDatabase.getInstance(this).getTravelsList(status).toString());
        params.put("cname", preference.getCompanyName());
        params.put("role", preference.getDesignation());

        MyRequestQueue.getInstance(this).addToQueue(HCMURL.GET_EXPENSES, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    getExpenses(new JSONObject(response));
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void getExpenses(JSONObject jsonObject) throws JSONException{
        HcmDatabase hcmDatabase=HcmDatabase.getInstance(this);
        hcmDatabase.insertExpenses(jsonObject.getJSONArray("list"));
        getExpensesOffline();
    }

    private void getExpensesOffline(){
        jsonArray=HcmDatabase.getInstance(this).getExpenses();
        setAdapter();
    }



    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.hcm_travel, menu);
        MenuItem search=menu.findItem(R.id.action_search);

        SearchManager searchManager = (SearchManager) getSystemService(Context.SEARCH_SERVICE);
        SearchView searchView = (SearchView) search.getActionView();
        searchView.performClick();
        // menuItem.expandActionView();
        searchView.setIconified(true);

        searchManager.setOnDismissListener(new SearchManager.OnDismissListener() {
            @Override
            public void onDismiss() {
                setAdapter();
            }
        });
        searchManager.setOnCancelListener(new SearchManager.OnCancelListener() {
            @Override
            public void onCancel() {
                setAdapter();
            }
        });
        searchView.setOnQueryTextListener(new SearchView.OnQueryTextListener() {
            @Override
            public boolean onQueryTextSubmit(String s) {
                return false;
            }

            @Override
            public boolean onQueryTextChange(String s) {
                if(s.isEmpty()){
                    setAdapter();
                }else {
                    try {
                        setFilteredAdapter(s);
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
                return false;
            }
        });
        return true;
    }

    private void setFilteredAdapter(String string) throws JSONException {
        adapterArray=new JSONArray();
        for (int i = 0; i < jsonArray.length(); i++) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            if (jsonObject.toString().contains(string)) {
                adapterArray.put(jsonObject);
            }
        }
        expenseAdapter=new ExpenseAdapter(this,adapterArray);
        recyclerView.setAdapter(expenseAdapter);
        if(adapterArray.length()==0){
            errorText.setText("No Matched Found");
            errorText.setVisibility(View.VISIBLE);
        }else if(errorText.getVisibility()== View.VISIBLE){
            errorText.setVisibility(View.GONE);
        }
    }

    private void setAdapter(){
        expenseAdapter=new ExpenseAdapter(this,jsonArray);
        recyclerView.setAdapter(expenseAdapter);
        if(jsonArray.length()==0){
            errorText.setText("No Expense Found");
            errorText.setVisibility(View.VISIBLE);
        }else if(errorText.getVisibility()==View.VISIBLE){
            errorText.setVisibility(View.GONE);
        }
    }

    @Override
    public void itemClicked(int position) {
        try{
            Intent intent=new Intent(getApplicationContext(),ExpenseInfoActivity.class);
            intent.putExtra("id",expenseAdapter.getJsonArray().getJSONObject(position).getString(TripExpenseTable.EXPENSEID));
            startActivity(intent);
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()){
            case android.R.id.home:
                onBackPressed();
                return true;
        }
        return super.onOptionsItemSelected(item);
    }

}
