package com.b2lmobitech.fieldcloudplus.hcm.activities;

import android.content.Intent;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import android.view.MenuItem;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.hcm.sql.HcmDatabase;
import com.b2lmobitech.fieldcloudplus.hcm.sql.tables.TripTable;

import org.json.JSONException;
import org.json.JSONObject;

public class TravelInfoActivity extends AppCompatActivity {

    LinearLayout mainLayout;
    String travelId;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_travelinfo);
        mainLayout=findViewById(R.id.mainLayout);
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        getSupportActionBar().setTitle("Travel Details");
        travelId=getIntent().getStringExtra("id");
        try {
            addDetais();
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    private void addDetais() throws JSONException {
        JSONObject jsonObject = HcmDatabase.getInstance(this).getTravelInfo(travelId);
        mainLayout.removeAllViews();
        addView("Travel Id",jsonObject.getString(TripTable.TRIPID));
        addView("Travelers",jsonObject.getString(TripTable.EMAILID));
        addView("Travel to",jsonObject.getString(TripTable.PLACE));
        addView("Duration",jsonObject.getString(TripTable.DURATION));
        addView("Start Date",jsonObject.getString(TripTable.START));
        addView("End Date", jsonObject.getString(TripTable.END));
        addView("Visit Purpsoe",jsonObject.getString(TripTable.VISITPURPOSE));

        if(!jsonObject.getString(TripTable.CUSTOMERNAME).equalsIgnoreCase("no data available")) {
            addView("Customer", jsonObject.getString(TripTable.CUSTOMERNAME));
            addView("Billable", jsonObject.getString(TripTable.BILLABLE));
        }

        if(jsonObject.getString(TripTable.CREATEDBYTYPE).equalsIgnoreCase("admin")){
            addView("Created By",jsonObject.getString(TripTable.CREATEDBY));
            addView("Created Datetime",jsonObject.getString(TripTable.DATETIME));
        }else {
            addView("Requested By",jsonObject.getString(TripTable.CREATEDBY));
            if (jsonObject.getString(TripTable.STATUS).equalsIgnoreCase("approved")) {
                addView("Approved Datetime", jsonObject.getString(TripTable.UPDATEDDATETIME));
                addView("Status", "Approved");
            } else if (jsonObject.getString(TripTable.STATUS).equalsIgnoreCase("cancel")) {
                addView("Cancelled Datetime", jsonObject.getString(TripTable.UPDATEDDATETIME));
                addView("Status", "Cancelled");
            } else {
                addView("Requested Datetime",jsonObject.getString(TripTable.DATETIME));
                addView("Status", "Requested");
            }
        }

    }

    private void addView(String key,String pair){
        View view=getLayoutInflater().inflate(R.layout.mode_keypair,null);
        TextView keyText=view.findViewById(R.id.keyText);
        TextView pairText=view.findViewById(R.id.pairText);
        keyText.setText(key);
        pairText.setText(pair);
        mainLayout.addView(view);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()){
            case R.id.add:
                startActivity(new Intent(getApplicationContext(),TravelApplyActivtiy.class));
                break;
            case android.R.id.home:
                onBackPressed();
                return true;
        }
        return super.onOptionsItemSelected(item);
    }


}
